/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.page;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.s.sourcebuilder.page.PageSourceBuilder;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.MethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerationContext;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerators;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;

public class PageNewOperation
implements IOperation {
    private final IJavaEnvironmentProvider m_javaEnvironmentProvider = new CachingJavaEnvironmentProvider();
    private String m_pageName;
    private IPackageFragmentRoot m_clientSourceFolder;
    private IPackageFragmentRoot m_pageDataSourceFolder;
    private IPackageFragmentRoot m_sharedSourceFolder;
    private IPackageFragmentRoot m_serverSourceFolder;
    private String m_package;
    private IType m_superType;
    private IType m_createdPage;
    private IType m_createdPageData;
    private IType m_createdServiceIfc;
    private IType m_createdServiceImpl;

    @Override
    public String getOperationName() {
        return "Create Page '" + this.getPageName() + "'.";
    }

    @Override
    public void validate() {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getPageName()), (String)"No page name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getClientSourceFolder()), (String)"No client source folder provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getPackage()), (String)"No package name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSuperType()), (String)"No supertype provided", (Object[])new Object[0]);
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        boolean isCreatePageData;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)4);
        String sharedPackage = ScoutTier.Client.convert(ScoutTier.Shared, this.getPackage());
        boolean isPageWithTable = S2eUtils.hierarchyContains(this.getSuperType().newSupertypeHierarchy(null), "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable");
        boolean bl = isCreatePageData = isPageWithTable && S2eUtils.exists((IJavaElement)this.getPageDataSourceFolder());
        if (isCreatePageData) {
            this.setCreatedPageData(this.createPageData(sharedPackage, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        }
        if (isCreatePageData && S2eUtils.exists((IJavaElement)this.getSharedSourceFolder()) && S2eUtils.exists((IJavaElement)this.getServerSourceFolder())) {
            this.createService(sharedPackage, this.calcServiceBaseName(), (IProgressMonitor)progress.newChild(2), workingCopyManager);
        }
        progress.setWorkRemaining(1);
        this.setCreatedPage(this.createPage(isPageWithTable, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        if (isCreatePageData) {
            ScoutSdkCore.getDerivedResourceManager().trigger(Collections.singleton(this.getCreatedPage().getResource()));
        }
    }

    protected String calcServiceBaseName() {
        String svcBaseName = this.getPageName();
        if (svcBaseName.endsWith("Page")) {
            svcBaseName = svcBaseName.substring(0, svcBaseName.length() - "Page".length());
        }
        return svcBaseName;
    }

    protected void createService(String sharedPackage, String baseName, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        ServiceNewOperation serviceNewOperation = this.createServiceOperation();
        serviceNewOperation.setServiceName(baseName);
        serviceNewOperation.setSharedPackage(sharedPackage);
        serviceNewOperation.setSharedSourceFolder(this.getSharedSourceFolder());
        serviceNewOperation.setServerSourceFolder(this.getServerSourceFolder());
        serviceNewOperation.addMethod(this.createServiceMethod());
        serviceNewOperation.validate();
        serviceNewOperation.run(monitor, workingCopyManager);
        this.setCreatedServiceImpl(serviceNewOperation.getCreatedServiceImpl());
        this.setCreatedServiceIfc(serviceNewOperation.getCreatedServiceInterface());
    }

    protected IMethodSourceBuilder createServiceMethod() {
        MethodSourceBuilder methodBuilder = new MethodSourceBuilder("getTableData");
        methodBuilder.setFlags(1);
        methodBuilder.setComment(CommentSourceBuilderFactory.createDefaultMethodComment((IMethodSourceBuilder)methodBuilder));
        final String pageDataSig = Signature.createTypeSignature((String)this.getCreatedPageData().getFullyQualifiedName());
        methodBuilder.setReturnTypeSignature(pageDataSig);
        methodBuilder.addParameter((IMethodParameterSourceBuilder)new MethodParameterSourceBuilder("filter", Signature.createTypeSignature((String)"org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter")));
        methodBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                String varName = "pageData";
                source.append(validator.useSignature(pageDataSig)).append(' ').append(varName).append(" = new ").append(validator.useSignature(pageDataSig)).append("();").append(lineDelimiter);
                source.append(CoreUtils.getCommentBlock((String)("fill " + varName + '.'))).append(lineDelimiter);
                source.append("return ").append(varName).append(';');
            }
        });
        return methodBuilder;
    }

    protected ServiceNewOperation createServiceOperation() {
        return new ServiceNewOperation(this.getEnvProvider());
    }

    protected PageSourceBuilder createPageBuilder(boolean isPageWithTable) {
        PageSourceBuilder pageBuilder = new PageSourceBuilder(this.getPageName(), this.getPackage());
        if (ClassIdGenerators.isAutomaticallyCreateClassIdAnnotation()) {
            pageBuilder.setClassIdValue(ClassIdGenerators.generateNewId(new ClassIdGenerationContext(String.valueOf(this.getPackage()) + '.' + this.getPageName())));
        }
        if (S2eUtils.exists((IJavaElement)this.getCreatedPageData())) {
            pageBuilder.setPageDataSignature(Signature.createTypeSignature((String)this.getCreatedPageData().getFullyQualifiedName()));
        }
        if (S2eUtils.exists((IJavaElement)this.getCreatedServiceIfc())) {
            pageBuilder.setPageServiceIfcSignature(Signature.createTypeSignature((String)this.getCreatedServiceIfc().getFullyQualifiedName()));
        }
        pageBuilder.setPageWithTable(isPageWithTable);
        pageBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)this.getSuperType().getFullyQualifiedName()));
        pageBuilder.setup();
        return pageBuilder;
    }

    protected IType createPage(boolean isPageWithTable, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        PageSourceBuilder pageBuilder = this.createPageBuilder(isPageWithTable);
        return S2eUtils.writeType(this.getClientSourceFolder(), (ICompilationUnitSourceBuilder)pageBuilder, this.getEnvProvider().get(this.getClientSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    protected IType createPageData(String sharedPackage, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        String pageDataName = String.valueOf(this.getPageName()) + "Data";
        CompilationUnitSourceBuilder pageDataBuilder = new CompilationUnitSourceBuilder(String.valueOf(pageDataName) + ".java", sharedPackage);
        TypeSourceBuilder formDataTypeBuilder = new TypeSourceBuilder(pageDataName);
        formDataTypeBuilder.setFlags(1);
        formDataTypeBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.shared.data.page.AbstractTablePageData"));
        pageDataBuilder.addType((ITypeSourceBuilder)formDataTypeBuilder);
        return S2eUtils.writeType(this.getPageDataSourceFolder(), (ICompilationUnitSourceBuilder)pageDataBuilder, this.getEnvProvider().get(this.getPageDataSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    public IType getCreatedPage() {
        return this.m_createdPage;
    }

    protected void setCreatedPage(IType page) {
        this.m_createdPage = page;
    }

    public String getPageName() {
        return this.m_pageName;
    }

    public void setPageName(String pageName) {
        this.m_pageName = pageName;
    }

    public IPackageFragmentRoot getClientSourceFolder() {
        return this.m_clientSourceFolder;
    }

    public void setClientSourceFolder(IPackageFragmentRoot clientSourceFolder) {
        this.m_clientSourceFolder = clientSourceFolder;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public IType getCreatedPageData() {
        return this.m_createdPageData;
    }

    protected void setCreatedPageData(IType createdPageData) {
        this.m_createdPageData = createdPageData;
    }

    protected IJavaEnvironmentProvider getEnvProvider() {
        return this.m_javaEnvironmentProvider;
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    public IType getCreatedServiceIfc() {
        return this.m_createdServiceIfc;
    }

    protected void setCreatedServiceIfc(IType createdServiceIfc) {
        this.m_createdServiceIfc = createdServiceIfc;
    }

    public IType getCreatedServiceImpl() {
        return this.m_createdServiceImpl;
    }

    protected void setCreatedServiceImpl(IType createdServiceImpl) {
        this.m_createdServiceImpl = createdServiceImpl;
    }

    public IPackageFragmentRoot getPageDataSourceFolder() {
        return this.m_pageDataSourceFolder;
    }

    public void setPageDataSourceFolder(IPackageFragmentRoot pageDataSourceFolder) {
        this.m_pageDataSourceFolder = pageDataSourceFolder;
    }
}

