/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.serviceproject;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.scout.sdk.core.util.IFilter;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.serviceproject.NlsServiceType;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.SimpleNlsProject;
import org.eclipse.scout.sdk.s2e.nls.model.INlsProjectProvider;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class ServiceNlsProjectProvider
implements INlsProjectProvider {
    private static Set<IType> getRegisteredTextProviderTypes(IJavaProject javaProject) throws CoreException {
        final HashSet duplicateOrders = new HashSet(0);
        final class TextProviderServiceDeclaration {
            private final IType m_svc;
            private final double m_prio;

            TextProviderServiceDeclaration(IType s, double p) {
                this.m_svc = s;
                this.m_prio = p;
            }
        }
        Comparator<TextProviderServiceDeclaration> comparator = new Comparator<TextProviderServiceDeclaration>(){

            @Override
            public int compare(TextProviderServiceDeclaration o1, TextProviderServiceDeclaration o2) {
                if (o1 == o2) {
                    return 0;
                }
                int compare = Double.compare(o1.m_prio, o2.m_prio);
                if (compare != 0) {
                    return compare;
                }
                Object[] duplicateOrdersFqn = new String[]{o1.m_svc.getFullyQualifiedName(), o2.m_svc.getFullyQualifiedName()};
                Arrays.sort(duplicateOrdersFqn);
                duplicateOrders.add(Arrays.toString(duplicateOrdersFqn));
                compare = Boolean.compare(o1.m_svc.isBinary(), o2.m_svc.isBinary());
                if (compare != 0) {
                    return compare;
                }
                return o1.m_svc.getFullyQualifiedName().compareTo(o2.m_svc.getFullyQualifiedName());
            }
        };
        final TreeSet<TextProviderServiceDeclaration> result = new TreeSet<TextProviderServiceDeclaration>(comparator);
        S2eUtils.PublicPrimaryTypeFilter filter = new S2eUtils.PublicPrimaryTypeFilter(){

            public boolean evaluate(IType candidate) {
                block5: {
                    boolean accept = super.evaluate(candidate);
                    if (!accept) {
                        return false;
                    }
                    int flags = candidate.getFlags();
                    if (!Flags.isAbstract((int)flags)) break block5;
                    return false;
                }
                try {
                    if (SourceRange.isAvailable((ISourceRange)candidate.getSourceRange())) {
                        TextProviderServiceDeclaration d = new TextProviderServiceDeclaration(candidate, ServiceNlsProjectProvider.getOrder(candidate));
                        result.add(d);
                    }
                }
                catch (JavaModelException e) {
                    SdkLog.warning((String)"Attempt to access source range of type '{}' failed. Type will be skipped.", (Object[])new Object[]{candidate.getFullyQualifiedName(), e});
                }
                return false;
            }
        };
        S2eUtils.findClassesInStrictHierarchy((IJavaProject)javaProject, (String)"org.eclipse.scout.rt.shared.services.common.text.AbstractDynamicNlsTextProviderService", null, (IFilter)filter);
        if (!duplicateOrders.isEmpty()) {
            SdkLog.warning((String)"There are TextProviderServices with the same @Order value: {}", (Object[])new Object[]{duplicateOrders});
        }
        LinkedHashSet<IType> returnValueSorted = new LinkedHashSet<IType>(result.size());
        for (TextProviderServiceDeclaration d : result) {
            returnValueSorted.add(d.m_svc);
        }
        return returnValueSorted;
    }

    private static double getOrder(IType registration) {
        try {
            BigDecimal val;
            IAnnotation a = S2eUtils.getAnnotation((IAnnotatable)registration, (String)"org.eclipse.scout.rt.platform.Order");
            if (S2eUtils.exists((IJavaElement)a) && (val = S2eUtils.getAnnotationValueNumeric((IAnnotation)a, (String)"value")) != null) {
                return val.doubleValue();
            }
        }
        catch (Exception e) {
            SdkLog.debug((String)"Unable to parse order annotation value for type '{}'. Using default bean order instead.", (Object[])new Object[]{registration.getFullyQualifiedName(), e});
        }
        return 5000.0;
    }

    private static SimpleNlsProject getServiceNlsProject(IType serviceType) {
        if (serviceType == null) {
            SdkLog.error((String)"nls service type cannot be null.", (Object[])new Object[0]);
            return null;
        }
        if (!S2eUtils.exists((IJavaElement)serviceType)) {
            SdkLog.error((String)"nls service type '{}' does not exist.", (Object[])new Object[]{serviceType.getFullyQualifiedName()});
            return null;
        }
        NlsServiceType type = new NlsServiceType(serviceType);
        if (type.getTranslationsFolderName() == null) {
            SdkLog.warning((String)"The NLS Service for Type '{}' could not be parsed. Ensure that the method '{}' is available and returns a String literal like \"resources.texts.Texts\" directly.", (Object[])new Object[]{serviceType.getFullyQualifiedName(), "getDynamicNlsBaseName"});
            return null;
        }
        return new SimpleNlsProject(type);
    }

    private static INlsProject getNlsProjectTree(IJavaProject projectFilter) throws CoreException {
        Set<IType> registeredTextProviderTypes = ServiceNlsProjectProvider.getRegisteredTextProviderTypes(projectFilter);
        return ServiceNlsProjectProvider.textProviderTypesToNlsProject(registeredTextProviderTypes);
    }

    private static INlsProject textProviderTypesToNlsProject(Set<IType> textProviderServices) throws CoreException {
        SimpleNlsProject previous = null;
        SimpleNlsProject root = null;
        for (IType type : textProviderServices) {
            SimpleNlsProject p = ServiceNlsProjectProvider.getServiceNlsProject(type);
            if (p != null) {
                if (root == null) {
                    root = p;
                }
                if (previous != null) {
                    previous.setParent(p);
                }
                previous = p;
                continue;
            }
            if (root != null) continue;
            throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.s2e.nls", "The NLS Service for Type " + type.getFullyQualifiedName() + " could not be parsed."));
        }
        return root;
    }

    private static INlsProject getNlsProjectTree(IType type) throws CoreException {
        Set<IType> nlsProviders = ServiceNlsProjectProvider.getRegisteredTextProviderTypes(type.getJavaProject());
        String searchString = ServiceNlsProjectProvider.getTypeIdentifyer(type);
        LinkedHashSet<IType> filtered = new LinkedHashSet<IType>(nlsProviders.size());
        boolean minFound = false;
        for (IType t : nlsProviders) {
            if (ServiceNlsProjectProvider.getTypeIdentifyer(t).equals(searchString) && !minFound) {
                minFound = true;
            }
            if (!minFound) continue;
            filtered.add(t);
        }
        return ServiceNlsProjectProvider.textProviderTypesToNlsProject(filtered);
    }

    private static String getTypeIdentifyer(IType t) {
        return String.valueOf(t.getJavaProject().getProject().getName()) + "/" + t.getFullyQualifiedName();
    }

    @Override
    public INlsProject getProject(Object[] args) {
        if (args != null) {
            if (args.length == 1) {
                if (args[0] instanceof IType) {
                    return ServiceNlsProjectProvider.getProjectByTextServiceType((IType)args[0]);
                }
                if (args[0] instanceof IFile) {
                    return ServiceNlsProjectProvider.getProjectByTextServiceFile((IFile)args[0]);
                }
            } else if (args.length == 2 && args[0] instanceof IType) {
                if (args[1] instanceof IJavaProject || args[1] == null) {
                    return ServiceNlsProjectProvider.getAllProjects((IJavaProject)args[1]);
                }
                if (args[1] instanceof IType) {
                    IType iType = (IType)args[1];
                    return ServiceNlsProjectProvider.getAllProjects(iType.getJavaProject());
                }
            }
        }
        return null;
    }

    private static INlsProject getAllProjects(IJavaProject javaProject) {
        try {
            return ServiceNlsProjectProvider.getNlsProjectTree(javaProject);
        }
        catch (CoreException e) {
            SdkLog.warning((String)"Could not load full text provider service tree.", (Object[])new Object[]{e});
            return null;
        }
    }

    private static INlsProject getProjectByTextServiceFile(IFile f) {
        try {
            IType type = ServiceNlsProjectProvider.getITypeForFile(f);
            if (type != null) {
                return NlsCore.getNlsWorkspace().getNlsProject(new Object[]{type});
            }
        }
        catch (CoreException e) {
            SdkLog.warning((String)"Could not load text provider services for file: {}", (Object[])new Object[]{f.getFullPath().toString(), e});
        }
        return null;
    }

    private static IType getITypeForFile(IFile file) throws JavaModelException {
        IJavaElement element = JavaCore.create((IFile)file);
        if (S2eUtils.exists((IJavaElement)element)) {
            if (element.getElementType() == 5) {
                ICompilationUnit icu = (ICompilationUnit)element;
                IType[] types = icu.getTypes();
                if (types.length > 0) {
                    return types[0];
                }
            } else if (element.getElementType() == 7) {
                return (IType)element;
            }
        }
        return null;
    }

    private static INlsProject getProjectByTextServiceType(IType textservice) {
        try {
            return ServiceNlsProjectProvider.getNlsProjectTree(textservice);
        }
        catch (CoreException e) {
            SdkLog.warning((String)"Could not load text provider services for {}", (Object[])new Object[]{textservice.getFullyQualifiedName(), e});
            return null;
        }
    }
}

