/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.simpleproject;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.scout.sdk.s2e.nls.resource.AbstractTranslationResource;
import org.eclipse.scout.sdk.s2e.nls.resource.TranslationResourceEvent;
import org.eclipse.scout.sdk.s2e.operation.ResourceWriteOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.WeakResourceChangeListener;

public class WorkspaceTranslationFile
extends AbstractTranslationResource {
    private final IFile m_file;
    private final IResourceChangeListener m_translationFileChangedListener;

    public WorkspaceTranslationFile(IFile file) {
        super(Language.parse(file.getName()));
        Validate.notNull((Object)file);
        Validate.isTrue((boolean)file.exists());
        this.m_file = file;
        this.m_translationFileChangedListener = new P_TranslationFileChangedListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new WeakResourceChangeListener(this.m_translationFileChangedListener), 1);
        this.reload((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void reload(IProgressMonitor monitor) {
        try {
            this.m_file.refreshLocal(0, monitor);
        }
        catch (CoreException e) {
            SdkLog.warning((String)"Could not refresh file '{}'.", (Object[])new Object[]{this.m_file.getLocation().toOSString(), e});
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (InputStream io = this.m_file.getContents();){
                this.parseResource(io);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            SdkLog.error((String)"cold not reload translation file: {}", (Object[])new Object[]{this.m_file.getName(), e});
        }
    }

    @Override
    public void updateText(String key, String newText, boolean fireEvent, IProgressMonitor monitor) {
        this.setTranslation(key, newText, fireEvent, monitor);
    }

    @Override
    public IStatus remove(String key, IProgressMonitor monitor) {
        super.setTranslation(key, null, false, monitor);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus updateKey(String oldKey, String newKey, IProgressMonitor monitor) {
        String translation = this.getTranslation(oldKey);
        this.setTranslation(oldKey, null, monitor);
        this.setTranslation(newKey, translation, monitor);
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitChanges(IProgressMonitor monitor) {
        IFile iFile = this.m_file;
        synchronized (iFile) {
            if (!this.m_file.exists()) {
                SdkLog.error((String)"File: {} not found!", (Object[])new Object[]{this.m_file.getName()});
            }
            Properties prop = new Properties();
            String nl = NlsCore.getLineSeparator((IResource)this.m_file);
            Map<String, String> allTranslations = this.getAllTranslations();
            prop.putAll(allTranslations);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                prop.store(os, null);
                Object[] lines = os.toString("8859_1").split(nl);
                int i = 0;
                if (lines.length > 0 && ((String)lines[0]).startsWith("#")) {
                    ++i;
                }
                Arrays.sort(lines);
                StringBuilder builder = new StringBuilder();
                while (i < lines.length) {
                    String lineContent = StringUtils.replaceEach((String)lines[i], (String[])new String[]{"\n", "\r"}, (String[])new String[]{"", ""});
                    builder.append(lineContent);
                    builder.append(nl);
                    ++i;
                }
                S2eUtils.writeResources(Collections.singletonList(new ResourceWriteOperation(this.m_file, builder.toString())), (IProgressMonitor)monitor, (boolean)true);
            }
            catch (IOException | CoreException e) {
                SdkLog.error((String)"could not refresh file: {}", (Object[])new Object[]{this.m_file.getName(), e});
            }
        }
    }

    private class P_TranslationFileChangedListener
    implements IResourceChangeListener {
        private P_TranslationFileChangedListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta d) {
                            IResource resource = d.getResource();
                            if (resource != null && resource.equals((Object)WorkspaceTranslationFile.this.m_file)) {
                                if (d.getKind() == 2) {
                                    WorkspaceTranslationFile.this.fireTranslationResourceChanged(new TranslationResourceEvent(WorkspaceTranslationFile.this, 1024));
                                } else {
                                    WorkspaceTranslationFile.this.reload((IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                            return true;
                        }
                    });
                }
            }
            catch (CoreException e) {
                SdkLog.warning((Object[])new Object[]{e});
            }
        }
    }
}

