/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.event.EventListenerList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.util.OptimisticLock;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.internal.model.InheritedNlsEntry;
import org.eclipse.scout.sdk.s2e.nls.model.INlsEntry;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.scout.sdk.s2e.nls.model.NlsEntry;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProjectListener;
import org.eclipse.scout.sdk.s2e.nls.project.NlsProjectEvent;
import org.eclipse.scout.sdk.s2e.nls.project.NlsResourceProvider;
import org.eclipse.scout.sdk.s2e.nls.resource.ITranslationResource;
import org.eclipse.scout.sdk.s2e.nls.resource.ITranslationResourceListener;
import org.eclipse.scout.sdk.s2e.nls.resource.TranslationResourceEvent;

public abstract class AbstractNlsProject
implements INlsProject {
    private final EventListenerList m_listeners = new EventListenerList();
    private final ITranslationResourceListener m_translationResourceListener;
    private final P_ParentListener m_parentProjectListener = new P_ParentListener();
    private final OptimisticLock m_translationResourceEventLock;
    private final NlsResourceProvider m_resourceProvider;
    private final String m_name;
    private final ReadWriteLock m_lock;
    private volatile Map<String, NlsEntry> m_entries = null;
    private Language m_developerLanguage = null;
    private INlsProject m_parent = null;

    public AbstractNlsProject(IType type) {
        this.m_translationResourceListener = new P_TranslationResourceChangedListener();
        this.m_translationResourceEventLock = new OptimisticLock();
        this.m_resourceProvider = new NlsResourceProvider();
        this.m_lock = new ReentrantReadWriteLock();
        this.m_name = type.getElementName();
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    protected void resetCache() {
        this.m_lock.writeLock().lock();
        try {
            this.m_entries = null;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isReadOnly() {
        for (Language l : this.getAllLanguages()) {
            ITranslationResource resource = this.getTranslationResource(l);
            if (resource == null || !resource.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Language> getAllLanguages() {
        return this.m_resourceProvider.getAllLanguages();
    }

    @Override
    public ITranslationResource getTranslationResource(Language language) {
        return this.m_resourceProvider.getResource(language);
    }

    public List<ITranslationResource> getAllTranslationResources() {
        return this.m_resourceProvider.getSortedResources();
    }

    private void cache() {
        if (this.m_entries == null) {
            this.m_lock.writeLock().lock();
            try {
                if (this.m_entries == null) {
                    HashMap<String, NlsEntry> entries = new HashMap<String, NlsEntry>();
                    if (this.getParent() != null) {
                        for (String parentKey : this.getParent().getAllKeys()) {
                            entries.put(parentKey, new InheritedNlsEntry(this.getParent().getEntry(parentKey)));
                        }
                    }
                    for (ITranslationResource r : this.getAllTranslationResources()) {
                        for (String key : r.getAllKeys()) {
                            NlsEntry nlsEntry = (NlsEntry)entries.get(key);
                            if (nlsEntry == null) {
                                nlsEntry = new NlsEntry(key, (INlsProject)this);
                                entries.put(key, nlsEntry);
                            }
                            if (nlsEntry.getType() == 2) {
                                entries.remove(key);
                                nlsEntry = new NlsEntry(nlsEntry);
                                entries.put(key, nlsEntry);
                            }
                            nlsEntry.addTranslation(r.getLanguage(), r.getTranslation(key));
                        }
                    }
                    this.m_entries = entries;
                }
            }
            finally {
                this.m_lock.writeLock().unlock();
            }
        }
    }

    @Override
    public Set<String> getAllKeys() {
        this.cache();
        this.m_lock.readLock().lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.m_entries.keySet());
            return hashSet;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    @Override
    public IStatus removeEntries(Collection<INlsEntry> entries, IProgressMonitor m) {
        if (entries == null || entries.isEmpty()) {
            return Status.OK_STATUS;
        }
        for (ITranslationResource r : this.getAllTranslationResources()) {
            for (INlsEntry e : entries) {
                IStatus status = r.remove(e.getKey(), m);
                if (status.isOK()) continue;
                SdkLog.error((String)status.getMessage(), (Object[])new Object[]{status.getException()});
            }
            r.commitChanges(m);
        }
        this.refresh();
        return Status.OK_STATUS;
    }

    @Override
    public INlsEntry getEntry(String key) {
        this.cache();
        this.m_lock.readLock().lock();
        try {
            INlsEntry iNlsEntry = this.m_entries.get(key);
            return iNlsEntry;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    @Override
    public List<INlsEntry> getEntries(String prefix, boolean caseSensitive) {
        this.cache();
        this.m_lock.readLock().lock();
        try {
            if (prefix != null && prefix.length() > 0) {
                String compareablePrefix = prefix;
                if (!caseSensitive) {
                    compareablePrefix = compareablePrefix.toLowerCase();
                }
                Set<Map.Entry<String, NlsEntry>> set = this.m_entries.entrySet();
                ArrayList<INlsEntry> entries = new ArrayList<INlsEntry>(set.size());
                for (Map.Entry<String, NlsEntry> entry : set) {
                    String compareKey = entry.getKey();
                    if (!caseSensitive) {
                        compareKey = compareKey.toLowerCase();
                    }
                    if (!compareKey.startsWith(compareablePrefix)) continue;
                    entries.add(entry.getValue());
                }
                ArrayList<INlsEntry> arrayList = entries;
                return arrayList;
            }
            ArrayList<INlsEntry> result = new ArrayList<INlsEntry>(this.m_entries.size());
            for (INlsEntry iNlsEntry : this.m_entries.values()) {
                result.add(iNlsEntry);
            }
            ArrayList<INlsEntry> arrayList = result;
            return arrayList;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    @Override
    public List<INlsEntry> getAllEntries() {
        this.cache();
        this.m_lock.readLock().lock();
        try {
            ArrayList<INlsEntry> result = new ArrayList<INlsEntry>(this.m_entries.size());
            for (INlsEntry iNlsEntry : this.m_entries.values()) {
                result.add(iNlsEntry);
            }
            ArrayList<INlsEntry> arrayList = result;
            return arrayList;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    @Override
    public INlsProject getParent() {
        return this.m_parent;
    }

    @Override
    public String generateKey(String baseText) {
        return this.generateKey(baseText, false);
    }

    @Override
    public String generateNewKey(String baseText) {
        return this.generateKey(baseText, true);
    }

    protected String generateKey(String baseText, boolean appendFreeNumSuffix) {
        this.cache();
        if (baseText == null || baseText.length() < 1) {
            return null;
        }
        StringBuilder ret = new StringBuilder(baseText.length());
        baseText = baseText.replaceAll("[^a-zA-Z0-9_\\.\\- ]*", "").trim();
        String[] split = baseText.split(" ");
        int i = 0;
        while (i < split.length) {
            String splitValue = split[i];
            if (splitValue.length() > 0) {
                char first = splitValue.charAt(0);
                if (split.length > 1) {
                    first = Character.toUpperCase(first);
                }
                ret.append(first);
                if (splitValue.length() > 1) {
                    ret.append(splitValue.substring(1));
                }
            }
            ++i;
        }
        while (ret.length() > 0 && (ret.charAt(0) == '.' || ret.charAt(0) == '_' || ret.charAt(0) == '-')) {
            ret.deleteCharAt(0);
        }
        while (ret.length() > 0 && (ret.charAt(ret.length() - 1) == '.' || ret.charAt(ret.length() - 1) == '-')) {
            ret.deleteCharAt(ret.length() - 1);
        }
        int maxLength = 190;
        String newKey = ret.length() > maxLength ? ret.substring(0, maxLength) : ret.toString();
        String result = newKey;
        if (appendFreeNumSuffix) {
            int i2 = 0;
            this.m_lock.readLock().lock();
            try {
                while (this.m_entries.containsKey(result)) {
                    result = String.valueOf(newKey) + i2++;
                }
            }
            finally {
                this.m_lock.readLock().unlock();
            }
        }
        return result;
    }

    public void setParent(INlsProject newParent) {
        if (this.m_parent != null) {
            this.m_parent.removeProjectListener(this.m_parentProjectListener);
        }
        this.m_parent = newParent;
        this.m_parent.addProjectListener(this.m_parentProjectListener);
    }

    @Override
    public Language getDevelopmentLanguage() {
        if (this.m_developerLanguage == null) {
            Language lang = new Language(Locale.getDefault());
            if (!(this.containsLanguage(lang) || this.containsLanguage(lang = new Language(new Locale(lang.getLocale().getLanguage(), lang.getLocale().getCountry()))) || this.containsLanguage(lang = new Language(new Locale(lang.getLocale().getLanguage()))))) {
                lang = Language.LANGUAGE_DEFAULT;
            }
            this.m_developerLanguage = lang;
        }
        return this.m_developerLanguage;
    }

    @Override
    public void updateKey(INlsEntry entry, String newKey, IProgressMonitor monitor) {
        this.cache();
        NlsProjectEvent multiEvent = new NlsProjectEvent(this);
        this.m_lock.writeLock().lock();
        try {
            this.m_translationResourceEventLock.acquire();
            monitor.beginTask("update Key", -1);
            NlsEntry originalEntry = this.m_entries.remove(entry.getKey());
            if (originalEntry == null) {
                SdkLog.error((String)"The nls entry with the key '{}' can not be found.", (Object[])new Object[]{entry.getKey()});
                return;
            }
            if (originalEntry.getType() == 2) {
                SdkLog.error((String)"The inherited NLS entry '{}' can not be modified.", (Object[])new Object[]{originalEntry.getKey()});
                return;
            }
            multiEvent.addChildEvent(new NlsProjectEvent((INlsProject)this, originalEntry, 2));
            for (Map.Entry<Language, String> e : entry.getAllTranslations().entrySet()) {
                ITranslationResource r = this.getTranslationResource(e.getKey());
                if (r == null) continue;
                r.updateKey(entry.getKey(), newKey, monitor);
            }
            NlsEntry newEntry = new NlsEntry(originalEntry);
            newEntry.setKey(newKey);
            this.m_entries.put(newEntry.getKey(), newEntry);
            multiEvent.addChildEvent(new NlsProjectEvent((INlsProject)this, newEntry, 1));
        }
        finally {
            this.m_lock.writeLock().unlock();
            this.m_translationResourceEventLock.release();
        }
    }

    @Override
    public void updateRow(INlsEntry row, IProgressMonitor monitor) {
        this.updateRow(row, true, monitor);
    }

    @Override
    public void flush(IProgressMonitor monitor) {
        for (ITranslationResource r : this.m_resourceProvider.getResources()) {
            r.commitChanges(monitor);
        }
        this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, null, 16));
    }

    @Override
    public void updateRow(INlsEntry row, boolean flush, IProgressMonitor monitor) {
        String key = row.getKey();
        if (key == null || key.length() < 1) {
            throw new IllegalArgumentException("a text key cannot be null.");
        }
        this.cache();
        this.m_lock.writeLock().lock();
        try {
            this.m_translationResourceEventLock.acquire();
            NlsEntry existingEntry = this.m_entries.get(key);
            if (existingEntry != null) {
                if (existingEntry.getType() == 2) {
                    this.createNewRowInternal(row, flush, monitor);
                } else {
                    this.updateExistingRowInternal(existingEntry, row, flush, monitor);
                }
            } else {
                this.createNewRowInternal(row, flush, monitor);
            }
        }
        finally {
            this.m_lock.writeLock().unlock();
            this.m_translationResourceEventLock.release();
        }
    }

    private void createNewRowInternal(INlsEntry row, boolean flush, IProgressMonitor monitor) {
        NlsEntry newRow = new NlsEntry(row);
        this.m_entries.put(newRow.getKey(), newRow);
        for (Map.Entry<Language, String> entry : newRow.getAllTranslations().entrySet()) {
            ITranslationResource r = this.getTranslationResource(entry.getKey());
            if (r == null) continue;
            r.updateText(newRow.getKey(), entry.getValue(), flush, monitor);
        }
        if (flush) {
            this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, newRow, 1));
        }
    }

    private void updateExistingRowInternal(NlsEntry existingRow, INlsEntry row, boolean flush, IProgressMonitor monitor) {
        boolean updated = false;
        for (Map.Entry<Language, String> entry : row.getAllTranslations().entrySet()) {
            ITranslationResource r;
            String existingTranslation = existingRow.getTranslation(entry.getKey());
            if (Objects.equals(existingTranslation, entry.getValue()) || (r = this.getTranslationResource(entry.getKey())) == null) continue;
            updated = true;
            r.updateText(row.getKey(), entry.getValue(), flush, monitor);
            existingRow.addTranslation(entry.getKey(), entry.getValue());
        }
        if (updated && flush) {
            this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, existingRow, 4));
        }
    }

    private void handleParentRowAdded(INlsEntry superRow) {
        if (this.m_entries != null) {
            this.m_lock.writeLock().lock();
            try {
                NlsEntry entry = this.m_entries.get(superRow.getKey());
                if (entry == null || entry.getType() == 2) {
                    entry = new InheritedNlsEntry(superRow);
                    this.m_entries.put(entry.getKey(), entry);
                    this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, entry, 1));
                }
            }
            finally {
                this.m_lock.writeLock().unlock();
            }
        }
    }

    private void handleParentRowRemoved(INlsEntry superRow) {
        if (this.m_entries != null) {
            this.m_lock.writeLock().lock();
            try {
                NlsEntry removedEntry;
                NlsEntry existing = this.m_entries.get(superRow.getKey());
                if (existing.getType() == 2 && (removedEntry = this.m_entries.remove(superRow.getKey())) != null) {
                    this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, removedEntry, 2));
                }
            }
            finally {
                this.m_lock.writeLock().unlock();
            }
        }
    }

    private void handleParentRowModified(INlsEntry superRow) {
        if (this.m_entries != null) {
            this.m_lock.writeLock().lock();
            try {
                NlsEntry entry = this.m_entries.get(superRow.getKey());
                if (entry == null) {
                    SdkLog.error((String)"NLS entry with key:'{}' not found.", (Object[])new Object[]{superRow.getKey()});
                    return;
                }
                if (entry.getType() == 2) {
                    entry.update(superRow);
                    this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, entry, 4));
                }
            }
            finally {
                this.m_lock.writeLock().unlock();
            }
        }
    }

    protected abstract List<ITranslationResource> loadTranslationResources() throws CoreException;

    protected void updateTranslationResourceLocation() {
        try {
            List<ITranslationResource> translationResources = this.loadTranslationResources();
            for (ITranslationResource r : translationResources) {
                if (r.getLanguage() == null) continue;
                this.addTranslationResource(r);
            }
        }
        catch (CoreException e) {
            SdkLog.error((String)"could not load translation property resources.", (Object[])new Object[]{e});
        }
    }

    protected void addTranslationResource(ITranslationResource r) {
        r.getLanguage().setLocal(true);
        r.addTranslationResourceListener(this.m_translationResourceListener);
        this.m_resourceProvider.addResource(r);
        this.resetCache();
        this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)this, r, 32));
    }

    @Override
    public void refresh() {
        this.resetCache();
        for (ITranslationResource r : this.m_resourceProvider.getResources()) {
            r.removeTranslationResourceListener(this.m_translationResourceListener);
            this.m_resourceProvider.remove(r);
        }
        this.updateTranslationResourceLocation();
        this.fireNlsProjectEvent(new NlsProjectEvent(this, 16));
    }

    @Override
    public Language getBestMatchingProjectLanguage(Language language) {
        if (this.containsLanguage(language)) {
            return language;
        }
        Locale locale = new Locale(language.getLocale().getLanguage(), language.getLocale().getCountry());
        Language bestMatch = new Language(locale);
        if (this.containsLanguage(bestMatch)) {
            return bestMatch;
        }
        locale = new Locale(language.getLocale().getLanguage());
        bestMatch = new Language(locale);
        if (this.containsLanguage(bestMatch)) {
            return bestMatch;
        }
        return Language.LANGUAGE_DEFAULT;
    }

    @Override
    public boolean containsLanguage(Language languge) {
        return this.m_resourceProvider.containsResource(languge);
    }

    @Override
    public void addProjectListener(INlsProjectListener listener) {
        this.m_listeners.add(INlsProjectListener.class, listener);
    }

    @Override
    public void removeProjectListener(INlsProjectListener listener) {
        this.m_listeners.remove(INlsProjectListener.class, listener);
    }

    protected void fireNlsProjectEvent(NlsProjectEvent event) {
        INlsProjectListener[] iNlsProjectListenerArray = (INlsProjectListener[])this.m_listeners.getListeners(INlsProjectListener.class);
        int n = iNlsProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            INlsProjectListener listener = iNlsProjectListenerArray[n2];
            try {
                listener.notifyProjectChanged(event);
            }
            catch (Exception t) {
                SdkLog.error((String)"error during listener notification.", (Object[])new Object[]{t});
            }
            ++n2;
        }
    }

    private void handleTranlationResourceChanged(TranslationResourceEvent event) {
        try {
            if (this.m_translationResourceEventLock.acquire()) {
                HashMap<INlsEntry, NlsProjectEvent> addEvents = new HashMap<INlsEntry, NlsProjectEvent>();
                HashMap<INlsEntry, NlsProjectEvent> modifyEvents = new HashMap<INlsEntry, NlsProjectEvent>();
                HashMap<INlsEntry, NlsProjectEvent> removeEvents = new HashMap<INlsEntry, NlsProjectEvent>();
                this.handleTranslationResourceChangedRec(addEvents, modifyEvents, removeEvents, event);
                NlsProjectEvent multiEvent = new NlsProjectEvent(this);
                for (NlsProjectEvent e : addEvents.values()) {
                    multiEvent.addChildEvent(e);
                }
                for (NlsProjectEvent e : removeEvents.values()) {
                    multiEvent.addChildEvent(e);
                }
                for (NlsProjectEvent e : modifyEvents.values()) {
                    multiEvent.addChildEvent(e);
                }
                if (multiEvent.getChildEvents().length == 1) {
                    this.fireNlsProjectEvent(multiEvent.getChildEvents()[0]);
                } else if (multiEvent.getChildEvents().length > 1) {
                    this.fireNlsProjectEvent(multiEvent);
                }
            }
        }
        finally {
            this.m_translationResourceEventLock.release();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleTranslationResourceChangedRec(Map<INlsEntry, NlsProjectEvent> addEvents, Map<INlsEntry, NlsProjectEvent> modifyEvents, Map<INlsEntry, NlsProjectEvent> removeEvents, TranslationResourceEvent event) {
        block17: {
            block16: {
                if (!event.isMulti()) break block16;
                var8_5 = event.getSubEvents();
                var7_8 = var8_5.length;
                var6_10 = 0;
                while (var6_10 < var7_8) {
                    e = var8_5[var6_10];
                    this.handleTranslationResourceChangedRec(addEvents, modifyEvents, removeEvents, e);
                    ++var6_10;
                }
                break block17;
            }
            key = event.getKey();
            translation = event.getTranslation();
            this.cache();
            entry = this.m_entries.get(key);
            switch (event.getType()) {
                case 1: {
                    if (entry != null) ** GOTO lbl32
                    this.m_lock.writeLock().lock();
                    try {
                        entry = new NlsEntry(key, (INlsProject)this);
                        entry.addTranslation(event.getSource().getLanguage(), translation);
                        this.m_entries.put(entry.getKey(), entry);
                    }
                    finally {
                        this.m_lock.writeLock().unlock();
                    }
                    addEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 1));
                    break;
lbl32:
                    // 1 sources

                    modifyEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 4));
                    break;
                }
                case 2: {
                    if (entry == null || entry.getType() != 1) break;
                    entry.addTranslation(event.getSource().getLanguage(), null);
                    isEmpty = true;
                    for (ITranslationResource r : this.getAllTranslationResources()) {
                        if (r.getTranslation(entry.getKey()) == null) continue;
                        isEmpty = false;
                        break;
                    }
                    if (!isEmpty) ** GOTO lbl60
                    this.m_lock.writeLock().lock();
                    try {
                        this.m_entries.remove(entry.getKey());
                        if (this.m_parent != null && (e = this.m_parent.getEntry(entry.getKey())) != null) {
                            this.m_entries.put(entry.getKey(), new InheritedNlsEntry(e));
                        }
                    }
                    finally {
                        this.m_lock.writeLock().unlock();
                    }
                    removeEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 2));
                    modifyEvents.remove(entry);
                    break;
lbl60:
                    // 1 sources

                    modifyEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 4));
                    break;
                }
                case 4: {
                    if (entry == null) break;
                    if (entry.getType() == 1) {
                        entry.addTranslation(event.getSource().getLanguage(), translation);
                    }
                    modifyEvents.put(entry, new NlsProjectEvent((INlsProject)this, entry, 4));
                    break;
                }
                case 1024: {
                    this.refresh();
                    break;
                }
            }
        }
    }

    private class P_ParentListener
    implements INlsProjectListener {
        private P_ParentListener() {
        }

        @Override
        public void notifyProjectChanged(NlsProjectEvent event) {
            if (event.isMultiEvent()) {
                NlsProjectEvent[] nlsProjectEventArray = event.getChildEvents();
                int n = nlsProjectEventArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NlsProjectEvent subEvent = nlsProjectEventArray[n2];
                    this.notifyProjectChanged(subEvent);
                    ++n2;
                }
            } else {
                switch (event.getType()) {
                    case 1: {
                        AbstractNlsProject.this.handleParentRowAdded(event.getEntry());
                        break;
                    }
                    case 2: {
                        AbstractNlsProject.this.handleParentRowRemoved(event.getEntry());
                        break;
                    }
                    case 4: {
                        AbstractNlsProject.this.handleParentRowModified(event.getEntry());
                        break;
                    }
                }
            }
        }
    }

    private class P_TranslationResourceChangedListener
    implements ITranslationResourceListener {
        private P_TranslationResourceChangedListener() {
        }

        @Override
        public void translationResourceChanged(TranslationResourceEvent event) {
            AbstractNlsProject.this.handleTranlationResourceChanged(event);
        }
    }
}

