/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.project;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.core.s.project.ScoutProjectNewHelper;
import org.eclipse.scout.sdk.s2e.ui.fields.file.FileSelectionField;
import org.eclipse.scout.sdk.s2e.ui.fields.file.IFileSelectionListener;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ScoutProjectNewWizardPage
extends AbstractWizardPage {
    public static final String PROP_GROUP_ID = "groupId";
    public static final String PROP_ARTIFACT_ID = "artifactId";
    public static final String PROP_DISPLAY_NAME = "dispName";
    public static final String PROP_DIR = "dir";
    public static final String PROP_USE_WORKSPACE_LOC = "useWorkspaceLoc";
    public static final String SETTINGS_TARGET_DIR = "targetDirSetting";
    protected StyledTextField m_groupIdField;
    protected StyledTextField m_artifactIdField;
    protected StyledTextField m_displayNameField;
    protected Button m_useWsLoc;
    protected FileSelectionField m_targetDirectoryField;

    public ScoutProjectNewWizardPage() {
        super(ScoutProjectNewWizardPage.class.getName());
        this.setTitle("Create a Scout Project");
        this.setDescription("Create a new Scout Project");
        this.initDefaultValues();
    }

    @Override
    protected void createContent(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createProjectNameGroup(parent);
        this.createProjectLocationGroup(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_new_project_page_context");
    }

    protected void createProjectNameGroup(Composite parent) {
        Group nameGroup = this.getFieldToolkit().createGroupBox(parent, "Project Name");
        nameGroup.setLayoutData((Object)new GridData(768));
        nameGroup.setLayout((Layout)new GridLayout(1, true));
        this.m_groupIdField = this.getFieldToolkit().createStyledTextField((Composite)nameGroup, "Group Id");
        this.m_groupIdField.setText(this.getGroupId());
        this.m_groupIdField.setLayoutData(new GridData(768));
        this.m_groupIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.setGroupIdInternal(ScoutProjectNewWizardPage.this.m_groupIdField.getText());
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_groupIdField.setSelection(new Point(0, this.m_groupIdField.getText().length()));
        this.m_groupIdField.setFocus();
        this.m_artifactIdField = this.getFieldToolkit().createStyledTextField((Composite)nameGroup, "Artifact Id");
        this.m_artifactIdField.setText(this.getArtifactId());
        this.m_artifactIdField.setLayoutData(new GridData(768));
        this.m_artifactIdField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.setArtifactIdInternal(ScoutProjectNewWizardPage.this.m_artifactIdField.getText());
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_displayNameField = this.getFieldToolkit().createStyledTextField((Composite)nameGroup, "Display Name");
        this.m_displayNameField.setText(this.getDisplayName());
        this.m_displayNameField.setLayoutData(new GridData(768));
        this.m_displayNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScoutProjectNewWizardPage.this.setDisplayNameInternal(ScoutProjectNewWizardPage.this.m_displayNameField.getText());
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
    }

    protected void createProjectLocationGroup(Composite parent) {
        Group locationGroup = this.getFieldToolkit().createGroupBox(parent, "Project Location");
        GridData locatoinGroupData = new GridData(768);
        locatoinGroupData.verticalIndent = 10;
        locationGroup.setLayoutData((Object)locatoinGroupData);
        locationGroup.setLayout((Layout)new GridLayout(1, true));
        this.createLocationCheckbox((Composite)locationGroup);
        this.m_targetDirectoryField = new FileSelectionField((Composite)locationGroup);
        this.m_targetDirectoryField.setLabelText("Target Directory");
        this.m_targetDirectoryField.setFile(this.getTargetDirectory());
        this.m_targetDirectoryField.setFolderMode(true);
        this.m_targetDirectoryField.setEnabled(!this.m_useWsLoc.getSelection());
        this.m_targetDirectoryField.setLayoutData(new GridData(768));
        this.m_targetDirectoryField.addFileSelectionListener(new IFileSelectionListener(){

            @Override
            public void fileSelected(File file) {
                ScoutProjectNewWizardPage.this.setTargetDirectoryInternal(file);
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
    }

    protected Composite createLocationCheckbox(Composite p) {
        Composite parent = new Composite(p, 0);
        Label lbl = new Label(parent, 0);
        parent.setLayout((Layout)new FormLayout());
        parent.setLayoutData((Object)new GridData(768));
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(20, 0);
        labelData.bottom = new FormAttachment(100, 0);
        lbl.setLayoutData((Object)labelData);
        this.m_useWsLoc = new Button(parent, 32);
        this.m_useWsLoc.setText("Use default Workspace location");
        this.m_useWsLoc.setSelection(this.isUseWorkspaceLocation());
        this.m_useWsLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScoutProjectNewWizardPage.this.setUseWorkspaceLocationInternal(ScoutProjectNewWizardPage.this.m_useWsLoc.getSelection());
                ScoutProjectNewWizardPage.this.updateTargetDirViewState();
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)lbl, 5);
        textData.right = new FormAttachment(100, 0);
        textData.bottom = new FormAttachment(100, 0);
        this.m_useWsLoc.setLayoutData((Object)textData);
        return parent;
    }

    protected void initDefaultValues() {
        this.setGroupIdInternal("org.eclipse.scout.apps");
        this.setArtifactIdInternal("helloworld");
        this.setDisplayNameInternal("My Application");
        this.setUseWorkspaceLocationInternal(true);
        this.updateTargetDirViewState();
    }

    protected void updateTargetDirViewState() {
        if (this.isControlCreated()) {
            this.m_targetDirectoryField.setEnabled(!this.isUseWorkspaceLocation());
        }
        File file = null;
        if (this.isUseWorkspaceLocation()) {
            file = ScoutProjectNewWizardPage.getWorkspaceLocation();
        } else {
            File wsLoc = ScoutProjectNewWizardPage.getWorkspaceLocation();
            if (this.getTargetDirectory() == null || wsLoc.equals(this.getTargetDirectory())) {
                String recentTargetDir = this.getDialogSettings().get(SETTINGS_TARGET_DIR);
                file = recentTargetDir != null ? new File(recentTargetDir) : wsLoc;
            }
        }
        if (file != null) {
            this.setTargetDirectory(file);
        }
    }

    public static File getWorkspaceLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsoluteFile();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusGroupId());
        multiStatus.add(this.getStatusArtifactId());
        multiStatus.add(this.getStatusDisplayName());
        multiStatus.add(this.getStatusTargetDirectory());
    }

    protected IStatus getStatusGroupId() {
        String msg = ScoutProjectNewHelper.getMavenNameErrorMessage((String)this.getGroupId(), (String)"Group Id");
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusArtifactId() {
        String msg = ScoutProjectNewHelper.getMavenNameErrorMessage((String)this.getArtifactId(), (String)"Artifact Id");
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        File folder = null;
        folder = this.isUseWorkspaceLocation() ? ScoutProjectNewWizardPage.getWorkspaceLocation() : this.getTargetDirectory();
        if (folder != null && new File(folder, this.getArtifactId()).exists()) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "A project with this Artifact Id already exists in this target directory.");
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.getName().startsWith(String.valueOf(this.getArtifactId()) + '.')) {
                return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "A project with this Artifact Id already exists in the workspace.");
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusDisplayName() {
        String msg = ScoutProjectNewHelper.getDisplayNameErrorMEssage((String)this.getDisplayName());
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusTargetDirectory() {
        if (this.isUseWorkspaceLocation()) {
            return Status.OK_STATUS;
        }
        if (this.getTargetDirectory() == null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "Please choose a target directory.");
        }
        return Status.OK_STATUS;
    }

    public String getDisplayName() {
        return this.getPropertyString(PROP_DISPLAY_NAME);
    }

    public void setDisplayName(String s) {
        try {
            this.setStateChanging(true);
            this.setDisplayNameInternal(s);
            if (this.isControlCreated()) {
                this.m_displayNameField.setText(s);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setDisplayNameInternal(String s) {
        this.setPropertyString(PROP_DISPLAY_NAME, s);
    }

    public String getGroupId() {
        return this.getPropertyString(PROP_GROUP_ID);
    }

    public void setGroupId(String s) {
        try {
            this.setStateChanging(true);
            this.setGroupIdInternal(s);
            if (this.isControlCreated()) {
                this.m_groupIdField.setText(s);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setGroupIdInternal(String s) {
        this.setPropertyString(PROP_GROUP_ID, s);
    }

    public String getArtifactId() {
        return this.getPropertyString(PROP_ARTIFACT_ID);
    }

    public void setArtifactId(String s) {
        try {
            this.setStateChanging(true);
            this.setArtifactIdInternal(s);
            if (this.isControlCreated()) {
                this.m_artifactIdField.setText(s);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setArtifactIdInternal(String s) {
        this.setPropertyString(PROP_ARTIFACT_ID, s);
    }

    public boolean isUseWorkspaceLocation() {
        return this.getPropertyBool(PROP_USE_WORKSPACE_LOC);
    }

    public void setUseWorkspaceLocation(boolean f) {
        try {
            this.setStateChanging(true);
            this.setUseWorkspaceLocationInternal(f);
            if (this.isControlCreated()) {
                this.m_useWsLoc.setSelection(f);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setUseWorkspaceLocationInternal(boolean f) {
        this.setPropertyBool(PROP_USE_WORKSPACE_LOC, f);
    }

    public File getTargetDirectory() {
        return this.getProperty(PROP_DIR, File.class);
    }

    public void setTargetDirectory(File f) {
        try {
            this.setStateChanging(true);
            this.setTargetDirectoryInternal(f);
            if (this.isControlCreated()) {
                this.m_targetDirectoryField.setFile(f);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetDirectoryInternal(File f) {
        this.setProperty(PROP_DIR, f);
    }
}

