/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.scout.sdk.core.model.api.IFileLocator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.spi.internal.ClasspathEntry;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.WorkspaceFileSystem;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.internal.S2ESdkActivator;
import org.eclipse.scout.sdk.s2e.internal.WorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.trigger.IDerivedResourceManager;

public final class ScoutSdkCore {
    private ScoutSdkCore() {
    }

    public static IDerivedResourceManager getDerivedResourceManager() {
        S2ESdkActivator plugin = S2ESdkActivator.getDefault();
        if (plugin == null) {
            return null;
        }
        return plugin.getDerivedResourceManager();
    }

    public static IWorkingCopyManager createWorkingCopyManager() {
        return new WorkingCopyManager();
    }

    public static IJavaEnvironment createJavaEnvironment(IJavaProject javaProject) {
        Validate.notNull((Object)javaProject);
        return new JavaEnvironmentWithJdt(ScoutSdkCore.createFileLocator(javaProject), ScoutSdkCore.getClasspathEntries(javaProject)).wrap();
    }

    private static IFileLocator createFileLocator(IJavaProject javaProject) {
        final IProject project = javaProject.getProject();
        return new IFileLocator(){

            public File getFile(String path) {
                return project.getFile(path).getRawLocation().toFile();
            }
        };
    }

    private static Collection<ClasspathEntry> getClasspathEntries(IJavaProject javaProject) {
        try {
            IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            ArrayList<ClasspathEntry> result = new ArrayList<ClasspathEntry>(allPackageFragmentRoots.length);
            IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots;
            int n = allPackageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot cpRoot = iPackageFragmentRootArray[n2];
                String encoding = ScoutSdkCore.getEncoding(cpRoot);
                if (cpRoot.getKind() == 1) {
                    ScoutSdkCore.appendPath(result, cpRoot.getResource().getLocation().toFile(), true, encoding);
                } else {
                    IPath sourceAttachmentPath = cpRoot.getSourceAttachmentPath();
                    if (sourceAttachmentPath != null) {
                        ScoutSdkCore.appendPath(result, sourceAttachmentPath.toFile(), true, encoding);
                    } else {
                        File cpLocation = cpRoot.getPath().toFile();
                        ScoutSdkCore.appendPath(result, cpLocation, true, encoding);
                        ScoutSdkCore.appendPath(result, cpLocation, false, encoding);
                    }
                }
                ++n2;
            }
            return result;
        }
        catch (CoreException e) {
            throw new SdkException((Throwable)e);
        }
    }

    private static void appendPath(Collection<ClasspathEntry> paths, File f, boolean source, String encoding) {
        FileSystem.Classpath classpath = WorkspaceFileSystem.createClasspath((File)f, (boolean)source, (String)encoding);
        if (classpath != null) {
            paths.add(new ClasspathEntry(classpath, encoding));
        }
    }

    private static String getEncoding(IPackageFragmentRoot root) throws CoreException {
        IContainer c;
        IFile f;
        String charset;
        IResource resource = root.getResource();
        if (resource != null && resource.exists() && (resource instanceof IFile ? ScoutSdkCore.isValidEncoding(charset = (f = (IFile)resource).getCharset(true), root) : resource instanceof IContainer && ScoutSdkCore.isValidEncoding(charset = (c = (IContainer)resource).getDefaultCharset(true), root))) {
            return charset;
        }
        IPreferencesService preferencesService = Platform.getPreferencesService();
        if (preferencesService != null) {
            IScopeContext[] scopeContext = new IScopeContext[]{new ProjectScope(root.getJavaProject().getProject())};
            String encoding = preferencesService.getString("org.eclipse.core.resources", "encoding", null, scopeContext);
            if (ScoutSdkCore.isValidEncoding(encoding, root)) {
                return encoding;
            }
            scopeContext = new IScopeContext[]{InstanceScope.INSTANCE};
            encoding = preferencesService.getString("org.eclipse.core.resources", "encoding", null, scopeContext);
            if (ScoutSdkCore.isValidEncoding(encoding, root)) {
                return encoding;
            }
        }
        return System.getProperty("file.encoding", StandardCharsets.UTF_8.name());
    }

    private static boolean isValidEncoding(String encoding, IPackageFragmentRoot root) {
        if (StringUtils.isNotBlank((CharSequence)encoding)) {
            if (Charset.isSupported(encoding)) {
                return true;
            }
            SdkLog.warning((String)"Charset '{}' of classpath entry '{}' is not supported by this platform. Trying to decode using default charset.", (Object[])new Object[]{encoding, root.getElementName()});
        }
        return false;
    }
}

