/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.job;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;

public abstract class AbstractResourceBlockingJob
extends AbstractJob {
    private Exception m_callerTrace;

    public AbstractResourceBlockingJob(String name, IResource ... blockedResources) {
        super(name);
        if (blockedResources == null || blockedResources.length < 1) {
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        } else if (blockedResources.length == 1) {
            this.setRule((ISchedulingRule)blockedResources[0]);
        } else {
            this.setRule((ISchedulingRule)new MultiRule((ISchedulingRule[])blockedResources));
        }
    }

    public AbstractResourceBlockingJob(String name) {
        this(name, null);
    }

    public boolean shouldSchedule() {
        this.m_callerTrace = new Exception("Job scheduled by:");
        return super.shouldSchedule();
    }

    protected final IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        long start = System.currentTimeMillis();
        try {
            iStatus = this.doRun(monitor);
        }
        catch (Throwable throwable) {
            SdkLog.debug((String)"Operation job '{}' took {}ms to execute.", (Object[])new Object[]{this.getName(), System.currentTimeMillis() - start});
            throw throwable;
        }
        SdkLog.debug((String)"Operation job '{}' took {}ms to execute.", (Object[])new Object[]{this.getName(), System.currentTimeMillis() - start});
        return iStatus;
    }

    private IStatus doRun(IProgressMonitor monitor) {
        IWorkingCopyManager workingCopyManager = ScoutSdkCore.createWorkingCopyManager();
        boolean save = true;
        try {
            try {
                this.validate();
                this.run(monitor, workingCopyManager);
            }
            catch (Exception e) {
                save = false;
                if (e.getCause() == e || e.getCause() == null) {
                    e.initCause(this.m_callerTrace);
                }
                SdkLog.error((String)e.getMessage(), (Object[])new Object[]{e});
                Status status = new Status(4, "org.eclipse.scout.sdk.s2e", e.getMessage(), (Throwable)e);
                workingCopyManager.unregisterAll(monitor, save);
                monitor.done();
                return status;
            }
        }
        finally {
            workingCopyManager.unregisterAll(monitor, save);
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected void validate() {
    }

    protected abstract void run(IProgressMonitor var1, IWorkingCopyManager var2) throws CoreException;
}

