/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.scout.sdk.core.importcollector.IImportCollector;
import org.eclipse.scout.sdk.core.importcollector.ImportCollector;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.importvalidator.ImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitScopedImportCollector;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.ImportsCreateOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class AnnotationNewOperation
implements IOperation {
    private static final Pattern REGEX_WHITE_SPACE_START = Pattern.compile("^(\\s+).*");
    private IAnnotationSourceBuilder m_sourceBuilder;
    private final IMember m_declaringMember;

    public AnnotationNewOperation(IAnnotationSourceBuilder sourceBuilder, IMember declaringType) {
        this.m_sourceBuilder = sourceBuilder;
        this.m_declaringMember = declaringType;
    }

    @Override
    public String getOperationName() {
        return "create annotation " + Signature.getSimpleName((String)this.m_sourceBuilder.getName()) + "...";
    }

    @Override
    public void validate() {
        if (!S2eUtils.exists((IJavaElement)this.m_declaringMember)) {
            throw new IllegalArgumentException("Declaring member does not exist!");
        }
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        ICompilationUnit icu = this.m_declaringMember.getCompilationUnit();
        workingCopyManager.register(icu, monitor);
        IJavaEnvironment env = ScoutSdkCore.createJavaEnvironment(this.m_declaringMember.getJavaProject());
        CompilationUnitScopedImportCollector collector = new CompilationUnitScopedImportCollector((IImportCollector)new ImportCollector(env), S2eUtils.getPackage(icu));
        Document doc = new Document(icu.getSource());
        TextEdit edit = this.createEdit((IImportValidator)new ImportValidator((IImportCollector)collector), doc, icu.findRecommendedLineSeparator());
        try {
            edit.apply((IDocument)doc);
            IBuffer buffer = icu.getBuffer();
            buffer.setContents(doc.get());
            new ImportsCreateOperation(icu, (IImportCollector)collector).run(monitor, workingCopyManager);
        }
        catch (Exception e) {
            SdkLog.warning((String)"could not add annotation to '{}'.", (Object[])new Object[]{this.m_declaringMember.getElementName(), e});
        }
    }

    protected ISourceRange getAnnotationReplaceRange(Document sourceDocument, String newLine, String newAnnotationSource) throws JavaModelException, BadLocationException {
        String sn = Signature.getSimpleName((String)this.m_sourceBuilder.getName());
        String fqn = String.valueOf(Signature.getQualifier((String)this.m_sourceBuilder.getName())) + "." + sn;
        int newLineLength = newLine.length();
        IRegion lineOfMemberName = sourceDocument.getLineInformationOfOffset(this.m_declaringMember.getNameRange().getOffset());
        int lineBeforeMemberNameEndPos = lineOfMemberName.getOffset() - newLineLength;
        int lastLineStart = sourceDocument.getLineInformationOfOffset(this.m_declaringMember.getSourceRange().getOffset()).getOffset();
        int newAnnotationLen = newAnnotationSource.length();
        IRegion lineInfo = sourceDocument.getLineInformationOfOffset(lineBeforeMemberNameEndPos);
        IRegion result = lineOfMemberName;
        boolean isReplaceExisting = false;
        boolean isInBlockComment = false;
        while (lineInfo.getOffset() >= lastLineStart) {
            String lineSource = sourceDocument.get(lineInfo.getOffset(), lineInfo.getLength());
            if (lineSource != null && (lineSource = CoreUtils.removeComments((String)lineSource.trim())).length() > 0) {
                if (!isInBlockComment && lineSource.endsWith("*/")) {
                    isInBlockComment = true;
                } else if (isInBlockComment && lineSource.startsWith("/*")) {
                    isInBlockComment = false;
                }
                if (!isInBlockComment && lineSource.charAt(0) == '@') {
                    if (lineSource.length() > newAnnotationLen) {
                        result = lineInfo;
                    }
                    if (lineSource.startsWith("@" + sn) || lineSource.startsWith("@" + fqn)) {
                        result = lineInfo;
                        isReplaceExisting = true;
                        break;
                    }
                }
            }
            lineInfo = sourceDocument.getLineInformationOfOffset(lineInfo.getOffset() - newLineLength);
        }
        return new SourceRange(result.getOffset(), isReplaceExisting ? result.getLength() : 0);
    }

    protected String getIndent(Document sourceDocument, ISourceRange replaceRange) throws BadLocationException {
        IRegion line = sourceDocument.getLineInformationOfOffset(replaceRange.getOffset());
        Matcher matcher = REGEX_WHITE_SPACE_START.matcher(sourceDocument.get(line.getOffset(), line.getLength()));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public TextEdit createEdit(IImportValidator validator, Document sourceDocument, String nl) throws CoreException {
        try {
            StringBuilder builder = new StringBuilder();
            PropertyMap context = S2eUtils.propertyMap(this.m_declaringMember.getJavaProject());
            this.getSourceBuilder().createSource(builder, nl, context, validator);
            ISourceRange replaceRange = this.getAnnotationReplaceRange(sourceDocument, nl, builder.toString());
            builder.insert(0, this.getIndent(sourceDocument, replaceRange));
            if (replaceRange.getLength() == 0) {
                builder.append(nl);
            }
            return new ReplaceEdit(replaceRange.getOffset(), replaceRange.getLength(), builder.toString());
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.s2e", "could not find insert location for annotation.", (Throwable)e));
        }
    }

    public IAnnotationSourceBuilder getSourceBuilder() {
        return this.m_sourceBuilder;
    }
}

