/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.Document;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.SourceFormatOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class CompilationUnitWriteOperation
implements IOperation {
    private final IJavaProject m_project;
    private final IPackageFragmentRoot m_root;
    private final String m_packageName;
    private final String m_fileName;
    private final String m_content;
    private ICompilationUnit m_createdCompilationUnit;

    public CompilationUnitWriteOperation(IType existingJdtType, String content) {
        this(((IType)Validate.notNull((Object)existingJdtType)).getCompilationUnit(), content);
    }

    public CompilationUnitWriteOperation(ICompilationUnit existingUnit, String content) {
        this((IPackageFragment)((ICompilationUnit)Validate.notNull((Object)existingUnit)).getAncestor(4), existingUnit.getElementName(), content);
    }

    public CompilationUnitWriteOperation(IPackageFragment pck, String fileName, String content) {
        this((IPackageFragmentRoot)((IPackageFragment)Validate.notNull((Object)pck)).getAncestor(3), pck.getElementName(), fileName, content);
    }

    public CompilationUnitWriteOperation(IPackageFragmentRoot srcFolder, ICompilationUnitSourceBuilder contentBuilder) {
        this(srcFolder, contentBuilder, null);
    }

    public CompilationUnitWriteOperation(IPackageFragmentRoot srcFolder, ICompilationUnitSourceBuilder contentBuilder, IJavaEnvironment env) {
        this(srcFolder, contentBuilder.getPackageName(), contentBuilder.getElementName(), S2eUtils.createJavaCode((ISourceBuilder)contentBuilder, srcFolder.getJavaProject(), env));
    }

    public CompilationUnitWriteOperation(IPackageFragmentRoot srcFolder, String packageName, String fileName, String content) {
        this.m_root = (IPackageFragmentRoot)Validate.notNull((Object)srcFolder);
        this.m_project = srcFolder.getJavaProject();
        this.m_packageName = StringUtils.isBlank((CharSequence)packageName) ? "" : packageName;
        this.m_fileName = (String)Validate.notNull((Object)fileName);
        this.m_content = content;
    }

    @Override
    public String getOperationName() {
        StringBuilder sb = new StringBuilder("write ");
        sb.append(this.m_root.getPath().toString()).append('/');
        if (!this.m_packageName.isEmpty()) {
            sb.append(this.m_packageName.replace('.', '/')).append('/');
        }
        sb.append(this.m_fileName);
        return sb.toString();
    }

    public ICompilationUnit getCreatedCompilationUnit() {
        return this.m_createdCompilationUnit;
    }

    @Override
    public void validate() {
    }

    public IResource getAffectedResource() {
        IResource result = this.m_root.getResource();
        IPackageFragment packageFragment = this.m_root.getPackageFragment(this.m_packageName);
        if (packageFragment.exists()) {
            result = packageFragment.getResource();
            ICompilationUnit compilationUnit = packageFragment.getCompilationUnit(this.m_fileName);
            if (compilationUnit.exists()) {
                result = compilationUnit.getResource();
            }
        }
        return result;
    }

    protected static String getSourceFormatted(String unformattedJavaSource, IJavaProject settings, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SourceFormatOperation op = new SourceFormatOperation(settings, new Document(unformattedJavaSource));
        op.validate();
        op.run(monitor, workingCopyManager);
        return op.getDocument().get();
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)4);
        try {
            String newSource = CompilationUnitWriteOperation.getSourceFormatted(this.m_content, this.m_project, (IProgressMonitor)progress.newChild(0), workingCopyManager);
            if (progress.isCanceled()) {
                return;
            }
            progress.worked(1);
            IPackageFragment pck = this.m_root.getPackageFragment(this.m_packageName);
            if (!pck.exists()) {
                pck = this.m_root.createPackageFragment(this.m_packageName, true, (IProgressMonitor)progress.newChild(0));
            }
            progress.worked(1);
            this.m_createdCompilationUnit = pck.getCompilationUnit(this.m_fileName);
            if (!this.m_createdCompilationUnit.exists()) {
                this.m_createdCompilationUnit = pck.createCompilationUnit(this.m_fileName, newSource, true, (IProgressMonitor)progress.newChild(0));
                progress.worked(1);
                workingCopyManager.register(this.m_createdCompilationUnit, (IProgressMonitor)progress.newChild(0));
                progress.worked(1);
            } else {
                String oldSource = S2eUtils.getContentOfFile((IFile)this.m_createdCompilationUnit.getResource());
                progress.worked(1);
                if (!CompilationUnitWriteOperation.isSourceEqual(oldSource, newSource)) {
                    workingCopyManager.register(this.m_createdCompilationUnit, (IProgressMonitor)progress.newChild(0));
                    IBuffer buffer = this.m_createdCompilationUnit.getBuffer();
                    buffer.setContents(newSource);
                }
                progress.worked(1);
            }
        }
        catch (Exception e) {
            SdkLog.error((String)"Could not {}", (Object[])new Object[]{this.getOperationName(), e});
        }
    }

    protected static boolean isSourceEqual(String source1, String source2) {
        if (source1 == source2) {
            return true;
        }
        if (source1 == null || source2 == null) {
            return false;
        }
        source1 = CompilationUnitWriteOperation.getSourceStartingAtPackage(source1);
        source2 = CompilationUnitWriteOperation.getSourceStartingAtPackage(source2);
        if (source1.length() != source2.length()) {
            return false;
        }
        return source1.equals(source2);
    }

    protected static String getSourceStartingAtPackage(String fullSource) {
        int packagePos = fullSource.indexOf("package ");
        if (packagePos <= 0) {
            return fullSource;
        }
        return fullSource.substring(packagePos);
    }
}

