/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.search;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.model.INlsEntry;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.search.ui.text.Match;

public class NlsFindKeysJob
extends Job {
    private final List<String> m_searchKeys;
    private final Map<String, List<Match>> m_matches;

    public NlsFindKeysJob(String nlsKey, String jobTitle) {
        super(jobTitle);
        this.m_searchKeys = new ArrayList<String>(1);
        this.m_searchKeys.add("\"" + nlsKey + "\"");
        this.m_matches = new HashMap<String, List<Match>>(this.m_searchKeys.size());
    }

    public NlsFindKeysJob(INlsProject project, String jobTitle) {
        super(jobTitle);
        this.m_searchKeys = new ArrayList<String>();
        for (INlsEntry e : project.getAllEntries()) {
            if (e.getType() != 1) continue;
            this.m_searchKeys.add("\"" + e.getKey() + "\"");
        }
        this.m_matches = new HashMap<String, List<Match>>(this.m_searchKeys.size());
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            this.m_matches.clear();
            IJavaProject[] javaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
            monitor.beginTask("Searching for NLS keys", javaProjects.length);
            IJavaProject[] iJavaProjectArray = javaProjects;
            int n = javaProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject root = iJavaProjectArray[n2];
                monitor.setTaskName("Searching in '" + root.getElementName() + "'.");
                IProject p = root.getProject();
                Path outputLocation = Paths.get(new File(p.getLocation().toOSString(), root.getOutputLocation().removeFirstSegments(1).toOSString()).toURI());
                this.searchInFolder(Paths.get(p.getLocation().toFile().toURI()), p.getDefaultCharset(), outputLocation, monitor);
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                try {
                    monitor.worked(1);
                    ++n2;
                    continue;
                }
                catch (Exception e) {
                    SdkLog.error((String)"Could not create java projects for nls search.", (Object[])new Object[]{e});
                }
                break;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected void searchInFolder(Path folder, final String charset, final Path outputFolder, final IProgressMonitor monitor) throws IOException {
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                boolean isHiddenDir;
                if (monitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
                if (dir.equals(outputFolder)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path fileName = dir.getFileName();
                boolean bl = isHiddenDir = fileName != null && fileName.toString().startsWith(".");
                if (isHiddenDir) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path path = file.getFileName();
                if (path == null) {
                    return FileVisitResult.CONTINUE;
                }
                String fileName = path.toString().toLowerCase();
                if (attrs.isRegularFile() && (fileName.endsWith(".java") || fileName.endsWith(".html"))) {
                    NlsFindKeysJob.this.searchInFile(file, charset, monitor);
                }
                if (monitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected void searchInFile(Path file, String charset, IProgressMonitor monitor) throws IOException {
        String content = new String(Files.readAllBytes(file), charset);
        IFile[] workspaceFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toUri());
        if (workspaceFiles.length < 1) {
            return;
        }
        IFile workspaceFile = workspaceFiles[0];
        if (!workspaceFile.exists()) {
            return;
        }
        for (String search : this.m_searchKeys) {
            int pos = 0;
            int index = -1;
            while ((index = content.indexOf(search, pos)) >= 0) {
                if (monitor.isCanceled()) {
                    return;
                }
                Match match = new Match((Object)workspaceFile, index, search.length());
                String key = search.substring(1, search.length() - 1);
                this.acceptNlsKeyMatch(key, match);
                pos = index + search.length();
            }
        }
    }

    protected void acceptNlsKeyMatch(String nlsKey, Match match) {
        List<Match> list = this.m_matches.get(nlsKey);
        if (list == null) {
            list = new ArrayList<Match>();
            this.m_matches.put(nlsKey, list);
        }
        list.add(match);
    }

    public List<Match> getMatches(String nlsKey) {
        List<Match> list = this.m_matches.get(nlsKey);
        if (list == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Match>(list);
    }

    public Map<String, List<Match>> getAllMatches() {
        return new HashMap<String, List<Match>>(this.m_matches);
    }
}

