/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.simpleproject;

import java.beans.PropertyChangeListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.util.BasicPropertySupport;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.internal.simpleproject.INlsType;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.WeakResourceChangeListener;

public class NlsType
implements INlsType {
    public static final char FOLDER_SEGMENT_SEPARATOR = '/';
    public static final String RESOURCE_BUNDLE_FIELD_NAME = "RESOURCE_BUNDLE_NAME";
    public static final String PROP_TRANSLATION_FOLDER_NAME = "translationFolderName";
    public static final String PROP_TRANSLATION_FILE_PREFIX = "translationFilePrefix";
    public static final String PROP_SUPER_TYPE = "superType";
    private static final Pattern REGEX_RESOURCE_BUNDLE_FIELD = Pattern.compile("RESOURCE_BUNDLE_NAME\\s*=\\s*\\\"([^\\\"]*)\\\"\\s*\\;", 32);
    protected IResourceChangeListener m_nlsResourceChangeListener;
    protected final IType m_type;
    protected final BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);

    public NlsType(IType type) {
        this.m_type = type;
        if (!this.m_type.isReadOnly()) {
            this.m_nlsResourceChangeListener = new P_NlsResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new WeakResourceChangeListener(this.m_nlsResourceChangeListener), 1);
        }
        this.reload();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    protected String getBundleValue() throws JavaModelException {
        Matcher matcher;
        IField field = this.m_type.getField(RESOURCE_BUNDLE_FIELD_NAME);
        if (S2eUtils.exists((IJavaElement)field) && (matcher = REGEX_RESOURCE_BUNDLE_FIELD.matcher(field.getSource())).find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected void loadSuperTypeHierarchy() throws JavaModelException {
        String superTypeFqn;
        ITypeHierarchy superTypeHierarchy = this.m_type.newSupertypeHierarchy(null);
        IType firstType = superTypeHierarchy.getSuperclass(this.m_type);
        if (S2eUtils.exists((IJavaElement)firstType) && !"org.eclipse.scout.rt.platform.nls.DynamicNls".equals(superTypeFqn = firstType.getFullyQualifiedName()) && !Object.class.getName().equals(superTypeFqn)) {
            this.m_propertySupport.setProperty(PROP_SUPER_TYPE, (Object)firstType);
        }
    }

    public void reload() {
        try {
            String bundleValue = this.getBundleValue();
            if (bundleValue != null) {
                String[] splitedValue = bundleValue.split("\\.");
                String filePrefix = splitedValue[splitedValue.length - 1];
                StringBuilder folderName = new StringBuilder();
                int i = 0;
                while (i < splitedValue.length - 1) {
                    folderName.append('/').append(splitedValue[i]);
                    ++i;
                }
                this.setTranslationFolderName(folderName.toString());
                this.setTranslationFilePrefix(filePrefix);
            }
            this.loadSuperTypeHierarchy();
        }
        catch (JavaModelException e) {
            SdkLog.error((String)"could not reload NLS type '{}'.", (Object[])new Object[]{this.m_type.getFullyQualifiedName(), e});
        }
    }

    @Override
    public IType getType() {
        return this.m_type;
    }

    protected void setTranslationFolderName(String name) {
        this.m_propertySupport.setPropertyString(PROP_TRANSLATION_FOLDER_NAME, name);
    }

    @Override
    public String getTranslationsFolderName() {
        return this.m_propertySupport.getPropertyString(PROP_TRANSLATION_FOLDER_NAME);
    }

    protected void setTranslationFilePrefix(String filePrefix) {
        this.m_propertySupport.setPropertyString(PROP_TRANSLATION_FILE_PREFIX, filePrefix);
    }

    @Override
    public String getTranslationsPrefix() {
        return this.m_propertySupport.getPropertyString(PROP_TRANSLATION_FILE_PREFIX);
    }

    public IType getSuperType() {
        return (IType)this.m_propertySupport.getProperty(PROP_SUPER_TYPE);
    }

    private class P_NlsResourceChangeListener
    implements IResourceChangeListener {
        private P_NlsResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!S2eUtils.exists((IJavaElement)NlsType.this.m_type)) {
                return;
            }
            final IResource resourceToFind = NlsType.this.m_type.getResource();
            if (resourceToFind == null || !resourceToFind.exists()) {
                return;
            }
            try {
                final boolean[] resourceFound = new boolean[1];
                IResourceDelta delta = event.getDelta();
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta d) throws CoreException {
                        if (resourceFound[0]) {
                            return false;
                        }
                        resourceFound[0] = resourceToFind.equals((Object)d.getResource());
                        return !resourceFound[0];
                    }
                });
                if (resourceFound[0]) {
                    NlsType.this.reload();
                }
            }
            catch (CoreException e) {
                SdkLog.warning((Object[])new Object[]{e});
            }
        }
    }
}

