/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.code;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalListener;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.TypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.code.CodeTypeNewWizard;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.CompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class CodeTypeNewWizardPage
extends CompilationUnitNewWizardPage {
    private final IJavaEnvironmentProvider m_provider;
    private final ProposalTextField[] m_typeArgFields;
    private static final int NUM_ARG_FIELDS = 3;

    public CodeTypeNewWizardPage(PackageContainer packageContainer) {
        super(CodeTypeNewWizardPage.class.getName(), packageContainer, "CodeType", "org.eclipse.scout.rt.shared.services.common.code.ICodeType", "org.eclipse.scout.rt.shared.services.common.code.AbstractCodeType", ScoutTier.Shared);
        this.setTitle("Create a new CodeType");
        this.setDescription(this.getTitle());
        this.setIcuGroupName("New CodeType Details");
        this.m_provider = new CachingJavaEnvironmentProvider();
        this.m_typeArgFields = new ProposalTextField[3];
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.createArgumentsGroup(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_code-type_page_context");
    }

    protected void createArgumentsGroup(Composite p) {
        Group parent = this.getFieldToolkit().createGroupBox(p, "Type Arguments");
        parent.setLayoutData((Object)new GridData(768));
        parent.setLayout((Layout)new GridLayout(1, true));
        int i = 0;
        while (i < 3) {
            this.m_typeArgFields[i] = this.getFieldToolkit().createTypeProposalField((Composite)parent, this.getTypeArgLabel(i), this.getJavaProject());
            this.m_typeArgFields[i].setLayoutData(new GridData(768));
            this.m_typeArgFields[i].addProposalListener(new IProposalListener(){

                @Override
                public void proposalAccepted(Object proposal) {
                    CodeTypeNewWizardPage.this.pingStateChanging();
                }
            });
            ++i;
        }
        this.syncTypeArgFieldsToSuperType();
    }

    protected String getTypeArgLabel(int index) {
        switch (index) {
            case 0: {
                return "First Argument";
            }
            case 1: {
                return "Second Argument";
            }
            case 2: {
                return "Third Argument";
            }
        }
        throw new SdkException("unsupported index: " + index);
    }

    protected IJavaEnvironment getEnvironment() {
        return this.m_provider.get(this.getJavaProject());
    }

    @Override
    protected void handleJavaProjectChanged() {
        super.handleJavaProjectChanged();
        if (!this.isControlCreated()) {
            return;
        }
        ProposalTextField[] proposalTextFieldArray = this.m_typeArgFields;
        int n = this.m_typeArgFields.length;
        int n2 = 0;
        while (n2 < n) {
            ProposalTextField field = proposalTextFieldArray[n2];
            ((TypeContentProvider)field.getContentProvider()).setJavaProject(this.getJavaProject());
            ++n2;
        }
    }

    @Override
    protected void handleSuperTypeChanged() {
        super.handleSuperTypeChanged();
        if (this.isControlCreated()) {
            this.syncTypeArgFieldsToSuperType();
        }
    }

    protected void syncTypeArgFieldsToSuperType() {
        IType superType = this.getSuperType();
        if (!S2eUtils.exists((IJavaElement)superType)) {
            ProposalTextField[] proposalTextFieldArray = this.m_typeArgFields;
            int n = this.m_typeArgFields.length;
            int n2 = 0;
            while (n2 < n) {
                ProposalTextField field = proposalTextFieldArray[n2];
                field.setEnabled(false);
                ++n2;
            }
        } else {
            List typeParameters = S2eUtils.jdtTypeToScoutType((IType)superType, (IJavaEnvironment)this.getEnvironment()).typeParameters();
            int i = 0;
            while (i < 3) {
                boolean typeParamAvailable = typeParameters.size() > i;
                this.m_typeArgFields[i].setEnabled(typeParamAvailable);
                if (typeParamAvailable) {
                    List bounds = ((ITypeParameter)typeParameters.get(i)).bounds();
                    TypeContentProvider typeContentProvider = (TypeContentProvider)this.m_typeArgFields[i].getContentProvider();
                    if (bounds.isEmpty()) {
                        typeContentProvider.setBaseClassFqn(null);
                    } else {
                        typeContentProvider.setBaseClassFqn(((org.eclipse.scout.sdk.core.model.api.IType)bounds.get(0)).name());
                    }
                }
                ++i;
            }
        }
    }

    public String getSuperTypeSignature() {
        IType superType = this.getSuperType();
        StringBuilder superTypeBuilder = new StringBuilder(superType.getFullyQualifiedName());
        try {
            int numParams = superType.getTypeParameters().length;
            if (numParams > 0) {
                superTypeBuilder.append('<');
                int i = 0;
                while (i < numParams) {
                    if (i != 0) {
                        superTypeBuilder.append(',');
                    }
                    String param = null;
                    boolean appendCodeGeneric = false;
                    if (i < 3) {
                        IType selectedProposal = (IType)this.m_typeArgFields[i].getSelectedProposal();
                        appendCodeGeneric = selectedProposal.getTypeParameters().length > 0 && S2eUtils.hierarchyContains((ITypeHierarchy)selectedProposal.newSupertypeHierarchy(null), (String)"org.eclipse.scout.rt.shared.services.common.code.ICode");
                        param = selectedProposal.getFullyQualifiedName();
                    } else {
                        param = "java.lang.Object";
                    }
                    superTypeBuilder.append(param);
                    if (appendCodeGeneric) {
                        superTypeBuilder.append('<');
                        superTypeBuilder.append(SignatureUtils.toFullyQualifiedName((String)this.getCodeIdDatatypeSignature()));
                        superTypeBuilder.append('>');
                    }
                    ++i;
                }
                superTypeBuilder.append('>');
            }
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
        return Signature.createTypeSignature((String)superTypeBuilder.toString());
    }

    public String getCodeIdDatatypeSignature() {
        return this.getCodeTypeTypeArgDatatypeSig(1);
    }

    public String getCodeTypeIdDatatypeSignature() {
        return this.getCodeTypeTypeArgDatatypeSig(0);
    }

    protected String getCodeTypeTypeArgDatatypeSig(int typeParamIndex) {
        org.eclipse.scout.sdk.core.model.api.IType superType = S2eUtils.jdtTypeToScoutType((IType)this.getSuperType(), (IJavaEnvironment)this.getEnvironment());
        org.eclipse.scout.sdk.core.model.api.IType codeTypeIdArg = (org.eclipse.scout.sdk.core.model.api.IType)superType.superTypes().withName("org.eclipse.scout.rt.shared.services.common.code.ICodeType").first().typeArguments().get(typeParamIndex);
        if (codeTypeIdArg.isParameterType()) {
            List typeParameters = superType.typeParameters();
            int index = -1;
            int i = 0;
            while (i < typeParameters.size()) {
                if (((ITypeParameter)typeParameters.get(i)).elementName().equals(codeTypeIdArg.elementName())) {
                    index = i;
                    break;
                }
                ++i;
            }
            IType result = null;
            if (index >= 0 && index < 3) {
                result = (IType)this.m_typeArgFields[index].getSelectedProposal();
            }
            if (result != null) {
                return Signature.createTypeSignature((String)result.getFullyQualifiedName());
            }
        } else {
            return codeTypeIdArg.signature();
        }
        return Signature.createTypeSignature((String)"java.lang.Object");
    }

    public CodeTypeNewWizard getWizard() {
        return (CodeTypeNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getStatusTypeArgFields());
    }

    protected IStatus getStatusTypeArgFields() {
        if (this.isControlCreated()) {
            ProposalTextField[] proposalTextFieldArray = this.m_typeArgFields;
            int n = this.m_typeArgFields.length;
            int n2 = 0;
            while (n2 < n) {
                IType selected;
                ProposalTextField field = proposalTextFieldArray[n2];
                if (field.isEnabled() && !S2eUtils.exists((IJavaElement)(selected = (IType)field.getSelectedProposal()))) {
                    return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose the type arguments.");
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }
}

