/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.lookupcall;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.lookupcall.LookupCallNewOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.lookupcall.LookupCallNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;

public class LookupCallNewWizard
extends AbstractWizard
implements INewWizard {
    public static volatile Class<? extends LookupCallNewWizardPage> pageClass = LookupCallNewWizardPage.class;
    private LookupCallNewWizardPage m_page1;
    private boolean m_executed = false;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        PackageContainer packageContainer = S2eUiUtils.getSharedPackageOfSelection((ISelection)selection);
        try {
            this.m_page1 = pageClass.getConstructor(PackageContainer.class).newInstance(packageContainer);
            this.addPage((IWizardPage)this.m_page1);
            this.setWindowTitle(this.m_page1.getTitle());
            this.setHelpAvailable(true);
            this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        }
        catch (InvocationTargetException e) {
            throw new SdkException(e.getCause());
        }
        catch (Exception e) {
            throw new SdkException((Throwable)e);
        }
    }

    public void scheduleLookupCallCreation(LookupCallNewOperation op) {
        this.scheduleLookupCallCreation(op, null);
    }

    public void scheduleLookupCallCreation(final LookupCallNewOperation op, Set<IResource> blockingFolders) {
        IPackageFragmentRoot testSourceFolder;
        if (this.isExecuted()) {
            return;
        }
        if (blockingFolders == null) {
            blockingFolders = new HashSet<IResource>(3);
        }
        op.setPackage(this.m_page1.getTargetPackage());
        op.setLookupCallName(this.m_page1.getIcuName());
        op.setSharedSourceFolder(this.m_page1.getSourceFolder());
        blockingFolders.add(this.m_page1.getSourceFolder().getResource());
        op.setSuperType(this.m_page1.getSuperType());
        op.setKeyType(this.m_page1.getKeyType());
        IPackageFragmentRoot serverSourceFolder = this.m_page1.getServerSourceFolder();
        if (S2eUtils.exists((IJavaElement)serverSourceFolder)) {
            blockingFolders.add(serverSourceFolder.getResource());
        }
        op.setServerSourceFolder(serverSourceFolder);
        op.setLookupServiceSuperType(this.m_page1.getServiceImplSuperType());
        if (!S2eUtils.exists((IJavaElement)op.getTestSourceFolder()) && (testSourceFolder = S2eUiUtils.getTestSourceFolder((IJavaElement)this.m_page1.getServerSourceFolder(), null, "LookupCall test")) != null) {
            op.setTestSourceFolder(testSourceFolder);
            blockingFolders.add(testSourceFolder.getResource());
        }
        final Display d = this.getContainer().getShell().getDisplay();
        ResourceBlockingOperationJob job = new ResourceBlockingOperationJob((IOperation)op, blockingFolders.toArray(new IResource[blockingFolders.size()]));
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IType createdLookupCallType = op.getCreatedLookupCall();
                        if (!S2eUtils.exists((IJavaElement)createdLookupCallType)) {
                            return;
                        }
                        try {
                            JavaUI.openInEditor((IJavaElement)createdLookupCallType, (boolean)true, (boolean)true);
                        }
                        catch (JavaModelException | PartInitException e) {
                            SdkLog.info((String)"Unable to open type {} in editor.", (Object[])new Object[]{createdLookupCallType.getFullyQualifiedName(), e});
                        }
                    }
                });
            }
        });
        job.schedule();
        this.setExecuted(true);
    }

    @Override
    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        if (!this.isExecuted()) {
            this.scheduleLookupCallCreation(new LookupCallNewOperation());
        }
        return true;
    }

    public boolean isExecuted() {
        return this.m_executed;
    }

    protected void setExecuted(boolean executed) {
        this.m_executed = executed;
    }
}

