/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wizard.page;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalListener;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.page.PageNewWizard;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.CompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class PageNewWizardPage
extends CompilationUnitNewWizardPage {
    public static final String PROP_SHARED_SOURCE_FOLDER = "sharedSourceFolder";
    public static final String PROP_SERVER_SOURCE_FOLDER = "serverSourceFolder";
    protected ProposalTextField m_sharedSourceFolder;
    protected ProposalTextField m_serverSourceFolder;

    public PageNewWizardPage(PackageContainer packageContainer) {
        super(PageNewWizardPage.class.getName(), packageContainer, "TablePage", "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage", "org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithTable", ScoutTier.Client);
        this.setTitle("Create a new Page");
        this.setDescription(this.getTitle());
        this.setIcuGroupName("New Page Details");
    }

    public PageNewWizard getWizard() {
        return (PageNewWizard)super.getWizard();
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.guessSharedFolders();
        this.createPageServcieGroup(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.scout.sdk.s2e.ui.scout_wizard_page_page_context");
    }

    @Override
    protected void handleJavaProjectChanged() {
        super.handleJavaProjectChanged();
        this.guessSharedFolders();
    }

    @Override
    protected void handleSuperTypeChanged() {
        super.handleSuperTypeChanged();
        IType superType = this.getSuperType();
        if (S2eUtils.exists((IJavaElement)superType)) {
            try {
                ITypeHierarchy supertypeHierarchy = superType.newSupertypeHierarchy(null);
                if (S2eUtils.hierarchyContains((ITypeHierarchy)supertypeHierarchy, (String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable")) {
                    this.setReadOnlySuffix("TablePage");
                } else {
                    this.setReadOnlySuffix("NodePage");
                }
            }
            catch (JavaModelException e) {
                SdkLog.warning((String)"Unable to calculate super type hierarchy for type '{}'.", (Object[])new Object[]{superType.getFullyQualifiedName(), e});
            }
        }
    }

    protected void guessSharedFolders() {
        IPackageFragmentRoot clientSourceFolder = this.getSourceFolder();
        if (!S2eUtils.exists((IJavaElement)clientSourceFolder)) {
            return;
        }
        try {
            this.setServerSourceFolder(ScoutTier.Client.convert(ScoutTier.Server, clientSourceFolder));
        }
        catch (JavaModelException e) {
            SdkLog.info((String)"Unable to calculate server source folder.", (Object[])new Object[]{e});
        }
        try {
            this.setSharedSourceFolder(ScoutTier.Client.convert(ScoutTier.Shared, clientSourceFolder));
        }
        catch (JavaModelException e) {
            SdkLog.info((String)"Unable to calculate shared source folder.", (Object[])new Object[]{e});
        }
    }

    protected void createPageServcieGroup(Composite p) {
        Group parent = this.getFieldToolkit().createGroupBox(p, "PageData & Service Source Folders");
        parent.setLayoutData((Object)new GridData(768));
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_sharedSourceFolder = this.getFieldToolkit().createSourceFolderTextField((Composite)parent, "Shared Source Folder", ScoutTier.Shared, 20);
        GridData sharedGridData = new GridData(768);
        sharedGridData.horizontalSpan = 3;
        sharedGridData.verticalIndent = 8;
        this.m_sharedSourceFolder.setLayoutData(sharedGridData);
        this.m_sharedSourceFolder.acceptProposal(this.getSharedSourceFolder());
        this.m_sharedSourceFolder.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                PageNewWizardPage.this.setSharedSourceFolderInternal((IPackageFragmentRoot)proposal);
                PageNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_serverSourceFolder = this.getFieldToolkit().createSourceFolderTextField((Composite)parent, "Server Source Folder", ScoutTier.Server, 20);
        this.m_serverSourceFolder.setLayoutData(new GridData(768));
        this.m_serverSourceFolder.acceptProposal(this.getServerSourceFolder());
        this.m_serverSourceFolder.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                PageNewWizardPage.this.setServerSourceFolderInternal((IPackageFragmentRoot)proposal);
                PageNewWizardPage.this.pingStateChanging();
            }
        });
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.getProperty(PROP_SHARED_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        try {
            this.setStateChanging(true);
            this.setSharedSourceFolderInternal(sharedSourceFolder);
            if (this.isControlCreated() && this.m_sharedSourceFolder != null) {
                this.m_sharedSourceFolder.acceptProposal(sharedSourceFolder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setSharedSourceFolderInternal(IPackageFragmentRoot sharedSourceFolder) {
        this.setProperty(PROP_SHARED_SOURCE_FOLDER, sharedSourceFolder);
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.getProperty(PROP_SERVER_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        try {
            this.setStateChanging(true);
            this.setServerSourceFolderInternal(serverSourceFolder);
            if (this.isControlCreated() && this.m_serverSourceFolder != null) {
                this.m_serverSourceFolder.acceptProposal(serverSourceFolder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setServerSourceFolderInternal(IPackageFragmentRoot serverSourceFolder) {
        this.setProperty(PROP_SERVER_SOURCE_FOLDER, serverSourceFolder);
    }
}

