/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.internal;

import org.apache.maven.archetype.catalog.Archetype;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.archetype.ArchetypeManager;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.internal.dto.DtoDerivedResourceHandlerFactory;
import org.eclipse.scout.sdk.s2e.internal.trigger.DerivedResourceManager;
import org.osgi.framework.BundleContext;

public class S2ESdkActivator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.scout.sdk.s2e";
    private static volatile S2ESdkActivator plugin;
    private DerivedResourceManager m_derivedResourceManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.m_derivedResourceManager = new DerivedResourceManager();
        this.m_derivedResourceManager.addDerivedResourceHandlerFactory(new DtoDerivedResourceHandlerFactory());
        Job j = new Job("register scout archetype"){

            protected IStatus run(IProgressMonitor monitor) {
                S2ESdkActivator.registerScoutArchetype();
                return Status.OK_STATUS;
            }
        };
        j.setUser(false);
        j.setSystem(true);
        j.schedule(1000L);
    }

    public void stop(BundleContext context) throws Exception {
        this.m_derivedResourceManager.dispose();
        this.m_derivedResourceManager = null;
        plugin = null;
        super.stop(context);
    }

    public static S2ESdkActivator getDefault() {
        return plugin;
    }

    public DerivedResourceManager getDerivedResourceManager() {
        return this.m_derivedResourceManager;
    }

    private static void registerScoutArchetype() {
        try {
            MavenPluginActivator mavenPlugin = MavenPluginActivator.getDefault();
            if (mavenPlugin == null) {
                return;
            }
            ArchetypeManager archetypeManager = mavenPlugin.getArchetypeManager();
            if (archetypeManager == null) {
                return;
            }
            org.apache.maven.archetype.ArchetypeManager archetyper = archetypeManager.getArchetyper();
            if (archetyper == null) {
                return;
            }
            Archetype archetype = new Archetype();
            archetype.setGroupId("org.eclipse.scout.archetypes");
            archetype.setArtifactId("scout-helloworld-app");
            archetype.setVersion("6.0.0.RC1");
            archetype.setDescription("Creates a new Scout helloworld application. Instead of using the 'Maven Project' wizard you may also use the 'Scout Project' wizard which already prefills all properties with correct values.");
            archetype.setRepository("http://repo1.maven.org/maven2/");
            archetyper.updateLocalCatalog(archetype);
        }
        catch (Exception e) {
            SdkLog.info((String)"Unable to register Scout HelloWorld archetype.", (Object[])new Object[]{e});
        }
    }
}

