/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.internal.trigger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.trigger.IDerivedResourceHandler;
import org.eclipse.scout.sdk.s2e.trigger.IDerivedResourceHandlerFactory;
import org.eclipse.scout.sdk.s2e.trigger.IDerivedResourceManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class DerivedResourceManager
implements IDerivedResourceManager {
    public static final String TYPE_CHANGED_TRIGGER_JOB_FAMILY = "AUTO_UPDATE_JOB_FAMILY";
    public static final String JAVA_DELTA_CHECK_JOB_FAMILY = "JAVA_DELTA_CHECK_JOB_FAMILY";
    private boolean m_enabled = false;
    private final List<IDerivedResourceHandlerFactory> m_updateHandlerFactories = new ArrayList<IDerivedResourceHandlerFactory>();
    private IResourceChangeListener m_resourceChangeListener;
    private final BlockingQueue<IResourceChangeEvent> m_javaChangeEventsToCheck = new ArrayBlockingQueue<IResourceChangeEvent>(5000, true);
    private final P_ResourceChangeEventCheckJob m_javaDeltaCheckJob;
    private final BlockingQueue<IDerivedResourceHandler> m_triggerHandlers = new ArrayBlockingQueue<IDerivedResourceHandler>(2000, true);
    private final P_RunQueuedTriggerHandlersJob m_runQueuedTriggerHandlersJob = new P_RunQueuedTriggerHandlersJob(this.m_triggerHandlers);

    public DerivedResourceManager() {
        this.m_javaDeltaCheckJob = new P_ResourceChangeEventCheckJob(this, this.m_javaChangeEventsToCheck);
    }

    public void dispose() {
        this.setEnabled(false);
        AbstractJob.waitForJobFamily(TYPE_CHANGED_TRIGGER_JOB_FAMILY);
    }

    @Override
    public void addDerivedResourceHandlerFactory(IDerivedResourceHandlerFactory handler) {
        this.m_updateHandlerFactories.add(handler);
    }

    @Override
    public void removeDerivedResourceHandlerFactory(IDerivedResourceHandlerFactory handler) {
        this.m_updateHandlerFactories.remove(handler);
    }

    @Override
    public void trigger(final Set<IResource> resources) {
        AbstractJob triggerJob = new AbstractJob("Searching base resources for derived resources update..."){

            protected IStatus run(IProgressMonitor monitor) {
                DerivedResourceManager.this.triggerSync(resources);
                return Status.OK_STATUS;
            }
        };
        triggerJob.setPriority(50);
        triggerJob.schedule();
    }

    protected void triggerSync(Set<IResource> resources) {
        Set<IResource> cleanResources = DerivedResourceManager.cleanCopy(resources);
        if (this.enqueueFiles(cleanResources)) {
            this.m_runQueuedTriggerHandlersJob.abort();
            this.m_runQueuedTriggerHandlersJob.schedule(1000L);
        }
    }

    protected boolean enqueueFiles(Set<IResource> resources) {
        if (resources.isEmpty()) {
            return false;
        }
        boolean added = false;
        try {
            CachingJavaEnvironmentProvider envProvider = new CachingJavaEnvironmentProvider();
            IJavaSearchScope searchScope = S2eUtils.createJavaSearchScope(resources);
            for (IDerivedResourceHandler handler : this.createOperations(resources, envProvider, searchScope)) {
                if (this.m_triggerHandlers.contains(handler)) continue;
                if (DerivedResourceManager.addElementToQueueSecure(this.m_triggerHandlers, handler, handler.getName(), -1L, null)) {
                    added = true;
                    continue;
                }
                SdkLog.warning((String)"Unable to queue more derived resource update events. Queue is already full. Skipping event: {}", (Object[])new Object[]{handler.getName()});
            }
        }
        catch (CoreException e) {
            SdkLog.warning((String)"Unable to create java search scope", (Object[])new Object[]{e});
        }
        return added;
    }

    protected static Set<IResource> cleanCopy(Set<IResource> resources) {
        if (resources == null) {
            return Collections.emptySet();
        }
        HashSet<IResource> cleanSet = new HashSet<IResource>(resources.size());
        for (IResource r : resources) {
            if (r == null || !r.isAccessible() || DerivedResourceManager.existsParentIn(resources, r)) continue;
            cleanSet.add(r);
        }
        return cleanSet;
    }

    protected static boolean existsParentIn(Collection<IResource> searchList, IResource resource) {
        IPath path = resource.getFullPath();
        for (IResource r : searchList) {
            if (r == null || !r.isAccessible() || r.equals((Object)resource) || !r.getFullPath().isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    protected Collection<IDerivedResourceHandler> createOperations(Set<IResource> resources, IJavaEnvironmentProvider envProvider, IJavaSearchScope searchScope) {
        ArrayList<IDerivedResourceHandler> all = null;
        for (IDerivedResourceHandlerFactory factory : this.m_updateHandlerFactories) {
            try {
                List<IDerivedResourceHandler> ops = factory.createHandlersFor(resources, envProvider, searchScope);
                if (ops == null || ops.isEmpty()) continue;
                if (all == null) {
                    all = new ArrayList<IDerivedResourceHandler>();
                }
                all.addAll(ops);
            }
            catch (Exception e) {
                SdkLog.error((String)"Unable to create operation with handler '{}'.", (Object[])new Object[]{factory.getClass(), e});
            }
        }
        if (all == null) {
            return Collections.emptyList();
        }
        return all;
    }

    @Override
    public synchronized void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        if (enabled) {
            if (this.m_resourceChangeListener == null) {
                this.m_resourceChangeListener = new P_ResourceChangeListener(this.m_javaChangeEventsToCheck);
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.m_resourceChangeListener, 1);
            }
            this.m_javaDeltaCheckJob.schedule();
        } else {
            Thread thread;
            if (this.m_resourceChangeListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.m_resourceChangeListener);
                this.m_resourceChangeListener = null;
            }
            if ((thread = this.m_javaDeltaCheckJob.getThread()) != null) {
                this.m_javaDeltaCheckJob.cancel();
                thread.interrupt();
                try {
                    this.m_javaDeltaCheckJob.join(3000L, null);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public synchronized boolean isEnabled() {
        return this.m_enabled;
    }

    private static <T> boolean addElementToQueueSecure(BlockingQueue<T> queue, T element, String name, long timeout, TimeUnit unit) {
        int numInterrupted = 0;
        while (true) {
            block5: {
                boolean interrupted;
                try {
                    interrupted = false;
                    if (timeout == 0L) {
                        return queue.offer(element);
                    }
                    if (timeout >= 0L) break block5;
                    queue.put(element);
                    return true;
                }
                catch (InterruptedException e) {
                    if (interrupted = numInterrupted++ < 10) continue;
                    SdkLog.warning((String)"Too many thread interrupts while waiting for space in the trigger queue. Skipping '{}'.", (Object[])new Object[]{name});
                    return false;
                }
            }
            return queue.offer(element, timeout, unit);
            break;
        }
    }

    private static final class P_ResourceChangeEventCheckJob
    extends AbstractJob {
        private final DerivedResourceManager m_manager;
        private final BlockingQueue<IResourceChangeEvent> m_queueToConsume;

        private P_ResourceChangeEventCheckJob(DerivedResourceManager manager, BlockingQueue<IResourceChangeEvent> queueToConsume) {
            super("Check if resource delta triggers a derived resource update");
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(50);
            this.m_manager = manager;
            this.m_queueToConsume = queueToConsume;
        }

        public boolean belongsTo(Object family) {
            return DerivedResourceManager.JAVA_DELTA_CHECK_JOB_FAMILY.equals(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!monitor.isCanceled()) {
                IResourceChangeEvent event = null;
                try {
                    event = this.m_queueToConsume.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (event == null || event.getDelta() == null) continue;
                Set<IResource> resources = P_ResourceChangeEventCheckJob.collectFilesFromDelta(event.getDelta());
                this.m_manager.triggerSync(resources);
            }
            return Status.CANCEL_STATUS;
        }

        private static Set<IResource> collectFilesFromDelta(IResourceDelta d) {
            final HashSet<IResource> scope = new HashSet<IResource>();
            try {
                d.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource != null && resource.getType() == 1 && resource.exists()) {
                            scope.add(resource);
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                SdkLog.error((String)"Could not calculate the resources affected by a change event.", (Object[])new Object[]{e});
            }
            return scope;
        }
    }

    private static final class P_ResourceChangeListener
    implements IResourceChangeListener {
        private final BlockingQueue<IResourceChangeEvent> m_eventCollector;

        private P_ResourceChangeListener(BlockingQueue<IResourceChangeEvent> eventCollector) {
            this.m_eventCollector = eventCollector;
        }

        private static boolean acceptUpdateEvent() {
            Job curJob = Job.getJobManager().currentJob();
            if (curJob == null) {
                return false;
            }
            if (curJob instanceof AbstractJob || curJob instanceof P_RunQueuedTriggerHandlersJob) {
                return false;
            }
            if (curJob.belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD) || curJob.belongsTo(ResourcesPlugin.FAMILY_MANUAL_BUILD)) {
                return false;
            }
            String[] excludedJobNamePrefixes = new String[]{"org.eclipse.team.", "org.eclipse.core.internal.events.NotificationManager.NotifyJob", "org.eclipse.egit.", "org.eclipse.core.internal.events.AutoBuildJob", "org.eclipse.m2e.", "org.eclipse.jdt.internal.core.ExternalFoldersManager.RefreshJob", "org.eclipse.core.internal.refresh.RefreshJob", "org.eclipse.jdt.internal.ui.InitializeAfterLoadJob.RealJob", "org.eclipse.wst.jsdt.internal.ui.InitializeAfterLoadJob.RealJob"};
            String jobFqn = curJob.getClass().getName().replace('$', '.');
            String[] stringArray = excludedJobNamePrefixes;
            int n = excludedJobNamePrefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String excludedPrefix = stringArray[n2];
                if (jobFqn.startsWith(excludedPrefix)) {
                    return false;
                }
                ++n2;
            }
            if ("org.eclipse.core.internal.jobs.ThreadJob".equals(jobFqn)) {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                int i = stackTrace.length - 1;
                while (i >= 0) {
                    String[] stringArray2 = excludedJobNamePrefixes;
                    int n3 = excludedJobNamePrefixes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String excludedPrefix = stringArray2[n4];
                        if (stackTrace[i].getClassName().startsWith(excludedPrefix)) {
                            return false;
                        }
                        ++n4;
                    }
                    --i;
                }
            }
            return true;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event != null && P_ResourceChangeListener.acceptUpdateEvent() && !DerivedResourceManager.addElementToQueueSecure(this.m_eventCollector, event, event.toString(), 10L, TimeUnit.SECONDS)) {
                SdkLog.warning((String)"Unable to queue more java element changes. Queue is already full. Skipping event.", (Object[])new Object[0]);
            }
        }
    }

    private static final class P_RunQueuedTriggerHandlersJob
    extends AbstractJob {
        private final BlockingQueue<IDerivedResourceHandler> m_queueToConsume;
        private boolean m_isAborted;

        private P_RunQueuedTriggerHandlersJob(BlockingQueue<IDerivedResourceHandler> queueToConsume) {
            super("Auto-updating derived resources");
            this.setRule(RunTriggerHandlersJobRule.INSTANCE);
            this.setPriority(50);
            this.m_isAborted = false;
            this.m_queueToConsume = queueToConsume;
        }

        public boolean belongsTo(Object family) {
            return DerivedResourceManager.TYPE_CHANGED_TRIGGER_JOB_FAMILY.equals(family);
        }

        private void abort() {
            this.m_isAborted = true;
        }

        private boolean isAborted() {
            return this.m_isAborted;
        }

        private IStatus doCancel() {
            this.m_queueToConsume.clear();
            return Status.CANCEL_STATUS;
        }

        private IStatus doAbort() {
            this.m_isAborted = false;
            this.schedule();
            return Status.CANCEL_STATUS;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return this.doCancel();
            }
            if (this.isAborted()) {
                return this.doAbort();
            }
            int numOperations = this.m_queueToConsume.size();
            if (numOperations < 1) {
                return Status.OK_STATUS;
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)numOperations);
            int i = 1;
            while (i <= numOperations) {
                if (progress.isCanceled()) {
                    return this.doCancel();
                }
                if (this.isAborted()) {
                    return this.doAbort();
                }
                IDerivedResourceHandler handler = (IDerivedResourceHandler)this.m_queueToConsume.poll();
                try {
                    progress.setTaskName(String.valueOf(handler.getName()) + " [" + i + " of " + numOperations + "]");
                    progress.subTask("");
                    handler.validate();
                    long start = System.currentTimeMillis();
                    try {
                        handler.run((IProgressMonitor)progress.newChild(1));
                    }
                    catch (Throwable throwable) {
                        SdkLog.debug((String)"Derived Resource Handler ({}) took {}ms to execute.", (Object[])new Object[]{handler.getName(), System.currentTimeMillis() - start});
                        throw throwable;
                    }
                    SdkLog.debug((String)"Derived Resource Handler ({}) took {}ms to execute.", (Object[])new Object[]{handler.getName(), System.currentTimeMillis() - start});
                }
                catch (Exception e) {
                    SdkLog.error((String)"Error while: {}", (Object[])new Object[]{handler.getName(), e});
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
    }

    public static final class RunTriggerHandlersJobRule
    implements ISchedulingRule {
        public static final RunTriggerHandlersJobRule INSTANCE = new RunTriggerHandlersJobRule();

        private RunTriggerHandlersJobRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == INSTANCE;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == INSTANCE;
        }
    }
}

