/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.page;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.sourcebuilder.page.PageSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.testcase.TestSourceBuilder;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.CompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.MethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerationContext;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerators;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.service.ServiceNewOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;

public class PageNewOperation
implements IOperation {
    private final IJavaEnvironmentProvider m_javaEnvironmentProvider;
    private String m_pageName;
    private IPackageFragmentRoot m_clientSourceFolder;
    private IPackageFragmentRoot m_pageDataSourceFolder;
    private IPackageFragmentRoot m_sharedSourceFolder;
    private IPackageFragmentRoot m_serverSourceFolder;
    private IPackageFragmentRoot m_testSourceFolder;
    private String m_package;
    private IType m_superType;
    private IType m_createdPage;
    private IType m_createdPageData;
    private IType m_createdServiceIfc;
    private IType m_createdServiceImpl;
    private IType m_createdServiceTest;
    private String m_dataFetchMethodName;

    public PageNewOperation() {
        this(new CachingJavaEnvironmentProvider());
    }

    protected PageNewOperation(IJavaEnvironmentProvider provider) {
        this.m_javaEnvironmentProvider = provider;
    }

    @Override
    public String getOperationName() {
        return "Create Page '" + this.getPageName() + "'.";
    }

    @Override
    public void validate() {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getPageName()), (String)"No page name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getClientSourceFolder()), (String)"No client source folder provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getPackage()), (String)"No package name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSuperType()), (String)"No supertype provided", (Object[])new Object[0]);
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        boolean isCreateService;
        boolean isCreatePageData;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)5);
        String sharedPackage = ScoutTier.Client.convert(ScoutTier.Shared, this.getPackage());
        boolean isPageWithTable = S2eUtils.hierarchyContains(this.getSuperType().newSupertypeHierarchy(null), "org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable");
        boolean bl = isCreatePageData = isPageWithTable && S2eUtils.exists((IJavaElement)this.getPageDataSourceFolder());
        if (isCreatePageData) {
            this.setCreatedPageData(this.createPageData(sharedPackage, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        }
        boolean bl2 = isCreateService = isCreatePageData && S2eUtils.exists((IJavaElement)this.getSharedSourceFolder()) && S2eUtils.exists((IJavaElement)this.getServerSourceFolder());
        if (isCreateService) {
            this.createService(sharedPackage, this.calcServiceBaseName(), (IProgressMonitor)progress.newChild(2), workingCopyManager);
        }
        progress.setWorkRemaining(2);
        this.setCreatedPage(this.createPage(isPageWithTable, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        if (isCreateService) {
            this.setCreatedServiceTest(this.createServiceTest((IProgressMonitor)progress.newChild(1), workingCopyManager));
        }
        progress.setWorkRemaining(0);
        if (isCreatePageData) {
            ScoutSdkCore.getDerivedResourceManager().trigger(Collections.singleton(this.getCreatedPage().getResource()));
        }
    }

    protected String calcServiceMethodName() {
        String name = this.calcPageBaseName();
        return "get" + name + "TableData";
    }

    protected String calcPageBaseName() {
        String[] suffixes;
        String name = this.getPageName();
        String[] stringArray = suffixes = new String[]{"NodePage", "TablePage", "Page"};
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)suffix)) {
                name = name.substring(0, name.length() - suffix.length());
            }
            ++n2;
        }
        return name;
    }

    protected String calcServiceBaseName() {
        return this.calcPageBaseName();
    }

    protected IType createServiceTest(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        if (!S2eUtils.exists((IJavaElement)this.getTestSourceFolder())) {
            return null;
        }
        String serverPackage = Signature.getQualifier((String)this.getCreatedServiceImpl().getFullyQualifiedName());
        String baseName = this.getCreatedServiceImpl().getElementName();
        String elementName = String.valueOf(baseName) + "Test";
        IType existingServiceTest = this.getTestSourceFolder().getJavaProject().findType(serverPackage, elementName);
        if (S2eUtils.exists((IJavaElement)existingServiceTest)) {
            return existingServiceTest;
        }
        IJavaEnvironment env = this.getEnvProvider().get(this.getTestSourceFolder().getJavaProject());
        TestSourceBuilder testBuilder = new TestSourceBuilder(elementName, serverPackage, env);
        testBuilder.setRunnerSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.testing.server.runner.ServerTestRunner"));
        testBuilder.setClientTest(false);
        IType session = S2eUtils.getSession(this.getServerSourceFolder().getJavaProject(), ScoutTier.Server, monitor);
        if (S2eUtils.exists((IJavaElement)session)) {
            testBuilder.setSessionSignature(Signature.createTypeSignature((String)session.getFullyQualifiedName()));
        }
        testBuilder.setup();
        return S2eUtils.writeType(this.getTestSourceFolder(), (ICompilationUnitSourceBuilder)testBuilder, env, monitor, workingCopyManager);
    }

    protected void createService(String sharedPackage, String baseName, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        ServiceNewOperation serviceNewOperation = this.createServiceOperation();
        serviceNewOperation.setServiceName(baseName);
        serviceNewOperation.setSharedPackage(sharedPackage);
        serviceNewOperation.setSharedSourceFolder(this.getSharedSourceFolder());
        serviceNewOperation.setServerSourceFolder(this.getServerSourceFolder());
        serviceNewOperation.addMethod(this.createServiceMethod());
        serviceNewOperation.validate();
        serviceNewOperation.run(monitor, workingCopyManager);
        this.setCreatedServiceImpl(serviceNewOperation.getCreatedServiceImpl());
        this.setCreatedServiceIfc(serviceNewOperation.getCreatedServiceInterface());
    }

    protected IMethodSourceBuilder createServiceMethod() {
        this.setDataFetchMethodName(this.calcServiceMethodName());
        MethodSourceBuilder methodBuilder = new MethodSourceBuilder(this.getDataFetchMethodName());
        methodBuilder.setFlags(1);
        methodBuilder.setComment(CommentSourceBuilderFactory.createDefaultMethodComment((IMethodSourceBuilder)methodBuilder));
        final String pageDataSig = Signature.createTypeSignature((String)this.getCreatedPageData().getFullyQualifiedName());
        methodBuilder.setReturnTypeSignature(pageDataSig);
        methodBuilder.addParameter((IMethodParameterSourceBuilder)new MethodParameterSourceBuilder("filter", Signature.createTypeSignature((String)"org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter")));
        methodBuilder.setBody(new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                String varName = "pageData";
                source.append(validator.useSignature(pageDataSig)).append(' ').append(varName).append(" = new ").append(validator.useSignature(pageDataSig)).append("();").append(lineDelimiter);
                source.append(CoreUtils.getCommentBlock((String)("fill " + varName + '.'))).append(lineDelimiter);
                source.append("return ").append(varName).append(';');
            }
        });
        return methodBuilder;
    }

    protected ServiceNewOperation createServiceOperation() {
        return new ServiceNewOperation(this.getEnvProvider());
    }

    protected PageSourceBuilder createPageBuilder(boolean isPageWithTable) {
        PageSourceBuilder pageBuilder = new PageSourceBuilder(this.getPageName(), this.getPackage(), this.getEnvProvider().get(this.getClientSourceFolder().getJavaProject()));
        if (ClassIdGenerators.isAutomaticallyCreateClassIdAnnotation()) {
            pageBuilder.setClassIdValue(ClassIdGenerators.generateNewId(new ClassIdGenerationContext(String.valueOf(this.getPackage()) + '.' + this.getPageName())));
        }
        if (S2eUtils.exists((IJavaElement)this.getCreatedPageData())) {
            pageBuilder.setPageDataSignature(Signature.createTypeSignature((String)this.getCreatedPageData().getFullyQualifiedName()));
        }
        if (S2eUtils.exists((IJavaElement)this.getCreatedServiceIfc())) {
            pageBuilder.setPageServiceIfcSignature(Signature.createTypeSignature((String)this.getCreatedServiceIfc().getFullyQualifiedName()));
        }
        pageBuilder.setDataFetchMethodName(this.getDataFetchMethodName());
        pageBuilder.setPageWithTable(isPageWithTable);
        pageBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)this.getSuperType().getFullyQualifiedName()));
        pageBuilder.setup();
        return pageBuilder;
    }

    protected IType createPage(boolean isPageWithTable, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        PageSourceBuilder pageBuilder = this.createPageBuilder(isPageWithTable);
        return S2eUtils.writeType(this.getClientSourceFolder(), (ICompilationUnitSourceBuilder)pageBuilder, pageBuilder.getJavaEnvironment(), monitor, workingCopyManager);
    }

    protected IType createPageData(String sharedPackage, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        String pageDataName = String.valueOf(this.getPageName()) + "Data";
        CompilationUnitSourceBuilder pageDataBuilder = new CompilationUnitSourceBuilder(String.valueOf(pageDataName) + ".java", sharedPackage);
        TypeSourceBuilder formDataTypeBuilder = new TypeSourceBuilder(pageDataName);
        formDataTypeBuilder.setFlags(1);
        formDataTypeBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.shared.data.page.AbstractTablePageData"));
        pageDataBuilder.addType((ITypeSourceBuilder)formDataTypeBuilder);
        return S2eUtils.writeType(this.getPageDataSourceFolder(), (ICompilationUnitSourceBuilder)pageDataBuilder, this.getEnvProvider().get(this.getPageDataSourceFolder().getJavaProject()), monitor, workingCopyManager);
    }

    public IType getCreatedPage() {
        return this.m_createdPage;
    }

    protected void setCreatedPage(IType page) {
        this.m_createdPage = page;
    }

    public String getPageName() {
        return this.m_pageName;
    }

    public void setPageName(String pageName) {
        this.m_pageName = pageName;
    }

    public IPackageFragmentRoot getClientSourceFolder() {
        return this.m_clientSourceFolder;
    }

    public void setClientSourceFolder(IPackageFragmentRoot clientSourceFolder) {
        this.m_clientSourceFolder = clientSourceFolder;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public IType getCreatedPageData() {
        return this.m_createdPageData;
    }

    protected void setCreatedPageData(IType createdPageData) {
        this.m_createdPageData = createdPageData;
    }

    protected IJavaEnvironmentProvider getEnvProvider() {
        return this.m_javaEnvironmentProvider;
    }

    public IPackageFragmentRoot getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IPackageFragmentRoot serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    public IType getCreatedServiceIfc() {
        return this.m_createdServiceIfc;
    }

    protected void setCreatedServiceIfc(IType createdServiceIfc) {
        this.m_createdServiceIfc = createdServiceIfc;
    }

    public IType getCreatedServiceImpl() {
        return this.m_createdServiceImpl;
    }

    protected void setCreatedServiceImpl(IType createdServiceImpl) {
        this.m_createdServiceImpl = createdServiceImpl;
    }

    public IPackageFragmentRoot getPageDataSourceFolder() {
        return this.m_pageDataSourceFolder;
    }

    public void setPageDataSourceFolder(IPackageFragmentRoot pageDataSourceFolder) {
        this.m_pageDataSourceFolder = pageDataSourceFolder;
    }

    public IPackageFragmentRoot getTestSourceFolder() {
        return this.m_testSourceFolder;
    }

    public void setTestSourceFolder(IPackageFragmentRoot testSourceFolder) {
        this.m_testSourceFolder = testSourceFolder;
    }

    public IType getCreatedServiceTest() {
        return this.m_createdServiceTest;
    }

    protected void setCreatedServiceTest(IType createdServiceTest) {
        this.m_createdServiceTest = createdServiceTest;
    }

    protected String getDataFetchMethodName() {
        return this.m_dataFetchMethodName;
    }

    protected void setDataFetchMethodName(String dataFetchMethodName) {
        this.m_dataFetchMethodName = dataFetchMethodName;
    }
}

