/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.core.util.IFilter;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.PackageContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.SourceFolderContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.TypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class FieldToolkit {
    public StyledTextField createStyledTextField(Composite parent, String label) {
        return new StyledTextField(parent, label);
    }

    public StyledTextField createStyledTextField(Composite parent, String label, int labelPercentage) {
        return new StyledTextField(parent, label, labelPercentage);
    }

    public ProposalTextField createProposalField(Composite parent, String label) {
        return this.createProposalField(parent, label, 2);
    }

    public ProposalTextField createProposalField(Composite parent, String label, int style) {
        return this.createProposalField(parent, label, style, 20);
    }

    public ProposalTextField createProposalField(Composite parent, String label, int style, int labelPercentage) {
        if (label == null) {
            label = "";
        }
        ProposalTextField field = new ProposalTextField(parent, style, labelPercentage);
        field.setLabelText(label);
        return field;
    }

    public ProposalTextField createPackageTextField(Composite parent, String label, IJavaProject project) {
        return this.createPackageTextField(parent, label, project, 20);
    }

    public ProposalTextField createPackageTextField(Composite parent, String label, IJavaProject project, int labelPercentage) {
        ProposalTextField proposalField = this.createProposalField(parent, label, 1, labelPercentage);
        PackageContentProvider provider = new PackageContentProvider(project);
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        proposalField.setProposalDescriptionProvider(provider);
        return proposalField;
    }

    public ProposalTextField createSourceFolderTextField(Composite parent, String label, ScoutTier tier, int labelPercentage) {
        ProposalTextField proposalField = this.createProposalField(parent, label, 1, labelPercentage);
        SourceFolderContentProvider provider = new SourceFolderContentProvider((IFilter<IJavaElement>)tier);
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        return proposalField;
    }

    public ProposalTextField createAbstractTypeProposalField(Composite parent, String label, IJavaProject jp, String baseClassFqn) {
        return this.createAbstractTypeProposalField(parent, label, jp, baseClassFqn, 20);
    }

    public ProposalTextField createAbstractTypeProposalField(Composite parent, String label, IJavaProject jp, String baseClassFqn, int labelPercentage) {
        ProposalTextField proposalField = this.createProposalField(parent, label, 1, labelPercentage);
        StrictHierarchyTypeContentProvider provider = new StrictHierarchyTypeContentProvider(jp, baseClassFqn);
        provider.setTypeProposalFilter((IFilter<IType>)new S2eUtils.PublicAbstractPrimaryTypeFilter());
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        proposalField.setProposalDescriptionProvider(provider);
        return proposalField;
    }

    public ProposalTextField createTypeProposalField(Composite parent, String label, IJavaProject jp) {
        return this.createTypeProposalField(parent, label, jp, 20);
    }

    public ProposalTextField createTypeProposalField(Composite parent, String label, IJavaProject jp, int labelPercentage) {
        ProposalTextField proposalField = this.createProposalField(parent, label, 1, labelPercentage);
        TypeContentProvider provider = new TypeContentProvider(jp);
        provider.setTypeProposalFilter((IFilter<IType>)new S2eUtils.PublicPrimaryTypeFilter());
        proposalField.setContentProvider(provider);
        proposalField.setLabelProvider((IBaseLabelProvider)provider);
        proposalField.setProposalDescriptionProvider(provider);
        return proposalField;
    }

    public Group createGroupBox(Composite parent, String label) {
        Group group = new Group(parent, 16);
        group.setText(label);
        return group;
    }

    public Button createCheckBox(Composite parent, String label, boolean checkedByDefault) {
        Button btn = new Button(parent, 32);
        btn.setText(label);
        btn.setSelection(checkedByDefault);
        return btn;
    }
}

