/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.FutureTask;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.model.ScoutModelHierarchy;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.job.RunnableJob;
import org.eclipse.scout.sdk.s2e.ui.internal.template.BigDecimalFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ButtonProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.CalendarFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.CodeProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ColumnProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.DateFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ExtensionProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.FormFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.FormHandlerProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.KeyStrokeProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.LabelFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ListBoxFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.LongFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.MenuProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.RadioButtonProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.SequenceBoxProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.StringFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TabBoxProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TableFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TemplateProposalDescriptor;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TreeFieldProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ValueTypeFieldProposal;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public final class ScoutTemplateProposalFactory {
    public static final Map<String, TemplateProposalDescriptor> TEMPLATES = new ConcurrentHashMap<String, TemplateProposalDescriptor>();

    static {
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField", "org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField", "MyString", "Field", "stringfield_add.gif", 1000, StringFieldProposal.class, Arrays.asList("textfield")));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.IBigDecimalField", "org.eclipse.scout.rt.client.ui.form.fields.bigdecimalfield.AbstractBigDecimalField", "MyBigDecimal", "Field", "doublefield_add.gif", 1000, BigDecimalFieldProposal.class, Arrays.asList("numberfield", "doublefield", "floatfield")));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField", "org.eclipse.scout.rt.client.ui.form.fields.booleanfield.AbstractBooleanField", "MyBoolean", "Field", "formField_add.png", 1000, FormFieldProposal.class, Arrays.asList("checkboxfield")));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.button.IButton", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.button.IButton", "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton", "My", "Button", "button_add.gif", 1000, ButtonProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.calendarfield.ICalendarField", "org.eclipse.scout.rt.client.ui.form.fields.calendarfield.AbstractCalendarField", "MyCalendar", "Field", "formField_add.png", 1000, CalendarFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField", "org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField", "MyDate", "Field", "datefield_add.gif", 1000, DateFieldProposal.class, Arrays.asList("datetimefield")));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField", "org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.AbstractFileChooserField", "MyFileChooser", "Field", "filechooserfield_add.gif", 1000, FormFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox", "org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox", "MyGroup", "Box", "groupbox_add.png", 1000, FormFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField", "org.eclipse.scout.rt.client.ui.form.fields.htmlfield.AbstractHtmlField", "MyHtml", "Field", "formField_add.png", 1000, FormFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.labelfield.ILabelField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.labelfield.ILabelField", "org.eclipse.scout.rt.client.ui.form.fields.labelfield.AbstractLabelField", "MyLabel", "Field", "formField_add.png", 1000, LabelFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox", "org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox", "MyList", "Box", "formField_add.png", 1000, ListBoxFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.smartfield.IProposalField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.smartfield.IProposalField", "org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractProposalField", "MyProposal", "Field", "smartfield_add.gif", 1000, ValueTypeFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField", "org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField", "MySmart", "Field", "smartfield_add.gif", 1000, ValueTypeFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField", "org.eclipse.scout.rt.client.ui.form.fields.longfield.AbstractLongField", "MyLong", "Field", "integerfield_add.gif", 1000, LongFieldProposal.class, Arrays.asList("integerfield", "numberfield")));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup", "org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup", "MyRadioButtonGroup", "Box", "radiobuttonGroup_add.gif", 1000, ValueTypeFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox", "org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox", "MySequence", "Box", "sequencebox_add.gif", 1000, SequenceBoxProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox", "org.eclipse.scout.rt.client.ui.form.fields.tabbox.AbstractTabBox", "MyTab", "Box", "tabbox_add.gif", 1000, TabBoxProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField", "org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField", "MyTable", "Field", "tablefield_add.gif", 1000, TableFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.treefield.ITreeField", "org.eclipse.scout.rt.client.ui.form.fields.treefield.AbstractTreeField", "MyTree", "Field", "treefield_add.gif", 1000, TreeFieldProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton", "org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton", "MyRadio", "Button", "radiobutton_add.gif", 1000, RadioButtonProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.action.menu.IMenu", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.action.menu.IMenu", "org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu", "MyMenu", "Menu", "menu_add.png", 1000, MenuProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke", "org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke", "My", "KeyStroke", "keystroke_add.png", 1000, KeyStrokeProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.shared.services.common.code.ICode", new TemplateProposalDescriptor("org.eclipse.scout.rt.shared.services.common.code.ICode", "org.eclipse.scout.rt.shared.services.common.code.AbstractCode", "My", "Code", "code_add.png", 1000, CodeProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.form.IFormHandler", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.form.IFormHandler", "org.eclipse.scout.rt.client.ui.form.AbstractFormHandler", "My", "Handler", "formHandler.png", 1000, FormHandlerProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn", new TemplateProposalDescriptor("org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn", "org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn", "My", "Column", "tableColumn_add.png", 1000, ColumnProposal.class));
        TEMPLATES.put("org.eclipse.scout.rt.shared.extension.IExtension", new TemplateProposalDescriptor("org.eclipse.scout.rt.shared.extension.IExtension", "org.eclipse.scout.rt.shared.extension.AbstractExtension", "My", "Extension", "extension_add.png", 1000, ExtensionProposal.class));
    }

    private ScoutTemplateProposalFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ICompletionProposal> createTemplateProposals(IType surroundingType, int offset, String prefix) {
        HashSet<String> possibleChildrenIfcFqn = new HashSet<String>();
        HashSet<String> superTypesOfSurroundingType = null;
        ISourceRange surroundingTypeNameRange = null;
        try {
            ITypeHierarchy supertypeHierarchy = surroundingType.newSupertypeHierarchy(null);
            IType[] allTypes = supertypeHierarchy.getAllTypes();
            superTypesOfSurroundingType = new HashSet<String>(allTypes.length);
            IType[] iTypeArray = allTypes;
            int n = allTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType superType = iTypeArray[n2];
                superTypesOfSurroundingType.add(superType.getFullyQualifiedName());
                ++n2;
            }
            System.out.println("old: " + superTypesOfSurroundingType.size());
            surroundingTypeNameRange = surroundingType.getNameRange();
        }
        catch (JavaModelException e) {
            SdkLog.error((String)"Unable to calculate supertype hierarchy for '{}'.", (Object[])new Object[]{surroundingType.getFullyQualifiedName(), e});
            return Collections.emptyList();
        }
        if (superTypesOfSurroundingType.contains("org.eclipse.scout.rt.client.ui.form.fields.tabbox.AbstractTabBox") || superTypesOfSurroundingType.contains("org.eclipse.scout.rt.client.extension.ui.form.fields.tabbox.AbstractTabBoxExtension")) {
            possibleChildrenIfcFqn.add("org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox");
            possibleChildrenIfcFqn.add("org.eclipse.scout.rt.client.ui.action.menu.IMenu");
            possibleChildrenIfcFqn.add("org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke");
        } else if (superTypesOfSurroundingType.contains("org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox") || superTypesOfSurroundingType.contains("org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBox") || superTypesOfSurroundingType.contains("org.eclipse.scout.rt.client.extension.ui.form.fields.listbox.AbstractListBoxExtension") || superTypesOfSurroundingType.contains("org.eclipse.scout.rt.client.extension.ui.form.fields.treebox.AbstractTreeBoxExtension")) {
            possibleChildrenIfcFqn.add("org.eclipse.scout.rt.client.ui.action.menu.IMenu");
            possibleChildrenIfcFqn.add("org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke");
        } else if (superTypesOfSurroundingType.contains("org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroup") || superTypesOfSurroundingType.contains("org.eclipse.scout.rt.client.extension.ui.form.fields.radiobuttongroup.AbstractRadioButtonGroupExtension")) {
            possibleChildrenIfcFqn.add("org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton");
            possibleChildrenIfcFqn.add("org.eclipse.scout.rt.client.ui.action.menu.IMenu");
            possibleChildrenIfcFqn.add("org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke");
        } else {
            for (String superType : superTypesOfSurroundingType) {
                Set possibleChildren = ScoutModelHierarchy.getPossibleChildren((String)superType);
                if (possibleChildren.isEmpty()) continue;
                possibleChildrenIfcFqn.addAll(possibleChildren);
            }
        }
        if (possibleChildrenIfcFqn.isEmpty()) {
            return Collections.emptyList();
        }
        ICompilationUnit compilationUnit = surroundingType.getCompilationUnit();
        FutureTask<IJavaEnvironmentProvider> javaEnvProviderCreator = new FutureTask<IJavaEnvironmentProvider>(new P_JavaEnvironmentInitCallable(compilationUnit, prefix != null, offset));
        RunnableJob javaEnvCreatorJob = new RunnableJob("Init Java Environment", javaEnvProviderCreator);
        javaEnvCreatorJob.setUser(false);
        javaEnvCreatorJob.setSystem(true);
        javaEnvCreatorJob.setPriority(20);
        javaEnvCreatorJob.schedule();
        IJavaProject javaProject = surroundingType.getJavaProject();
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        TemplateProposalDescriptor[] templates = null;
        Map<String, TemplateProposalDescriptor> map = TEMPLATES;
        synchronized (map) {
            templates = TEMPLATES.values().toArray(new TemplateProposalDescriptor[TEMPLATES.size()]);
        }
        TemplateProposalDescriptor[] templateProposalDescriptorArray = templates;
        int n = templates.length;
        int n3 = 0;
        while (n3 < n) {
            TemplateProposalDescriptor candidate = templateProposalDescriptorArray[n3];
            if (candidate.isActiveFor(possibleChildrenIfcFqn, javaProject, prefix)) {
                result.add(candidate.createProposal(compilationUnit, offset, surroundingTypeNameRange, javaEnvProviderCreator, prefix));
            }
            ++n3;
        }
        return result;
    }

    private static final class P_JavaEnvironmentInitCallable
    implements Callable<IJavaEnvironmentProvider> {
        private final ICompilationUnit m_icu;
        private final boolean m_hasSearchString;
        private final int m_pos;

        private P_JavaEnvironmentInitCallable(ICompilationUnit icu, boolean hasSearchString, int pos) {
            this.m_icu = icu;
            this.m_hasSearchString = hasSearchString;
            this.m_pos = pos;
        }

        @Override
        public IJavaEnvironmentProvider call() throws Exception {
            CachingJavaEnvironmentProvider provider = new CachingJavaEnvironmentProvider();
            String pck = S2eUtils.getPackage((ICompilationUnit)this.m_icu);
            if (StringUtils.isBlank((CharSequence)pck)) {
                pck = null;
            }
            IJavaEnvironment env = provider.get(this.m_icu.getJavaProject());
            StringBuilder buf = new StringBuilder(this.m_icu.getSource());
            if (this.m_hasSearchString) {
                buf.insert(this.m_pos, ';');
            }
            env.registerCompilationUnitOverride(pck, this.m_icu.getElementName(), buf);
            env.findType(this.m_icu.findPrimaryType().getFullyQualifiedName());
            return provider;
        }
    }
}

