/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.wizard;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalListener;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.PackageContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.util.PackageContainer;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CompilationUnitNewWizardPage
extends AbstractWizardPage {
    private static final Pattern WELLFORMD_JAVAFIELD = Pattern.compile("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b");
    private static final Pattern JAVAFIELD = Pattern.compile("\\b[A-Za-z_][a-zA-Z0-9_]{0,200}\\b");
    public static final String PROP_SOURCE_FOLDER = "sourceFolder";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    public static final String PROP_JAVA_PROJECT = "javaProject";
    public static final String PROP_ICU_NAME = "icuName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_SUPER_TYPE_BASE = "superTypeBase";
    public static final String PREF_SUPER_TYPE = "superType";
    private final String m_superTypeDefaultBase;
    private final String m_defaultSuperType;
    private final ScoutTier m_sourceFolderTier;
    private String m_readOnlySuffix;
    private String m_icuGroupName;
    private ProposalTextField m_sourceFolderField;
    private ProposalTextField m_packageField;
    private StyledTextField m_nameField;
    private ProposalTextField m_superTypeField;
    private Group m_icuGroupField;

    public CompilationUnitNewWizardPage(String pageName, PackageContainer packageContainer, String readOnlySuffix, String superTypeBaseClass, String defaultSuperType, ScoutTier sourceFolderTier) {
        super((String)Validate.notNull((Object)pageName));
        this.m_readOnlySuffix = (String)Validate.notNull((Object)readOnlySuffix);
        this.m_superTypeDefaultBase = superTypeBaseClass;
        this.m_defaultSuperType = (String)Validate.notNull((Object)defaultSuperType);
        this.m_sourceFolderTier = (ScoutTier)Validate.notNull((Object)sourceFolderTier);
        this.setSuperTypeBaseClassInternal(superTypeBaseClass);
        if (packageContainer.getPackage() != null) {
            this.setTargetPackageInternal(packageContainer.getPackage().getElementName());
        }
        this.setSourceFolderInternal(packageContainer.getSrcFolder());
    }

    @Override
    protected void createContent(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createIcuGroup(parent);
    }

    protected void createIcuGroup(Composite p) {
        String groupName = this.getIcuGroupName();
        if (StringUtils.isBlank((CharSequence)groupName)) {
            groupName = "New Class Details";
        }
        this.m_icuGroupField = this.getFieldToolkit().createGroupBox(p, groupName);
        this.m_icuGroupField.setLayoutData((Object)new GridData(768));
        this.m_icuGroupField.setLayout((Layout)new GridLayout(1, true));
        int labelColWidthPercent = 20;
        boolean enabled = S2eUtils.exists((IJavaElement)this.getSourceFolder());
        this.m_sourceFolderField = this.getFieldToolkit().createSourceFolderTextField((Composite)this.m_icuGroupField, "Source Folder", this.m_sourceFolderTier, labelColWidthPercent);
        this.m_sourceFolderField.setLayoutData(new GridData(768));
        this.m_sourceFolderField.acceptProposal(this.getSourceFolder());
        this.m_sourceFolderField.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                CompilationUnitNewWizardPage.this.setSourceFolderInternal((IPackageFragmentRoot)proposal);
                CompilationUnitNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_packageField = this.getFieldToolkit().createPackageTextField((Composite)this.m_icuGroupField, "Package", this.getJavaProject(), labelColWidthPercent);
        this.m_packageField.setLayoutData(new GridData(768));
        this.m_packageField.setText(this.getTargetPackage());
        this.m_packageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompilationUnitNewWizardPage.this.setTargetPackageInternal(CompilationUnitNewWizardPage.this.m_packageField.getText());
                CompilationUnitNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_packageField.setEnabled(enabled);
        this.m_nameField = this.getFieldToolkit().createStyledTextField((Composite)this.m_icuGroupField, "Name", labelColWidthPercent);
        this.m_nameField.setLayoutData(new GridData(768));
        this.m_nameField.setText(this.getIcuName());
        this.m_nameField.setReadOnlySuffix(this.getReadOnlySuffix());
        this.m_nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompilationUnitNewWizardPage.this.setIcuNameInternal(CompilationUnitNewWizardPage.this.m_nameField.getText());
                CompilationUnitNewWizardPage.this.pingStateChanging();
            }
        });
        IType superType = this.calcSuperTypeDefault();
        if (S2eUtils.exists((IJavaElement)superType)) {
            this.setSuperTypeInternal(superType);
        }
        this.m_superTypeField = this.getFieldToolkit().createAbstractTypeProposalField((Composite)this.m_icuGroupField, "Super Class", this.getJavaProject(), this.getSuperTypeBaseClass());
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalListener(new IProposalListener(){

            @Override
            public void proposalAccepted(Object proposal) {
                CompilationUnitNewWizardPage.this.setSuperTypeInternal((IType)proposal);
                CompilationUnitNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField.setEnabled(enabled);
    }

    protected void handleSuperTypeChanged() {
    }

    protected void handleSourceFolderChanged() {
    }

    protected void handleTargetPackageChanged() {
    }

    protected void handleIcuNameChanged() {
    }

    protected IType calcSuperTypeDefault() {
        IType defaultSuperType = null;
        String prefSuperTypeFqn = this.getDialogSettings().get("superType");
        if (StringUtils.isNotBlank((CharSequence)prefSuperTypeFqn)) {
            defaultSuperType = this.resolveType(prefSuperTypeFqn);
        }
        if (!S2eUtils.exists(defaultSuperType)) {
            defaultSuperType = this.resolveType(this.getSuperTypeDefault());
        }
        return defaultSuperType;
    }

    protected IType resolveType(String fqn) {
        return CompilationUnitNewWizardPage.resolveType(this.getJavaProject(), fqn);
    }

    protected static IType resolveType(IJavaProject javaProject, String fqn) {
        if (!S2eUtils.exists((IJavaElement)javaProject)) {
            return null;
        }
        try {
            return javaProject.findType(fqn);
        }
        catch (JavaModelException e) {
            SdkLog.info((String)"Could not find default super type {} in project {}.", (Object[])new Object[]{fqn, javaProject.getElementName(), e});
            return null;
        }
    }

    @Override
    public boolean performFinish() {
        this.getDialogSettings().put("superType", this.getSuperType().getFullyQualifiedName());
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        if (this.m_sourceFolderField.getSelectedProposal() == null) {
            this.m_sourceFolderField.setFocus();
        } else if (StringUtils.isBlank((CharSequence)this.m_packageField.getText())) {
            this.m_packageField.setFocus();
        } else {
            this.m_nameField.setFocus();
        }
    }

    protected void handleJavaProjectChanged() {
        if (!this.isControlCreated()) {
            return;
        }
        boolean isEnabled = S2eUtils.exists((IJavaElement)this.getJavaProject());
        this.m_packageField.setEnabled(isEnabled);
        PackageContentProvider packageContentProvider = (PackageContentProvider)this.m_packageField.getContentProvider();
        packageContentProvider.setJavaProject(this.getJavaProject());
        this.m_packageField.setText(null);
        this.m_superTypeField.setEnabled(isEnabled);
        StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.m_superTypeField.getContentProvider();
        superTypeContentProvider.setJavaProject(this.getJavaProject());
        this.m_superTypeField.acceptProposal(this.getSuperType(), true, true);
        if (this.m_superTypeField.getSelectedProposal() == null) {
            this.m_superTypeField.acceptProposal(this.calcSuperTypeDefault());
        }
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusSourceFolder());
        multiStatus.add(this.getStatusPackage());
        multiStatus.add(this.getStatusName());
        multiStatus.add(this.getStatusSuperType());
    }

    protected IStatus getStatusSourceFolder() {
        if (!S2eUtils.exists((IJavaElement)this.getSourceFolder())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose a source folder.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusPackage() {
        return CompilationUnitNewWizardPage.validatePackageName(this.getTargetPackage());
    }

    protected IStatus getStatusName() {
        IStatus javaFieldNameStatus = CompilationUnitNewWizardPage.validateJavaName(this.getIcuName(), this.getReadOnlySuffix());
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IStatus existingStatus = CompilationUnitNewWizardPage.validateTypeNotExisting(this.getSourceFolder(), this.getTargetPackage(), this.getIcuName());
        if (!existingStatus.isOK()) {
            return existingStatus;
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() {
        if (!S2eUtils.exists((IJavaElement)this.getSuperType())) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please choose a super class.");
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateJavaName(String name, String suffix) {
        if (StringUtils.isBlank((CharSequence)name) || name.equals(suffix)) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Please specify a class name.");
        }
        if (WELLFORMD_JAVAFIELD.matcher(name).matches()) {
            return Status.OK_STATUS;
        }
        if (JAVAFIELD.matcher(name).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.s2e", "Name should start with upper case.");
        }
        return new Status(4, "org.eclipse.scout.sdk.s2e", "Name not valid.");
    }

    private static String getContainingJavaKeyWord(String s) {
        for (String keyWord : CoreUtils.getJavaKeyWords()) {
            if (!s.startsWith(String.valueOf(keyWord) + '.') && !s.endsWith(String.valueOf('.') + keyWord) && !s.contains(String.valueOf('.') + keyWord + '.')) continue;
            return keyWord;
        }
        return null;
    }

    public static IStatus validateTypeNotExisting(IPackageFragmentRoot srcFolder, String pck, String typeName) {
        IPackageFragment packageFragment;
        if (StringUtils.isBlank((CharSequence)typeName)) {
            return Status.OK_STATUS;
        }
        if (!S2eUtils.exists((IJavaElement)srcFolder)) {
            return Status.OK_STATUS;
        }
        if (pck == null) {
            pck = "";
        }
        if (!S2eUtils.exists((IJavaElement)(packageFragment = srcFolder.getPackageFragment(pck)))) {
            return Status.OK_STATUS;
        }
        IFolder folder = (IFolder)packageFragment.getResource();
        if (folder == null || !folder.exists()) {
            return Status.OK_STATUS;
        }
        final boolean[] elementFound = new boolean[1];
        final String typeNameComplete = String.valueOf(typeName) + ".java";
        if (folder.exists()) {
            try {
                folder.accept(new IResourceProxyVisitor(){
                    boolean m_selfVisited = false;

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.getType() == 2) {
                            if (!this.m_selfVisited) {
                                this.m_selfVisited = true;
                                return true;
                            }
                            return false;
                        }
                        if (proxy.getType() == 1 && typeNameComplete.equalsIgnoreCase(proxy.getName())) {
                            elementFound[0] = true;
                        }
                        return false;
                    }
                }, 1, 0);
            }
            catch (CoreException e) {
                SdkLog.warning((String)"Unable to check if the type '{}' already exists.", (Object[])new Object[]{typeName, e});
            }
        }
        if (elementFound[0]) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "Name '" + typeName + "' is already used. Choose another name.");
        }
        return Status.OK_STATUS;
    }

    public static IStatus validatePackageName(String pckName) {
        if (StringUtils.isBlank((CharSequence)pckName)) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The default package is not allowed.");
        }
        String invalidPackageName = "The package name is not valid.";
        if (pckName.contains("..")) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", invalidPackageName);
        }
        Pattern regexPackageName = Pattern.compile("^[0-9a-zA-Z\\.\\_]*$");
        if (!regexPackageName.matcher(pckName).matches()) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", invalidPackageName);
        }
        Pattern regexPackageNameStart = Pattern.compile("[a-zA-Z]{1}.*$");
        Pattern regesPackageNameEnd = Pattern.compile("^.*[a-zA-Z]{1}$");
        if (!regexPackageNameStart.matcher(pckName).matches() || !regesPackageNameEnd.matcher(pckName).matches()) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", invalidPackageName);
        }
        String jkw = CompilationUnitNewWizardPage.getContainingJavaKeyWord(pckName);
        if (jkw != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e", "The package may not contain a reserved Java keyword: '" + jkw + "'");
        }
        Pattern regexContainsUpperCase = Pattern.compile(".*[A-Z].*");
        if (regexContainsUpperCase.matcher(pckName).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.s2e", "The package should contain only lower case characters.");
        }
        return Status.OK_STATUS;
    }

    public IJavaProject getJavaProject() {
        return this.getProperty(PROP_JAVA_PROJECT, IJavaProject.class);
    }

    protected void setJavaProjectInternal(IJavaProject javaProject) {
        if (this.setProperty(PROP_JAVA_PROJECT, javaProject)) {
            this.handleJavaProjectChanged();
        }
    }

    public IPackageFragmentRoot getSourceFolder() {
        return this.getProperty(PROP_SOURCE_FOLDER, IPackageFragmentRoot.class);
    }

    public void setSourceFolder(IPackageFragmentRoot sourceFolder) {
        try {
            this.setStateChanging(true);
            this.setSourceFolderInternal(sourceFolder);
            if (this.isControlCreated() && this.m_sourceFolderField != null) {
                this.m_sourceFolderField.acceptProposal(sourceFolder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setSourceFolderInternal(IPackageFragmentRoot sourceFolder) {
        if (this.setProperty(PROP_SOURCE_FOLDER, sourceFolder)) {
            this.handleSourceFolderChanged();
        }
        if (sourceFolder != null) {
            this.setJavaProjectInternal(sourceFolder.getJavaProject());
        } else {
            this.setJavaProjectInternal(null);
        }
    }

    public String getTargetPackage() {
        return this.getProperty(PROP_TARGET_PACKAGE, String.class);
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_packageField != null) {
                this.m_packageField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        if (this.setProperty(PROP_TARGET_PACKAGE, targetPackage)) {
            this.handleTargetPackageChanged();
        }
    }

    public String getIcuName() {
        return this.getProperty(PROP_ICU_NAME, String.class);
    }

    public void setIcuName(String name) {
        try {
            this.setStateChanging(true);
            this.setIcuNameInternal(name);
            if (this.isControlCreated() && this.m_nameField != null) {
                this.m_nameField.setText(name);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setIcuNameInternal(String name) {
        if (this.setProperty(PROP_ICU_NAME, name)) {
            this.handleIcuNameChanged();
        }
    }

    public IType getSuperType() {
        return this.getProperty("superType", IType.class);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated() && this.m_superTypeField != null) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setSuperTypeInternal(IType superType) {
        if (this.setProperty("superType", superType)) {
            this.handleSuperTypeChanged();
        }
    }

    public String getSuperTypeBaseClass() {
        return this.getProperty(PROP_SUPER_TYPE_BASE, String.class);
    }

    public void setSuperTypeBaseClass(String className) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeBaseClassInternal(className);
            if (this.isControlCreated() && this.m_superTypeField != null) {
                StrictHierarchyTypeContentProvider superTypeContentProvider = (StrictHierarchyTypeContentProvider)this.m_superTypeField.getContentProvider();
                superTypeContentProvider.setBaseClassFqn(className);
                this.m_superTypeField.acceptProposal(this.calcSuperTypeDefault());
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setSuperTypeBaseClassInternal(String className) {
        this.setProperty(PROP_SUPER_TYPE_BASE, className);
    }

    public String getSuperTypeDefault() {
        return this.m_defaultSuperType;
    }

    public String getReadOnlySuffix() {
        return this.m_readOnlySuffix;
    }

    public void setReadOnlySuffix(String newSuffix) {
        this.m_readOnlySuffix = newSuffix;
        if (this.isControlCreated()) {
            this.m_nameField.setReadOnlySuffix(newSuffix);
        }
    }

    public String getIcuGroupName() {
        return this.m_icuGroupName;
    }

    public void setIcuGroupName(String icuGroupName) {
        this.m_icuGroupName = icuGroupName;
    }

    public String getSuperTypeDefaultBase() {
        return this.m_superTypeDefaultBase;
    }

    protected Group getIcuGroupComposite() {
        return this.m_icuGroupField;
    }
}

