/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.dialog.AbstractNlsEntryDialog;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.TextField;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.formatter.IInputValidator;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.formatter.IValidationListener;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.formatter.InputValidator;
import org.eclipse.scout.sdk.s2e.nls.model.NlsEntry;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.swt.widgets.Shell;

public class NlsEntryNewDialog
extends AbstractNlsEntryDialog {
    private final IValidationListener m_validationListener = new IValidationListener(){

        @Override
        public void validationChanged(IStatus valid) {
            NlsEntryNewDialog.this.revalidate();
        }
    };

    public NlsEntryNewDialog(Shell parentShell, INlsProject project, boolean showProjectList) {
        this(parentShell, new NlsEntry("", project), project, showProjectList);
    }

    public NlsEntryNewDialog(Shell parentShell, NlsEntry row, INlsProject project, boolean showProjectList) {
        super(parentShell, "New Entry", row, project, showProjectList);
    }

    @Override
    protected void postCreate() {
        this.getKeyField().setInputValidator(new IInputValidator(){

            @Override
            public IStatus isValid(String value) {
                IInputValidator tmp = InputValidator.getNlsKeyValidator(NlsEntryNewDialog.this.getNlsProject());
                return tmp.isValid(value);
            }
        });
        this.getKeyField().removeValidationListener(this.m_validationListener);
        this.getKeyField().addValidationListener(this.m_validationListener);
        TextField<String> defaultField = this.getDefaultTranslationField();
        defaultField.setInputValidator(InputValidator.getDefaultTranslationValidator());
        defaultField.addValidationListener(new IValidationListener(){

            @Override
            public void validationChanged(IStatus valid) {
                NlsEntryNewDialog.this.revalidate();
            }
        });
        this.revalidate();
    }

    @Override
    protected void revalidate() {
        MultiStatus status = new MultiStatus("org.eclipse.scout.sdk.s2e.nls", -1, "multi status", null);
        status.add(this.getKeyField().getStatus());
        status.add(this.getDefaultTranslationField().getStatus());
        IStatus highestSeverity = NlsCore.getHighestSeverityStatus((IStatus)status);
        if (highestSeverity.isOK()) {
            this.setMessage("Create a new Translation entry.");
        } else {
            this.setMessage(highestSeverity);
        }
        this.getButton(0).setEnabled(highestSeverity.getSeverity() != 4);
    }
}

