/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.AbstractResourceBlockingJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;

public class ResourceBlockingOperationJob
extends AbstractResourceBlockingJob {
    private final Collection<? extends IOperation> m_operations;

    public ResourceBlockingOperationJob(IOperation operation) {
        this(operation, null);
    }

    public ResourceBlockingOperationJob(IOperation operation, IResource ... resources) {
        this(Collections.singletonList(operation), resources);
    }

    public ResourceBlockingOperationJob(Iterable<? extends IOperation> operations) {
        this(operations, null);
    }

    public ResourceBlockingOperationJob(Iterable<? extends IOperation> operations, IResource ... resources) {
        super(ResourceBlockingOperationJob.getJobName(operations), resources);
        ArrayList<IOperation> ops = new ArrayList<IOperation>();
        if (operations != null) {
            for (IOperation iOperation : operations) {
                if (iOperation == null) continue;
                ops.add(iOperation);
            }
        }
        this.m_operations = new ArrayList<IOperation>(ops);
    }

    private static String getJobName(Iterable<? extends IOperation> operations) {
        if (operations == null) {
            return "";
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (IOperation iOperation : operations) {
            if (iOperation == null) continue;
            String itOpName = iOperation.getOperationName();
            if (StringUtils.isBlank((CharSequence)itOpName)) {
                SdkLog.warning((String)"operation '{}' does not have a name.", (Object[])new Object[]{iOperation.getClass().getName()});
                itOpName = "Missing operation name.";
            }
            if (nameBuilder.length() > 0) {
                nameBuilder.append(", ");
            }
            nameBuilder.append(itOpName);
        }
        return nameBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validate() {
        Collection<? extends IOperation> collection = this.m_operations;
        synchronized (collection) {
            for (IOperation iOperation : this.m_operations) {
                iOperation.validate();
            }
        }
    }

    @Override
    protected final void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)ResourceBlockingOperationJob.getJobName(this.m_operations), (int)(this.m_operations.size() * 100));
        if (progress.isCanceled()) {
            return;
        }
        for (IOperation iOperation : this.m_operations) {
            iOperation.run((IProgressMonitor)progress.newChild(100), workingCopyManager);
        }
    }
}

