/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.internal.model.InheritedNlsEntry;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.action.CopyPasteAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.action.FindReferencesAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.action.NlsEntryModifyAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.action.NlsEntryNewAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.action.NlsRefreshAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.action.RemoveAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.action.TranslationNewAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.action.UpdateReferenceCountAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.editor.INlsTableActionHanlder;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.editor.NlsTable;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.editor.NlsTableInputValidator;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.editor.NlsTableModel;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.importexport.NlsExportAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.importexport.NlsImportAction;
import org.eclipse.scout.sdk.s2e.nls.model.INlsEntry;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.scout.sdk.s2e.nls.model.NlsEntry;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProjectListener;
import org.eclipse.scout.sdk.s2e.nls.project.NlsProjectEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NlsTablePage
extends Composite {
    private INlsProject m_nlsProjects;
    private NlsTable m_table;
    private Button m_hideInherited;
    private NlsTableModel m_tableModel;
    private P_ProjectListener m_projectListener;

    public NlsTablePage(Composite parent, INlsProject projects) {
        super(parent, 0);
        this.m_nlsProjects = projects;
        this.m_tableModel = new NlsTableModel(projects);
        FormToolkit toolkit = new FormToolkit(this.getDisplay());
        Form form = toolkit.createForm((Composite)this);
        form.setText("Translations");
        this.createContent(toolkit, form.getBody());
        this.setLayout((Layout)new FillLayout());
        this.createFormMenu(form.getToolBarManager());
        form.updateToolBar();
        this.attachListeners();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NlsTablePage.this.dettachListeners();
            }
        });
    }

    private void attachListeners() {
        if (this.m_projectListener == null) {
            this.m_projectListener = new P_ProjectListener();
        }
        if (this.m_nlsProjects != null) {
            this.m_nlsProjects.addProjectListener(this.m_projectListener);
        }
    }

    private void dettachListeners() {
        if (this.m_projectListener != null && this.m_nlsProjects != null) {
            this.m_nlsProjects.removeProjectListener(this.m_projectListener);
        }
    }

    private void createFormMenu(IToolBarManager manager) {
        manager.add((IAction)new NlsRefreshAction(this.m_nlsProjects));
        manager.add((IAction)new UpdateReferenceCountAction(this.m_nlsProjects, this.m_table, this.m_tableModel));
        manager.add((IAction)new NlsEntryNewAction(this.m_table.getShell(), this.m_nlsProjects, false));
        manager.add((IAction)new TranslationNewAction(this.m_nlsProjects, this.m_table.getShell()));
        manager.add((IAction)new NlsImportAction(this.m_nlsProjects, this.m_table.getShell()));
        manager.add((IAction)new NlsExportAction(this.m_nlsProjects, this.m_table.getShell()));
    }

    private void createContent(FormToolkit toolkit, Composite parent) {
        Composite rootArea = toolkit.createComposite(parent);
        this.m_hideInherited = toolkit.createButton(rootArea, "Hide inherited rows", 32);
        this.m_hideInherited.setSelection(true);
        this.m_hideInherited.setEnabled(this.m_nlsProjects != null);
        this.m_hideInherited.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NlsTablePage.this.m_table.setHideInherited(NlsTablePage.this.m_hideInherited.getSelection());
            }
        });
        this.m_table = new NlsTable(rootArea, this.m_tableModel);
        this.m_table.setHideInherited(this.m_hideInherited.getSelection());
        this.m_table.setInputValidator(new NlsTableInputValidator(this.m_nlsProjects));
        this.m_table.setActionHanlder(new P_TableActionHandler());
        this.m_table.addMenuListener(new P_MenuListener());
        parent.setLayout((Layout)new FillLayout());
        rootArea.setLayout((Layout)new GridLayout(1, true));
        this.m_hideInherited.setLayoutData((Object)new GridData(768));
        this.m_table.setLayoutData(new GridData(1808));
    }

    private void handleProjectChangedEvent(NlsProjectEvent event) {
        try {
            if (this.m_table.isDisposed()) {
                return;
            }
            this.m_table.setRedraw(false);
            boolean fullRefresh = this.handleProjectChangedEventInternalRec(event);
            this.m_table.refreshAll(fullRefresh);
        }
        finally {
            if (!this.m_table.isDisposed()) {
                this.m_table.setRedraw(true);
            }
        }
    }

    private boolean handleProjectChangedEventInternalRec(NlsProjectEvent event) {
        boolean full = false;
        if (event.isMultiEvent()) {
            NlsProjectEvent[] nlsProjectEventArray = event.getChildEvents();
            int n = nlsProjectEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                NlsProjectEvent e = nlsProjectEventArray[n2];
                if (this.handleProjectChangedEventInternalRec(e)) {
                    full = true;
                }
                ++n2;
            }
        } else {
            switch (event.getType()) {
                case 1: {
                    this.m_table.getViewer().reveal((Object)event.getEntry());
                    this.m_table.getViewer().setSelection((ISelection)new StructuredSelection((Object)event.getEntry()));
                    break;
                }
                case 2: {
                    this.m_table.getViewer().remove((Object)event.getEntry());
                    break;
                }
                case 4: 
                case 8: 
                case 16: 
                case 32: {
                    full = true;
                }
            }
        }
        return full;
    }

    private class P_MenuListener
    implements IMenuListener {
        private P_MenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            IStructuredSelection selection = (IStructuredSelection)NlsTablePage.this.m_table.getViewer().getSelection();
            ArrayList<INlsEntry> entries = new ArrayList<INlsEntry>(selection.size());
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                entries.add((NlsEntry)it.next());
            }
            MenuManager menuManager = (MenuManager)manager;
            if (entries.size() == 1) {
                Point cursorPos = NlsTablePage.this.m_table.getCursorLocation();
                if (cursorPos.y < 0) {
                    cursorPos.y = -1;
                }
                TableItem row = null;
                if (cursorPos.x >= 0) {
                    row = NlsTablePage.this.m_table.getViewer().getTable().getItem(cursorPos.x);
                }
                if (row != null) {
                    Language languageOfColumn;
                    INlsEntry e = (INlsEntry)entries.get(0);
                    int colIndex = cursorPos.y;
                    String txt = null;
                    if (colIndex == 1) {
                        txt = e.getKey();
                    } else if (colIndex > 1 && (languageOfColumn = NlsTablePage.this.m_tableModel.getLanguageOfColumn(colIndex)) != null) {
                        txt = e.getTranslation(languageOfColumn);
                    }
                    this.addSingleSelectMenues(menuManager, e, colIndex, txt, e instanceof InheritedNlsEntry);
                }
            } else if (entries.size() > 1) {
                this.addMultiSelectMenues(menuManager, entries);
            }
        }

        private void addSingleSelectMenues(MenuManager manager, INlsEntry entry, int cursorColumn, String cursorText, boolean isInheritedEntry) {
            if (!isInheritedEntry) {
                if (cursorColumn == 1) {
                    manager.add((IAction)new Action("Edit key"){

                        public void run() {
                            NlsTablePage.this.m_table.showEditor();
                        }
                    });
                    manager.add((IContributionItem)new Separator());
                }
                manager.add((IAction)new NlsEntryModifyAction(NlsTablePage.this.getShell(), entry, NlsTablePage.this.m_nlsProjects));
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)new FindReferencesAction(NlsTablePage.this.m_nlsProjects, entry.getKey()));
            if (cursorText != null && cursorText.length() > 0) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new CopyPasteAction("Copy", cursorText, NlsTablePage.this.m_table.getDisplay()));
            }
            if (!isInheritedEntry) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new RemoveAction("Remove " + entry.getKey(), NlsTablePage.this.m_nlsProjects, entry));
            }
        }

        private void addMultiSelectMenues(MenuManager manager, List<INlsEntry> entries) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new RemoveAction("Remove entries", NlsTablePage.this.m_nlsProjects, entries));
        }
    }

    private class P_ProjectListener
    implements INlsProjectListener {
        private P_ProjectListener() {
        }

        @Override
        public void notifyProjectChanged(final NlsProjectEvent event) {
            if (NlsTablePage.this.m_table != null && !NlsTablePage.this.m_table.isDisposed()) {
                NlsTablePage.this.m_table.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        NlsTablePage.this.handleProjectChangedEvent(event);
                    }
                });
            }
        }
    }

    private class P_TableActionHandler
    implements INlsTableActionHanlder {
        private P_TableActionHandler() {
        }

        @Override
        public void handleRefreshTable() {
            NlsRefreshAction refreshAciton = new NlsRefreshAction(NlsTablePage.this.m_nlsProjects);
            refreshAciton.run();
            try {
                refreshAciton.join();
            }
            catch (InterruptedException e) {
                SdkLog.warning((Object[])new Object[]{e});
            }
            NlsTablePage.this.m_nlsProjects = refreshAciton.getNlsProject();
        }

        @Override
        public void handleRefreshReferenceCount(String key) {
        }
    }
}

