/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.fields;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.IInputChangedListener;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.formatter.IInputFormatter;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.formatter.IInputValidator;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.formatter.IValidationListener;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.formatter.TextInputFormatter;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.formatter.TextValidator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TextField<T>
extends Composite {
    public static final int VALIDATE_ON_MODIFY = 8;
    public static final int VALIDATE_ON_FOCUS_LOST = 4;
    public static final int MULTI_LINE_TEXT_FIELD = 2;
    private Text m_text;
    private Label m_label;
    private IInputFormatter<T> m_inputFormatter = new TextInputFormatter();
    private IInputValidator m_inputValidator = new TextValidator();
    private List<IInputChangedListener<T>> m_inputChangedListener = new LinkedList<IInputChangedListener<T>>();
    private List<IValidationListener> m_validationListener = new LinkedList<IValidationListener>();
    private Object m_input;
    private IStatus m_status;
    private final int m_labelColWidth;

    public TextField(Composite parent) {
        this(parent, 4);
    }

    public TextField(Composite parent, int style) {
        this(parent, style, "");
    }

    public TextField(Composite parent, int style, String labelName) {
        this(parent, style, labelName, 40);
    }

    public TextField(Composite parent, int style, String labelName, int labelColWidth) {
        super(parent, 0);
        this.m_labelColWidth = labelColWidth;
        this.setLayout((Layout)new FormLayout());
        this.createComposite(this, style);
        this.setLabelText(labelName);
        this.validateInput();
    }

    public void setLabelVisible(boolean visible) {
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        if (visible) {
            labelData.right = new FormAttachment(40, 0);
        }
        labelData.bottom = new FormAttachment(100, 0);
        this.m_label.setLayoutData((Object)labelData);
        this.m_label.setVisible(visible);
    }

    private void createComposite(Composite parent, int style) {
        boolean isMultiLineTextField;
        this.m_label = new Label(parent, 0);
        this.m_label.setAlignment(131072);
        int txtStyle = 2048;
        boolean bl = isMultiLineTextField = (style & 2) != 0;
        if (isMultiLineTextField) {
            txtStyle = 2818;
        }
        this.m_text = new Text(parent, txtStyle);
        if ((style & 8) != 0) {
            this.m_text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TextField.this.validateInput();
                }
            });
        } else {
            this.m_text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    TextField.this.validateInput();
                }
            });
        }
        if (isMultiLineTextField) {
            this.m_text.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 16) {
                        e.doit = true;
                    }
                }
            });
        }
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(this.m_labelColWidth, 0);
        labelData.bottom = new FormAttachment(100, 0);
        this.m_label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)this.m_label, 5);
        textData.right = new FormAttachment(100, 0);
        textData.bottom = new FormAttachment(100, 0);
        this.m_text.setLayoutData((Object)textData);
    }

    public void addInputChangedListener(IInputChangedListener<T> listener) {
        this.m_inputChangedListener.add(listener);
    }

    public void removeInputChangedListener(IInputChangedListener<T> listener) {
        this.m_inputChangedListener.remove(listener);
    }

    public void addValidationListener(IValidationListener listener) {
        this.m_validationListener.add(listener);
    }

    public void removeValidationListener(IValidationListener listener) {
        this.m_validationListener.remove(listener);
    }

    private void validateInput() {
        String input = this.m_text.getText();
        if (input.equals(this.m_input)) {
            return;
        }
        this.validate();
        for (IInputChangedListener<T> listener : this.m_inputChangedListener) {
            listener.inputChanged(this.m_inputFormatter.parse((Object)this, input));
        }
        this.m_input = input;
    }

    public IStatus getStatus() {
        return this.m_status;
    }

    public IStatus validate() {
        IStatus newValid = this.m_inputValidator.isValid(this.m_text.getText());
        if (!Objects.equals(this.m_status, newValid)) {
            this.m_status = newValid;
            for (IValidationListener listener : this.m_validationListener) {
                listener.validationChanged(newValid);
            }
            if (newValid.getSeverity() < 4) {
                this.m_text.setForeground(null);
            } else {
                this.m_text.setForeground(this.getDisplay().getSystemColor(3));
            }
        }
        return newValid;
    }

    public boolean setFocus() {
        return this.m_text.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.m_text.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.m_text.removeFocusListener(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.m_text.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.m_text.removeModifyListener(listener);
    }

    public void setLabelText(String text) {
        this.m_label.setText(text);
    }

    public String getLabelText() {
        return this.m_label.getText();
    }

    public void setToolTipText(String string) {
        this.m_label.setToolTipText(string);
        this.m_text.setToolTipText(string);
        super.setToolTipText(string);
    }

    public void setValue(T value) {
        this.m_text.setText(this.m_inputFormatter.format((Object)this, value));
    }

    public T getValue() {
        return this.m_inputFormatter.parse((Object)this, this.m_text.getText());
    }

    public void setEditable(boolean editable) {
        this.m_text.setEditable(editable);
    }

    public IInputFormatter<T> getInputFormatter() {
        return this.m_inputFormatter;
    }

    public void setInputFormatter(IInputFormatter<T> inputFormatter) {
        this.m_inputFormatter = inputFormatter;
    }

    public IInputValidator getInputValidator() {
        return this.m_inputValidator;
    }

    public void setInputValidator(IInputValidator inputValidator) {
        this.m_inputValidator = inputValidator;
        this.m_input = null;
        this.validateInput();
    }
}

