/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class ResourceWriteOperation
implements IOperation {
    private final IFile m_file;
    private final String m_content;

    public ResourceWriteOperation(IFile file, String content) {
        this.m_file = file;
        this.m_content = content;
    }

    public ResourceWriteOperation(IFolder resourceFolder, String packageName, String fileName, String content) {
        if (resourceFolder == null) {
            this.m_file = null;
        } else {
            IFolder folder = packageName != null ? resourceFolder.getFolder(packageName.replace('.', '/')) : resourceFolder;
            this.m_file = folder.getFile(fileName);
        }
        this.m_content = content;
    }

    @Override
    public String getOperationName() {
        return "Write " + this.m_file.getProjectRelativePath();
    }

    public IFile getFile() {
        return this.m_file;
    }

    @Override
    public void validate() {
        if (this.m_file == null) {
            throw new IllegalArgumentException("file is null");
        }
        if (this.m_content == null) {
            throw new IllegalArgumentException("content is null");
        }
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        Validate.notNull((Object)workingCopyManager);
        monitor.subTask("Write " + this.m_file.getProjectRelativePath());
        String newSource = this.m_content;
        try {
            String oldSource = S2eUtils.getContentOfFile(this.m_file);
            if (Objects.equals(oldSource, newSource)) {
                return;
            }
            oldSource = null;
            if (monitor.isCanceled()) {
                return;
            }
            String charsetName = this.m_file.getCharset();
            Throwable throwable = null;
            Object var7_9 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(newSource.getBytes(charsetName));){
                if (!this.m_file.exists()) {
                    ResourceWriteOperation.mkdirs(this.m_file.getParent(), monitor);
                    this.m_file.create((InputStream)stream, true, monitor);
                } else {
                    IStatus result = S2eUtils.makeCommittable(Collections.singletonList(this.m_file));
                    if (result.isOK()) {
                        this.m_file.setContents((InputStream)stream, true, true, monitor);
                    } else {
                        SdkLog.warning((String)"Unable to make all resources committable. Save will be skipped.", (Object[])new Object[]{new CoreException(result)});
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            SdkLog.error((String)"could not store '{}'.", (Object[])new Object[]{this.m_file.getProjectRelativePath(), e});
        }
    }

    private static void mkdirs(IContainer dir, IProgressMonitor monitor) throws CoreException {
        if (dir.getType() != 2) {
            return;
        }
        if (!dir.getParent().exists()) {
            ResourceWriteOperation.mkdirs(dir.getParent(), monitor);
        }
        if (!dir.exists()) {
            ((IFolder)dir).create(true, false, monitor);
        }
    }
}

