/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.codetype;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.sourcebuilder.codetype.CodeTypeSourceBuilder;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.RawSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.s2e.CachingJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.IJavaEnvironmentProvider;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerationContext;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerators;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.uniqueid.UniqueIdExtensionPoint;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class CodeTypeNewOperation
implements IOperation {
    private final IJavaEnvironmentProvider m_javaEnvironmentProvider;
    private String m_codeTypeName;
    private IPackageFragmentRoot m_sharedSourceFolder;
    private String m_package;
    private String m_superTypeSignature;
    private String m_codeTypeIdSignature;
    private IType m_createdCodeType;

    public CodeTypeNewOperation() {
        this(new CachingJavaEnvironmentProvider());
    }

    protected CodeTypeNewOperation(IJavaEnvironmentProvider provider) {
        this.m_javaEnvironmentProvider = provider;
    }

    @Override
    public String getOperationName() {
        return "Create CodeType '" + this.getCodeTypeName() + "'.";
    }

    @Override
    public void validate() {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getCodeTypeName()), (String)"No codetype name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)S2eUtils.exists((IJavaElement)this.getSharedSourceFolder()), (String)"No source folder provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getPackage()), (String)"No package name provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getSuperTypeSignature()), (String)"No supertype provided", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getCodeTypeIdSignature()), (String)"No codetype id datatype provided", (Object[])new Object[0]);
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)1);
        this.setCreatedCodeType(this.createCodeType((IProgressMonitor)progress.newChild(1), workingCopyManager));
    }

    protected IType createCodeType(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        IJavaEnvironment env = this.getEnvProvider().get(this.getSharedSourceFolder().getJavaProject());
        CodeTypeSourceBuilder codeTypeBuilder = new CodeTypeSourceBuilder(this.getCodeTypeName(), this.getPackage(), env);
        codeTypeBuilder.setSuperTypeSignature(this.getSuperTypeSignature());
        codeTypeBuilder.setCodeTypeIdSignature(this.getCodeTypeIdSignature());
        String idValue = UniqueIdExtensionPoint.getNextUniqueId(null, this.getCodeTypeIdSignature());
        if (StringUtils.isBlank((CharSequence)idValue)) {
            idValue = CoreUtils.getDefaultValueOf((String)SignatureUtils.unboxToPrimitiveSignature((String)this.getCodeTypeIdSignature()));
        }
        if (StringUtils.isNotBlank((CharSequence)idValue) && !"null".equals(idValue)) {
            codeTypeBuilder.setIdValueBuilder((ISourceBuilder)new RawSourceBuilder(idValue));
        }
        if (ClassIdGenerators.isAutomaticallyCreateClassIdAnnotation()) {
            codeTypeBuilder.setClassIdValue(ClassIdGenerators.generateNewId(new ClassIdGenerationContext(String.valueOf(this.getPackage()) + '.' + this.getCodeTypeName())));
        }
        codeTypeBuilder.setup();
        return S2eUtils.writeType(this.getSharedSourceFolder(), (ICompilationUnitSourceBuilder)codeTypeBuilder, env, monitor, workingCopyManager);
    }

    public String getCodeTypeName() {
        return this.m_codeTypeName;
    }

    public void setCodeTypeName(String codeTypeName) {
        this.m_codeTypeName = codeTypeName;
    }

    public IPackageFragmentRoot getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IPackageFragmentRoot sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    protected void setCreatedCodeType(IType createdCodeType) {
        this.m_createdCodeType = createdCodeType;
    }

    public IType getCreatedCodeType() {
        return this.m_createdCodeType;
    }

    public String getSuperTypeSignature() {
        return this.m_superTypeSignature;
    }

    public void setSuperTypeSignature(String superTypeSignature) {
        this.m_superTypeSignature = superTypeSignature;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public String getCodeTypeIdSignature() {
        return this.m_codeTypeIdSignature;
    }

    public void setCodeTypeIdSignature(String codeTypeIdSignature) {
        this.m_codeTypeIdSignature = codeTypeIdSignature;
    }

    protected IJavaEnvironmentProvider getEnvProvider() {
        return this.m_javaEnvironmentProvider;
    }
}

