/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.util.ast;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstTypeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.ILinkedPositionHolder;

public class AstValueFieldBuilder<INSTANCE extends AstValueFieldBuilder<INSTANCE>>
extends AstTypeBuilder<INSTANCE> {
    public static final Set<String> PROPOSAL_VALUE_DATA_TYPES = Collections.synchronizedSortedSet(new TreeSet());

    static {
        PROPOSAL_VALUE_DATA_TYPES.add("java.lang.Long");
        PROPOSAL_VALUE_DATA_TYPES.add("java.lang.Boolean");
        PROPOSAL_VALUE_DATA_TYPES.add("java.math.BigDecimal");
        PROPOSAL_VALUE_DATA_TYPES.add("java.lang.String");
    }

    protected AstValueFieldBuilder(AstNodeFactory owner) {
        super(owner);
    }

    @Override
    public INSTANCE insert() {
        Type typeArg = null;
        ParameterizedType parameterizedType = this.getFactory().getAst().newParameterizedType(this.getSuperType());
        typeArg = this.getFactory().newTypeReference("java.lang.Long");
        parameterizedType.typeArguments().add(typeArg);
        this.withSuperType((Type)parameterizedType);
        super.insert();
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            String[] proposalTypes;
            if (typeArg != null) {
                ITrackedNodePosition dataTypeTracker = this.getFactory().getRewrite().track((ASTNode)typeArg);
                links.addLinkedPosition(dataTypeTracker, true, "VALUE_TYPE");
            }
            String[] stringArray = proposalTypes = PROPOSAL_VALUE_DATA_TYPES.toArray(new String[PROPOSAL_VALUE_DATA_TYPES.size()]);
            int n = proposalTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String fqn = stringArray[n2];
                ITypeBinding typeBinding = this.getFactory().resolveTypeBinding(fqn);
                if (typeBinding != null) {
                    links.addLinkedPositionProposal("VALUE_TYPE", typeBinding);
                }
                ++n2;
            }
        }
        return (INSTANCE)this;
    }
}

