/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.job;

import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.sdk.core.util.SdkLog;

public abstract class AbstractJob
extends Job {
    private StackTraceElement[] m_callerTrace;

    public AbstractJob(String name) {
        super(name);
    }

    public boolean shouldSchedule() {
        this.m_callerTrace = Thread.currentThread().getStackTrace();
        return super.shouldSchedule();
    }

    public static void waitForJobFamily(Object family) {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(family, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public final IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        long start = System.currentTimeMillis();
        try {
            iStatus = this.runInternal(monitor);
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - start;
            String logMsg = "Job '{}' finished after {}ms.";
            if (SdkLog.isDebugEnabled()) {
                SdkLog.debug((String)(String.valueOf(logMsg) + " It has been scheduled by:{}"), (Object[])new Object[]{this.getName(), duration, this.getCallerStackTrace()});
            } else {
                SdkLog.debug((String)logMsg, (Object[])new Object[]{this.getName(), duration});
            }
            throw throwable;
        }
        long duration = System.currentTimeMillis() - start;
        String logMsg = "Job '{}' finished after {}ms.";
        if (SdkLog.isDebugEnabled()) {
            SdkLog.debug((String)(String.valueOf(logMsg) + " It has been scheduled by:{}"), (Object[])new Object[]{this.getName(), duration, this.getCallerStackTrace()});
        } else {
            SdkLog.debug((String)logMsg, (Object[])new Object[]{this.getName(), duration});
        }
        return iStatus;
    }

    protected String getCallerStackTrace() {
        int numElementsToRemove = 4;
        StackTraceElement[] cleaned = new StackTraceElement[this.m_callerTrace.length - numElementsToRemove];
        System.arraycopy(this.m_callerTrace, numElementsToRemove, cleaned, 0, cleaned.length);
        StringBuilder callerStack = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = cleaned;
        int n = cleaned.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement traceElement = stackTraceElementArray[n2];
            callerStack.append("\n\tat ").append(traceElement);
            ++n2;
        }
        return callerStack.toString();
    }

    private IStatus runInternal(IProgressMonitor monitor) {
        Throwable exc;
        block10: {
            exc = null;
            try {
                this.validate();
                this.execute(monitor);
            }
            catch (LinkageError e) {
                exc = e;
                monitor.done();
                break block10;
            }
            catch (Exception e) {
                try {
                    exc = e;
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        if (exc != null) {
            Level lvl = Level.SEVERE;
            int severity = 4;
            String msg = exc.getMessage();
            if (exc instanceof OperationCanceledException) {
                lvl = Level.FINE;
                severity = 8;
            }
            SdkLog.log((Level)lvl, (String)msg, (Object[])new Object[]{exc});
            return new Status(severity, "org.eclipse.scout.sdk.s2e", msg, exc);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected void validate() {
    }

    protected abstract void execute(IProgressMonitor var1) throws CoreException;
}

