/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.util;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.osgi.framework.Bundle;

public class ContentAssistContextInfo {
    private final int m_offset;
    private final ICompilationUnit m_compilationUnit;
    private final String m_identifierPrefix;

    protected ContentAssistContextInfo(int offset, ICompilationUnit compilationUnit, String identifierPrefix) {
        this.m_offset = offset;
        this.m_compilationUnit = compilationUnit;
        this.m_identifierPrefix = identifierPrefix;
    }

    public static ContentAssistContextInfo build(ContentAssistInvocationContext context, String callingPluginId, IProgressMonitor monitor) {
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)callingPluginId);
        if (bundle == null || bundle.getState() != 32) {
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        ICompilationUnit compilationUnit = javaContext.getCompilationUnit();
        if (!S2eUtils.exists((IJavaElement)compilationUnit)) {
            return null;
        }
        int offset = javaContext.getInvocationOffset();
        if (offset < 0) {
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        String identifierPrefix = null;
        try {
            CharSequence prefix = javaContext.computeIdentifierPrefix();
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                identifierPrefix = prefix.toString().trim();
            }
        }
        catch (BadLocationException e) {
            SdkLog.warning((String)"Unable to compute identifier prefix.", (Object[])new Object[]{e});
            return null;
        }
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        return new ContentAssistContextInfo(offset, compilationUnit, identifierPrefix);
    }

    public int getOffset() {
        return this.m_offset;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.m_compilationUnit;
    }

    public String getIdentifierPrefix() {
        return this.m_identifierPrefix;
    }

    public IJavaElement computeEnclosingElement() {
        try {
            IJavaElement element = this.m_compilationUnit.getElementAt(this.m_offset);
            if (S2eUtils.exists((IJavaElement)element)) {
                return element;
            }
        }
        catch (JavaModelException e) {
            SdkLog.warning((String)"Unable to compute enclosing java element for offset {} in compilation unit '{}'.", (Object[])new Object[]{this.m_offset, this.m_compilationUnit.getElementName(), e});
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_compilationUnit == null ? 0 : this.m_compilationUnit.hashCode());
        result = 31 * result + (this.m_identifierPrefix == null ? 0 : this.m_identifierPrefix.hashCode());
        result = 31 * result + this.m_offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentAssistContextInfo other = (ContentAssistContextInfo)obj;
        if (this.m_compilationUnit == null ? other.m_compilationUnit != null : !this.m_compilationUnit.equals(other.m_compilationUnit)) {
            return false;
        }
        if (this.m_identifierPrefix == null ? other.m_identifierPrefix != null : !this.m_identifierPrefix.equals(other.m_identifierPrefix)) {
            return false;
        }
        return this.m_offset == other.m_offset;
    }
}

