/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.proposal;

import java.util.Collection;
import java.util.Objects;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.window.Window;
import org.eclipse.scout.sdk.core.util.OptimisticLock;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IDialogSettingsProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalContentProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalDescriptionProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.IProposalPopupListener;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ISearchRangeConsumer;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ISelectionStateLabelProvider;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ISeparatorProposal;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalPopupEvent;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextEx;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.util.NormalizedPattern;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

class ProposalPopup
extends Window {
    private static final String DIALOG_SETTINGS_WIDTH = "dialogSettingsWidth";
    private static final String DIALOG_SETTINGS_HEIGHT = "dialogSettingsHeight";
    private static final int POPUP_OFFSET = 2;
    private static final int MINIMUM_HEIGHT = 100;
    private static final int MINIMUM_WIDTH = 200;
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 300;
    public static final ISeparatorProposal LOADING_PROPOSAL = new ISeparatorProposal(){

        @Override
        public String getLabel() {
            return "Loading...";
        }

        @Override
        public Image getImage() {
            return S2ESdkUiActivator.getImage("type_separator.gif");
        }
    };
    private final StyledTextEx m_proposalField;
    private final EventListenerList m_selectionListeners;
    private final OptimisticLock m_uiLock = new OptimisticLock();
    private final Object m_lazyLoaderJobLock = new Object();
    private final Object m_descLoaderJobLock = new Object();
    private TableViewer m_tableViewer;
    private Label m_itemCountLabel;
    private ScrolledComposite m_proposalDescriptionArea;
    private Object m_selectedProposal;
    private volatile SearchPatternInput m_input;
    private IProposalDescriptionProvider m_proposalDescriptionProvider;
    private IBaseLabelProvider m_labelProvider;
    private P_LazyContentProvider m_contentProvider;
    private P_LazyLoader m_lazyLoaderJob;
    private P_DescriptionLoader m_descLoaderJob;
    private IDialogSettings m_dialogSettings;
    private Point m_shellSizeDif;

    ProposalPopup(StyledTextEx proposalField) {
        super(proposalField.getShell());
        this.m_selectionListeners = new EventListenerList();
        this.m_proposalField = proposalField;
        this.setShellStyle(540692);
        this.setBlockOnOpen(false);
        this.getOwnerControl().getShell().addListener(10, new Listener(){

            public void handleEvent(Event event) {
                ProposalPopup.this.close();
            }
        });
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setBackground(shell.getDisplay().getSystemColor(1));
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                ProposalPopup.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ProposalPopup.this.getOwnerControl() != null && !ProposalPopup.this.getOwnerControl().isDisposed()) {
                            if (!ProposalPopup.this.getOwnerControl().isFocusControl()) {
                                ProposalPopup.this.close();
                            }
                        } else {
                            ProposalPopup.this.close();
                        }
                    }
                });
            }
        });
    }

    protected void fireProposalAccepted(IStructuredSelection selection, boolean moveFocus) {
        ProposalPopupEvent delegateEvent = new ProposalPopupEvent(2);
        delegateEvent.setData("selectedProposal", selection.getFirstElement());
        delegateEvent.setData("moveFocus", moveFocus);
        this.firePopupEvent(delegateEvent);
    }

    protected Control createContents(Composite parent) {
        Composite proposalArea = new Composite(parent, 2);
        proposalArea.setBackground(proposalArea.getDisplay().getSystemColor(1));
        Table table = new Table(proposalArea, 66304);
        this.m_tableViewer = new TableViewer(table);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_contentProvider);
        this.m_tableViewer.setLabelProvider(this.m_labelProvider);
        this.m_tableViewer.setInput((Object)this.getInput());
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object newSelection = null;
                if (!event.getSelection().isEmpty() && (newSelection = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof ISeparatorProposal) {
                    return;
                }
                ProposalPopup.this.handleProposalSelection(newSelection);
            }
        });
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    if (selection.size() == 1 && selection.getFirstElement() instanceof ISeparatorProposal) {
                        return;
                    }
                    ProposalPopup.this.fireProposalAccepted(selection, true);
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                IStructuredSelection selection;
                if (32 == e.keyCode && !(selection = ProposalPopup.this.m_tableViewer.getStructuredSelection()).isEmpty()) {
                    ProposalPopup.this.fireProposalAccepted(selection, true);
                }
            }
        });
        table.setHeaderVisible(false);
        this.m_proposalDescriptionArea = new ScrolledComposite(parent, 2816);
        this.m_proposalDescriptionArea.setBackground(this.m_proposalDescriptionArea.getDisplay().getSystemColor(29));
        this.m_proposalDescriptionArea.setExpandHorizontal(true);
        this.m_proposalDescriptionArea.setExpandVertical(true);
        Composite footer = new Composite(proposalArea, 2048);
        footer.setBackground(footer.getDisplay().getSystemColor(1));
        this.m_itemCountLabel = new Label(footer, 0);
        this.m_itemCountLabel.setBackground(this.m_itemCountLabel.getDisplay().getSystemColor(1));
        GridLayoutFactory.swtDefaults().spacing(0, 0).margins(0, 0).applyTo((Composite)this.m_proposalDescriptionArea);
        GridLayoutFactory.swtDefaults().equalWidth(true).spacing(0, 0).margins(0, 0).applyTo(parent);
        GridDataFactory.defaultsFor((Control)proposalArea).align(4, 4).grab(true, true).applyTo((Control)proposalArea);
        GridDataFactory.defaultsFor((Control)this.m_proposalDescriptionArea).align(4, 4).grab(true, true).exclude(true).applyTo((Control)this.m_proposalDescriptionArea);
        proposalArea.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)footer, 0);
        table.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        footer.setLayoutData((Object)data);
        GridLayoutFactory.swtDefaults().margins(5, 0).applyTo(footer);
        GridDataFactory.defaultsFor((Control)this.m_itemCountLabel).align(4, 1).grab(true, true).applyTo((Control)this.m_itemCountLabel);
        return parent;
    }

    private void handleProposalSelection(Object proposal) {
        if (Objects.equals(this.m_selectedProposal, proposal)) {
            return;
        }
        Object old = this.m_selectedProposal;
        this.m_selectedProposal = null;
        if (old != null) {
            this.m_tableViewer.update(old, new String[]{"label"});
        }
        this.m_selectedProposal = proposal;
        if (this.m_selectedProposal != null) {
            this.m_tableViewer.update(this.m_selectedProposal, new String[]{"label"});
        }
        this.updateDescription(this.m_selectedProposal);
        try {
            if (this.m_uiLock.acquire()) {
                ProposalPopupEvent delegateEvent = new ProposalPopupEvent(4);
                delegateEvent.setData("selectedProposal", this.m_selectedProposal);
                this.firePopupEvent(delegateEvent);
            }
        }
        finally {
            this.m_uiLock.release();
        }
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.m_dialogSettings = dialogSettings;
    }

    public IDialogSettings getDialogSettings() {
        return this.m_dialogSettings;
    }

    public void updatePattern(String pattern, Object input) {
        this.setInput(new SearchPatternInput(input, pattern));
    }

    public SearchPatternInput getInput() {
        return this.m_input;
    }

    protected Object getProposalByText(String text, Collection<Object> proposals) {
        if (proposals == null || proposals.isEmpty()) {
            return null;
        }
        for (Object o : proposals) {
            if (!text.equals(this.getText(o))) continue;
            return o;
        }
        return null;
    }

    public synchronized void setInput(SearchPatternInput input) {
        this.m_input = input;
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        try {
            this.m_uiLock.acquire();
            this.m_tableViewer.getTable().setRedraw(false);
            this.m_tableViewer.setInput((Object)this.m_input);
            IStructuredSelection selection = this.m_tableViewer.getStructuredSelection();
            if (selection.isEmpty()) {
                Object proposal = input.getInput();
                if (proposal == null && this.m_proposalField.getText() != null && (proposal = this.getProposalByText(this.m_proposalField.getText(), input.m_proposals)) != null) {
                    this.fireProposalAccepted((IStructuredSelection)new StructuredSelection(proposal), false);
                }
                if (proposal != null) {
                    selection = new StructuredSelection(proposal);
                    this.m_tableViewer.setSelection((ISelection)selection, true);
                }
            }
            if (!selection.isEmpty()) {
                int selectedRowIndex = this.m_tableViewer.getTable().getSelectionIndex();
                int lastRowIndex = this.m_tableViewer.getTable().getItemCount() - 1;
                int numOffsetRows = 3;
                int revealRowIndex = selectedRowIndex < lastRowIndex - 3 ? selectedRowIndex + 3 : lastRowIndex;
                if (revealRowIndex != selectedRowIndex) {
                    this.m_tableViewer.reveal(this.m_tableViewer.getElementAt(revealRowIndex));
                }
            }
            if (this.m_itemCountLabel != null) {
                int itemCount = this.m_tableViewer.getTable().getItemCount();
                if (itemCount < 1) {
                    this.m_itemCountLabel.setText("No items found.");
                } else if (itemCount == 1) {
                    if (this.m_tableViewer.getTable().getItem(0).getData() == LOADING_PROPOSAL) {
                        this.m_itemCountLabel.setText("Still loading. Please wait...");
                    } else {
                        this.m_itemCountLabel.setText("1 item found.");
                    }
                } else {
                    this.m_itemCountLabel.setText(String.valueOf(itemCount) + " items found.");
                }
            }
            this.constrainShellSize();
        }
        finally {
            this.m_tableViewer.getTable().setRedraw(true);
            this.m_uiLock.release();
        }
    }

    public void setContentProvider(IProposalContentProvider contentProvider) {
        this.m_contentProvider = new P_LazyContentProvider(contentProvider);
        if (contentProvider instanceof IDialogSettingsProvider) {
            this.setDialogSettings(((IDialogSettingsProvider)((Object)contentProvider)).getDialogSettings());
        } else {
            this.setDialogSettings(null);
        }
        if (this.m_tableViewer != null) {
            this.m_tableViewer.setContentProvider((IContentProvider)this.m_contentProvider);
        }
    }

    public IProposalContentProvider getContentProvider() {
        if (this.m_contentProvider == null) {
            return null;
        }
        return this.m_contentProvider.getWrappedProvider();
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.m_labelProvider = labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider ? new P_StyledLabelProvider(labelProvider) : labelProvider;
        if (this.m_tableViewer != null) {
            this.m_tableViewer.setLabelProvider(this.m_labelProvider);
        }
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.m_labelProvider instanceof P_StyledLabelProvider) {
            return ((P_StyledLabelProvider)this.m_labelProvider).getWrappedLabelProvider();
        }
        return this.m_labelProvider;
    }

    public String getText(Object element) {
        if (this.m_labelProvider instanceof P_StyledLabelProvider) {
            return ((P_StyledLabelProvider)this.m_labelProvider).getText(element, false);
        }
        return ((ILabelProvider)this.m_labelProvider).getText(element);
    }

    public Object getSelectedProposal() {
        return this.m_selectedProposal;
    }

    public int open() {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            shell = null;
            this.create();
            shell = this.getShell();
        }
        this.constrainShellSize();
        shell.setVisible(true);
        return 0;
    }

    protected void constrainShellSize() {
        Shell shell = this.getShell();
        try {
            int xDiff;
            shell.setRedraw(false);
            Rectangle ownerBounds = this.getOwnerControl().getDisplay().map((Control)this.getOwnerControl().getParent(), null, this.getOwnerControl().getBounds());
            Rectangle displayBounds = shell.getDisplay().getBounds();
            Rectangle shellBounds = new Rectangle(ownerBounds.x + 2, ownerBounds.y + ownerBounds.height + 2, 400, 300);
            if (this.getDialogSettings() != null) {
                String heightString;
                String widthString = this.getDialogSettings().get(DIALOG_SETTINGS_WIDTH);
                if (StringUtils.isNotBlank((CharSequence)widthString)) {
                    shellBounds.width = Integer.parseInt(widthString);
                }
                if (StringUtils.isNotBlank((CharSequence)(heightString = this.getDialogSettings().get(DIALOG_SETTINGS_HEIGHT)))) {
                    shellBounds.height = Integer.parseInt(heightString);
                }
            }
            if (!((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude) {
                shellBounds.width *= 2;
            }
            shellBounds.height = Math.min(displayBounds.height / 2, shellBounds.height);
            shellBounds.width = Math.min(displayBounds.width / 2, shellBounds.width);
            int yDiff = displayBounds.y + displayBounds.height - (shellBounds.y + shellBounds.height);
            if (yDiff < 0) {
                if (Math.abs(yDiff) <= 100) {
                    shellBounds.height += yDiff;
                } else {
                    shellBounds.y = shellBounds.y - (ownerBounds.height - 4) - shellBounds.height - 10;
                }
            }
            if ((xDiff = displayBounds.x + displayBounds.width - (shellBounds.x + shellBounds.width)) < 0) {
                shellBounds.x += xDiff;
            }
            if (shellBounds.width < 200) {
                shellBounds.width = 200;
            }
            if (shellBounds.height < 100) {
                shellBounds.height = 100;
            }
            shell.setBounds(shellBounds);
            shell.layout();
            Point sizeAfterSetBounds = shell.getSize();
            int deltaX = shellBounds.width - sizeAfterSetBounds.x;
            int deltaY = shellBounds.height - sizeAfterSetBounds.y;
            if (deltaX != 0 || deltaY != 0) {
                this.m_shellSizeDif = new Point(deltaX / 2, deltaY);
            }
        }
        finally {
            shell.setRedraw(true);
        }
    }

    private void disposeDescriptions() {
        Control[] controlArray = this.m_proposalDescriptionArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!c.isDisposed()) {
                c.dispose();
            }
            ++n2;
        }
        Control content = this.m_proposalDescriptionArea.getContent();
        if (content != null && !content.isDisposed()) {
            content.dispose();
        }
        this.m_proposalDescriptionArea.setContent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDescription(Object proposal) {
        Object object = this.m_descLoaderJobLock;
        synchronized (object) {
            this.disposeDescriptions();
            if (proposal == null) {
                return;
            }
            IProposalDescriptionProvider proposalDescriptionProvider = this.getProposalDescriptionProvider();
            if (proposalDescriptionProvider != null) {
                if (this.m_descLoaderJob != null) {
                    this.m_descLoaderJob.cancel();
                }
                this.m_descLoaderJob = new P_DescriptionLoader(proposal);
                this.m_descLoaderJob.schedule(400L);
            }
        }
    }

    protected void layoutDescriptionArea() {
        Control content = this.m_proposalDescriptionArea.getContent();
        if (content != null && !content.isDisposed()) {
            ((GridLayout)this.m_proposalDescriptionArea.getParent().getLayout()).numColumns = 2;
            this.m_proposalDescriptionArea.setMinSize(content.computeSize(-1, -1));
            ((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude = false;
        } else {
            ((GridLayout)this.m_proposalDescriptionArea.getParent().getLayout()).numColumns = 1;
            ((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude = true;
        }
        this.constrainShellSize();
    }

    public void setProposalDescriptionProvider(IProposalDescriptionProvider proposalDescriptionProvider) {
        this.m_proposalDescriptionProvider = proposalDescriptionProvider;
    }

    public IProposalDescriptionProvider getProposalDescriptionProvider() {
        return this.m_proposalDescriptionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        if (!this.isVisible()) {
            return false;
        }
        Object object = this.m_descLoaderJobLock;
        synchronized (object) {
            if (this.m_descLoaderJob != null) {
                this.m_descLoaderJob.cancel();
                this.m_descLoaderJob = null;
            }
            this.disposeDescriptions();
            this.layoutDescriptionArea();
        }
        object = this.m_lazyLoaderJobLock;
        synchronized (object) {
            if (this.m_lazyLoaderJob != null) {
                this.m_lazyLoaderJob.cancel();
                this.m_lazyLoaderJob = null;
            }
        }
        this.firePopupEvent(new ProposalPopupEvent(8));
        if (this.getDialogSettings() != null) {
            Point size = this.getShell().getSize();
            if (!((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude) {
                size.x /= 2;
            }
            if (this.m_shellSizeDif != null) {
                size.x += this.m_shellSizeDif.x;
                size.y += this.m_shellSizeDif.y;
                this.m_shellSizeDif = null;
            }
            this.getDialogSettings().put(DIALOG_SETTINGS_WIDTH, size.x);
            this.getDialogSettings().put(DIALOG_SETTINGS_HEIGHT, size.y);
        }
        this.getShell().setVisible(false);
        return true;
    }

    public void dispose() {
        super.close();
    }

    public boolean isFocusOwner() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return false;
        }
        Control focusControl = this.getShell().getDisplay().getFocusControl();
        return focusControl != null && focusControl.getShell() == this.getShell();
    }

    public boolean isVisible() {
        return this.getShell() != null && !this.getShell().isDisposed() && this.getShell().isVisible();
    }

    public void addPopupListener(IProposalPopupListener proposalSelectionListener) {
        this.m_selectionListeners.add(IProposalPopupListener.class, proposalSelectionListener);
    }

    public void removePopupListener(IProposalPopupListener proposalSelectionListener) {
        this.m_selectionListeners.remove(IProposalPopupListener.class, proposalSelectionListener);
    }

    private void firePopupEvent(ProposalPopupEvent event) {
        IProposalPopupListener[] iProposalPopupListenerArray = (IProposalPopupListener[])this.m_selectionListeners.getListeners(IProposalPopupListener.class);
        int n = iProposalPopupListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProposalPopupListener listener = iProposalPopupListenerArray[n2];
            try {
                listener.popupChanged(event);
            }
            catch (Exception e) {
                SdkLog.error((String)"Error in IProposalPopupListener listener notification.", (Object[])new Object[]{e});
            }
            ++n2;
        }
    }

    boolean setFocus() {
        Table table = this.m_tableViewer.getTable();
        if (this.m_tableViewer.getSelection().isEmpty() && table.getItemCount() > 0) {
            Object first = this.m_tableViewer.getElementAt(0);
            this.m_tableViewer.setSelection((ISelection)new StructuredSelection(first), true);
        }
        return table.setFocus();
    }

    protected Control getOwnerControl() {
        return this.m_proposalField;
    }

    private Collection<Object> loadProposals(String pattern, IProgressMonitor monitor) {
        return this.m_contentProvider.getWrappedProvider().getProposals(NormalizedPattern.build((String)pattern), monitor);
    }

    private void setInputAsync(final SearchPatternInput input, final IProgressMonitor monitor) {
        final Control control = this.m_tableViewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (control.isDisposed()) {
                        return;
                    }
                    ProposalPopup.this.setInput(input);
                }
            });
        }
    }

    private final class P_DescriptionLoader
    extends AbstractJob {
        private final Object m_proposal;

        private P_DescriptionLoader(Object proposal) {
            super(P_DescriptionLoader.class.getName());
            this.setSystem(true);
            this.setUser(false);
            this.m_proposal = proposal;
        }

        protected void execute(final IProgressMonitor monitor) {
            final IProposalDescriptionProvider proposalDescriptionProvider = ProposalPopup.this.getProposalDescriptionProvider();
            if (proposalDescriptionProvider == null) {
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (ProposalPopup.this.m_proposalDescriptionArea.isDisposed()) {
                return;
            }
            final Object contentData = proposalDescriptionProvider.createDescriptionContent(this.m_proposal, monitor);
            ProposalPopup.this.m_proposalDescriptionArea.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ProposalPopup.this.m_descLoaderJobLock;
                    synchronized (object) {
                        Control content;
                        if (ProposalPopup.this.m_proposalDescriptionArea.isDisposed()) {
                            return;
                        }
                        if (contentData != null && (content = proposalDescriptionProvider.createDescriptionControl((Composite)ProposalPopup.this.m_proposalDescriptionArea, contentData)) != null && !monitor.isCanceled()) {
                            ProposalPopup.this.m_proposalDescriptionArea.setContent(content);
                        }
                        ProposalPopup.this.layoutDescriptionArea();
                    }
                }
            });
        }
    }

    private final class P_LazyContentProvider
    implements IStructuredContentProvider {
        private final IProposalContentProvider m_wrappedProvider;

        private P_LazyContentProvider(IProposalContentProvider wrappedProvider) {
            this.m_wrappedProvider = wrappedProvider;
        }

        public IProposalContentProvider getWrappedProvider() {
            return this.m_wrappedProvider;
        }

        public void dispose() {
            this.m_wrappedProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.m_wrappedProvider.inputChanged(viewer, oldInput, newInput);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getElements(Object inputElement) {
            SearchPatternInput input = (SearchPatternInput)inputElement;
            Collection<Object> proposals = input.getProposals();
            if (proposals == null) {
                Object object = ProposalPopup.this.m_lazyLoaderJobLock;
                synchronized (object) {
                    if (ProposalPopup.this.m_lazyLoaderJob != null) {
                        ProposalPopup.this.m_lazyLoaderJob.cancel();
                    } else {
                        ProposalPopup.this.m_lazyLoaderJob = new P_LazyLoader();
                    }
                    ProposalPopup.this.m_lazyLoaderJob.schedule(input);
                }
                return new Object[]{LOADING_PROPOSAL};
            }
            return proposals.toArray();
        }
    }

    private final class P_LazyLoader
    extends AbstractJob {
        private SearchPatternInput m_searchPatternInput;

        private P_LazyLoader() {
            super(P_LazyLoader.class.getName());
            this.setSystem(true);
            this.setUser(false);
        }

        public void schedule(SearchPatternInput input) {
            this.m_searchPatternInput = new SearchPatternInput(input.getInput(), input.getPattern());
            this.schedule();
        }

        protected void execute(IProgressMonitor monitor) {
            this.m_searchPatternInput.setProposals(ProposalPopup.this.loadProposals(this.m_searchPatternInput.getPattern(), monitor));
            if (monitor.isCanceled()) {
                return;
            }
            ProposalPopup.this.setInputAsync(this.m_searchPatternInput, monitor);
        }
    }

    private final class P_StyledLabelProvider
    extends StyledCellLabelProvider {
        private final IBaseLabelProvider m_wrappedLabelProvider;
        private Font m_boldFont;
        private StyledString.Styler m_boldStyler;

        private P_StyledLabelProvider(IBaseLabelProvider labelProvider) {
            this.m_wrappedLabelProvider = labelProvider;
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.m_wrappedLabelProvider.isLabelProperty(element, property);
        }

        public IBaseLabelProvider getWrappedLabelProvider() {
            return this.m_wrappedLabelProvider;
        }

        public void initialize(ColumnViewer viewer, ViewerColumn column) {
            super.initialize(viewer, column);
            Font defaultFont = viewer.getControl().getFont();
            FontData[] defaultFontData = defaultFont.getFontData();
            FontData[] boldFontData = new FontData[defaultFontData.length];
            int i = 0;
            while (i < defaultFontData.length) {
                boldFontData[i] = new FontData(defaultFontData[i].getName(), defaultFontData[i].getHeight(), defaultFontData[i].getStyle() | 1);
                ++i;
            }
            this.m_boldFont = new Font((Device)viewer.getControl().getDisplay(), boldFontData);
            this.m_boldStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = P_StyledLabelProvider.this.m_boldFont;
                }
            };
        }

        public void dispose() {
            super.dispose();
            this.m_wrappedLabelProvider.dispose();
            this.m_boldFont.dispose();
            this.m_boldFont = null;
        }

        public void update(ViewerCell cell) {
            ISearchRangeConsumer labelProvider;
            int[] matchingRegions;
            Object element = cell.getElement();
            StyledString text = new StyledString(this.getText(element, Objects.equals(ProposalPopup.this.m_selectedProposal, element)));
            if (cell.getColumnIndex() == 0 && this.m_wrappedLabelProvider instanceof ISearchRangeConsumer && (matchingRegions = (labelProvider = (ISearchRangeConsumer)this.m_wrappedLabelProvider).getMatchRanges(element)) != null && matchingRegions.length > 0) {
                int i = 0;
                while (i < matchingRegions.length - 1) {
                    int offset = matchingRegions[i];
                    int length = matchingRegions[i + 1];
                    if (offset >= 0 && offset + length <= text.length()) {
                        text.setStyle(offset, length, this.m_boldStyler);
                    }
                    i += 2;
                }
            }
            cell.setText(text.getString());
            cell.setStyleRanges(text.getStyleRanges());
            cell.setImage(this.getImage(element, cell.getColumnIndex(), ProposalPopup.this.m_selectedProposal == element));
        }

        private String getText(Object element, boolean selected) {
            if (element instanceof ISeparatorProposal) {
                return ((ISeparatorProposal)element).getLabel();
            }
            if (selected && this.m_wrappedLabelProvider instanceof ISelectionStateLabelProvider) {
                return ((ISelectionStateLabelProvider)this.m_wrappedLabelProvider).getTextSelected(element);
            }
            if (this.m_wrappedLabelProvider instanceof ILabelProvider) {
                return ((ILabelProvider)this.m_wrappedLabelProvider).getText(element);
            }
            return null;
        }

        private Image getImage(Object element, int columnIndex, boolean selected) {
            if (element instanceof ISeparatorProposal) {
                return ((ISeparatorProposal)element).getImage();
            }
            if (selected && this.m_wrappedLabelProvider instanceof ISelectionStateLabelProvider) {
                return ((ISelectionStateLabelProvider)this.m_wrappedLabelProvider).getImageSelected(element);
            }
            if (this.m_wrappedLabelProvider instanceof ITableLabelProvider) {
                return ((ITableLabelProvider)this.m_wrappedLabelProvider).getColumnImage(element, columnIndex);
            }
            if (this.m_wrappedLabelProvider instanceof ILabelProvider) {
                return ((ILabelProvider)this.m_wrappedLabelProvider).getImage(element);
            }
            return null;
        }
    }

    protected static final class SearchPatternInput {
        private final String m_pattern;
        private final Object m_input;
        private Collection<Object> m_proposals;

        protected SearchPatternInput(Object input, String pattern) {
            this.m_input = input;
            this.m_pattern = pattern;
        }

        public Object getInput() {
            return this.m_input;
        }

        public String getPattern() {
            return this.m_pattern;
        }

        public Collection<Object> getProposals() {
            return this.m_proposals;
        }

        public void setProposals(Collection<Object> collection) {
            this.m_proposals = collection;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("input[").append(this.getInput()).append("] ");
            builder.append("pattern[").append(this.getPattern()).append("] ");
            builder.append("proposals[");
            Collection<Object> proposals = this.getProposals();
            if (proposals == null) {
                builder.append("null");
            } else {
                builder.append(proposals.toString());
            }
            builder.append("] ");
            return builder.toString();
        }

        public int hashCode() {
            int hash = 0;
            if (this.m_input != null) {
                hash ^= this.m_input.hashCode();
            }
            if (this.m_pattern != null) {
                hash ^= this.m_pattern.hashCode();
            }
            if (this.m_proposals != null) {
                for (Object proposal : this.m_proposals) {
                    if (proposal == null) continue;
                    hash ^= proposal.hashCode();
                }
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SearchPatternInput)) {
                return false;
            }
            SearchPatternInput input = (SearchPatternInput)obj;
            return Objects.equals(input.getInput(), this.getInput()) && Objects.equals(input.getPattern(), this.getPattern()) && Objects.equals(input.getProposals(), this.getProposals());
        }
    }
}

