/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.jaxws.RebuildArtifactsOperation;
import org.eclipse.scout.sdk.s2e.operation.jaxws.WebServiceNewOperation;
import org.eclipse.scout.sdk.s2e.operation.jaxws.WebServiceUpdateOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws.ErrorFormPage;
import org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws.WebServiceEditorInput;
import org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws.WebServiceFormPage;
import org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws.WebServiceFormPageInput;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.jaxws.WebServiceNewWizard;
import org.eclipse.scout.sdk.s2e.ui.internal.wizard.jaxws.WebServiceNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class WebServiceEditor
extends FormEditor {
    public static final String WEB_SERVICE_EDITOR_ID = "org.eclipse.scout.sdk.s2e.ui.jaxwsEditor";
    public static final String WEB_SERVICE_FILE_EXTENSION = "jaxws";
    private IJavaProject m_project;
    private IFile m_jaxwsFile;

    protected void addPages() {
        IEditorInput input = this.getEditorInput();
        if (!(input instanceof FileEditorInput)) {
            this.showError("Invalid input for Web Service Editor: " + input, new IllegalArgumentException());
            return;
        }
        this.m_jaxwsFile = ((FileEditorInput)input).getFile();
        if (this.getJaxwsFile() == null || !this.getJaxwsFile().exists()) {
            this.showError("Invalid file input for Web Service Editor: " + this.getJaxwsFile(), new IllegalArgumentException());
            return;
        }
        this.m_project = JavaCore.create((IProject)this.getJaxwsFile().getProject());
        if (!S2eUtils.exists((IJavaElement)this.getJavaProject())) {
            this.showError("Invalid project input for Web Service Editor: " + this.getJavaProject(), new IllegalArgumentException());
            return;
        }
        try {
            if (!ScoutTier.Server.equals((Object)ScoutTier.valueOf((IJavaElement)this.getJavaProject()))) {
                this.showError("Invalid project type: " + this.getJavaProject().getElementName() + " is not a server project", new IllegalArgumentException());
                return;
            }
        }
        catch (JavaModelException e) {
            this.showError("Unable to check type of project " + this.getJavaProject().getElementName(), e);
            return;
        }
        this.setPartName(String.valueOf(this.getJavaProject().getProject().getName()) + " Web Services");
        String idToActivate = null;
        if (input instanceof WebServiceEditorInput) {
            idToActivate = ((WebServiceEditorInput)input).getPageIdToActivate();
        }
        this.reload(idToActivate);
    }

    protected void addPageSafe(IFormPage page) {
        if (this.getContainer().isDisposed()) {
            return;
        }
        try {
            this.addPage(page);
        }
        catch (PartInitException e) {
            SdkLog.error((String)"Unable to add page to editor.", (Object[])new Object[]{e});
        }
    }

    protected void showError(String msg, Throwable t) {
        this.addPageSafe((IFormPage)new ErrorFormPage(this, msg, t));
        SdkLog.error((String)msg, (Object[])new Object[]{t});
    }

    protected void rebuildAllArtifacts() {
        RebuildArtifactsOperation op = new RebuildArtifactsOperation();
        op.setJavaProject(this.getJavaProject());
        this.runOperations(Collections.singletonList(op));
    }

    protected void startNewWebServiceWizard() {
        WebServiceNewWizard wiz = new WebServiceNewWizard();
        StructuredSelection selection = new StructuredSelection((Object)this.getJaxwsFile());
        wiz.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        WebServiceNewWizardPage wizPage = wiz.getWebServiceNewWizardPage();
        wizPage.setIsCreateNewProject(false);
        wizPage.setExistingJaxWsProject(this.getJavaProject());
        wiz.setFinishAction(new WebServiceNewWizard.IWebServiceNewWizardFinishedAction(){

            @Override
            public void operationFinished(WebServiceNewOperation operation, Display d) {
                final String pageId = operation.getCreatedWsdlFile().getName();
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WebServiceEditor.this.reload(pageId);
                    }
                });
            }
        });
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)wiz);
        dialog.open();
    }

    protected void reload(String idToActivate) {
        IFormPage activatedPage;
        this.removeAllPages();
        final TreeSet webServices = new TreeSet();
        final Shell shell = this.getSite().getShell();
        final boolean[] isCanceled = new boolean[1];
        try {
            new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Set<WebServiceFormPageInput> result = WebServiceEditor.this.findWebServices(monitor);
                        isCanceled[0] = monitor.isCanceled();
                        if (isCanceled[0]) {
                            shell.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    WebServiceEditor.this.close(false);
                                }
                            });
                        } else {
                            webServices.addAll(result);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.showError("Unable to search for web services in project: " + this.getJavaProject().getElementName(), e);
            return;
        }
        if (isCanceled[0]) {
            this.addPageSafe((IFormPage)new ErrorFormPage(this, null, null));
            return;
        }
        if (webServices.isEmpty()) {
            this.showError("No web services found in project " + this.getJavaProject().getElementName(), null);
            return;
        }
        for (WebServiceFormPageInput input : webServices) {
            this.addPageSafe((IFormPage)new WebServiceFormPage(this, input));
        }
        if (this.getContainer().isDisposed()) {
            return;
        }
        if (idToActivate != null && (activatedPage = this.setActivePage(idToActivate)) != null) {
            return;
        }
        if (this.getPageCount() > 0) {
            this.setActivePage(0);
        } else {
            this.showError("No pages found.", null);
        }
    }

    protected IFormPage getPage(int index) {
        Object result = this.pages.get(index);
        if (result instanceof IFormPage) {
            return (IFormPage)result;
        }
        return null;
    }

    protected void removeAllPages() {
        while (this.getPageCount() > 0) {
            IFormPage page = this.getPage(0);
            this.removePage(page.getIndex());
            if (page.isEditor()) continue;
            page.dispose();
        }
    }

    protected Set<WebServiceFormPageInput> findWebServices(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Loading contents", (int)100);
        if (progress.isCanceled()) {
            return Collections.emptySet();
        }
        IFolder wsdlFolder = WebServiceNewOperation.getWsdlRootFolder((IProject)this.getJavaProject().getProject());
        if (!wsdlFolder.exists()) {
            return Collections.emptySet();
        }
        progress.worked(5);
        IJavaSearchScope scope = S2eUtils.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getJavaProject()});
        final Set webServiceEntryPointAnnotatedTypes = S2eUtils.findAllTypesAnnotatedWith((String)"org.eclipse.scout.rt.server.jaxws.provider.annotation.WebServiceEntryPoint", (IJavaSearchScope)scope, (IProgressMonitor)progress.newChild(10));
        final Set webServiceClientAnnotatedTypes = S2eUtils.findAllTypesAnnotatedWith((String)"javax.xml.ws.WebServiceClient", (IJavaSearchScope)scope, (IProgressMonitor)progress.newChild(10));
        final Set webServiceAnnotatedTypes = S2eUtils.findAllTypesAnnotatedWith((String)"javax.jws.WebService", (IJavaSearchScope)scope, (IProgressMonitor)progress.newChild(10));
        if (progress.isCanceled()) {
            return Collections.emptySet();
        }
        final TreeSet<WebServiceFormPageInput> services = new TreeSet<WebServiceFormPageInput>();
        wsdlFolder.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1 && proxy.getName().toLowerCase().endsWith(".wsdl")) {
                    P_PreloadedWebServiceData webServiceData = new P_PreloadedWebServiceData((IFile)proxy.requestResource(), WebServiceEditor.this.getJavaProject(), webServiceEntryPointAnnotatedTypes, webServiceClientAnnotatedTypes, webServiceAnnotatedTypes);
                    services.add(webServiceData);
                }
                return true;
            }
        }, 2);
        progress.worked(5);
        if (progress.isCanceled() || services.isEmpty()) {
            return Collections.emptySet();
        }
        int progressPerItem = 50 / services.size();
        for (WebServiceFormPageInput s : services) {
            s.load((IProgressMonitor)progress.newChild(progressPerItem));
            if (!progress.isCanceled()) continue;
            return Collections.emptySet();
        }
        Iterator it = services.iterator();
        while (it.hasNext()) {
            WebServiceFormPageInput data = (WebServiceFormPageInput)it.next();
            if (!data.getAllPortTypes().isEmpty()) continue;
            it.remove();
        }
        return services;
    }

    public void doSave(IProgressMonitor monitor) {
        List<WebServiceFormPage> allPages = this.getAllPages();
        ArrayList<WebServiceFormPage> pagesToSave = new ArrayList<WebServiceFormPage>(allPages.size());
        boolean isValid = true;
        for (WebServiceFormPage page : allPages) {
            if (!page.isDirty()) continue;
            if (page.isValid()) {
                pagesToSave.add(page);
                continue;
            }
            this.setActivePage(page.getIndex());
            isValid = false;
            break;
        }
        if (!isValid || pagesToSave.isEmpty()) {
            return;
        }
        ArrayList<Object> updateOps = new ArrayList<Object>(pagesToSave.size() + 1);
        for (WebServiceFormPage page : pagesToSave) {
            WebServiceUpdateOperation op = new WebServiceUpdateOperation();
            page.fillOperation(op);
            updateOps.add(op);
        }
        RebuildArtifactsOperation op = new RebuildArtifactsOperation();
        op.setJavaProject(this.getJavaProject());
        updateOps.add(op);
        this.runOperations(updateOps);
    }

    protected void runOperations(Iterable<? extends IOperation> ops) {
        final List<WebServiceFormPage> allPages = this.getAllPages();
        this.setEnabled(allPages, false);
        final String idToActivate = this.getActivePageInstance().getId();
        final Composite c = this.getContainer();
        Display d = c.getDisplay();
        c.setCursor(d.getSystemCursor(1));
        ResourceBlockingOperationJob j = new ResourceBlockingOperationJob(ops, new IResource[]{this.getJavaProject().getProject()});
        j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (c.isDisposed()) {
                    return;
                }
                c.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (c.isDisposed()) {
                            return;
                        }
                        c.setCursor(null);
                        WebServiceEditor.this.reload(idToActivate);
                        WebServiceEditor.this.editorDirtyStateChanged();
                        WebServiceEditor.this.setEnabled(allPages, true);
                    }
                });
            }
        });
        j.schedule();
    }

    protected void setEnabled(List<WebServiceFormPage> allPages, boolean enabled) {
        this.getContainer().setEnabled(enabled);
        for (WebServiceFormPage page : allPages) {
            page.setEnabled(enabled);
        }
    }

    public List<WebServiceFormPage> getAllPages() {
        ArrayList<WebServiceFormPage> result = new ArrayList<WebServiceFormPage>(this.pages.size());
        for (Object o : this.pages) {
            if (!(o instanceof WebServiceFormPage)) continue;
            result.add((WebServiceFormPage)((Object)o));
        }
        return result;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public IJavaProject getJavaProject() {
        return this.m_project;
    }

    public IFile getJaxwsFile() {
        return this.m_jaxwsFile;
    }

    private static final class P_PreloadedWebServiceData
    extends WebServiceFormPageInput {
        private final Set<IType> m_typesAnnotatedWithWebServiceEntryPoint;
        private final Set<IType> m_typesAnnotatedWithWebServiceClient;
        private final Set<IType> m_typesAnnotatedWithWebService;

        public P_PreloadedWebServiceData(IFile wsdl, IJavaProject javaProject, Set<IType> typesAnnotatedWithWebServiceEntryPoint, Set<IType> typesAnnotatedWithWebServiceClient, Set<IType> typesAnnotatedWithWebService) {
            super(wsdl, javaProject);
            this.m_typesAnnotatedWithWebServiceEntryPoint = typesAnnotatedWithWebServiceEntryPoint;
            this.m_typesAnnotatedWithWebServiceClient = typesAnnotatedWithWebServiceClient;
            this.m_typesAnnotatedWithWebService = typesAnnotatedWithWebService;
        }

        @Override
        protected Set<IType> findAllTypesAnnotatedWith(String fqn) throws CoreException {
            switch (fqn) {
                case "org.eclipse.scout.rt.server.jaxws.provider.annotation.WebServiceEntryPoint": {
                    return this.m_typesAnnotatedWithWebServiceEntryPoint;
                }
                case "javax.xml.ws.WebServiceClient": {
                    return this.m_typesAnnotatedWithWebServiceClient;
                }
                case "javax.jws.WebService": {
                    return this.m_typesAnnotatedWithWebService;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

