/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.s2e.operation.jaxws.WebServiceUpdateOperation;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.TextField;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws.WebServiceEditor;
import org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws.WebServiceFormPageInput;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.ui.wizard.CompilationUnitNewWizardPage;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WebServiceFormPage
extends FormPage {
    protected static final String PROP_PORT_TYPE = "portType";
    protected static final String PROP_WEB_SERVICE = "webService";
    public static final String UPDATE_FOR_ALL_SERVICES_QUESTION_KEY = "doNotShowWsChangeGenerateElementForAll";
    private final WebServiceFormPageInput m_input;
    private final ILabelProvider m_decoratingWorkbenchLabelProvider;
    private final FieldToolkit m_fieldToolkit;
    private final List<StyledTextField> m_portTypeNameFields;
    private ProposalTextField m_packageField;
    private final List<StyledTextField> m_webServiceNameFields;
    private final List<StyledTextField> m_entryPointNameFields;
    private final List<ProposalTextField> m_entryPointPackageFields;

    public WebServiceFormPage(FormEditor editor, WebServiceFormPageInput input) {
        super((FormEditor)Validate.notNull((Object)editor), ((WebServiceFormPageInput)Validate.notNull((Object)input)).getWsdl().getName(), input.getDisplayName());
        this.m_input = input;
        this.m_decoratingWorkbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
        this.m_fieldToolkit = new FieldToolkit();
        this.m_entryPointNameFields = new LinkedList<StyledTextField>();
        this.m_entryPointPackageFields = new LinkedList<ProposalTextField>();
        this.m_portTypeNameFields = new LinkedList<StyledTextField>();
        this.m_webServiceNameFields = new LinkedList<StyledTextField>();
    }

    public WebServiceEditor getEditor() {
        return (WebServiceEditor)super.getEditor();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm scrolledForm = managedForm.getForm();
        this.getFormToolkit().decorateFormHeading(scrolledForm.getForm());
        this.createActionToolBar(scrolledForm.getToolBarManager());
        scrolledForm.setText(this.getInput().getDisplayName());
        scrolledForm.updateToolBar();
        Composite body = scrolledForm.getBody();
        this.createBody(body);
        this.setEnabled(true);
        scrolledForm.reflow(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)body, "org.eclipse.scout.sdk.s2e.ui.scout_editor_webservice_context");
    }

    protected void createOverviewImage(final Composite parent, String imgName, final Iterable<P_ImageArea> areas, int horizontalSpan) {
        Image overviewImage = S2ESdkUiActivator.getImage(imgName);
        final int imageWidth = overviewImage.getBounds().width;
        final Label label = this.getFormToolkit().createLabel(parent, "", 0x1000000);
        label.setImage(overviewImage);
        label.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                for (P_ImageArea area : areas) {
                    if (!area.contains(e.x, e.y, imageWidth, label.getSize().x)) continue;
                    parent.setCursor(parent.getDisplay().getSystemCursor(21));
                    return;
                }
                parent.setCursor(null);
            }
        });
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                for (P_ImageArea area : areas) {
                    if (!area.contains(e.x, e.y, imageWidth, label.getSize().x)) continue;
                    Object element = area.m_elementToShow;
                    if (element instanceof IJavaElement) {
                        S2eUiUtils.openInEditor((IJavaElement)element);
                    } else if (element instanceof IFile) {
                        S2eUiUtils.openInEditor((IFile)element);
                    }
                    return;
                }
            }
        });
        GridDataFactory.defaultsFor((Control)label).align(4, 0x1000000).grab(true, false).span(horizontalSpan, 1).applyTo((Control)label);
    }

    protected void createBody(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        int labelColWidth = 180;
        Set<IType> allPortTypes = this.getInput().getAllPortTypes();
        if (!allPortTypes.isEmpty()) {
            if (this.getInput().hasProviderElements()) {
                this.createProviderGroup(parent, allPortTypes, labelColWidth);
            } else {
                this.createConsumerGroup(parent, allPortTypes, labelColWidth);
            }
        }
        if (!this.getInput().getBindings().isEmpty()) {
            this.createBindingGroup(parent);
        }
    }

    protected void createConsumerGroup(Composite p, Set<IType> allPortTypes, int labelColWidth) {
        int numPortTypes = allPortTypes.size();
        IType firstPortType = allPortTypes.iterator().next();
        Set<IType> webServices = this.getInput().getWebServices();
        IType firstWebService = webServices.iterator().next();
        Composite parent = this.createSection(this.getFormToolkit(), p, "Consumer");
        GridLayoutFactory.swtDefaults().numColumns(numPortTypes).equalWidth(true).applyTo(parent);
        LinkedList<P_ImageArea> clickAreas = new LinkedList<P_ImageArea>();
        clickAreas.add(new P_ImageArea(10, 60, 180, 33, this.getInput().getWsdl()));
        clickAreas.add(new P_ImageArea(460, 110, 170, 50, this.getInput().getWebServiceClient(firstPortType)));
        clickAreas.add(new P_ImageArea(460, 10, 170, 50, firstPortType));
        clickAreas.add(new P_ImageArea(345, 160, 95, 50, firstWebService));
        this.createOverviewImage(parent, "ws_consumer_overview.png", clickAreas, numPortTypes);
        this.createLabeledHyperlink(parent, "WSDL", this.getInput().getWsdl(), null, labelColWidth, 0);
        int i = 0;
        while (i < numPortTypes - 1) {
            this.getFormToolkit().createLabel(parent, "");
            ++i;
        }
        for (IType portType : allPortTypes) {
            this.createLabeledHyperlink(parent, "Web Service Client", null, this.getInput().getWebServiceClient(portType), labelColWidth, 0);
        }
        for (IType portType : allPortTypes) {
            this.createPortTypeNameField(parent, portType, labelColWidth);
        }
        for (IType webservice : webServices) {
            int numPortTypesInThisService = this.getInput().getPortTypes(webservice).size();
            StyledTextField webServiceNameField = this.getFieldToolkit().createStyledTextField(parent, "Web Service", 6, labelColWidth);
            GridDataFactory.defaultsFor((Control)webServiceNameField).align(4, 0x1000000).grab(true, false).span(numPortTypesInThisService, 1).applyTo((Control)webServiceNameField);
            webServiceNameField.setReadOnlySuffix("Service");
            webServiceNameField.setText(webservice.getElementName());
            webServiceNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WebServiceFormPage.this.clearMessage();
                    WebServiceFormPage.this.getManagedForm().dirtyStateChanged();
                }
            });
            webServiceNameField.setData(PROP_WEB_SERVICE, webservice);
            webServiceNameField.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)webservice));
            webServiceNameField.getLabelComponent().setToolTipText(webservice.getFullyQualifiedName());
            final IType currentWs = webservice;
            webServiceNameField.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    S2eUiUtils.openInEditor((IJavaElement)currentWs);
                }
            });
            this.m_webServiceNameFields.add(webServiceNameField);
        }
        this.createPackageField(parent, firstPortType, labelColWidth, numPortTypes);
    }

    protected void createProviderGroup(Composite p, Set<IType> allPortTypes, int labelColWidth) {
        int numPortTypes = allPortTypes.size();
        IType firstPortType = allPortTypes.iterator().next();
        Composite parent = this.createSection(this.getFormToolkit(), p, "Provider");
        GridLayoutFactory.swtDefaults().numColumns(numPortTypes).equalWidth(true).applyTo(parent);
        LinkedList<P_ImageArea> clickAreas = new LinkedList<P_ImageArea>();
        clickAreas.add(new P_ImageArea(11, 10, 180, 33, this.getInput().getWsdl()));
        clickAreas.add(new P_ImageArea(545, 159, 196, 50, this.getInput().getServiceImplementation(firstPortType)));
        clickAreas.add(new P_ImageArea(445, 49, 170, 50, firstPortType));
        clickAreas.add(new P_ImageArea(385, 159, 95, 50, this.getInput().getEntryPoint(firstPortType)));
        clickAreas.add(new P_ImageArea(10, 154, 180, 60, this.getInput().getEntryPointDefinition(firstPortType)));
        this.createOverviewImage(parent, "ws_provider_overview.png", clickAreas, numPortTypes);
        this.createLabeledHyperlink(parent, "WSDL", this.getInput().getWsdl(), null, labelColWidth, 0);
        int i = 0;
        while (i < numPortTypes - 1) {
            this.getFormToolkit().createLabel(parent, "");
            ++i;
        }
        for (IType portType : allPortTypes) {
            this.createLabeledHyperlink(parent, "Web Service Implementation", null, this.getInput().getServiceImplementation(portType), labelColWidth, 0);
        }
        for (IType portType : allPortTypes) {
            this.createPortTypeNameField(parent, portType, labelColWidth);
        }
        this.createPackageField(parent, firstPortType, labelColWidth, numPortTypes);
        for (IType portType : allPortTypes) {
            this.createLabeledHyperlink(parent, "Entry Point Definition", null, this.getInput().getEntryPointDefinition(portType), labelColWidth, 20);
        }
        for (IType portType : allPortTypes) {
            StyledTextField entryPointNameField = this.getFieldToolkit().createStyledTextField(parent, "Entry Point", 6, labelColWidth);
            GridDataFactory.defaultsFor((Control)entryPointNameField).align(4, 0x1000000).grab(true, false).applyTo((Control)entryPointNameField);
            String nameInDefinition = this.getInput().getEntryPointNameFromDefinition(portType);
            if (StringUtils.isNotBlank((CharSequence)nameInDefinition)) {
                entryPointNameField.setReadOnlySuffix("WebServiceEntryPoint");
                entryPointNameField.setText(nameInDefinition);
            }
            final IType entryPoint = this.getInput().getEntryPoint(portType);
            entryPointNameField.setData(PROP_PORT_TYPE, portType);
            entryPointNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WebServiceFormPage.this.clearMessage();
                    WebServiceFormPage.this.getManagedForm().dirtyStateChanged();
                }
            });
            if (S2eUtils.exists((IJavaElement)entryPoint)) {
                entryPointNameField.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)entryPoint));
                entryPointNameField.getLabelComponent().setToolTipText(entryPoint.getFullyQualifiedName());
                entryPointNameField.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        S2eUiUtils.openInEditor((IJavaElement)entryPoint);
                    }
                });
            }
            this.m_entryPointNameFields.add(entryPointNameField);
        }
        for (IType portType : allPortTypes) {
            ProposalTextField entryPointPackageField = this.getFieldToolkit().createPackageField(parent, "Entry Point Package", this.getInput().getJavaProject(), labelColWidth, 5);
            GridDataFactory.defaultsFor((Control)entryPointPackageField).align(4, 0x1000000).grab(true, false).applyTo((Control)entryPointPackageField);
            String packageInDefinition = this.getInput().getEntryPointPackageFromDefinition(portType);
            if (StringUtils.isNotBlank((CharSequence)packageInDefinition)) {
                entryPointPackageField.setText(packageInDefinition);
            }
            entryPointPackageField.setData(PROP_PORT_TYPE, portType);
            entryPointPackageField.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)portType.getPackageFragment()));
            entryPointPackageField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WebServiceFormPage.this.clearMessage();
                    WebServiceFormPage.this.getManagedForm().dirtyStateChanged();
                }
            });
            this.m_entryPointPackageFields.add(entryPointPackageField);
        }
        for (IType portType : allPortTypes) {
            this.createHandlersList(parent, portType, labelColWidth, numPortTypes);
        }
        for (IType portType : allPortTypes) {
            IType authMethodFromDefinition = this.getInput().getAuthMethodFromDefinition(portType);
            if (!S2eUtils.exists((IJavaElement)authMethodFromDefinition)) continue;
            this.createLabeledHyperlink(parent, "Authentication Method", null, authMethodFromDefinition, labelColWidth, 0);
        }
        for (IType portType : allPortTypes) {
            IType authVerifierFromDefinition = this.getInput().getAuthVerifierFromDefinition(portType);
            if (!S2eUtils.exists((IJavaElement)authVerifierFromDefinition)) continue;
            this.createLabeledHyperlink(parent, "Authentication Verifier", null, authVerifierFromDefinition, labelColWidth, 0);
        }
    }

    protected void createHandlersList(Composite p, IType portType, int labelColWidth, int numPortTypes) {
        List<IType> handlers = this.getInput().getHandlers(portType);
        if (handlers.isEmpty() && numPortTypes <= 1) {
            return;
        }
        Composite parent = this.getFormToolkit().createComposite(p);
        GridDataFactory.defaultsFor((Control)parent).align(4, 1).grab(true, false).indent(0, 20).applyTo((Control)parent);
        parent.setLayout((Layout)new FormLayout());
        if (!handlers.isEmpty()) {
            Label label = this.getFormToolkit().createLabel(parent, "Handlers", 131072);
            Composite handlersComposite = this.getFormToolkit().createComposite(parent);
            GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(handlersComposite);
            for (IType handler : handlers) {
                ImageHyperlink link = this.getFormToolkit().createImageHyperlink(handlersComposite, 0);
                link.setUnderlined(true);
                link.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)handler));
                link.setToolTipText(handler.getFullyQualifiedName());
                link.setText(handler.getElementName());
                final IType currentHandler = handler;
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        S2eUiUtils.openInEditor((IJavaElement)currentHandler);
                    }
                });
            }
            FormData labelData = new FormData();
            labelData.top = new FormAttachment(0, 2);
            labelData.left = new FormAttachment(0, 0);
            labelData.right = new FormAttachment(0, labelColWidth);
            labelData.bottom = new FormAttachment(100, 0);
            label.setLayoutData((Object)labelData);
            FormData textData = new FormData();
            textData.top = new FormAttachment(0, 0);
            textData.left = new FormAttachment((Control)label, 5);
            textData.right = new FormAttachment(100, 0);
            textData.bottom = new FormAttachment(100, 0);
            handlersComposite.setLayoutData((Object)textData);
        }
    }

    protected void setEnabled(boolean enabled) {
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm == null) {
            return;
        }
        ScrolledForm form = managedForm.getForm();
        if (form.isDisposed()) {
            return;
        }
        form.setEnabled(enabled);
        form.getBody().setEnabled(enabled);
        boolean jaxwsBindingFileExists = !this.getInput().getJaxWsBindingFiles().isEmpty();
        for (StyledTextField styledTextField : this.m_portTypeNameFields) {
            styledTextField.setEnabled(enabled && jaxwsBindingFileExists);
        }
        this.m_packageField.setEnabled(enabled && jaxwsBindingFileExists);
        for (StyledTextField styledTextField : this.m_webServiceNameFields) {
            styledTextField.setEnabled(enabled && jaxwsBindingFileExists);
        }
        for (StyledTextField styledTextField : this.m_entryPointNameFields) {
            styledTextField.setEnabled(enabled && S2eUtils.exists((IJavaElement)this.getInput().getEntryPointDefinition(this.getPortType((Control)styledTextField))));
        }
        for (ProposalTextField proposalTextField : this.m_entryPointPackageFields) {
            proposalTextField.setEnabled(enabled && S2eUtils.exists((IJavaElement)this.getInput().getEntryPointDefinition(this.getPortType((Control)proposalTextField))));
        }
    }

    protected IType getPortType(Control control) {
        return (IType)control.getData(PROP_PORT_TYPE);
    }

    protected void createBindingGroup(Composite p) {
        Composite parent = this.createSection(this.getFormToolkit(), p, "Bindings");
        GridLayoutFactory.swtDefaults().applyTo(parent);
        Iterator<IFile> iterator = this.getInput().getBindings().iterator();
        while (iterator.hasNext()) {
            IFile f;
            final IFile file = f = iterator.next();
            ImageHyperlink field = this.getFormToolkit().createImageHyperlink(parent, 0);
            field.setUnderlined(true);
            field.setText(f.getName());
            field.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)f));
            GridDataFactory.defaultsFor((Control)field).align(4, 0x1000000).grab(true, false).applyTo((Control)field);
            field.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    S2eUiUtils.openInEditor(file);
                }
            });
        }
    }

    protected void createPackageField(Composite parent, IType portType, int labelColWidth, int horizontalSpan) {
        this.m_packageField = this.getFieldToolkit().createPackageField(parent, "Package", this.getInput().getJavaProject(), labelColWidth, 5);
        GridDataFactory.defaultsFor((Control)this.m_packageField).align(4, 0x1000000).grab(true, false).span(horizontalSpan, 1).applyTo((Control)this.m_packageField);
        String packageInBinding = Signature.getQualifier((String)portType.getFullyQualifiedName());
        if (StringUtils.isNotBlank((CharSequence)packageInBinding)) {
            this.m_packageField.setText(packageInBinding);
        }
        this.m_packageField.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)portType.getPackageFragment()));
        this.m_packageField.setData(PROP_PORT_TYPE, portType);
        this.m_packageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebServiceFormPage.this.clearMessage();
                WebServiceFormPage.this.getManagedForm().dirtyStateChanged();
            }
        });
    }

    protected void createPortTypeNameField(Composite parent, final IType portType, int labelColWidth) {
        StyledTextField portTypeNameField = this.getFieldToolkit().createStyledTextField(parent, "Port Type (EPI)", 6, labelColWidth);
        GridDataFactory.defaultsFor((Control)portTypeNameField).align(4, 0x1000000).grab(true, false).applyTo((Control)portTypeNameField);
        String nameInBinding = portType.getElementName();
        if (StringUtils.isNotBlank((CharSequence)nameInBinding)) {
            portTypeNameField.setReadOnlyPrefix("I");
            portTypeNameField.setReadOnlySuffix("PortType");
            portTypeNameField.setText(nameInBinding);
        }
        portTypeNameField.setData(PROP_PORT_TYPE, portType);
        portTypeNameField.getLabelComponent().setToolTipText(portType.getFullyQualifiedName());
        portTypeNameField.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)portType));
        portTypeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebServiceFormPage.this.clearMessage();
                WebServiceFormPage.this.getManagedForm().dirtyStateChanged();
            }
        });
        portTypeNameField.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                S2eUiUtils.openInEditor((IJavaElement)portType);
            }
        });
        this.m_portTypeNameFields.add(portTypeNameField);
    }

    public boolean isPortTypeNameChanged() {
        for (StyledTextField field : this.m_portTypeNameFields) {
            if (Objects.equals(field.getText(), this.getPortType((Control)field).getElementName())) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        if (this.isPortTypeNameChanged()) {
            return true;
        }
        if (this.isPackageChanged()) {
            return true;
        }
        if (this.isWebServiceNameChanged()) {
            return true;
        }
        if (this.isEntryPointNameChanged()) {
            return true;
        }
        return this.isEntryPointPackageChanged();
    }

    protected boolean isEntryPointPackageChanged(ProposalTextField field) {
        return !Objects.equals(field.getText(), StringUtils.defaultIfEmpty((CharSequence)this.getInput().getEntryPointPackageFromDefinition(this.getPortType((Control)field)), (CharSequence)""));
    }

    public boolean isEntryPointPackageChanged() {
        for (ProposalTextField field : this.m_entryPointPackageFields) {
            if (!this.isEntryPointPackageChanged(field)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEntryPointNameChanged(StyledTextField field) {
        return !Objects.equals(field.getText(), StringUtils.defaultIfEmpty((CharSequence)this.getInput().getEntryPointNameFromDefinition(this.getPortType((Control)field)), (CharSequence)""));
    }

    public boolean isEntryPointNameChanged() {
        for (StyledTextField field : this.m_entryPointNameFields) {
            if (!this.isEntryPointNameChanged(field)) continue;
            return true;
        }
        return false;
    }

    public boolean isWebServiceNameChanged() {
        for (StyledTextField field : this.m_webServiceNameFields) {
            IType webService = (IType)field.getData(PROP_WEB_SERVICE);
            if (Objects.equals(field.getText(), webService.getElementName())) continue;
            return true;
        }
        return false;
    }

    public boolean isPackageChanged() {
        return this.m_packageField != null && !Objects.equals(this.m_packageField.getText(), Signature.getQualifier((String)this.getPortType((Control)this.m_packageField).getFullyQualifiedName()));
    }

    protected StyledTextField getWebServiceNameField(IType portType) {
        IType webService = this.getInput().getWebService(portType);
        for (StyledTextField field : this.m_webServiceNameFields) {
            if (!webService.equals(field.getData(PROP_WEB_SERVICE))) continue;
            return field;
        }
        return null;
    }

    protected StyledTextField getPortTypeNameField(IType portType) {
        for (StyledTextField field : this.m_portTypeNameFields) {
            if (!portType.equals(this.getPortType((Control)field))) continue;
            return field;
        }
        return null;
    }

    protected void fillOperation(WebServiceUpdateOperation op) {
        List<IFile> jaxWsBindingFiles = this.getInput().getJaxWsBindingFiles();
        if (!jaxWsBindingFiles.isEmpty() && (this.isPortTypeNameChanged() || this.isWebServiceNameChanged() || this.isPackageChanged())) {
            op.setJaxwsBindingFiles(jaxWsBindingFiles);
            op.setPackage(this.m_packageField.getText());
            for (StyledTextField webServiceField : this.m_webServiceNameFields) {
                IType webService = (IType)webServiceField.getData(PROP_WEB_SERVICE);
                op.addBindingClassUpdate(new WebServiceUpdateOperation.BindingClassUpdate(JaxWsUtils.getWebServiceXPath((String)this.getInput().getWebServiceNameInWsdl(webService).getLocalPart()), webServiceField.getText()));
            }
            for (StyledTextField portTypeNameField : this.m_portTypeNameFields) {
                IType serviceImpl;
                IType portType = this.getPortType((Control)portTypeNameField);
                IType webServiceClient = this.getInput().getWebServiceClient(portType);
                if (S2eUtils.exists((IJavaElement)webServiceClient)) {
                    op.addWebServiceClientUpdate(new WebServiceUpdateOperation.WebServiceClientUpdate(webServiceClient, this.m_packageField.getText(), portTypeNameField.getText(), this.getWebServiceNameField(portType).getText()));
                }
                if (S2eUtils.exists((IJavaElement)(serviceImpl = this.getInput().getServiceImplementation(portType)))) {
                    op.addWebServiceImplementationUpdate(new WebServiceUpdateOperation.WebServiceImplementationUpdate(serviceImpl, this.m_packageField.getText(), portTypeNameField.getText()));
                }
                op.addBindingClassUpdate(new WebServiceUpdateOperation.BindingClassUpdate(JaxWsUtils.getPortTypeXPath((String)this.getInput().getPortTypeNameInWsdl(portType).getLocalPart()), portTypeNameField.getText()));
            }
        }
        int i = 0;
        while (i < this.m_entryPointNameFields.size()) {
            StyledTextField entryPointNameField = this.m_entryPointNameFields.get(i);
            ProposalTextField entryPointPackageField = this.m_entryPointPackageFields.get(i);
            IType portType = this.getPortType((Control)entryPointNameField);
            IType entryPointDefinition = this.getInput().getEntryPointDefinition(portType);
            if (S2eUtils.exists((IJavaElement)entryPointDefinition) && (this.isPortTypeNameChanged() || this.isPackageChanged() || this.isEntryPointNameChanged(entryPointNameField) || this.isEntryPointPackageChanged(entryPointPackageField))) {
                WebServiceUpdateOperation.EntryPointDefinitionUpdate up = new WebServiceUpdateOperation.EntryPointDefinitionUpdate(entryPointDefinition, entryPointPackageField.getText(), entryPointNameField.getText(), this.getPortTypeNameField(portType).getText(), this.m_packageField.getText());
                op.addEntryPointDefinitionUpdate(up);
            }
            ++i;
        }
    }

    protected void clearMessage() {
        this.getManagedForm().getForm().setMessage("", 0);
    }

    protected void setMessage(IStatus status) {
        int severity = 0;
        switch (status.getSeverity()) {
            case 4: {
                severity = 3;
                break;
            }
            case 1: {
                severity = 1;
                break;
            }
            case 2: {
                severity = 2;
            }
        }
        this.getManagedForm().getForm().setMessage(status.getMessage(), severity);
    }

    protected boolean isValidJavaName(Iterable<StyledTextField> fields) {
        for (StyledTextField field : fields) {
            IStatus status;
            if (!field.isEnabled() || (status = CompilationUnitNewWizardPage.validateJavaName(field.getText(), field.getReadOnlySuffix())).isOK()) continue;
            this.setMessage(status);
            return false;
        }
        return true;
    }

    protected boolean isValidPackage(Iterable<? extends TextField> fields) {
        for (TextField textField : fields) {
            IStatus status;
            if (!textField.isEnabled() || (status = CompilationUnitNewWizardPage.validatePackageName(textField.getText())).isOK()) continue;
            this.setMessage(status);
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (!this.isValidJavaName(this.m_portTypeNameFields)) {
            return false;
        }
        if (!this.isValidJavaName(this.m_webServiceNameFields)) {
            return false;
        }
        if (!this.isValidJavaName(this.m_entryPointNameFields)) {
            return false;
        }
        if (!this.isValidPackage(Collections.singletonList(this.m_packageField))) {
            return false;
        }
        return this.isValidPackage(this.m_entryPointPackageFields);
    }

    protected void createLabeledHyperlink(Composite p, String labelText, final IFile file, final IType element, int labelWidth, int topOffset) {
        Composite parent = this.getFormToolkit().createComposite(p);
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).applyTo((Control)parent);
        parent.setLayout((Layout)new FormLayout());
        Label label = this.getFormToolkit().createLabel(parent, labelText, 131072);
        int fieldTopOffset = topOffset;
        int labelYOffset = 2;
        ImageHyperlink field = null;
        if (file != null && file.exists() || S2eUtils.exists((IJavaElement)element)) {
            ImageHyperlink link;
            field = link = this.getFormToolkit().createImageHyperlink(parent, 0);
            link.setUnderlined(true);
            if (file != null) {
                link.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)file));
                link.setToolTipText(file.getFullPath().toString());
                link.setText(file.getName());
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        S2eUiUtils.openInEditor(file);
                    }
                });
            } else {
                link.setImage(this.m_decoratingWorkbenchLabelProvider.getImage((Object)element));
                link.setToolTipText(element.getFullyQualifiedName());
                link.setText(element.getElementName());
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent event) {
                        S2eUiUtils.openInEditor((IJavaElement)element);
                    }
                });
            }
        } else {
            Label lbl = this.getFormToolkit().createLabel(parent, "Not found");
            field = lbl;
            lbl.setForeground(parent.getDisplay().getSystemColor(3));
            fieldTopOffset += labelYOffset;
        }
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, labelYOffset + topOffset);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(0, labelWidth);
        label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, fieldTopOffset);
        textData.left = new FormAttachment((Control)label, 5);
        field.setLayoutData((Object)textData);
    }

    protected void createActionToolBar(IToolBarManager manager) {
        Action rebuildAction = new Action("Rebuild all artifacts"){

            public void run() {
                WebServiceFormPage.this.getEditor().rebuildAllArtifacts();
            }
        };
        rebuildAction.setToolTipText("Rebuild all artifacts of this project");
        rebuildAction.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("wsdl.gif"));
        manager.add((IAction)rebuildAction);
        Action addServiceAction = new Action("Create new Web Service"){

            public void run() {
                WebServiceFormPage.this.getEditor().startNewWebServiceWizard();
            }
        };
        addServiceAction.setToolTipText("Create new Web Service");
        addServiceAction.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("webservice_add.gif"));
        manager.add((IAction)addServiceAction);
        Action refreshAction = new Action("Refresh Editor"){

            public void run() {
                WebServiceFormPage.this.getEditor().reload(WebServiceFormPage.this.getId());
            }
        };
        refreshAction.setToolTipText("Refresh the content of this editor.");
        refreshAction.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("refresh.gif"));
        manager.add((IAction)refreshAction);
    }

    protected Composite createSection(FormToolkit toolkit, Composite parent, String sectionLabel) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(sectionLabel);
        GridLayoutFactory.swtDefaults().applyTo((Composite)section);
        GridDataFactory.defaultsFor((Control)section).align(4, 0x1000000).grab(true, false).applyTo((Control)section);
        Composite result = toolkit.createComposite((Composite)section);
        section.setClient((Control)result);
        GridDataFactory.defaultsFor((Control)result).align(4, 0x1000000).grab(true, false).applyTo((Control)result);
        return result;
    }

    public WebServiceFormPageInput getInput() {
        return this.m_input;
    }

    public FormToolkit getFormToolkit() {
        return this.getManagedForm().getToolkit();
    }

    public FieldToolkit getFieldToolkit() {
        return this.m_fieldToolkit;
    }

    private static final class P_ImageArea {
        private final Rectangle m_area;
        private final Object m_elementToShow;

        public P_ImageArea(int topLeftX, int topLeftY, int width, int height, Object elementToShow) {
            this.m_area = new Rectangle(topLeftX, topLeftY, width, height);
            this.m_elementToShow = elementToShow;
        }

        private boolean contains(int x, int y, int imageWidth, int containerWidth) {
            int leftOffset = (containerWidth - imageWidth) / 2;
            return this.m_area.contains(x - leftOffset, y);
        }
    }
}

