/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.scout.sdk.s2e.nls.resource.ITranslationResource;

public class NlsResourceProvider {
    private List<Language> m_languagesOrdered;
    private final Map<Language, ITranslationResource> m_resourceMap = new HashMap<Language, ITranslationResource>();

    public NlsResourceProvider() {
        this.m_languagesOrdered = Collections.emptyList();
    }

    public void addResource(ITranslationResource r) {
        Language language = r.getLanguage();
        if (this.m_resourceMap.containsKey(language)) {
            SdkLog.warning((String)"language already exists!", (Object[])new Object[0]);
        } else {
            this.m_resourceMap.put(language, r);
            this.m_languagesOrdered = NlsResourceProvider.getOrderedLanguages(this.m_resourceMap.keySet());
        }
    }

    private static List<Language> getOrderedLanguages(Set<Language> languages) {
        TreeMap<Comparable[], Language> orderedLanguages = new TreeMap<Comparable[], Language>(new Comparator<Comparable[]>(){

            @Override
            public int compare(Comparable[] o1, Comparable[] o2) {
                int i = 0;
                while (i < o1.length) {
                    int dif = o1[i].compareTo(o2[i]);
                    if (dif != 0) {
                        return dif;
                    }
                    ++i;
                }
                return 0;
            }
        });
        for (Language l : languages) {
            int index = 3;
            if (l.equals(Language.LANGUAGE_KEY)) {
                index = 1;
            } else if (l.equals(Language.LANGUAGE_DEFAULT)) {
                index = 2;
            }
            orderedLanguages.put(new Comparable[]{Integer.valueOf(index), l.getDispalyName(), Integer.valueOf(l.hashCode())}, l);
        }
        return new ArrayList<Language>(orderedLanguages.values());
    }

    public void remove(ITranslationResource r) {
        if (!this.m_resourceMap.containsValue(r)) {
            SdkLog.warning((String)"trying to remove a non existing resource!", (Object[])new Object[0]);
        } else {
            this.m_resourceMap.remove(r.getLanguage());
            this.m_languagesOrdered = NlsResourceProvider.getOrderedLanguages(this.m_resourceMap.keySet());
        }
    }

    public List<ITranslationResource> getSortedResources() {
        ArrayList<ITranslationResource> resources = new ArrayList<ITranslationResource>(this.m_languagesOrdered.size());
        for (Language lang : this.m_languagesOrdered) {
            resources.add(this.m_resourceMap.get(lang));
        }
        return resources;
    }

    public List<ITranslationResource> getResources() {
        return new ArrayList<ITranslationResource>(this.m_resourceMap.values());
    }

    public ITranslationResource getResource(Language language) {
        return this.m_resourceMap.get(language);
    }

    public boolean containsResource(Language language) {
        return this.m_resourceMap.containsKey(language);
    }

    public List<Language> getAllLanguages() {
        return new ArrayList<Language>(this.m_languagesOrdered);
    }
}

