/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.scout.sdk.core.model.api.Flags;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.job.ResourceBlockingOperationJob;
import org.eclipse.scout.sdk.s2e.operation.CompilationUnitWriteOperation;
import org.eclipse.scout.sdk.s2e.operation.IFileWriteOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.ResourceWriteOperation;
import org.eclipse.scout.sdk.s2e.util.ScoutStatus;
import org.eclipse.scout.sdk.s2e.util.ScoutTier;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class S2eUtils {
    private static final Comparator<IType> COMPARATOR = new P_TypeMatchComparator();

    private S2eUtils() {
    }

    public static org.eclipse.scout.sdk.core.model.api.IType jdtTypeToScoutType(IType jdtType) throws CoreException {
        return S2eUtils.jdtTypeToScoutType(jdtType, ScoutSdkCore.createJavaEnvironment(jdtType.getJavaProject()));
    }

    public static IPackageFragmentRoot getSourceFolder(IJavaElement e) {
        if (e == null) {
            return null;
        }
        return (IPackageFragmentRoot)e.getAncestor(3);
    }

    public static String getPackage(ICompilationUnit icu) throws JavaModelException {
        if (!S2eUtils.exists((IJavaElement)icu)) {
            return "";
        }
        IPackageDeclaration[] packageDeclarations = icu.getPackageDeclarations();
        if (packageDeclarations.length < 1) {
            return "";
        }
        return packageDeclarations[0].getElementName();
    }

    public static org.eclipse.scout.sdk.core.model.api.IType jdtTypeToScoutType(IType jdtType, IJavaEnvironment env) {
        return env.findType(jdtType.getFullyQualifiedName());
    }

    public static Set<IType> findAbstractClassesInHierarchy(IJavaProject sourceProject, String baseTypeFqn, IProgressMonitor monitor) throws CoreException {
        return S2eUtils.findClassesInStrictHierarchy(sourceProject, baseTypeFqn, monitor, (Predicate<IType>)new PublicAbstractPrimaryTypeFilter());
    }

    public static Set<IType> findClassesInStrictHierarchy(IJavaProject sourceProject, String baseTypeFqn, IProgressMonitor monitor, Predicate<IType> filter) throws CoreException {
        if (!S2eUtils.exists((IJavaElement)sourceProject)) {
            return Collections.emptySet();
        }
        return S2eUtils.findClassesInStrictHierarchy(sourceProject, sourceProject.findType(baseTypeFqn.replace('$', '.')), monitor, filter);
    }

    public static Set<IType> findClassesInStrictHierarchy(IJavaProject sourceProject, IType baseType, final IProgressMonitor monitor, final Predicate<IType> filter) throws CoreException {
        if (!(S2eUtils.exists((IJavaElement)baseType) && S2eUtils.exists(baseType.getParent()) && S2eUtils.exists((IJavaElement)sourceProject))) {
            return Collections.emptySet();
        }
        final TreeSet<IType> collector = new TreeSet<IType>(new ElementNameComparator());
        TypeNameMatchRequestor nameMatchRequestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException("strict hierarchy search canceled by monitor.");
                }
                if (filter == null || filter.test(match.getType())) {
                    collector.add(match.getType());
                }
            }
        };
        IJavaSearchScope strictHierarchyScope = SearchEngine.createStrictHierarchyScope((IJavaProject)sourceProject, (IType)baseType, (boolean)true, (boolean)true, null);
        try {
            new SearchEngine().searchAllTypeNames(null, 0, null, 0, 5, strictHierarchyScope, nameMatchRequestor, 3, monitor);
        }
        catch (OperationCanceledException oce) {
            SdkLog.debug((String)"Strict hierarchy search has been canceled. An incomplete result will be returned.", (Object[])new Object[]{oce});
        }
        return collector;
    }

    public static IMethod getFirstMethod(IType type, Predicate<IMethod> filter) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (filter == null || filter.test(method)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static Set<IType> resolveJdtTypes(String fqn) throws CoreException {
        return S2eUtils.resolveJdtTypes(fqn, SearchEngine.createWorkspaceScope());
    }

    public static Set<IType> resolveJdtTypes(final String fqn, IJavaSearchScope scope) throws CoreException {
        String fastPat = Signature.getSimpleName((String)fqn);
        final TreeSet<IType> matchList = new TreeSet<IType>(COMPARATOR);
        new SearchEngine().search(SearchPattern.createPattern((String)fastPat, (int)0, (int)0, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                IType t;
                Object element = match.getElement();
                if (element instanceof IType && (t = (IType)element).getFullyQualifiedName().indexOf(fqn) >= 0) {
                    matchList.add(t);
                }
            }
        }, null);
        return matchList;
    }

    public static void waitForBuild() {
        AbstractJob.waitForJobFamily(ResourcesPlugin.FAMILY_MANUAL_BUILD);
        AbstractJob.waitForJobFamily(ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    public static void waitForJdt() {
        AbstractJob.waitForJobFamily("org.eclipse.jdt.ui");
    }

    public static IAnnotation getFirstAnnotationInSupertypeHierarchy(IType type, String ... fullyQualifiedAnnotations) throws CoreException {
        IType t;
        if (type == null) {
            return null;
        }
        IAnnotation ann = S2eUtils.getFirstDeclaredAnnotation((IAnnotatable)type, fullyQualifiedAnnotations);
        if (S2eUtils.exists((IJavaElement)ann)) {
            return ann;
        }
        ITypeHierarchy h = type.newSupertypeHierarchy(null);
        IType[] iTypeArray = h.getAllSuperclasses(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            t = iTypeArray[n2];
            ann = S2eUtils.getFirstDeclaredAnnotation((IAnnotatable)t, fullyQualifiedAnnotations);
            if (S2eUtils.exists((IJavaElement)ann)) {
                return ann;
            }
            ++n2;
        }
        iTypeArray = h.getAllSuperInterfaces(type);
        n = iTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            t = iTypeArray[n2];
            ann = S2eUtils.getFirstDeclaredAnnotation((IAnnotatable)t, fullyQualifiedAnnotations);
            if (S2eUtils.exists((IJavaElement)ann)) {
                return ann;
            }
            ++n2;
        }
        return null;
    }

    public static IAnnotation getFirstDeclaredAnnotation(IAnnotatable element, String ... fullyQualifiedAnnotations) {
        String[] stringArray = fullyQualifiedAnnotations;
        int n = fullyQualifiedAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            String fqn = stringArray[n2];
            IAnnotation ann = S2eUtils.getAnnotation(element, fqn);
            if (S2eUtils.exists((IJavaElement)ann)) {
                return ann;
            }
            ++n2;
        }
        return null;
    }

    public static IAnnotation getAnnotation(IAnnotatable element, String fullyQualifiedAnnotation) {
        String startFq;
        String startSimple;
        if (element == null) {
            return null;
        }
        String simpleName = Signature.getSimpleName((String)fullyQualifiedAnnotation);
        IAnnotation result = S2eUtils.getAnnotation(element, simpleName, startSimple = String.valueOf('@') + simpleName, startFq = String.valueOf('@') + fullyQualifiedAnnotation);
        if (result != null) {
            return result;
        }
        return S2eUtils.getAnnotation(element, fullyQualifiedAnnotation, startSimple, startFq);
    }

    private static IAnnotation getAnnotation(IAnnotatable element, String name, String startSimple, String startFq) {
        String annotSource = null;
        IAnnotation annotation = element.getAnnotation(name);
        if (!S2eUtils.exists((IJavaElement)annotation)) {
            return null;
        }
        try {
            annotSource = annotation.getSource();
            if (annotSource != null) {
                annotSource = annotSource.trim();
            }
        }
        catch (Exception e) {
            SdkLog.warning((String)"Could not get source of annotation '{}' in element '{}'.", (Object[])new Object[]{name, element, e});
        }
        if (annotSource == null || annotSource.startsWith(startSimple) || annotSource.startsWith(startFq)) {
            return annotation;
        }
        if (element instanceof IMember && (annotSource = S2eUtils.getAnnotationSourceFixed((IMember)element, annotation, startSimple)) != null && (annotSource.startsWith(startSimple) || annotSource.startsWith(startFq))) {
            return annotation;
        }
        return null;
    }

    private static String getAnnotationSourceFixed(IMember member, IAnnotation annotation, String startSimple) {
        try {
            String diff;
            int offset;
            String icuSource;
            ISourceRange annotSourceRange = annotation.getSourceRange();
            ISourceRange ownerSourceRange = member.getSourceRange();
            if (SourceRange.isAvailable((ISourceRange)ownerSourceRange) && SourceRange.isAvailable((ISourceRange)annotSourceRange) && ownerSourceRange.getOffset() > annotSourceRange.getOffset() && (icuSource = member.getCompilationUnit().getSource()) != null && icuSource.length() >= ownerSourceRange.getOffset() && (offset = (diff = icuSource.substring(annotSourceRange.getOffset(), ownerSourceRange.getOffset())).lastIndexOf(startSimple)) >= 0) {
                int end = (offset += annotSourceRange.getOffset()) + annotSourceRange.getLength();
                if (icuSource.length() >= end) {
                    return icuSource.substring(offset, end);
                }
            }
        }
        catch (JavaModelException e) {
            SdkLog.warning((String)"Unable to find source for annotation '{}' in '{}'.", (Object[])new Object[]{annotation.getElementName(), member.getElementName(), e});
        }
        return null;
    }

    public static Set<IType> findAllTypesAnnotatedWith(String annotationName, IJavaSearchScope scope, final IProgressMonitor monitor) throws CoreException {
        final LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        SearchRequestor collector = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException("annotated types search canceled.");
                }
                if (match.getElement() instanceof IType) {
                    IType t = (IType)match.getElement();
                    result.add(t);
                }
            }
        };
        for (IType annotationType : S2eUtils.resolveJdtTypes(annotationName, SearchEngine.createWorkspaceScope())) {
            if (monitor != null && monitor.isCanceled()) {
                return result;
            }
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)annotationType, (int)65536);
            try {
                new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, collector, monitor);
            }
            catch (OperationCanceledException oce) {
                SdkLog.debug((String)"Search for all types annotated with '{}' has been canceled.", (Object[])new Object[]{annotationName, oce});
            }
        }
        return result;
    }

    public static boolean exists(IJavaElement element) {
        return element != null && element.exists();
    }

    public static boolean isOnClasspath(IJavaElement element, IJavaProject project) {
        IMember member;
        if (!S2eUtils.exists(element)) {
            return false;
        }
        if (!S2eUtils.exists((IJavaElement)project)) {
            return false;
        }
        if (element instanceof IMember && (member = (IMember)element).isBinary()) {
            return project.isOnClasspath((IJavaElement)member);
        }
        IJavaProject elemenProject = element.getJavaProject();
        if (elemenProject != null) {
            if (project.equals(elemenProject)) {
                return true;
            }
            return project.isOnClasspath((IJavaElement)elemenProject);
        }
        return project.isOnClasspath(element);
    }

    public static BigDecimal getAnnotationValueNumeric(IAnnotation annotation, String name) throws JavaModelException {
        IMemberValuePair[] memberValues;
        if (!S2eUtils.exists((IJavaElement)annotation)) {
            return null;
        }
        IMemberValuePair[] iMemberValuePairArray = memberValues = annotation.getMemberValuePairs();
        int n = memberValues.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair p = iMemberValuePairArray[n2];
            if (Objects.equals(name, p.getMemberName())) {
                switch (p.getValueKind()) {
                    case 6: {
                        Double doubleValue = (Double)p.getValue();
                        return BigDecimal.valueOf(doubleValue);
                    }
                    case 5: {
                        Float floatValue = (Float)p.getValue();
                        return BigDecimal.valueOf(floatValue.doubleValue());
                    }
                    case 1: {
                        Integer intValue = (Integer)p.getValue();
                        return BigDecimal.valueOf(intValue.longValue());
                    }
                    case 2: {
                        Byte byteValue = (Byte)p.getValue();
                        return BigDecimal.valueOf(byteValue.longValue());
                    }
                    case 7: {
                        Long longValue = (Long)p.getValue();
                        return BigDecimal.valueOf(longValue);
                    }
                    case 3: {
                        Short shortValue = (Short)p.getValue();
                        return BigDecimal.valueOf(shortValue.longValue());
                    }
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    public static String getAnnotationValueString(IAnnotation annotation, String name) throws JavaModelException {
        IMemberValuePair[] memberValues;
        if (!S2eUtils.exists((IJavaElement)annotation)) {
            return null;
        }
        IMemberValuePair[] iMemberValuePairArray = memberValues = annotation.getMemberValuePairs();
        int n = memberValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object val;
            IMemberValuePair p = iMemberValuePairArray[n2];
            if (Objects.equals(name, p.getMemberName()) && (val = p.getValue()) != null) {
                return val.toString();
            }
            ++n2;
        }
        return null;
    }

    public static String lineSeparator(IJavaProject p) {
        return Util.getLineSeparator(null, (IJavaProject)p);
    }

    public static PropertyMap propertyMap(IJavaProject p) {
        PropertyMap context = new PropertyMap();
        context.setProperty("JavaProject", (Object)p);
        return context;
    }

    public static IStatus makeCommittable(Collection<IResource> resources) {
        if (resources == null || resources.isEmpty()) {
            return Status.OK_STATUS;
        }
        HashSet<IFile> existingReadOnlyFiles = new HashSet<IFile>(resources.size());
        for (IResource r : resources) {
            if (r == null || !r.exists() || r.getType() != 1 || !S2eUtils.isReadOnly(r)) continue;
            existingReadOnlyFiles.add((IFile)r);
        }
        if (existingReadOnlyFiles.isEmpty()) {
            return Status.OK_STATUS;
        }
        Map<IFile, Long> oldTimeStamps = S2eUtils.createModificationStampMap(existingReadOnlyFiles);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(existingReadOnlyFiles.toArray(new IFile[existingReadOnlyFiles.size()]), IWorkspace.VALIDATE_PROMPT);
        if (!status.isOK()) {
            return status;
        }
        IStatus modified = null;
        for (IFile f : existingReadOnlyFiles) {
            if (!S2eUtils.isReadOnly((IResource)f)) continue;
            String message = "File '" + f.getFullPath() + "' is read only.";
            modified = S2eUtils.addStatus(modified, message);
        }
        Map<IFile, Long> newTimeStamps = S2eUtils.createModificationStampMap(existingReadOnlyFiles);
        for (Map.Entry<IFile, Long> e : oldTimeStamps.entrySet()) {
            IFile file = e.getKey();
            if (e.getValue().equals(newTimeStamps.get(file))) continue;
            String message = "File '" + file.getFullPath() + "' has been modified since the beginning of the operation.";
            modified = S2eUtils.addStatus(modified, message);
        }
        if (modified != null) {
            return modified;
        }
        return Status.OK_STATUS;
    }

    private static IStatus addStatus(IStatus status, String msg) {
        ScoutStatus entry = new ScoutStatus(4, msg, null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("org.eclipse.scout.sdk.s2e", 0, msg, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }

    private static Map<IFile, Long> createModificationStampMap(Collection<IFile> files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>(files.size());
        for (IFile f : files) {
            map.put(f, f.getModificationStamp());
        }
        return map;
    }

    public static boolean isReadOnly(IResource resource) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes == null) {
            return false;
        }
        return resourceAttributes.isReadOnly();
    }

    public static List<IType> writeTypes(Collection<CompilationUnitWriteOperation> ops, IProgressMonitor monitor) throws CoreException {
        if (ops == null || ops.isEmpty()) {
            return Collections.emptyList();
        }
        S2eUtils.writeFiles(ops, monitor);
        ArrayList<IType> result = new ArrayList<IType>(ops.size());
        for (CompilationUnitWriteOperation op : ops) {
            result.add(S2eUtils.getFirstType(op));
        }
        return result;
    }

    private static IType getFirstType(CompilationUnitWriteOperation op) throws JavaModelException {
        if (op == null) {
            return null;
        }
        ICompilationUnit compilationUnit = op.getCreatedCompilationUnit();
        if (compilationUnit == null) {
            return null;
        }
        IType[] types = compilationUnit.getTypes();
        if (types.length < 1) {
            return null;
        }
        IType candidate = types[0];
        if (!S2eUtils.exists((IJavaElement)candidate)) {
            return null;
        }
        return candidate;
    }

    public static List<IFile> writeFiles(Collection<? extends IFileWriteOperation> ops, IProgressMonitor monitor) throws CoreException {
        if (ops == null || ops.isEmpty()) {
            return Collections.emptyList();
        }
        S2eUtils.writeFiles(ops, monitor, true);
        ArrayList<IFile> result = new ArrayList<IFile>(ops.size());
        for (IFileWriteOperation iFileWriteOperation : ops) {
            if (iFileWriteOperation == null) {
                result.add(null);
                continue;
            }
            result.add(iFileWriteOperation.getFile());
        }
        return result;
    }

    public static void writeFiles(Collection<? extends IFileWriteOperation> ops, IProgressMonitor monitor, boolean waitUntilWritten) throws CoreException {
        if (ops == null || ops.isEmpty()) {
            return;
        }
        HashSet<IResource> lockedResources = new HashSet<IResource>(ops.size());
        for (IFileWriteOperation iFileWriteOperation : ops) {
            IResource r;
            if (iFileWriteOperation == null || (r = iFileWriteOperation.getAffectedResource()) == null) continue;
            lockedResources.add(r);
        }
        ResourceBlockingOperationJob resourceBlockingOperationJob = new ResourceBlockingOperationJob(ops, lockedResources.toArray(new IResource[lockedResources.size()]));
        resourceBlockingOperationJob.schedule();
        if (waitUntilWritten) {
            try {
                resourceBlockingOperationJob.join(0L, monitor);
            }
            catch (InterruptedException | OperationCanceledException e) {
                SdkLog.info((String)"Unable to wait until resources have been written.", (Object[])new Object[]{e});
            }
        }
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)1);
    }

    public static IJavaSearchScope createJavaSearchScope(Collection<IResource> resources) throws CoreException {
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        final HashSet<IJavaElement> jset = new HashSet<IJavaElement>(resources.size());
        block6: for (IResource resource : resources) {
            if (resource == null || !resource.isAccessible()) continue;
            int type = resource.getType();
            switch (type) {
                case 4: {
                    IProject project = (IProject)resource;
                    if (!project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) continue block6;
                    S2eUtils.addJavaElement(jset, (IJavaElement)JavaCore.create((IProject)project));
                    break;
                }
                case 1: {
                    S2eUtils.addJavaElement(jset, JavaCore.create((IFile)((IFile)resource)));
                    break;
                }
                case 2: {
                    resource.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            if (proxy.getType() == 2) {
                                IFolder folder = (IFolder)proxy.requestResource();
                                S2eUtils.addJavaElement(jset, JavaCore.create((IFolder)folder));
                                return true;
                            }
                            return false;
                        }
                    }, 0);
                    break;
                }
                case 8: {
                    IJavaModel model = JavaCore.create((IWorkspaceRoot)((IWorkspaceRoot)resource));
                    if (!S2eUtils.exists((IJavaElement)model)) continue block6;
                    IJavaProject[] iJavaProjectArray = model.getJavaProjects();
                    int n = iJavaProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaProject jp = iJavaProjectArray[n2];
                        S2eUtils.addJavaElement(jset, (IJavaElement)jp);
                        ++n2;
                    }
                    continue block6;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown resource type: " + type);
                }
            }
        }
        if (jset.isEmpty()) {
            return null;
        }
        return S2eUtils.createJavaSearchScope(jset.toArray(new IJavaElement[jset.size()]));
    }

    private static void addJavaElement(Collection<IJavaElement> collector, IJavaElement elementToAdd) {
        if (S2eUtils.exists(elementToAdd)) {
            collector.add(elementToAdd);
        }
    }

    public static IPackageFragmentRoot getPrimarySourceFolder(IJavaProject project) throws JavaModelException {
        Set<IPackageFragmentRoot> sourceFolders = S2eUtils.getSourceFolders(project);
        if (sourceFolders.isEmpty()) {
            return null;
        }
        return (IPackageFragmentRoot)sourceFolders.iterator().next();
    }

    public static Set<IPackageFragmentRoot> getSourceFolders(IJavaProject project) throws JavaModelException {
        return S2eUtils.getSourceFolders(Collections.singletonList(project), null);
    }

    public static Set<IPackageFragmentRoot> getSourceFolders(Collection<IJavaProject> projects, IProgressMonitor monitor) throws JavaModelException {
        return S2eUtils.getSourceFolders(projects, null, monitor);
    }

    public static Set<IPackageFragmentRoot> getSourceFolders(Collection<IJavaProject> projects, Predicate<IPackageFragmentRoot> filter, IProgressMonitor monitor) throws JavaModelException {
        if (projects == null || projects.isEmpty()) {
            return Collections.emptySet();
        }
        TreeMap<CompositeObject, IPackageFragmentRoot> prioMap = new TreeMap<CompositeObject, IPackageFragmentRoot>();
        for (IJavaProject project : projects) {
            if (!S2eUtils.exists((IJavaElement)project)) continue;
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (monitor != null && monitor.isCanceled()) {
                    return Collections.emptySet();
                }
                if (S2eUtils.isJavaSourceFolder(root, filter)) {
                    String s = root.getPath().removeFirstSegments(1).toString().toLowerCase();
                    if ("src/main/java".equals(s)) {
                        prioMap.put(new CompositeObject(new Object[]{1, project, s}), root);
                    } else if ("src".equals(s)) {
                        prioMap.put(new CompositeObject(new Object[]{11, project, s}), root);
                    } else if (s.startsWith("src/main/")) {
                        prioMap.put(new CompositeObject(new Object[]{12, project, s}), root);
                    } else if ("src/test/java".equals(s)) {
                        prioMap.put(new CompositeObject(new Object[]{20, project, s}), root);
                    } else if (s.startsWith("src/test/")) {
                        prioMap.put(new CompositeObject(new Object[]{21, project, s}), root);
                    } else {
                        prioMap.put(new CompositeObject(new Object[]{30, project, s}), root);
                    }
                }
                ++n2;
            }
        }
        return new LinkedHashSet<IPackageFragmentRoot>(prioMap.values());
    }

    private static boolean isJavaSourceFolder(IPackageFragmentRoot root, Predicate<IPackageFragmentRoot> filter) throws JavaModelException {
        if (!S2eUtils.exists((IJavaElement)root)) {
            return false;
        }
        if (root.getKind() != 1 || root.isArchive() || root.isExternal()) {
            return false;
        }
        if (filter != null && !filter.test(root)) {
            return false;
        }
        IResource resource = root.getResource();
        if (resource == null || !resource.exists() || resource.isDerived()) {
            return false;
        }
        IClasspathEntry rawClasspathEntry = root.getRawClasspathEntry();
        if (rawClasspathEntry == null) {
            return false;
        }
        IPath[] exclusionPatterns = rawClasspathEntry.getExclusionPatterns();
        if (exclusionPatterns != null && exclusionPatterns.length > 0) {
            char[] javaSample = "Whatever.java".toCharArray();
            IPath[] iPathArray = exclusionPatterns;
            int n = exclusionPatterns.length;
            int n2 = 0;
            while (n2 < n) {
                IPath excludedPath = iPathArray[n2];
                char[] pattern = excludedPath.toString().toCharArray();
                boolean javaFilesExcluded = CharOperation.pathMatch((char[])pattern, (char[])javaSample, (boolean)true, (char)'/');
                if (javaFilesExcluded) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public static String createJavaCode(ISourceBuilder srcBuilder, IJavaProject targetProject) {
        return S2eUtils.createJavaCode(srcBuilder, targetProject, null);
    }

    public static String createJavaCode(ISourceBuilder srcBuilder, IJavaProject targetProject, IJavaEnvironment env) {
        if (srcBuilder == null) {
            return null;
        }
        if (!S2eUtils.exists((IJavaElement)targetProject)) {
            return null;
        }
        if (env == null) {
            env = ScoutSdkCore.createJavaEnvironment(targetProject);
        }
        return CoreUtils.createJavaCode((ISourceBuilder)srcBuilder, (IJavaEnvironment)env, (String)S2eUtils.lineSeparator(targetProject), (PropertyMap)S2eUtils.propertyMap(targetProject));
    }

    public static boolean hierarchyContains(ITypeHierarchy h, String fqn) {
        IType[] iTypeArray = h.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (fqn.equals(t.getFullyQualifiedName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IType writeType(IPackageFragmentRoot srcFolder, ICompilationUnitSourceBuilder sb, IJavaEnvironment env, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        CompilationUnitWriteOperation writeIcu = new CompilationUnitWriteOperation(srcFolder, sb, env);
        writeIcu.validate();
        writeIcu.run((IProgressMonitor)Validate.notNull((Object)monitor), (IWorkingCopyManager)Validate.notNull((Object)workingCopyManager));
        ICompilationUnit compilationUnit = writeIcu.getCreatedCompilationUnit();
        return compilationUnit.getType(sb.getMainType().getElementName());
    }

    public static IPackageFragmentRoot getTestSourceFolder(IJavaProject orig, String fqnOfRequiredType) throws JavaModelException {
        IPackageFragmentRoot sourceFolder = S2eUtils.getTestSourceFolderInProject(orig, fqnOfRequiredType);
        if (S2eUtils.exists((IJavaElement)sourceFolder)) {
            return sourceFolder;
        }
        String[] testProjectSuffixes = new String[]{".test", ".tests", ".testing"};
        IJavaModel javaModel = orig.getJavaModel();
        String[] stringArray = testProjectSuffixes;
        int n = testProjectSuffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            IJavaProject testProject = javaModel.getJavaProject(String.valueOf(orig.getElementName()) + suffix);
            sourceFolder = S2eUtils.getTestSourceFolderInProject(testProject, fqnOfRequiredType);
            if (S2eUtils.exists((IJavaElement)sourceFolder)) {
                return sourceFolder;
            }
            ++n2;
        }
        return null;
    }

    private static IPackageFragmentRoot getTestSourceFolderInProject(IJavaProject project, String fqnOfRequiredType) throws JavaModelException {
        if (!S2eUtils.exists((IJavaElement)project)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)fqnOfRequiredType) && !S2eUtils.exists((IJavaElement)project.findType(fqnOfRequiredType))) {
            return null;
        }
        Predicate<IPackageFragmentRoot> filter = new Predicate<IPackageFragmentRoot>(){

            @Override
            public boolean test(IPackageFragmentRoot element) {
                String s = element.getPath().removeFirstSegments(1).toString().toLowerCase();
                return s.contains("test");
            }
        };
        Set<IPackageFragmentRoot> testSourceFolders = S2eUtils.getSourceFolders(Collections.singletonList(project), filter, null);
        if (!testSourceFolders.isEmpty()) {
            return testSourceFolders.iterator().next();
        }
        return null;
    }

    public static IPackageFragmentRoot getDtoSourceFolder(IPackageFragmentRoot selectedSourceFolder) {
        if (!S2eUtils.exists((IJavaElement)selectedSourceFolder)) {
            return selectedSourceFolder;
        }
        IJavaProject targetProject = selectedSourceFolder.getJavaProject();
        if (!S2eUtils.exists((IJavaElement)targetProject)) {
            return selectedSourceFolder;
        }
        IFolder generatedFolder = targetProject.getProject().getFolder("src/generated/java");
        if (generatedFolder == null || !generatedFolder.exists()) {
            return selectedSourceFolder;
        }
        IPackageFragmentRoot generatedSourceFolder = targetProject.getPackageFragmentRoot((IResource)generatedFolder);
        if (!S2eUtils.exists((IJavaElement)generatedSourceFolder)) {
            return selectedSourceFolder;
        }
        return generatedSourceFolder;
    }

    public static IType getSession(IJavaProject project, ScoutTier tier, IProgressMonitor monitor) throws CoreException {
        PublicPrimaryTypeFilter filter = new PublicPrimaryTypeFilter(){

            @Override
            public boolean test(IType candidate) {
                if (!super.test(candidate)) {
                    return false;
                }
                try {
                    return candidate.isClass();
                }
                catch (JavaModelException e) {
                    throw new SdkException("Unable to check for flags in type '" + candidate.getFullyQualifiedName() + "'.", (Throwable)e);
                }
            }
        };
        String sessionToFind = null;
        switch (tier) {
            case Server: {
                sessionToFind = "org.eclipse.scout.rt.server.IServerSession";
                break;
            }
            case Client: 
            case HtmlUi: {
                sessionToFind = "org.eclipse.scout.rt.client.IClientSession";
                break;
            }
            default: {
                sessionToFind = "org.eclipse.scout.rt.shared.ISession";
            }
        }
        Set<IType> sessions = S2eUtils.findClassesInStrictHierarchy(project, sessionToFind, monitor, (Predicate<IType>)filter);
        if (sessions.isEmpty()) {
            return null;
        }
        return sessions.iterator().next();
    }

    public static String getContentOfFile(IFile file) throws CoreException {
        if (file == null || !file.exists()) {
            return null;
        }
        String charsetName = file.getCharset();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream contents = file.getContents();){
                return CoreUtils.inputStreamToString((InputStream)contents, (String)charsetName).toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new ScoutStatus("Unable to read file '" + file.getFullPath().toOSString() + "'.", e));
        }
    }

    public static Document getPomDocument(IProject p) throws CoreException {
        IFile pom = p.getFile("pom.xml");
        return S2eUtils.readXmlDocument(pom);
    }

    public static Document readXmlDocument(IFile file) throws CoreException {
        if (!file.exists()) {
            return null;
        }
        try {
            DocumentBuilder docBuilder = CoreUtils.createDocumentBuilder();
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = file.getContents();){
                return docBuilder.parse(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | CoreException | SAXException e) {
            throw new CoreException((IStatus)new ScoutStatus(e));
        }
    }

    public static void writeXmlDocument(Document document, IFile file, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        try {
            ResourceWriteOperation writeOp = new ResourceWriteOperation(file, CoreUtils.xmlDocumentToString((Document)document, (boolean)true));
            writeOp.validate();
            writeOp.run(monitor, workingCopyManager);
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new ScoutStatus(e));
        }
    }

    public static Map<String, IStatus> mavenUpdate(Set<IProject> projects, boolean updateSnapshots, boolean updateConfig, boolean cleanProject, boolean refreshFromDisk, IProgressMonitor monitor) {
        if (projects == null || projects.isEmpty()) {
            return Collections.emptyMap();
        }
        MavenPluginActivator mavenPlugin = MavenPluginActivator.getDefault();
        if (mavenPlugin == null) {
            return Collections.emptyMap();
        }
        ProjectConfigurationManager configurationManager = (ProjectConfigurationManager)mavenPlugin.getProjectConfigurationManager();
        if (configurationManager == null) {
            return Collections.emptyMap();
        }
        MavenUpdateRequest request = new MavenUpdateRequest(projects.toArray(new IProject[projects.size()]), false, updateSnapshots);
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptyMap();
        }
        Map result = configurationManager.updateProjectConfiguration(request, updateConfig, cleanProject, refreshFromDisk, monitor);
        return result;
    }

    public static final class ElementNameComparator
    implements Comparator<IType>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(IType o1, IType o2) {
            if (o1 == o2) {
                return 0;
            }
            int res = o1.getElementName().compareTo(o2.getElementName());
            if (res != 0) {
                return res;
            }
            res = o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
            if (res != 0) {
                return res;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    private static final class P_TypeMatchComparator
    implements Comparator<IType>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private P_TypeMatchComparator() {
        }

        @Override
        public int compare(IType o1, IType o2) {
            boolean b2;
            if (o1 == o2) {
                return 0;
            }
            boolean b1 = o1.isBinary();
            if (b1 != (b2 = o2.isBinary())) {
                if (b1) {
                    return 1;
                }
                return -1;
            }
            String path1 = P_TypeMatchComparator.buildPath(o1);
            String path2 = P_TypeMatchComparator.buildPath(o2);
            return path2.compareTo(path1);
        }

        private static String buildPath(IType t) {
            String fqn = t.getFullyQualifiedName();
            String portableString = t.getPath().toPortableString();
            StringBuilder sb = new StringBuilder(fqn.length() + portableString.length());
            sb.append(fqn);
            sb.append(portableString);
            return sb.toString();
        }
    }

    public static class PublicAbstractPrimaryTypeFilter
    extends PublicPrimaryTypeFilter {
        @Override
        public boolean test(IType candidate) {
            boolean accept = super.test(candidate);
            if (!accept) {
                return false;
            }
            try {
                int modifiers = candidate.getFlags();
                return Flags.isAbstract((int)modifiers) && !Flags.isInterface((int)modifiers);
            }
            catch (JavaModelException e) {
                throw new SdkException((Throwable)e);
            }
        }
    }

    public static class PublicPrimaryTypeFilter
    implements Predicate<IType> {
        @Override
        public boolean test(IType candidate) {
            block3: {
                try {
                    if (!candidate.isMember() && !candidate.isAnonymous() && !candidate.isEnum() && !candidate.isLocal()) break block3;
                    return false;
                }
                catch (JavaModelException e) {
                    throw new SdkException((Throwable)e);
                }
            }
            int modifiers = candidate.getFlags();
            return Flags.isPublic((int)modifiers) && !Flags.isDeprecated((int)modifiers);
        }
    }
}

