/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.s2e.ui.internal.editor.jaxws.WebServiceEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ErrorFormPage
extends FormPage {
    private final Throwable m_throwable;
    private final String m_message;

    public ErrorFormPage(FormEditor editor, String message, Throwable throwable) {
        super(editor, "ErrorFormPage", "Error");
        this.m_message = message;
        this.m_throwable = throwable;
    }

    public WebServiceEditor getEditor() {
        return (WebServiceEditor)super.getEditor();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        StringBuilder msgBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.m_message)) {
            msgBuilder.append(this.m_message).append("\n");
        }
        if (this.m_throwable != null) {
            msgBuilder.append(CoreUtils.getThrowableAsString((Throwable)this.m_throwable));
        }
        Text text = toolkit.createText(parent, msgBuilder.toString(), 2);
        text.setEditable(false);
        GridLayoutFactory.swtDefaults().applyTo(parent);
        GridDataFactory.defaultsFor((Control)text).align(4, 0x1000000).grab(true, false).applyTo((Control)text);
    }
}

