/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.jaxws;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.s.jaxws.ParsedWsdl;
import org.eclipse.scout.sdk.core.s.sourcebuilder.jaxws.EntryPointDefinitionSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.jaxws.WebServiceClientSourceBuilder;
import org.eclipse.scout.sdk.core.s.sourcebuilder.jaxws.WebServiceProviderSourceBuilder;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.ScoutSdkCore;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.ResourceWriteOperation;
import org.eclipse.scout.sdk.s2e.operation.jaxws.JaxWsModuleNewOperation;
import org.eclipse.scout.sdk.s2e.operation.jaxws.RebuildArtifactsOperation;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ScoutStatus;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WebServiceNewOperation
implements IOperation {
    private boolean m_isCreateNewModule;
    private boolean m_isCreateConsumer;
    private boolean m_isCreateEmptyWsdl;
    private IJavaProject m_serverModule;
    private String m_artifactId;
    private String m_package;
    private IJavaProject m_jaxWsProject;
    private URL m_wsdlUrl;
    private String m_wsdlName;
    private IFile m_createdWsdlFile;
    private IFile m_createdJaxbBindingFile;
    private final List<IFile> m_createdJaxwsBindingFiles;
    private final List<IType> m_createdWebServiceClients = new ArrayList<IType>(2);
    private final List<IType> m_createdEntryPointDefinitions = new ArrayList<IType>(this.m_createdWebServiceClients.size());
    private final List<IType> m_createdProviderServiceImpls = new ArrayList<IType>(this.m_createdWebServiceClients.size());
    private final List<String> m_createdUrlProperties = new ArrayList<String>(this.m_createdWebServiceClients.size());
    private String m_wsdlContent;
    private ParsedWsdl m_parsedWsdl;

    public WebServiceNewOperation() {
        this.m_createdJaxwsBindingFiles = new ArrayList<IFile>(this.m_createdWebServiceClients.size());
    }

    @Override
    public String getOperationName() {
        return "Create new Web Service";
    }

    @Override
    public void validate() {
        if (this.isCreateNewModule()) {
            Validate.notNull((Object)this.getServerModule(), (String)"Target module pom file must be specified when creating a new jaxws module.", (Object[])new Object[0]);
            Validate.isTrue((boolean)this.getServerModule().exists(), (String)"Target module pom file could not be found.", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getArtifactId()), (String)"ArtifactId cannot be empty when creating a new jaxws module.", (Object[])new Object[0]);
        } else {
            Validate.notNull((Object)this.getJaxWsProject(), (String)"JaxWs project must be specified.", (Object[])new Object[0]);
            Validate.isTrue((boolean)this.getJaxWsProject().exists(), (String)"JaxWs project does not exist.", (Object[])new Object[0]);
        }
        if (this.isCreateEmptyWsdl()) {
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getWsdlName()), (String)"WSDL name cannot be empty when creating an empty WSDL.", (Object[])new Object[0]);
        } else {
            Validate.notNull((Object)this.getWsdlUrl(), (String)"WSDL URL cannot be null.", (Object[])new Object[0]);
        }
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.getPackage()), (String)"Target package cannot be empty.", (Object[])new Object[0]);
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getOperationName(), (int)100);
        if (progress.isCanceled()) {
            return;
        }
        if (this.isCreateNewModule()) {
            this.setJaxWsProject(this.createNewJaxWsModule((IProgressMonitor)progress.newChild(39), workingCopyManager));
        }
        progress.setWorkRemaining(61);
        this.getJaxWsProject().getProject().refreshLocal(2, (IProgressMonitor)progress.newChild(1));
        String lineDelimiter = S2eUtils.lineSeparator(this.getJaxWsProject());
        if (progress.isCanceled()) {
            return;
        }
        String wsdlBaseName = this.getWsdlBaseName();
        if (this.isCreateEmptyWsdl()) {
            this.setWsdlContent(JaxWsUtils.getEmptyWsdl((String)wsdlBaseName, (String)this.getPackage(), (String)lineDelimiter).toString());
        } else {
            this.setWsdlContent(this.readXmlFromUrl(this.getWsdlUrl()));
        }
        this.setParsedWsdl(this.parseWsdl(this.getWsdlBaseUri(wsdlBaseName)));
        if (this.getParsedWsdl().isEmpty()) {
            SdkLog.warning((String)"No service or port found in WSDL: Generation of web service aborted.", (Object[])new Object[0]);
            return;
        }
        progress.worked(10);
        if (progress.isCanceled()) {
            return;
        }
        IFolder bindingFolder = WebServiceNewOperation.getBindingFolder(this.getJaxWsProject(), wsdlBaseName);
        this.setCreatedWsdlFile(this.writeWsdlToProject(wsdlBaseName, (IProgressMonitor)progress.newChild(2), workingCopyManager));
        this.copyReferencedResources(wsdlBaseName, (IProgressMonitor)progress.newChild(1), workingCopyManager);
        this.setParsedWsdl(this.parseWsdl(this.getTargetWsdlFileUri(wsdlBaseName)));
        this.setCreatedJaxbBindingFile(this.createJaxbBinding(bindingFolder, lineDelimiter, (IProgressMonitor)progress.newChild(1), workingCopyManager));
        this.createJaxwsBindings(bindingFolder, lineDelimiter, (IProgressMonitor)progress.newChild(2), workingCopyManager);
        IPath wsdlFolderRelativePath = this.getCreatedWsdlFile().getProjectRelativePath().makeRelativeTo(WebServiceNewOperation.getWsdlRootFolder(this.getJaxWsProject().getProject()).getProjectRelativePath());
        this.addWsdlToPom(wsdlFolderRelativePath.toString(), bindingFolder.getName(), (IProgressMonitor)progress.newChild(2), workingCopyManager);
        if (this.isCreateConsumer()) {
            this.createDerivedResources((IProgressMonitor)progress.newChild(30), workingCopyManager);
            this.createWebServiceClients((IProgressMonitor)progress.newChild(10), workingCopyManager);
        } else {
            this.enableApt(lineDelimiter, (IProgressMonitor)progress.newChild(2), workingCopyManager);
            this.createEntryPointDefinitions((IProgressMonitor)progress.newChild(4), workingCopyManager);
            this.createDerivedResources((IProgressMonitor)progress.newChild(30), workingCopyManager);
            this.createProviderServiceImplementations((IProgressMonitor)progress.newChild(4), workingCopyManager);
        }
        if (this.isCreateNewModule()) {
            this.setIgnoreOptionalProblems("target/generated-sources/wsimport", (IProgressMonitor)progress.newChild(2));
        } else {
            S2eUtils.mavenUpdate(Collections.singleton(this.getJaxWsProject().getProject()), false, true, false, false, (IProgressMonitor)progress.newChild(2));
        }
    }

    protected void setIgnoreOptionalProblems(String entryPath, IProgressMonitor monitor) throws JavaModelException {
        IJavaProject jaxWsProject = this.getJaxWsProject();
        IClasspathEntry[] rawClasspathEntries = jaxWsProject.getRawClasspath();
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(rawClasspathEntries.length);
        Path entryPathToSearch = new Path(String.valueOf('/') + jaxWsProject.getElementName() + '/' + entryPath);
        IClasspathEntry[] iClasspathEntryArray = rawClasspathEntries;
        int n = rawClasspathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry.getPath().equals((Object)entryPathToSearch)) {
                IClasspathAttribute[] origAttributes = entry.getExtraAttributes();
                ArrayList<IClasspathAttribute> newAttributes = new ArrayList<IClasspathAttribute>(origAttributes.length + 1);
                IClasspathAttribute[] iClasspathAttributeArray = origAttributes;
                int n3 = origAttributes.length;
                int n4 = 0;
                while (n4 < n3) {
                    IClasspathAttribute attrib = iClasspathAttributeArray[n4];
                    if (!"ignore_optional_problems".equals(attrib.getName())) {
                        newAttributes.add(attrib);
                    }
                    ++n4;
                }
                newAttributes.add(JavaCore.newClasspathAttribute((String)"ignore_optional_problems", (String)Boolean.TRUE.toString()));
                newEntries.add(JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])entry.getInclusionPatterns(), (IPath[])entry.getExclusionPatterns(), (IPath)entry.getOutputLocation(), (IClasspathAttribute[])newAttributes.toArray(new IClasspathAttribute[newAttributes.size()])));
            } else {
                newEntries.add(entry);
            }
            ++n2;
        }
        jaxWsProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), monitor);
    }

    protected String getWsdlBaseName() {
        String wsdlFileName = this.getWsdlFileName();
        wsdlFileName = wsdlFileName.substring(0, wsdlFileName.length() - ".wsdl".length());
        return JaxWsUtils.removeCommonSuffixes((String)wsdlFileName);
    }

    protected void createDerivedResources(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        RebuildArtifactsOperation op = new RebuildArtifactsOperation();
        op.setJavaProject(this.getJaxWsProject());
        op.validate();
        op.run(monitor, workingCopyManager);
    }

    protected IJavaEnvironment createNewEnv() {
        return ScoutSdkCore.createJavaEnvironment(this.getJaxWsProject());
    }

    protected void createProviderServiceImplementations(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws JavaModelException {
        IJavaEnvironment env = this.createNewEnv();
        for (Map.Entry service : this.getParsedWsdl().getServiceNames().entrySet()) {
            ParsedWsdl.WebServiceNames names = (ParsedWsdl.WebServiceNames)service.getValue();
            Set portTypes = this.getParsedWsdl().getPortTypes((Service)service.getKey());
            for (PortType pt : portTypes) {
                String portTypeName = pt.getQName().getLocalPart();
                WebServiceProviderSourceBuilder wspsb = new WebServiceProviderSourceBuilder(names.getWebServiceProviderImplClassName(portTypeName), this.getPackage(), env);
                wspsb.setPortTypeSignature(Signature.createTypeSignature((String)(String.valueOf(this.getPackage()) + '.' + names.getPortTypeClassName(portTypeName))));
                wspsb.setup();
                this.m_createdProviderServiceImpls.add(S2eUtils.writeType(S2eUtils.getPrimarySourceFolder(this.getJaxWsProject()), (ICompilationUnitSourceBuilder)wspsb, env, monitor, workingCopyManager));
            }
        }
    }

    protected void createEntryPointDefinitions(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws JavaModelException {
        IJavaEnvironment env = this.createNewEnv();
        for (Map.Entry service : this.getParsedWsdl().getServiceNames().entrySet()) {
            ParsedWsdl.WebServiceNames names = (ParsedWsdl.WebServiceNames)service.getValue();
            Set portTypes = this.getParsedWsdl().getPortTypes((Service)service.getKey());
            for (PortType pt : portTypes) {
                String portTypeName = pt.getQName().getLocalPart();
                EntryPointDefinitionSourceBuilder epdsb = new EntryPointDefinitionSourceBuilder(names.getEntryPointDefinitionClassName(portTypeName), this.getPackage(), env);
                epdsb.setPortTypeFqn(String.valueOf(this.getPackage()) + '.' + names.getPortTypeClassName(portTypeName));
                epdsb.setEntryPointPackage(this.getPackage());
                epdsb.setEntryPointName(names.getEntryPointClassName(portTypeName));
                epdsb.setPortName(this.getParsedWsdl().getPortName((Service)service.getKey(), pt));
                epdsb.setServiceName(names.getWebServiceNameFromWsdl());
                epdsb.setup();
                this.m_createdEntryPointDefinitions.add(S2eUtils.writeType(S2eUtils.getPrimarySourceFolder(this.getJaxWsProject()), (ICompilationUnitSourceBuilder)epdsb, env, monitor, workingCopyManager));
            }
        }
    }

    protected void createWebServiceClients(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IJavaEnvironment env = this.createNewEnv();
        for (Map.Entry service : this.getParsedWsdl().getServiceNames().entrySet()) {
            ParsedWsdl.WebServiceNames names = (ParsedWsdl.WebServiceNames)service.getValue();
            Set portTypes = this.getParsedWsdl().getPortTypes((Service)service.getKey());
            for (PortType pt : portTypes) {
                String portTypeName = pt.getQName().getLocalPart();
                WebServiceClientSourceBuilder wscsb = new WebServiceClientSourceBuilder(names.getWebServiceClientClassName(portTypeName), this.getPackage(), env);
                wscsb.setPortTypeSignature(Signature.createTypeSignature((String)(String.valueOf(this.getPackage()) + '.' + names.getPortTypeClassName(portTypeName))));
                wscsb.setServiceSignature(Signature.createTypeSignature((String)(String.valueOf(this.getPackage()) + '.' + names.getWebServiceClassName())));
                wscsb.setup();
                this.m_createdWebServiceClients.add(S2eUtils.writeType(S2eUtils.getPrimarySourceFolder(this.getJaxWsProject()), (ICompilationUnitSourceBuilder)wscsb, env, monitor, workingCopyManager));
                this.m_createdUrlProperties.add(wscsb.getUrlPropertyName());
            }
        }
    }

    protected void enableApt(String lineDelimiter, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        this.getJaxWsProject().setOption("org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        IEclipsePreferences aptUiPluginPreferenceNode = new ProjectScope(this.getJaxWsProject().getProject()).getNode("org.eclipse.jdt.apt.core");
        aptUiPluginPreferenceNode.putBoolean("org.eclipse.jdt.apt.aptEnabled", true);
        aptUiPluginPreferenceNode.put("org.eclipse.jdt.apt.genSrcDir", "target/generated-sources/annotations");
        aptUiPluginPreferenceNode.putBoolean("org.eclipse.jdt.apt.reconcileEnabled", true);
        try {
            aptUiPluginPreferenceNode.flush();
        }
        catch (BackingStoreException e) {
            SdkLog.info((String)"Unable to save the APT preferences of project '{}'.", (Object[])new Object[]{this.getJaxWsProject().getElementName(), e});
        }
        this.createFactoryPath(lineDelimiter, monitor, workingCopyManager);
    }

    protected void createFactoryPath(String lineDelimiter, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IFile factoryPathFile = this.getJaxWsProject().getProject().getFile(".factorypath");
        if (factoryPathFile.exists()) {
            return;
        }
        String scoutVersion = "7.0.0.001_M7";
        StringBuilder factoryPathBuilder = new StringBuilder();
        factoryPathBuilder.append("<factorypath>").append(lineDelimiter);
        factoryPathBuilder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/org/eclipse/scout/rt/org.eclipse.scout.jaxws.apt/").append(scoutVersion).append("/org.eclipse.scout.jaxws.apt-").append(scoutVersion).append(".jar\" enabled=\"true\" runInBatchMode=\"false\"/>").append(lineDelimiter);
        factoryPathBuilder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/com/unquietcode/tools/jcodemodel/codemodel/1.0.3/codemodel-1.0.3.jar\" enabled=\"true\" runInBatchMode=\"false\"/>").append(lineDelimiter);
        factoryPathBuilder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/org/eclipse/scout/rt/org.eclipse.scout.rt.platform/").append(scoutVersion).append("/org.eclipse.scout.rt.platform-").append(scoutVersion).append(".jar\" enabled=\"true\" runInBatchMode=\"false\"/>").append(lineDelimiter);
        factoryPathBuilder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/org/eclipse/scout/rt/org.eclipse.scout.rt.server.jaxws/").append(scoutVersion).append("/org.eclipse.scout.rt.server.jaxws-").append(scoutVersion).append(".jar\" enabled=\"true\" runInBatchMode=\"false\"/>").append(lineDelimiter);
        factoryPathBuilder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/javax/servlet/javax.servlet-api/3.1.0/javax.servlet-api-3.1.0.jar\" enabled=\"true\" runInBatchMode=\"false\"/>").append(lineDelimiter);
        factoryPathBuilder.append("  <factorypathentry kind=\"VARJAR\" id=\"M2_REPO/org/slf4j/slf4j-api/1.7.12/slf4j-api-1.7.12.jar\" enabled=\"true\" runInBatchMode=\"false\"/>").append(lineDelimiter);
        factoryPathBuilder.append("</factorypath>").append(lineDelimiter);
        ResourceWriteOperation writeFactoryPath = new ResourceWriteOperation(factoryPathFile, factoryPathBuilder.toString());
        writeFactoryPath.validate();
        writeFactoryPath.run(monitor, workingCopyManager);
    }

    protected void copyReferencedResources(String baseName, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        for (Map.Entry resource : this.getParsedWsdl().getReferencedResources().entrySet()) {
            URI sourceUri = (URI)resource.getKey();
            if (((String)resource.getValue()).equals(((URI)resource.getKey()).toString())) continue;
            String relPath = (String)resource.getValue();
            IFolder wsdlFolder = this.getWsdlFolder(baseName);
            IFile target = wsdlFolder.getFile(relPath);
            try {
                String content = this.readXmlFromUrl(sourceUri.toURL());
                ResourceWriteOperation writeWsdl = new ResourceWriteOperation(target, content);
                writeWsdl.validate();
                writeWsdl.run(monitor, workingCopyManager);
            }
            catch (MalformedURLException e) {
                throw new CoreException((IStatus)new ScoutStatus(e));
            }
        }
    }

    protected ParsedWsdl parseWsdl(URI documentBase) throws CoreException {
        try {
            return ParsedWsdl.create((URI)documentBase, (String)this.getWsdlContent());
        }
        catch (UnsupportedEncodingException | WSDLException e) {
            throw new CoreException((IStatus)new ScoutStatus("Unable to parse WSDL.", e));
        }
    }

    protected URI getWsdlBaseUri(String baseName) throws CoreException {
        URL wsdlUrl = this.getWsdlUrl();
        if (wsdlUrl == null) {
            return this.getTargetWsdlFileUri(baseName);
        }
        try {
            return wsdlUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new ScoutStatus(e));
        }
    }

    protected IFolder getWsdlFolder(String wsBaseName) {
        String wsdlFolderName = wsBaseName.toLowerCase();
        return WebServiceNewOperation.getWsdlRootFolder(this.getJaxWsProject().getProject()).getFolder(wsdlFolderName);
    }

    protected URI getTargetWsdlFileUri(String baseName) {
        IFolder wsdlFolder = this.getWsdlFolder(baseName);
        IFile wsdlFile = wsdlFolder.getFile(this.getWsdlFileName());
        return wsdlFile.getLocation().toFile().toURI();
    }

    protected void addWsdlToPom(String wsdlFilePath, String bindingFolderName, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IFile pom = this.getJaxWsProject().getProject().getFile("pom.xml");
        if (!pom.exists()) {
            return;
        }
        ArrayList<String> bindingFileNames = new ArrayList<String>(this.getCreatedJaxwsBindingFiles().size() + 1);
        for (IFile createdJaxWsBinding : this.getCreatedJaxwsBindingFiles()) {
            bindingFileNames.add(createdJaxWsBinding.getName());
        }
        bindingFileNames.add(this.getCreatedJaxbBindingFile().getName());
        Document document = S2eUtils.readXmlDocument(pom);
        JaxWsUtils.addWsdlToPom((Document)document, (String)wsdlFilePath, (String)bindingFolderName, bindingFileNames);
        S2eUtils.writeXmlDocument(document, pom, monitor, workingCopyManager);
    }

    protected static IFolder getBindingFolder(IJavaProject jaxWsProject, String wsBaseName) {
        String bindingFolderName = wsBaseName.toLowerCase();
        return WebServiceNewOperation.getBindingRootFolder(jaxWsProject.getProject()).getFolder(bindingFolderName);
    }

    protected void createJaxwsBindings(IFolder wsdlBindingsFolder, String lineDelimiter, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        URI parent = wsdlBindingsFolder.getLocation().toFile().toURI();
        Map jaxwsBindingContents = JaxWsUtils.getJaxwsBindingContents((ParsedWsdl)this.getParsedWsdl(), (URI)parent, (String)lineDelimiter, (String)this.getPackage());
        for (Map.Entry binding : jaxwsBindingContents.entrySet()) {
            IFile jaxwsBindingXmlFile = null;
            if (jaxwsBindingContents.size() == 1) {
                jaxwsBindingXmlFile = wsdlBindingsFolder.getFile("jaxws-binding.xml");
            } else {
                java.nio.file.Path pathFileName = ((java.nio.file.Path)binding.getKey()).getFileName();
                if (pathFileName == null) {
                    throw new IllegalArgumentException("zero length path found.");
                }
                String partName = pathFileName.toString().toLowerCase();
                if (partName.endsWith(".wsdl")) {
                    partName = partName.substring(0, partName.length() - ".wsdl".length());
                }
                int lastDotPos = "jaxws-binding.xml".lastIndexOf(46);
                StringBuilder fileName = new StringBuilder();
                fileName.append("jaxws-binding.xml".substring(0, lastDotPos));
                fileName.append('-').append(partName).append("jaxws-binding.xml".substring(lastDotPos));
                jaxwsBindingXmlFile = wsdlBindingsFolder.getFile(fileName.toString());
            }
            ResourceWriteOperation writeJaxwsBinding = new ResourceWriteOperation(jaxwsBindingXmlFile, ((StringBuilder)binding.getValue()).toString());
            writeJaxwsBinding.validate();
            writeJaxwsBinding.run(monitor, workingCopyManager);
            this.m_createdJaxwsBindingFiles.add(jaxwsBindingXmlFile);
        }
    }

    protected IFile createJaxbBinding(IFolder wsdlBindingsFolder, String lineDelimiter, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IFile jaxbBindingXmlFile = wsdlBindingsFolder.getFile("jaxb-binding.xml");
        ResourceWriteOperation writJaxbBinding = new ResourceWriteOperation(jaxbBindingXmlFile, JaxWsUtils.getJaxbBindingContent((String)lineDelimiter).toString());
        writJaxbBinding.validate();
        writJaxbBinding.run(monitor, workingCopyManager);
        return jaxbBindingXmlFile;
    }

    protected String getWsdlFileName() {
        String wsdlFileName = null;
        URL wsdlUrl = this.getWsdlUrl();
        if (wsdlUrl != null) {
            wsdlFileName = wsdlUrl.getPath();
            int lastSlashPos = wsdlFileName.lastIndexOf(47);
            int lastDotPos = wsdlFileName.lastIndexOf(46);
            if (lastDotPos < lastSlashPos) {
                lastDotPos = wsdlFileName.length();
            }
            wsdlFileName = wsdlFileName.substring(lastSlashPos + 1, lastDotPos);
        } else {
            wsdlFileName = this.getWsdlName();
            if (wsdlFileName.endsWith("WebService")) {
                wsdlFileName = wsdlFileName.substring(0, wsdlFileName.length() - "WebService".length());
            }
        }
        wsdlFileName = String.valueOf(wsdlFileName) + ".wsdl";
        return wsdlFileName;
    }

    protected IFile writeWsdlToProject(String baseName, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IFolder wsdlFolder = this.getWsdlFolder(baseName);
        IFile wsdlFile = wsdlFolder.getFile(this.getWsdlFileName());
        ResourceWriteOperation writeWsdl = new ResourceWriteOperation(wsdlFile, this.getWsdlContent());
        writeWsdl.validate();
        writeWsdl.run(monitor, workingCopyManager);
        return wsdlFile;
    }

    protected String readXmlFromUrl(URL url) throws CoreException {
        try {
            DocumentBuilder docBuilder = CoreUtils.createDocumentBuilder();
            Document xmlDoc = null;
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream in = url.openStream();){
                xmlDoc = docBuilder.parse(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return CoreUtils.xmlDocumentToString((Document)xmlDoc, (boolean)false);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new CoreException((IStatus)new ScoutStatus(e));
        }
    }

    protected IJavaProject createNewJaxWsModule(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        JaxWsModuleNewOperation op = new JaxWsModuleNewOperation();
        op.setArtifactId(this.getArtifactId());
        op.setServerModule(this.getServerModule());
        op.validate();
        op.run(monitor, workingCopyManager);
        return JavaCore.create((IProject)op.getCreatedProject());
    }

    public static IFolder getBindingRootFolder(IProject jaxWsProject) {
        return WebServiceNewOperation.getWebInfFolder(jaxWsProject).getFolder("binding");
    }

    public static IFolder getWsdlRootFolder(IProject jaxWsProject) {
        return WebServiceNewOperation.getWebInfFolder(jaxWsProject).getFolder("wsdl");
    }

    public static IFolder getWebInfFolder(IProject jaxWsProject) {
        return jaxWsProject.getFolder("src/main/resources/WEB-INF");
    }

    public boolean isCreateNewModule() {
        return this.m_isCreateNewModule;
    }

    public void setCreateNewModule(boolean isCreateNewModule) {
        this.m_isCreateNewModule = isCreateNewModule;
    }

    public IJavaProject getServerModule() {
        return this.m_serverModule;
    }

    public void setServerModule(IJavaProject targetModule) {
        this.m_serverModule = targetModule;
    }

    public String getArtifactId() {
        return this.m_artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.m_artifactId = artifactId;
    }

    public IJavaProject getJaxWsProject() {
        return this.m_jaxWsProject;
    }

    public void setJaxWsProject(IJavaProject jaxWsProject) {
        this.m_jaxWsProject = jaxWsProject;
    }

    public URL getWsdlUrl() {
        return this.m_wsdlUrl;
    }

    public void setWsdlUrl(URL wsdlUrl) {
        this.m_wsdlUrl = wsdlUrl;
    }

    public IFile getCreatedWsdlFile() {
        return this.m_createdWsdlFile;
    }

    protected void setCreatedWsdlFile(IFile createdWsdlFile) {
        this.m_createdWsdlFile = createdWsdlFile;
    }

    public IFile getCreatedJaxbBindingFile() {
        return this.m_createdJaxbBindingFile;
    }

    protected void setCreatedJaxbBindingFile(IFile createdJaxbBindingFile) {
        this.m_createdJaxbBindingFile = createdJaxbBindingFile;
    }

    public List<IFile> getCreatedJaxwsBindingFiles() {
        return Collections.unmodifiableList(this.m_createdJaxwsBindingFiles);
    }

    public String getWsdlContent() {
        return this.m_wsdlContent;
    }

    protected void setWsdlContent(String wsdlContent) {
        this.m_wsdlContent = wsdlContent;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String targetPackage) {
        this.m_package = targetPackage;
    }

    public List<IType> getCreatedWebServiceClients() {
        return Collections.unmodifiableList(this.m_createdWebServiceClients);
    }

    public boolean isCreateConsumer() {
        return this.m_isCreateConsumer;
    }

    public void setCreateConsumer(boolean isCreateConsumer) {
        this.m_isCreateConsumer = isCreateConsumer;
    }

    public boolean isCreateEmptyWsdl() {
        return this.m_isCreateEmptyWsdl;
    }

    public void setCreateEmptyWsdl(boolean isCreateEmptyWsdl) {
        this.m_isCreateEmptyWsdl = isCreateEmptyWsdl;
    }

    public String getWsdlName() {
        return this.m_wsdlName;
    }

    public void setWsdlName(String wsdlName) {
        this.m_wsdlName = wsdlName;
    }

    public List<IType> getCreatedEntryPointDefinitions() {
        return Collections.unmodifiableList(this.m_createdEntryPointDefinitions);
    }

    public List<IType> getCreatedProviderServiceImpls() {
        return Collections.unmodifiableList(this.m_createdProviderServiceImpls);
    }

    public List<String> getCreatedUrlProperties() {
        return Collections.unmodifiableList(this.m_createdUrlProperties);
    }

    public ParsedWsdl getParsedWsdl() {
        return this.m_parsedWsdl;
    }

    protected void setParsedWsdl(ParsedWsdl parsedWsdl) {
        this.m_parsedWsdl = parsedWsdl;
    }
}

