/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.util.ast;

import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstTypeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.ILinkedPositionHolder;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;

public class AstCodeBuilder
extends AstTypeBuilder<AstCodeBuilder> {
    public static final String ID_FIELD_NAME = "ID";
    public static final Set<String> PROPOSAL_CODE_DATA_TYPES = Collections.synchronizedSortedSet(new TreeSet());

    static {
        PROPOSAL_CODE_DATA_TYPES.add("java.lang.Long");
        PROPOSAL_CODE_DATA_TYPES.add("java.lang.Integer");
        PROPOSAL_CODE_DATA_TYPES.add("java.lang.String");
        PROPOSAL_CODE_DATA_TYPES.add("java.lang.Boolean");
        PROPOSAL_CODE_DATA_TYPES.add("java.math.BigDecimal");
    }

    protected AstCodeBuilder(AstNodeFactory owner) {
        super(owner);
    }

    @Override
    public AstCodeBuilder insert() {
        String genericFromCodeTypeFqn = this.parseCodeIdTypeFromCodeType();
        Type genericFromCodeType = this.getFactory().newTypeReference(genericFromCodeTypeFqn);
        this.applyTypeArgToSuperType(genericFromCodeType);
        TypeDeclaration codeType = ((AstCodeBuilder)super.insert()).get();
        codeType.bodyDeclarations().add(0, this.getFactory().newSerialVersionUid());
        codeType.bodyDeclarations().add(1, this.createId(genericFromCodeTypeFqn));
        MethodDeclaration getId = this.createGetId(genericFromCodeTypeFqn);
        codeType.bodyDeclarations().add(getId);
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            String[] proposalTypes;
            ITrackedNodePosition dataTypeTracker = this.getFactory().getRewrite().track((ASTNode)genericFromCodeType);
            links.addLinkedPosition(dataTypeTracker, true, "CODE_DATA_TYPE");
            links.addLinkedPositionProposalsHierarchy("SUPER_TYPE", "org.eclipse.scout.rt.shared.services.common.code.ICode");
            ITypeBinding typeBinding = this.getFactory().resolveTypeBinding(genericFromCodeTypeFqn);
            if (typeBinding != null) {
                links.addLinkedPositionProposal("CODE_DATA_TYPE", typeBinding);
            }
            String[] stringArray = proposalTypes = PROPOSAL_CODE_DATA_TYPES.toArray(new String[PROPOSAL_CODE_DATA_TYPES.size()]);
            int n = proposalTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String fqn = stringArray[n2];
                typeBinding = this.getFactory().resolveTypeBinding(fqn);
                if (typeBinding != null) {
                    links.addLinkedPositionProposal("CODE_DATA_TYPE", typeBinding);
                }
                ++n2;
            }
        }
        return this;
    }

    protected void applyTypeArgToSuperType(Type genericFromCodeType) {
        ParameterizedType parameterizedType = this.getFactory().getAst().newParameterizedType(this.getSuperType());
        parameterizedType.typeArguments().add(genericFromCodeType);
        this.withSuperType((Type)parameterizedType);
    }

    protected TypeDeclaration getDeclaringCodeType() {
        Deque parentTypes = AstUtils.getDeclaringTypes((TypeDeclaration)this.getDeclaringType());
        return (TypeDeclaration)parentTypes.getLast();
    }

    protected String parseCodeIdTypeFromCodeType() {
        TypeDeclaration codeType = this.getDeclaringCodeType();
        IType typeBinding = (IType)Validate.notNull((Object)AstUtils.getTypeBinding((AbstractTypeDeclaration)codeType));
        org.eclipse.scout.sdk.core.model.api.IType scoutType = S2eUtils.jdtTypeToScoutType((IType)typeBinding, (IJavaEnvironment)this.getFactory().getJavaEnvironment());
        List valueSignatures = CoreUtils.getResolvedTypeParamValue((org.eclipse.scout.sdk.core.model.api.IType)scoutType, (String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType", (int)1);
        if (valueSignatures.isEmpty()) {
            return "java.lang.Integer";
        }
        return ((org.eclipse.scout.sdk.core.model.api.IType)valueSignatures.get(0)).name();
    }

    protected FieldDeclaration createId(String codeIdTypeFqn) {
        AST ast = this.getFactory().getAst();
        Type dataType = this.calcIdDataType(codeIdTypeFqn);
        Expression initValue = this.getFactory().newDefaultValueExpression(dataType.toString(), true);
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(ID_FIELD_NAME));
        fragment.setInitializer(initValue);
        FieldDeclaration declaration = ast.newFieldDeclaration(fragment);
        declaration.setType(dataType);
        declaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        declaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        declaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            ITrackedNodePosition dataTypeTracker = this.getFactory().getRewrite().track((ASTNode)dataType);
            links.addLinkedPosition(dataTypeTracker, true, "ID_DATA_TYPE");
            ITrackedNodePosition valueTracker = this.getFactory().getRewrite().track((ASTNode)initValue);
            links.addLinkedPosition(valueTracker, true, "ID_VALUE");
        }
        return declaration;
    }

    protected Type calcIdDataType(String codeIdTypeFqn) {
        String primitive = CoreUtils.unboxToPrimitive((String)codeIdTypeFqn);
        if (primitive != null) {
            return this.getFactory().getAst().newPrimitiveType(PrimitiveType.toCode((String)primitive));
        }
        return this.getFactory().newTypeReference(codeIdTypeFqn);
    }

    protected MethodDeclaration createGetId(String codeIdTypeFqn) {
        AST ast = this.getFactory().getAst();
        ReturnStatement returnStatement = ast.newReturnStatement();
        returnStatement.setExpression((Expression)ast.newSimpleName(ID_FIELD_NAME));
        Block body = ast.newBlock();
        body.statements().add(returnStatement);
        MethodDeclaration getId = ast.newMethodDeclaration();
        getId.setConstructor(false);
        getId.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        getId.setName(ast.newSimpleName("getId"));
        Type simpleDataType = this.getFactory().newTypeReference(codeIdTypeFqn);
        getId.setReturnType2(simpleDataType);
        getId.setBody(body);
        AstUtils.addAnnotationTo((Annotation)this.getFactory().newOverrideAnnotation(), (BodyDeclaration)getId);
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            ITrackedNodePosition dataTypeTracker = this.getFactory().getRewrite().track((ASTNode)simpleDataType);
            links.addLinkedPosition(dataTypeTracker, false, "CODE_DATA_TYPE");
        }
        return getId;
    }
}

