/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.uniqueid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.uniqueid.IUniqueIdProvider;

public final class UniqueIdExtensionPoint {
    private static final String EXTENSION_POINT_NAME = "uniqueId";
    private static final String CODE_ID_PROVIDER_EXT_NAME = "uniqueIdProvider";
    private static final String ATTRIB_CLASS = "class";
    private static final String ATTRIB_PRIO = "priority";
    private static final Object CODE_ID_PROV_LOCK = new Object();
    private static volatile List<IUniqueIdProvider> uniqueIdProviderExtensions;

    private UniqueIdExtensionPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IUniqueIdProvider> getCodeIdProviderExtensions() {
        if (uniqueIdProviderExtensions == null) {
            Object object = CODE_ID_PROV_LOCK;
            synchronized (object) {
                if (uniqueIdProviderExtensions == null) {
                    TreeMap<CompositeObject, IUniqueIdProvider> providers = new TreeMap<CompositeObject, IUniqueIdProvider>();
                    IExtensionRegistry reg = RegistryFactory.getRegistry();
                    if (reg != null) {
                        IExtension[] extensions;
                        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.s2e", EXTENSION_POINT_NAME);
                        IExtension[] iExtensionArray = extensions = xp.getExtensions();
                        int n = extensions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement[] providerElememts;
                            IExtension extension = iExtensionArray[n2];
                            IConfigurationElement[] iConfigurationElementArray = providerElememts = extension.getConfigurationElements();
                            int n3 = providerElememts.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IConfigurationElement providerElememt = iConfigurationElementArray[n4];
                                if (CODE_ID_PROVIDER_EXT_NAME.equals(providerElememt.getName())) {
                                    try {
                                        IUniqueIdProvider provider = (IUniqueIdProvider)providerElememt.createExecutableExtension(ATTRIB_CLASS);
                                        providers.put(new CompositeObject(new Object[]{UniqueIdExtensionPoint.getPriority(providerElememt), provider.getClass().getName()}), provider);
                                    }
                                    catch (Exception t) {
                                        SdkLog.error((String)"Error registering code id provider '{}'.", (Object[])new Object[]{providerElememt.getNamespaceIdentifier(), t});
                                    }
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                    uniqueIdProviderExtensions = Collections.unmodifiableList(new ArrayList(providers.values()));
                }
            }
        }
        return uniqueIdProviderExtensions;
    }

    private static int getPriority(IConfigurationElement element) {
        int priority = 0;
        try {
            String prio = element.getAttribute(ATTRIB_PRIO);
            priority = Integer.MAX_VALUE - Integer.parseInt(prio);
        }
        catch (Exception e) {
            SdkLog.warning((String)"could not parse priority of {} extension '{}'.", (Object[])new Object[]{EXTENSION_POINT_NAME, element.getName(), e});
        }
        return priority;
    }

    public static String getNextUniqueId(PropertyMap context, String genericSignature) {
        for (IUniqueIdProvider p : UniqueIdExtensionPoint.getCodeIdProviderExtensions()) {
            try {
                String value = p.getNextId(context, genericSignature);
                if (value == null) continue;
                return value;
            }
            catch (Exception e) {
                SdkLog.warning((String)"Exception in codeIdExtension '{}'.", (Object[])new Object[]{p.getClass().getName(), e});
            }
        }
        return null;
    }
}

