/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.model.Language;
import org.eclipse.scout.sdk.s2e.nls.resource.ITranslationResource;
import org.eclipse.scout.sdk.s2e.nls.resource.ITranslationResourceListener;
import org.eclipse.scout.sdk.s2e.nls.resource.TranslationResourceEvent;

public abstract class AbstractTranslationResource
implements ITranslationResource {
    private Map<String, String> m_entries;
    private final Language m_language;
    private final EventListenerList m_eventListeners;

    public AbstractTranslationResource(Language language) {
        this.m_language = language;
        this.m_entries = new HashMap<String, String>();
        this.m_eventListeners = new EventListenerList();
    }

    @Override
    public void addTranslationResourceListener(ITranslationResourceListener listener) {
        this.m_eventListeners.add(ITranslationResourceListener.class, listener);
    }

    @Override
    public void removeTranslationResourceListener(ITranslationResourceListener listener) {
        this.m_eventListeners.remove(ITranslationResourceListener.class, listener);
    }

    protected void parseResource(InputStream stream) throws IOException {
        TranslationResourceEvent multiEvent = new TranslationResourceEvent(this);
        Properties prop = new Properties();
        prop.load(stream);
        Set<Map.Entry<Object, Object>> entrySet = prop.entrySet();
        HashMap<String, String> newEntries = new HashMap<String, String>(entrySet.size());
        for (Map.Entry<Object, Object> entry : entrySet) {
            String oldEntry;
            if (newEntries.get(entry.getKey()) != null) {
                SdkLog.error((String)"Doubled entry for key: {}. Skipping this entry.", (Object[])new Object[]{entry.getKey(), new Exception()});
                continue;
            }
            String key = (String)entry.getKey();
            String translation = (String)entry.getValue();
            if (translation != null) {
                newEntries.put(key, translation);
            }
            if ((oldEntry = this.m_entries.remove(key)) == null) {
                multiEvent.addEvent(new TranslationResourceEvent(this, key, translation, 1));
                continue;
            }
            if (translation == null || translation.length() < 1) {
                multiEvent.addEvent(new TranslationResourceEvent(this, key, translation, 2));
                continue;
            }
            if (oldEntry.equals(translation)) continue;
            multiEvent.addEvent(new TranslationResourceEvent(this, key, translation, 4));
        }
        for (Map.Entry<Object, Object> entry : this.m_entries.entrySet()) {
            multiEvent.addEvent(new TranslationResourceEvent(this, (String)entry.getKey(), (String)entry.getValue(), 2));
        }
        this.m_entries = newEntries;
        if (multiEvent.getSubEvents().length == 1) {
            this.fireTranslationResourceChanged(multiEvent.getSubEvents()[0]);
        } else if (multiEvent.getSubEvents().length > 1) {
            this.fireTranslationResourceChanged(multiEvent);
        }
    }

    protected Map<String, String> getAllTranslations() {
        return this.m_entries;
    }

    protected void fireTranslationResourceChanged(TranslationResourceEvent event) {
        ITranslationResourceListener[] iTranslationResourceListenerArray = (ITranslationResourceListener[])this.m_eventListeners.getListeners(ITranslationResourceListener.class);
        int n = iTranslationResourceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITranslationResourceListener listener = iTranslationResourceListenerArray[n2];
            try {
                listener.translationResourceChanged(event);
            }
            catch (Exception t) {
                SdkLog.error((String)"error during listener notification.", (Object[])new Object[]{t});
            }
            ++n2;
        }
    }

    @Override
    public boolean isDefaultLanguage() {
        return Language.LANGUAGE_DEFAULT.equals(this.m_language);
    }

    @Override
    public Language getLanguage() {
        return this.m_language;
    }

    @Override
    public Set<String> getAllKeys() {
        return new HashSet<String>(this.m_entries.keySet());
    }

    protected void setTranslation(String key, String translation, IProgressMonitor monitor) {
        this.setTranslation(key, translation, true, monitor);
    }

    protected void setTranslation(String key, String translation, boolean fireEvent, IProgressMonitor monitor) {
        TranslationResourceEvent event = null;
        String oldVal = this.m_entries.get(key);
        if (oldVal == null) {
            if (translation != null) {
                this.m_entries.put(key, translation);
                event = new TranslationResourceEvent(this, key, translation, 1);
            }
        } else if (translation == null || "".equals(translation)) {
            this.m_entries.remove(key);
            event = new TranslationResourceEvent(this, key, translation, 2);
        } else if (!oldVal.equals(translation)) {
            this.m_entries.put(key, translation);
            event = new TranslationResourceEvent(this, key, translation, 4);
        }
        if (event != null && fireEvent) {
            this.commitChanges(monitor);
            this.fireTranslationResourceChanged(event);
        }
    }

    @Override
    public String getTranslation(String key) {
        return this.m_entries.get(key);
    }

    @Override
    public void reload(IProgressMonitor monitor) {
        if (!this.isReadOnly()) {
            SdkLog.warning((String)"reload should be overwritten in writable resources! {}", (Object[])new Object[]{this.getClass().getName()});
        }
    }

    @Override
    public void commitChanges(IProgressMonitor monitor) {
        throw new UnsupportedOperationException("this method is not supported on : " + this.getClass().getSimpleName() + " readOnly=" + this.isReadOnly());
    }

    @Override
    public void updateText(String key, String text, boolean fireEvent, IProgressMonitor monitor) {
        throw new UnsupportedOperationException("this method is not supported on : " + this.getClass().getSimpleName() + " readOnly=" + this.isReadOnly());
    }

    @Override
    public IStatus updateKey(String oldKey, String newKey, IProgressMonitor monitor) {
        throw new UnsupportedOperationException("this method is not supported on : " + this.getClass().getSimpleName() + " readOnly=" + this.isReadOnly());
    }

    @Override
    public IStatus remove(String key, IProgressMonitor monitor) {
        throw new UnsupportedOperationException("this method is not supported on : " + this.getClass().getSimpleName() + " readOnly=" + this.isReadOnly());
    }
}

