/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.trigger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.apache.commons.lang3.Validate;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;

public class DefaultResourceChangeEventFilter
implements Predicate<IResourceChangeEvent> {
    public static final String GIT_UPDATES = "org.eclipse.egit.";
    public static final String MAVEN_UPDATES = "org.eclipse.m2e.";
    public static final String SONAR_UPDATE = "org.sonarlint.";
    public static final String WEB_TOOLS_UPDATE = "org.eclipse.wst.";
    public static final String DEBUG_EVENT = "org.eclipse.debug.";
    public static final String JDT_DEBUG_EVENT = "org.eclipse.jdt.internal.debug.";
    public static final String ANNOTATION_PROCESSING_JOB = "org.eclipse.core.internal.events.NotificationManager.NotifyJob";
    public static final String ANOTATION_PROCESSING_BUILD = "org.eclipse.core.internal.events.AutoBuildJob";
    public static final String EXTERNAL_FOLDER_UPDATE = "org.eclipse.jdt.internal.core.ExternalFoldersManager.RefreshJob";
    public static final String DEBUG_INIT = "org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager.InitJob";
    public static final String REFRESH_JOB = "org.eclipse.core.internal.refresh.RefreshJob";
    public static final String WORKSPACE_INIT_JOB = "org.eclipse.jdt.internal.ui.InitializeAfterLoadJob.RealJob";
    public static final String TEAM_UPDATES = "org.eclipse.team.";
    public static final String SEARCH = "org.eclipse.search2.";
    private boolean m_isIgnoreBuildEvents;
    private boolean m_isIgnoreScoutSdkEvents;
    private Collection<String> m_excludedJobNamePrefixes;

    public DefaultResourceChangeEventFilter() {
        String[] exclusions = new String[]{GIT_UPDATES, MAVEN_UPDATES, SONAR_UPDATE, WEB_TOOLS_UPDATE, DEBUG_EVENT, JDT_DEBUG_EVENT, ANNOTATION_PROCESSING_JOB, ANOTATION_PROCESSING_BUILD, EXTERNAL_FOLDER_UPDATE, DEBUG_INIT, REFRESH_JOB, WORKSPACE_INIT_JOB, TEAM_UPDATES, SEARCH};
        this.m_excludedJobNamePrefixes = new ArrayList<String>(exclusions.length);
        Collections.addAll(this.m_excludedJobNamePrefixes, exclusions);
        this.m_isIgnoreBuildEvents = true;
        this.m_isIgnoreScoutSdkEvents = true;
    }

    public DefaultResourceChangeEventFilter(Collection<String> excludedJobNamePrefixes, boolean ignoreBuildEvents, boolean ignoreScoutSdkEvents) {
        this.m_excludedJobNamePrefixes = new ArrayList<String>((Collection)Validate.notNull(excludedJobNamePrefixes));
        this.m_isIgnoreBuildEvents = ignoreBuildEvents;
        this.m_isIgnoreScoutSdkEvents = ignoreScoutSdkEvents;
    }

    @Override
    public boolean test(IResourceChangeEvent event) {
        if (event == null) {
            return false;
        }
        boolean ignoreBuildEvents = this.isIgnoreBuildEvents();
        if (ignoreBuildEvents && event.getBuildKind() != 0) {
            return false;
        }
        Job curJob = Job.getJobManager().currentJob();
        if (curJob == null) {
            return false;
        }
        if (this.isIgnoreScoutSdkEvents() && curJob instanceof AbstractJob) {
            return false;
        }
        if (ignoreBuildEvents && (curJob.belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD) || curJob.belongsTo(ResourcesPlugin.FAMILY_MANUAL_BUILD))) {
            return false;
        }
        Predicate<String> excludedByNamePrefix = className -> this.getExcludedJobNamePrefixes().stream().anyMatch(prefix -> className.startsWith((String)prefix));
        String jobFqn = curJob.getClass().getName().replace('$', '.');
        if (excludedByNamePrefix.test(jobFqn)) {
            return false;
        }
        if (!"org.eclipse.core.internal.jobs.ThreadJob".equals(jobFqn)) {
            return true;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        boolean isStackTraceElementExcluded = Arrays.stream(stackTrace).map(element -> element.getClassName()).anyMatch(excludedByNamePrefix);
        return !isStackTraceElementExcluded;
    }

    public boolean isIgnoreBuildEvents() {
        return this.m_isIgnoreBuildEvents;
    }

    public void setIgnoreBuildEvents(boolean isIgnoreBuildEvents) {
        this.m_isIgnoreBuildEvents = isIgnoreBuildEvents;
    }

    public boolean isIgnoreScoutSdkEvents() {
        return this.m_isIgnoreScoutSdkEvents;
    }

    public void setIgnoreScoutSdkEvents(boolean isIgnoreScoutSdkEvents) {
        this.m_isIgnoreScoutSdkEvents = isIgnoreScoutSdkEvents;
    }

    public Collection<String> getExcludedJobNamePrefixes() {
        return this.m_excludedJobNamePrefixes;
    }

    public void setExcludedJobNamePrefixes(Collection<String> excludedJobNamePrefixes) {
        this.m_excludedJobNamePrefixes = excludedJobNamePrefixes == null || excludedJobNamePrefixes.isEmpty() ? Collections.emptyList() : new ArrayList<String>(excludedJobNamePrefixes);
    }
}

