/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.tml.protocol.exceptions.MalformedProtocolExtensionException;
import org.eclipse.tml.protocol.internal.model.PluginProtocolModel;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolHandshake;
import org.eclipse.tml.protocol.lib.ProtocolActionDelegate;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.tml.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolHandshakeException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

public class PluginProtocolActionDelegate {
    public static ProtocolHandle startClientProtocol(String protocolId, IProtocolExceptionHandler exceptionHandler, String host, int port, Map parameters) throws IOException, ProtocolHandshakeException, MalformedProtocolExtensionException {
        PluginProtocolModel model = PluginProtocolModel.getInstance();
        Map<Long, ProtocolMsgDefinition> allMessages = model.getAllProtocolMessages(protocolId);
        Collection<String> incomingMessages = model.getServerMessages(protocolId);
        Collection<String> outgoingMessages = model.getClientMessages(protocolId);
        IProtocolHandshake protocolInitializer = model.getProtocolInit(protocolId);
        boolean isBigEndianProtocol = model.isBigEndianProtocol(protocolId);
        return ProtocolActionDelegate.startClientProtocol(allMessages, incomingMessages, outgoingMessages, protocolInitializer, exceptionHandler, isBigEndianProtocol, host, port, parameters);
    }

    public static ProtocolHandle startServerProtocol(String protocolId, int serverPort, IProtocolExceptionHandler exceptionHandler) throws IOException, ProtocolHandshakeException, MalformedProtocolExtensionException {
        PluginProtocolModel model = PluginProtocolModel.getInstance();
        Map<Long, ProtocolMsgDefinition> allMessages = model.getAllProtocolMessages(protocolId);
        Collection<String> incomingMessages = model.getClientMessages(protocolId);
        Collection<String> outgoingMessages = model.getServerMessages(protocolId);
        IProtocolHandshake protocolInitializer = model.getProtocolInit(protocolId);
        boolean isBigEndianProtocol = model.isBigEndianProtocol(protocolId);
        return ProtocolActionDelegate.startServerProtocol(serverPort, allMessages, incomingMessages, outgoingMessages, protocolInitializer, exceptionHandler, isBigEndianProtocol);
    }

    public static void stopProtocol(ProtocolHandle handle) throws IOException {
        ProtocolActionDelegate.stopProtocol(handle);
    }

    public static void restartProtocol(ProtocolHandle handle) throws IOException, ProtocolHandshakeException, ProtocolException {
        ProtocolActionDelegate.restartProtocol(handle);
    }

    public static void sendMessageToServer(ProtocolHandle handle, ProtocolMessage message) throws IOException, InvalidMessageException, InvalidDefinitionException, ProtocolRawHandlingException {
        ProtocolActionDelegate.sendMessageToServer(handle, message);
    }
}

