/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.editors;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.framework.device.events.InstanceEvent;
import org.eclipse.tml.framework.device.events.InstanceEventManager;
import org.eclipse.tml.framework.device.internal.model.MobileInstance;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.ui.DeviceUIResources;
import org.eclipse.ui.dialogs.PropertyPage;

public class InstancePropertyEditor
extends PropertyPage {
    private static final String LABEL_INSTANCE_NAME = "Instance name: ";
    private static final String LABEL_DEVICE_NAME = "Device Name: ";
    private static final String LABEL_DEVICE_CLASS = "Device class: ";
    private static final String LABEL_PROPERTIES = "Properties: ";
    private static final String COLUMN_NAME_KEY = "Key";
    private static final String COLUMN_NAME_VALUE = "Value";
    private Table table;
    private MobileInstance instance;
    private Text textInstanceName;
    private String initialInstanceName;

    private void onMouseDoubleClick() {
        String key = this.table.getSelection()[0].getText(0);
        String value = this.table.getSelection()[0].getText(1);
        InputDialog dialog = new InputDialog(this.getShell(), String.valueOf(key) + " Property Value", "Enter a new value for " + key, value, null);
        if (dialog.open() == 0) {
            this.table.getSelection()[0].setText(1, dialog.getValue().trim());
        }
    }

    private boolean validateName(String instanceName) {
        InstanceManager manager = InstanceManager.getInstance();
        String errorMessage = null;
        boolean retVal = false;
        if (instanceName != null && !(instanceName = instanceName.trim()).equals("")) {
            if (manager.getInstancesByname(instanceName).size() == 0 || instanceName.equals(this.initialInstanceName)) {
                retVal = true;
            } else {
                errorMessage = DeviceUIResources.TML_Instance_Name_Duplicated_Error;
            }
        }
        this.setErrorMessage(errorMessage);
        return retVal;
    }

    public Control createContents(Composite parent) {
        String[] columnNames = new String[]{COLUMN_NAME_KEY, COLUMN_NAME_VALUE};
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        this.instance = (MobileInstance)this.getElement().getAdapter(MobileInstance.class);
        Label label = new Label(composite, 0);
        label.setText(LABEL_INSTANCE_NAME);
        this.textInstanceName = new Text(composite, 2048);
        this.initialInstanceName = this.instance.getName().trim();
        this.textInstanceName.setText(this.initialInstanceName);
        GridData gridData = new GridData(768);
        this.textInstanceName.setLayoutData((Object)gridData);
        this.textInstanceName.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                boolean valid = InstancePropertyEditor.this.validateName(InstancePropertyEditor.this.textInstanceName.getText());
                InstancePropertyEditor.this.setValid(valid);
            }
        });
        label = new Label(composite, 0);
        label.setText(LABEL_DEVICE_NAME);
        label = new Label(composite, 0);
        label.setText(this.instance.getName());
        label = new Label(composite, 0);
        label.setText(LABEL_DEVICE_CLASS);
        label = new Label(composite, 0);
        label.setText(this.instance.getDeviceTypeId());
        label = new Label(composite, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(LABEL_PROPERTIES);
        this.table = new Table(composite, 65536);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)gridData);
        new TableColumn(this.table, 0x1000000).setText(columnNames[0]);
        new TableColumn(this.table, 0x1000000).setText(columnNames[1]);
        Properties properties = this.instance.getProperties();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String propertyKey = (String)e.nextElement();
            String propertyVal = properties.getProperty(propertyKey);
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{propertyKey, propertyVal});
        }
        int columns = this.table.getColumnCount();
        int i = 0;
        while (i < columns) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                InstancePropertyEditor.this.onMouseDoubleClick();
            }
        });
        this.noDefaultAndApplyButton();
        return composite;
    }

    public boolean performOk() {
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            String key = items[i].getText(0);
            String value = items[i].getText(1).trim();
            this.instance.getProperties().setProperty(key, value);
            ++i;
        }
        this.instance.setName(this.textInstanceName.getText().trim());
        InstanceEventManager.getInstance().fireInstanceUpdated(new InstanceEvent((IInstance)this.instance));
        return true;
    }
}

