/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.events;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.tml.framework.device.events.IInstanceListener;
import org.eclipse.tml.framework.device.events.InstanceEvent;

public class InstanceEventManager
extends EventManager {
    private static InstanceEventManager _instance;

    private InstanceEventManager() {
    }

    public static InstanceEventManager getInstance() {
        if (_instance == null) {
            _instance = new InstanceEventManager();
        }
        return _instance;
    }

    public void addInstanceListener(IInstanceListener listener) {
        this.addListenerObject(listener);
    }

    public void removeInstanceListener(IInstanceListener listener) {
        this.removeListenerObject(listener);
    }

    public void fireInstanceCreated(InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceCreated(event);
                }
            });
            ++i;
        }
    }

    public void fireInstanceDeleted(InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceDeleted(event);
                }
            });
            ++i;
        }
    }

    public void fireInstanceLoaded(InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceLoaded(event);
                }
            });
            ++i;
        }
    }

    public void fireInstanceUnloaded(InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceUnloaded(event);
                }
            });
            ++i;
        }
    }

    public void fireInstanceUpdated(InstanceEvent event) {
        Object[] list = this.getListeners();
        int i = 0;
        while (i < list.length) {
            IInstanceListener l = (IInstanceListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.instanceUpdated(event);
                }
            });
            ++i;
        }
    }
}

