/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.view;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tml.framework.device.DeviceUtils;
import org.eclipse.tml.framework.device.events.IInstanceListener;
import org.eclipse.tml.framework.device.events.InstanceAdapter;
import org.eclipse.tml.framework.device.events.InstanceEvent;
import org.eclipse.tml.framework.device.events.InstanceEventManager;
import org.eclipse.tml.framework.device.factory.DeviceTypeRegistry;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.model.AbstractMobileInstance;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IService;
import org.eclipse.tml.framework.device.model.handler.ServiceHandlerAction;
import org.eclipse.tml.framework.device.ui.view.InstanceMgtView;
import org.eclipse.tml.framework.device.ui.view.model.InstanceMgtViewComparator;
import org.eclipse.tml.framework.device.ui.view.model.ViewerAbstractNode;
import org.eclipse.tml.framework.device.ui.view.model.ViewerDeviceNode;
import org.eclipse.tml.framework.device.ui.view.model.ViewerInstanceNode;
import org.eclipse.tml.framework.device.ui.view.provider.InstanceMgtViewContentProvider;
import org.eclipse.tml.framework.device.ui.view.provider.InstanceMgtViewLabelProvider;
import org.eclipse.tml.framework.device.ui.wizard.DeviceWizardExtensionManager;
import org.eclipse.tml.framework.status.IStatus;
import org.eclipse.tml.framework.status.StatusRegistry;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceStatusComposite
extends Composite {
    private static final String PROPERTY_EDITOR_ID = "org.eclipse.tml.framework.device.ui.editors.InstancePropertyEditorDefault";
    private static final String MENU_DELETE = "Delete";
    private static final String MENU_PROPERTIES = "Properties";
    private static final String MENU_NEW = "New...";
    private static final String TOOLBAR_NEW_TOOLTIP = "New Instance";
    private static final String TOOLBAR_DIALOG_MESSAGE = "Select a Device to open the Instance Creation Wizard :";
    private static final String ERROR_DIALOG_TITLE = "Error";
    private static final String ERROR_NO_WIZARD_MESSAGE = "No wizard found for Device ";
    private static final int DEFAULT_MENU_IMAGE_SIZE = 16;
    private final Set<InstanceSelectionChangeListener> listeners = new LinkedHashSet<InstanceSelectionChangeListener>();
    private TreeViewer viewer;
    private IViewSite viewSite;
    protected Map<String, Action> wizardActions = new TreeMap<String, Action>();
    private IInstanceListener listener = new InstanceAdapter(){

        public void instanceLoaded(InstanceEvent e) {
            InstanceStatusComposite.this.instanceLoaded(e.getInstance());
        }

        public void instanceUnloaded(InstanceEvent e) {
            InstanceStatusComposite.this.instanceUnloaded(e.getInstance());
        }

        public void instanceUpdated(InstanceEvent e) {
            InstanceStatusComposite.this.instanceUpdated(e.getInstance());
        }
    };

    public InstanceStatusComposite(Composite parent, IViewSite viewSite) {
        super(parent, 0);
        this.viewSite = viewSite;
        this.createContents();
        InstanceEventManager eventMgr = InstanceEventManager.getInstance();
        eventMgr.addInstanceListener(this.listener);
    }

    public void dispose() {
        InstanceEventManager eventMgr = InstanceEventManager.getInstance();
        eventMgr.removeInstanceListener(this.listener);
        super.dispose();
    }

    protected void addInstanceSelectionChangeListener(InstanceSelectionChangeListener listener) {
        this.listeners.add(listener);
    }

    protected void removeInstanceSelectionChangeListener(InstanceSelectionChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyInstanceSelectionChangeListeners(IInstance instance) {
        InstanceSelectionChangeEvent event = new InstanceSelectionChangeEvent(instance);
        for (InstanceSelectionChangeListener listener : this.listeners) {
            listener.instanceSelectionChanged(event);
        }
    }

    private IInstance getSelectedInstance() {
        IInstance instance = null;
        Object lastSelection = this.getLastSelection();
        if (lastSelection instanceof IInstance) {
            instance = (IInstance)lastSelection;
        }
        return instance;
    }

    private void createContents() {
        this.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer((Composite)this, 66304);
        Tree tree = this.viewer.getTree();
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        this.createColumn("Instance name", 3);
        this.createColumn("Status", 1);
        InstanceMgtViewLabelProvider labelProvider = new InstanceMgtViewLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setContentProvider((IContentProvider)new InstanceMgtViewContentProvider());
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setComparator((ViewerComparator)new InstanceMgtViewComparator(labelProvider));
        this.viewer.setInput((Object)this.viewSite);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InstanceStatusComposite.this.notifyInstanceSelectionChangeListeners(InstanceStatusComposite.this.getSelectedInstance());
            }
        });
        this.createActions();
        this.fillMenuContext();
        this.fillViewMenu();
        this.fillViewToolbar();
        this.refreshViewer(null);
        this.viewer.expandAll();
    }

    private void createActions() {
        for (final IDeviceType device : DeviceTypeRegistry.getInstance().getDeviceTypes()) {
            if (device.isAbstract()) continue;
            this.wizardActions.put(device.getLabel(), new Action(device.getLabel()){

                public void run() {
                    IWizard wizard = DeviceWizardExtensionManager.getInstance().getDeviceWizard(device.getId());
                    if (wizard != null) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
                        dialog.create();
                        dialog.open();
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                MessageDialog.openError((Shell)ww.getShell(), (String)InstanceStatusComposite.ERROR_DIALOG_TITLE, (String)(InstanceStatusComposite.ERROR_NO_WIZARD_MESSAGE + device.getLabel()));
                            }
                        });
                    }
                }

                public String toString() {
                    return this.getText();
                }
            });
        }
    }

    private void fillMenuContext() {
        final Menu menu = new Menu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                InstanceStatusComposite.this.fillMenuContext(menu);
            }
        });
    }

    private void fillMenuContext(Menu menu) {
        MenuItem newItem = null;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strSelection = (IStructuredSelection)selection;
            Object firstSelection = strSelection.getFirstElement();
            if (firstSelection instanceof ViewerInstanceNode) {
                ViewerInstanceNode node = (ViewerInstanceNode)firstSelection;
                if (node.containsInstance()) {
                    IInstance instance = this.getSelectedInstance();
                    String statusId = instance.getStatus();
                    IStatus status = StatusRegistry.getInstance().getStatus(statusId);
                    IDeviceType device = DeviceUtils.getDeviceType((IInstance)instance);
                    String deviceName = device.getLabel();
                    newItem = new MenuItem(menu, 8);
                    newItem.setText(MENU_NEW);
                    newItem.addListener(13, (Listener)new WizardSelectionListener(deviceName));
                    newItem = new MenuItem(menu, 2);
                    newItem = new MenuItem(menu, 8);
                    newItem.setText(MENU_DELETE);
                    newItem.addListener(13, (Listener)new MenuDeleteListener());
                    newItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
                    newItem.setEnabled(status.canDeleteInstance());
                    newItem = new MenuItem(menu, 2);
                    newItem = new MenuItem(menu, 8);
                    newItem.setText(MENU_PROPERTIES);
                    newItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("ICON_PROPERTY"));
                    newItem.addListener(13, (Listener)new MenuPropertiesListener(instance));
                    newItem.setEnabled(status.canEditProperties());
                    newItem = new MenuItem(menu, 2);
                    for (IService service : device.getServices()) {
                        if (!service.isVisible()) continue;
                        boolean inTransition = ((AbstractMobileInstance)instance).getStateMachineHandler().isTransitioning();
                        boolean isServiceEnabled = service.getStatusTransitions(instance.getStatus()) != null;
                        isServiceEnabled = isServiceEnabled && !inTransition;
                        newItem = new MenuItem(menu, 8);
                        ImageData serviceImageData = service.getImage().getImageData().scaledTo(16, 16);
                        Image serviceImage = new Image((Device)this.getDisplay(), serviceImageData);
                        newItem.setImage(serviceImage);
                        newItem.setEnabled(isServiceEnabled);
                        newItem.setText(service.getName());
                        newItem.addListener(13, (Listener)new ServiceHandlerAction(instance, service.getHandler()));
                        final IInstance inst = instance;
                        newItem.addListener(13, new Listener(){

                            public void handleEvent(Event event) {
                                InstanceMgtView.getInstanceServicesComposite().setSelectedInstance(inst);
                            }
                        });
                    }
                }
            } else if (firstSelection instanceof ViewerDeviceNode) {
                newItem = new MenuItem(menu, 8);
                newItem.setText(MENU_NEW);
                String deviceName = ((ViewerDeviceNode)firstSelection).getDeviceName();
                newItem.addListener(13, (Listener)new WizardSelectionListener(deviceName));
            }
        }
    }

    private void fillViewMenu() {
        IMenuManager rootMenuManager = this.viewSite.getActionBars().getMenuManager();
        MenuManager wizardSubmenu = new MenuManager(MENU_NEW);
        rootMenuManager.add((IContributionItem)wizardSubmenu);
        for (Action action : this.wizardActions.values()) {
            wizardSubmenu.add((IAction)action);
        }
    }

    private void fillViewToolbar() {
        IToolBarManager toolbarManager = this.viewSite.getActionBars().getToolBarManager();
        WizardDropDownAction newWizardAction = new WizardDropDownAction();
        newWizardAction.setToolTipText(TOOLBAR_NEW_TOOLTIP);
        toolbarManager.add((IAction)newWizardAction);
    }

    private void createColumn(String columnLabel, int columnWeight) {
        Tree tree = this.viewer.getTree();
        TableLayout layout = (TableLayout)tree.getLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(columnWeight));
        TreeColumn tc = new TreeColumn(tree, 0);
        tc.setMoveable(true);
        tc.setText(columnLabel);
        tc.setResizable(true);
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstanceStatusComposite.this.columnSelected(e);
            }
        });
        tc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                InstanceStatusComposite.this.columnMoved(e);
            }
        });
    }

    private void refreshViewer(IInstance selectedInstance) {
        Collection<String> expandedDevices = this.getExpandedDevices();
        this.viewer.refresh();
        this.expandToNodeValues(expandedDevices, selectedInstance);
        this.notifyInstanceSelectionChangeListeners(this.getSelectedInstance());
    }

    private Collection<String> getExpandedDevices() {
        Object[] expandedElements = this.viewer.getVisibleExpandedElements();
        HashSet<String> devicesCol = new HashSet<String>();
        Object[] objectArray = expandedElements;
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof ViewerDeviceNode) {
                ViewerDeviceNode node = (ViewerDeviceNode)element;
                devicesCol.add(node.getDevice().getId());
            }
            ++n2;
        }
        return devicesCol;
    }

    private void expandToNodeValues(Collection<String> devices, IInstance instance) {
        TreeItem[] treeItemArray = this.viewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerDeviceNode deviceNode;
            TreeItem treeNode = treeItemArray[n2];
            Object node = treeNode.getData();
            if (node instanceof ViewerDeviceNode && devices.contains((deviceNode = (ViewerDeviceNode)node).getDevice().getId())) {
                treeNode.setExpanded(true);
                this.viewer.reveal((Object)treeNode);
                for (ViewerAbstractNode childNode : deviceNode.getChildren()) {
                    this.viewer.reveal((Object)childNode);
                    if (instance == null || !instance.equals(((ViewerInstanceNode)childNode).getInstance())) continue;
                    treeNode.setExpanded(true);
                    this.viewer.reveal((Object)treeNode);
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)childNode));
                }
            }
            ++n2;
        }
    }

    private Object getLastSelection() {
        IStructuredSelection strSelection;
        IInstance lastSelection = null;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (strSelection = (IStructuredSelection)selection).size() == 1) {
            Object firstSelection = strSelection.getFirstElement();
            if (firstSelection instanceof ViewerInstanceNode) {
                ViewerInstanceNode node = (ViewerInstanceNode)firstSelection;
                lastSelection = node.getInstance();
            } else if (firstSelection instanceof ViewerDeviceNode) {
                ViewerDeviceNode node = (ViewerDeviceNode)firstSelection;
                lastSelection = node.getDevice();
            }
        }
        return lastSelection;
    }

    private void columnSelected(SelectionEvent e) {
        TreeColumn selectedColumn = (TreeColumn)e.widget;
        Tree tree = selectedColumn.getParent();
        int columnIndex = tree.indexOf(selectedColumn);
        InstanceMgtViewComparator comparator = (InstanceMgtViewComparator)this.viewer.getComparator();
        comparator.setColumnToSort(columnIndex);
        if (tree.getSortColumn() == selectedColumn) {
            comparator.toggleAscending();
        }
        tree.setSortColumn(selectedColumn);
        if (comparator.isAscending()) {
            tree.setSortDirection(128);
        } else {
            tree.setSortDirection(1024);
        }
        this.refreshViewer(this.getSelectedInstance());
    }

    private void columnMoved(ControlEvent e) {
        InstanceMgtViewLabelProvider provider;
        int previousFirstColumnIndex;
        TreeColumn treeColumn = (TreeColumn)e.getSource();
        Tree tree = treeColumn.getParent();
        int[] order = tree.getColumnOrder();
        if (order[0] != (previousFirstColumnIndex = (provider = (InstanceMgtViewLabelProvider)this.viewer.getLabelProvider()).getFirstColumnIndex())) {
            provider.setFirstColumnIndex(order[0]);
            this.refreshViewer(this.getSelectedInstance());
        }
    }

    protected void removeSelected() {
        if (this.viewer.getSelection().isEmpty()) {
            return;
        }
        IInstance instance = this.getSelectedInstance();
        if (instance != null) {
            InstanceManager.getInstance().deleteInstance(instance);
        }
    }

    private void instanceLoaded(final IInstance instance) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Collection expandedDevices = InstanceStatusComposite.this.getExpandedDevices();
                InstanceStatusComposite.this.viewer.setInput((Object)InstanceStatusComposite.this.viewSite);
                InstanceStatusComposite.this.viewer.refresh();
                expandedDevices.add(instance.getDeviceTypeId());
                InstanceStatusComposite.this.expandToNodeValues(expandedDevices, instance);
                InstanceStatusComposite.this.notifyInstanceSelectionChangeListeners(instance);
            }
        });
    }

    private void instanceUnloaded(IInstance instance) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Collection expandedDevices = InstanceStatusComposite.this.getExpandedDevices();
                InstanceStatusComposite.this.viewer.setInput((Object)InstanceStatusComposite.this.viewSite);
                InstanceStatusComposite.this.viewer.refresh();
                InstanceStatusComposite.this.expandToNodeValues(expandedDevices, null);
            }
        });
    }

    private void instanceUpdated(final IInstance instance) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Collection expandedDevices = InstanceStatusComposite.this.getExpandedDevices();
                IInstance selectedInstance = InstanceStatusComposite.this.getSelectedInstance();
                InstanceStatusComposite.this.viewer.setInput((Object)InstanceStatusComposite.this.viewSite);
                InstanceStatusComposite.this.viewer.refresh();
                InstanceStatusComposite.this.expandToNodeValues(expandedDevices, selectedInstance);
                if (instance.equals(selectedInstance)) {
                    InstanceStatusComposite.this.notifyInstanceSelectionChangeListeners(selectedInstance);
                }
            }
        });
    }

    class InstanceSelectionChangeEvent {
        private final IInstance instance;

        InstanceSelectionChangeEvent() {
            this(null);
        }

        InstanceSelectionChangeEvent(IInstance instance) {
            this.instance = instance;
        }

        IInstance getInstance() {
            return this.instance;
        }
    }

    static interface InstanceSelectionChangeListener {
        public void instanceSelectionChanged(InstanceSelectionChangeEvent var1);
    }

    private class MenuDeleteListener
    implements Listener {
        private MenuDeleteListener() {
        }

        public void handleEvent(Event event) {
            InstanceStatusComposite.this.removeSelected();
        }
    }

    private class MenuPropertiesListener
    implements Listener {
        private IInstance instance;

        public MenuPropertiesListener(IInstance instance) {
            this.instance = instance;
        }

        public void handleEvent(Event event) {
            Shell shell = new Shell();
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)this.instance, (String)InstanceStatusComposite.PROPERTY_EDITOR_ID, (String[])new String[0], null);
            dialog.open();
        }
    }

    private class WizardDropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;

        public WizardDropDownAction() {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tml.framework.device.ui", (String)"icons/full/obj16/new_instance.gif");
            this.setHoverImageDescriptor(descriptor);
            this.setImageDescriptor(descriptor);
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            for (Action action : InstanceStatusComposite.this.wizardActions.values()) {
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(this.fMenu, -1);
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void run() {
            ListDialog dialog = new ListDialog(InstanceStatusComposite.this.viewSite.getShell());
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dialog.setLabelProvider((ILabelProvider)new LabelProvider());
            dialog.setTitle(InstanceStatusComposite.TOOLBAR_NEW_TOOLTIP);
            dialog.setMessage(InstanceStatusComposite.TOOLBAR_DIALOG_MESSAGE);
            Action[] input = new Action[InstanceStatusComposite.this.wizardActions.size()];
            input = InstanceStatusComposite.this.wizardActions.values().toArray(input);
            dialog.setInput((Object)input);
            if (dialog.open() == 0) {
                ((Action)dialog.getResult()[0]).run();
            }
        }
    }

    private class WizardSelectionListener
    implements Listener {
        private String deviceName;

        public WizardSelectionListener(String deviceName) {
            this.deviceName = deviceName;
        }

        public void handleEvent(Event event) {
            Action wizardAction = InstanceStatusComposite.this.wizardActions.get(this.deviceName);
            if (wizardAction != null) {
                wizardAction.run();
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        MessageDialog.openError((Shell)ww.getShell(), (String)InstanceStatusComposite.ERROR_DIALOG_TITLE, (String)(InstanceStatusComposite.ERROR_NO_WIZARD_MESSAGE + WizardSelectionListener.this.deviceName));
                    }
                });
            }
        }
    }
}

