/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IInstanceBuilder;
import org.eclipse.tml.framework.device.ui.DeviceUIPlugin;
import org.eclipse.tml.framework.device.ui.wizard.DefaultDeviceTypeWizardPage;
import org.eclipse.tml.framework.device.ui.wizard.DeviceTypeCustomWizardPageHandler;
import org.eclipse.tml.framework.device.ui.wizard.IInstanceProperties;
import org.eclipse.tml.framework.device.ui.wizard.InstanceBuilder;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewDeviceWizard
extends Wizard
implements INewWizard {
    public static String DEFAULT_PAGE_ID = "$_default_page_$";
    private String currentDeviceTypeId;
    private DeviceTypeCustomWizardPageHandler customWizardPageHandler = new DeviceTypeCustomWizardPageHandler(this);
    private DefaultDeviceTypeWizardPage firstPage;
    private Properties properties;

    public void addPages() {
        this.firstPage = new DefaultDeviceTypeWizardPage(DEFAULT_PAGE_ID);
        this.addPage((IWizardPage)this.firstPage);
        super.addPages();
    }

    public boolean performFinish() {
        this.updatePropertiesFromWizardPages();
        boolean ok = false;
        try {
            final IInstanceBuilder projectBuilder = this.getProjectBuilder();
            IWorkbench workbench = DeviceUIPlugin.getDefault().getWorkbench();
            workbench.getProgressService();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    InstanceManager.getInstance().createProject((IDeviceType)NewDeviceWizard.this.firstPage.getDeviceType(), projectBuilder, monitor);
                }
            };
            this.getContainer().run(false, true, runnable);
            ok = true;
        }
        catch (InvocationTargetException x) {
            x.printStackTrace();
        }
        catch (InterruptedException x) {
            x.printStackTrace();
        }
        if (ok) {
            return this.customWizardPageHandler.performFinish();
        }
        return false;
    }

    public IInstanceBuilder getProjectBuilder() {
        return new InstanceBuilder(this.firstPage.getInstanceName(), this.getProperties());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public String getCurrentDeviceTypeId() {
        return this.currentDeviceTypeId;
    }

    public void setCurrentDeviceTypeId(String currentDeviceTypeId) {
        this.currentDeviceTypeId = currentDeviceTypeId;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = this.customWizardPageHandler.getNextPage(page);
        this.addCustomPage(nextPage);
        return nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return this.customWizardPageHandler.getPreviousPage(page);
    }

    private void addCustomPage(IWizardPage customPage) {
        if (customPage == null) {
            return;
        }
        IWizardPage[] allPages = this.getPages();
        boolean customPageFound = false;
        int i = 0;
        while (i < allPages.length && !customPageFound) {
            if (allPages[i].equals(customPage)) {
                customPageFound = true;
            }
            ++i;
        }
        if (!customPageFound) {
            this.addPage(customPage);
        }
    }

    private void updatePropertiesFromWizardPages() {
        this.properties = new Properties();
        DefaultDeviceTypeWizardPage page = this.firstPage;
        while (page != null) {
            if (page instanceof IInstanceProperties) {
                this.properties.putAll((Map<?, ?>)((IInstanceProperties)((Object)page)).getProperties());
            }
            page = this.getNextPage((IWizardPage)page);
        }
    }

    public boolean canFinish() {
        return this.firstPage.isPageComplete() && this.customWizardPageHandler.canFinish();
    }

    public Image getDefaultPageImage() {
        return DeviceUIPlugin.getDefault().getImageRegistry().get("IMAGEKEY_NEW_DEVICE_WIZARD");
    }
}

