/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib.internal.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.protocol.lib.IRawDataHandler;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.tml.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.tml.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.tml.protocol.lib.internal.engine.ProtocolEngineUtils;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;
import org.eclipse.tml.protocol.lib.msgdef.databeans.FixedSizeDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.IMsgDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.IteratableBlockDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.RawDataBean;
import org.eclipse.tml.protocol.lib.msgdef.databeans.VariableSizeDataBean;

class MessageWriter {
    MessageWriter() {
    }

    static final void doSendMessage(OutputStream out, ProtocolMessage message, ProtocolEngine eng) throws ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException, IOException {
        if (eng.isConnected()) {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ProtocolMsgDefinition msgDefinition = eng.getDefinitionByCode(message.getCode());
            if (msgDefinition != null && ProtocolEngineUtils.isOutgoingMessage(msgDefinition.getId(), eng.getIncomingMessages(), eng.getOutgoingMessages())) {
                boolean isCodeSigned = msgDefinition.isMsgCodeSigned();
                int codeSize = msgDefinition.getMsgCodeSizeInBytes();
                MessageWriter.writeNumberToStream(byteOutputStream, new Long(message.getCode()), codeSize, isCodeSigned, eng);
                List<IMsgDataBean> msgDataList = msgDefinition.getMessageData();
                for (IMsgDataBean messageData : msgDataList) {
                    MessageWriter.writeFilterMessageDef(messageData, byteOutputStream, message, null, -1, eng);
                }
                try {
                    if (out != null) {
                        byteOutputStream.writeTo(out);
                        out.flush();
                    }
                }
                catch (IOException e) {
                    eng.requestRestart();
                    throw e;
                }
            }
        }
    }

    private static void writeFilterMessageDef(IMsgDataBean messageDataDef, ByteArrayOutputStream streamToWriteTo, ProtocolMessage message, String iteratableBlockId, int index, ProtocolEngine eng) throws ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException {
        if (messageDataDef instanceof FixedSizeDataBean) {
            MessageWriter.writeFixedSizeDataToStream(streamToWriteTo, (FixedSizeDataBean)messageDataDef, message, eng);
        } else if (messageDataDef instanceof VariableSizeDataBean) {
            MessageWriter.writeVariableSizeDataToStream(streamToWriteTo, (VariableSizeDataBean)messageDataDef, message, eng);
        } else if (messageDataDef instanceof RawDataBean) {
            MessageWriter.writeRawDataToStream(streamToWriteTo, (RawDataBean)messageDataDef, message, eng);
        } else {
            MessageWriter.writeIteratableBlockToStream(streamToWriteTo, (IteratableBlockDataBean)messageDataDef, message, eng);
        }
    }

    private static void writeFixedSizeDataToStream(ByteArrayOutputStream streamToWriteTo, FixedSizeDataBean messageDataDef, ProtocolMessage message, ProtocolEngine eng) throws InvalidMessageException, InvalidDefinitionException {
        String fieldName = messageDataDef.getFieldName();
        boolean isSigned = messageDataDef.isFieldSigned();
        int fieldSize = messageDataDef.getFieldSizeInBytes();
        Object value = messageDataDef.getValue();
        if (fieldName != null) {
            if (value == null) {
                value = message.getFieldValue(fieldName);
            }
            if (!(value instanceof Number)) {
                BasePlugin.logError((String)"Value retrieved from message is not a number.");
                throw new InvalidMessageException("Field does not contain a number");
            }
        } else {
            BasePlugin.logError((String)"The field name was not provided by the message definition.");
            throw new InvalidDefinitionException("Incomplete fixed data element");
        }
        MessageWriter.writeNumberToStream(streamToWriteTo, (Number)value, fieldSize, isSigned, eng);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeVariableSizeDataToStream(ByteArrayOutputStream streamToWriteTo, VariableSizeDataBean messageDataDef, ProtocolMessage message, ProtocolEngine eng) throws InvalidMessageException, InvalidDefinitionException {
        boolean isSizeSigned = messageDataDef.isSizeFieldSigned();
        int sizeFieldSize = messageDataDef.getSizeFieldSizeInBytes();
        String valueFieldName = messageDataDef.getValueFieldName();
        String charsetName = messageDataDef.getCharsetName();
        Object value = messageDataDef.getValue();
        if (valueFieldName == null) {
            BasePlugin.logError((String)"The field name was not provided by the message definition.");
            throw new InvalidDefinitionException("Incomplete fixed data element");
        }
        if (value == null) {
            value = message.getFieldValue(valueFieldName);
        }
        if (!(value instanceof String)) {
            BasePlugin.logError((String)"Value retrieved from message is not a string.");
            throw new InvalidMessageException("Value field does not contain a string");
        }
        try {
            byte[] valueBytes = ((String)value).getBytes(charsetName);
            int valueBytesSize = valueBytes.length;
            MessageWriter.writeNumberToStream(streamToWriteTo, valueBytesSize, sizeFieldSize, isSizeSigned, eng);
            streamToWriteTo.write(valueBytes, 0, valueBytes.length);
            return;
        }
        catch (UnsupportedEncodingException e) {
            BasePlugin.logError((String)"An invalid charset name was provided for the field");
            throw new InvalidDefinitionException("Invalid charset name provided at message definition", e);
        }
    }

    private static void writeRawDataToStream(ByteArrayOutputStream streamToWriteTo, RawDataBean messageDataDef, ProtocolMessage message, ProtocolEngine eng) throws ProtocolRawHandlingException {
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        IRawDataHandler handler = messageDataDef.getHandler();
        handler.writeRawDataToStream(eng.getHandle(), tempStream, message, eng.isBigEndianProtocol());
        try {
            tempStream.writeTo(streamToWriteTo);
        }
        catch (IOException iOException) {
            BasePlugin.logWarning((String)"An IOException was thrown by the raw field handler.");
        }
    }

    private static void writeIteratableBlockToStream(ByteArrayOutputStream streamToWriteTo, IteratableBlockDataBean messageDataDef, ProtocolMessage message, ProtocolEngine eng) throws ProtocolRawHandlingException, InvalidMessageException, InvalidDefinitionException {
        String iterateOnField = messageDataDef.getIterateOnField();
        String iteratableBlockId = messageDataDef.getId();
        Object fieldValue = message.getFieldValue(iterateOnField);
        if (fieldValue instanceof Integer) {
            int numberOfIterations = (Integer)fieldValue;
            Collection<IMsgDataBean> internalBeans = messageDataDef.getDataBeans();
            int i = 0;
            while (i < numberOfIterations) {
                for (IMsgDataBean internalBean : internalBeans) {
                    MessageWriter.writeFilterMessageDef(internalBean, streamToWriteTo, message, iteratableBlockId, i, eng);
                }
                ++i;
            }
        } else {
            BasePlugin.logError((String)"It was not possible to determine how many iterations are expected.");
            throw new InvalidMessageException("Iterate on field value is not numeric");
        }
    }

    private static void writeNumberToStream(ByteArrayOutputStream streamToWriteTo, Number data, int numberOfBytes, boolean isSigned, ProtocolEngine eng) {
        int i;
        byte[] bytesToWrite = MessageWriter.getUnsignedBytes(data, numberOfBytes);
        if (isSigned && data.longValue() < 0L) {
            i = 0;
            while (i < numberOfBytes) {
                bytesToWrite[i] = (byte)(bytesToWrite[i] ^ bytesToWrite[i]);
                ++i;
            }
            bytesToWrite[numberOfBytes - 1] = (byte)(bytesToWrite[numberOfBytes - 1] + 1);
        }
        if (eng.isBigEndianProtocol()) {
            i = 0;
            while (i < numberOfBytes) {
                streamToWriteTo.write(bytesToWrite[i]);
                ++i;
            }
        } else {
            i = numberOfBytes - 1;
            while (i >= 0) {
                streamToWriteTo.write(bytesToWrite[i]);
                --i;
            }
        }
    }

    private static byte[] getUnsignedBytes(Number number, int numberOfBytes) {
        long dataTmp = Math.abs(number.longValue());
        byte[] bytes = new byte[numberOfBytes];
        int i = 0;
        while (i < numberOfBytes) {
            byte oneByte = (byte)(dataTmp & 0xFFL);
            dataTmp >>= 8;
            bytes[numberOfBytes - i - 1] = oneByte;
            ++i;
        }
        return bytes;
    }
}

