/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib.internal.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.protocol.lib.IMessageHandler;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolHandshake;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.ProtocolMessage;
import org.eclipse.tml.protocol.lib.exceptions.InvalidDefinitionException;
import org.eclipse.tml.protocol.lib.exceptions.InvalidInputStreamDataException;
import org.eclipse.tml.protocol.lib.exceptions.InvalidMessageException;
import org.eclipse.tml.protocol.lib.exceptions.MessageHandleException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolHandshakeException;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolRawHandlingException;
import org.eclipse.tml.protocol.lib.internal.engine.MessageReader;
import org.eclipse.tml.protocol.lib.internal.engine.MessageWriter;
import org.eclipse.tml.protocol.lib.internal.engine.NioDataInput;
import org.eclipse.tml.protocol.lib.internal.engine.NioOutputStream;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolEngine {
    private static final int RECONNECTION_MAX = 5;
    private static int engineEventCounter = 0;
    private static int consumerCounter = 0;
    private boolean isBigEndianProtocol;
    private ProtocolHandle handle;
    private Map<Long, ProtocolMsgDefinition> messageDefCollection;
    private int retries;
    private int retriesMax = 5;
    private int connectionSerialNumber = 0;
    private Collection<String> incomingMessages;
    private Collection<String> outgoingMessages;
    private IProtocolHandshake initProcedure;
    private IProtocolExceptionHandler exceptionHandler;
    private SocketChannel sockChannel;
    private String host;
    private Map<?, ?> parameters;
    private int port = -1;
    private int timeout = -1;
    private boolean isServer;
    private NioDataInput in;
    private OutputStream out;
    private Consumer consumer;
    private EngineEventHandler eventHandler = new EngineEventHandler();

    public ProtocolEngine(ProtocolHandle handle, IProtocolHandshake initProcedure, Map<Long, ProtocolMsgDefinition> messageDefCollection, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolExceptionHandler exceptionHandler, boolean isBigEndianProtocol, boolean isServer, int retries) {
        BasePlugin.logDebugMessage((String)"ProtocolEngine", (String)"A protocol engine is being created.");
        this.handle = handle;
        this.initProcedure = initProcedure;
        this.messageDefCollection = messageDefCollection;
        this.incomingMessages = incomingMessages;
        this.outgoingMessages = outgoingMessages;
        this.exceptionHandler = exceptionHandler;
        this.isBigEndianProtocol = isBigEndianProtocol;
        this.isServer = isServer;
        this.retries = this.retriesMax = retries >= 0 ? retries : 5;
        new Thread((Runnable)this.eventHandler, "Protocol Event Handler-" + ++engineEventCounter).start();
    }

    public void dispose() {
        BasePlugin.logInfo((String)"The protocol engine is being disposed.");
        if (this.consumer != null) {
            this.consumer.stopConsumer();
            this.consumer = null;
        }
        if (this.eventHandler != null) {
            this.eventHandler.stopEventHandler();
            this.eventHandler = null;
        }
    }

    public void requestStart(String host, int port, Map<?, ?> parameters) {
        this.requestStart(host, port, parameters, -1);
    }

    public void requestStart(String host, int port, Map<?, ?> parameters, int timeout) {
        String nextHost = host != null ? host : this.host;
        int nextPort = port != -1 ? port : this.port;
        Map<?, ?> nextParameters = parameters != null ? parameters : this.parameters;
        int nextTimeout = timeout != -1 ? timeout : this.timeout;
        this.eventHandler.requestStart(this.sockChannel, nextHost, nextPort, nextTimeout, nextParameters);
    }

    public void requestStart(SocketChannel connChannel, Map<?, ?> parameters) {
        SocketChannel nextChannel = connChannel != null ? connChannel : this.sockChannel;
        String nextHost = nextChannel.socket().getInetAddress().getHostAddress();
        int nextPort = nextChannel.socket().getPort();
        Map<?, ?> nextParameters = parameters != null ? parameters : this.parameters;
        this.eventHandler.requestStart(nextChannel, nextHost, nextPort, -1, nextParameters);
    }

    private void doStartProtocol() throws ProtocolHandshakeException, IOException {
        if (!this.isRunning()) {
            BasePlugin.logInfo((String)"Starting protocol.");
            if (this.sockChannel == null) {
                InetSocketAddress socketAdress = new InetSocketAddress(this.host, this.port);
                this.sockChannel = SocketChannel.open(socketAdress);
            }
            this.sockChannel.configureBlocking(false);
            this.in = new NioDataInput(this.sockChannel);
            this.out = new NioOutputStream(this.sockChannel);
            if (this.initProcedure != null) {
                if (this.isServer) {
                    this.initProcedure.serverHandshake(this.handle, this.in, this.out, this.parameters);
                } else {
                    this.initProcedure.clientHandshake(this.handle, this.in, this.out, this.parameters);
                }
                BasePlugin.logInfo((String)"Handshake is finished.");
                this.consumer = new Consumer();
                Thread consumerThread = new Thread((Runnable)this.consumer, "Consumer-" + ++consumerCounter);
                consumerThread.start();
                this.retries = this.retriesMax;
                ++this.connectionSerialNumber;
            } else {
                BasePlugin.logWarning((String)"Handshake handler is not available. No handshake performed.");
            }
            BasePlugin.logInfo((String)"Protocol started.");
        }
    }

    public void requestStop() {
        this.eventHandler.requestStop();
    }

    private void doStopProtocol() throws IOException {
        if (this.isConnected()) {
            BasePlugin.logInfo((String)"Stopping protocol.");
            if (this.consumer != null) {
                this.consumer.stopConsumer();
                this.consumer = null;
            }
            if (this.sockChannel != null) {
                this.sockChannel.close();
                this.sockChannel = null;
            }
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            BasePlugin.logInfo((String)"Protocol stopped.");
        }
    }

    public void requestRestart() {
        this.eventHandler.requestRestart();
    }

    public boolean isConnected() {
        boolean isConnected = false;
        if (this.sockChannel != null && this.sockChannel.isConnected()) {
            isConnected = true;
        }
        return isConnected;
    }

    public boolean isRunning() {
        return this.isConnected() && this.consumer != null && this.consumer.isRunning();
    }

    public void requestSendMessage(ProtocolMessage message) {
        if (message != null) {
            this.eventHandler.queueMessage(message);
        }
    }

    Collection<String> getIncomingMessages() {
        return this.incomingMessages;
    }

    Collection<String> getOutgoingMessages() {
        return this.outgoingMessages;
    }

    ProtocolHandle getHandle() {
        return this.handle;
    }

    boolean isBigEndianProtocol() {
        return this.isBigEndianProtocol;
    }

    ProtocolMsgDefinition getDefinitionByCode(long code) {
        return this.messageDefCollection.get(code);
    }

    private class Consumer
    implements Runnable {
        private boolean isRunning = false;

        private Consumer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BasePlugin.logInfo((String)"Starting consumer");
            long code = 0L;
            this.isRunning = true;
            while (this.isRunning) {
                try {
                    try {
                        if (code > 0x3FFFFFFFFFFFFFFFL) {
                            BasePlugin.logError((String)"Message not found. Stopping protocol...");
                            ProtocolEngine.this.requestRestart();
                            this.isRunning = false;
                            continue;
                        }
                        byte nextByte = ProtocolEngine.this.in.readByte(false);
                        code <<= 8;
                        long auxCode = ProtocolEngine.this.isServer ? code : -(code += (long)nextByte);
                        ProtocolMsgDefinition messageDef = (ProtocolMsgDefinition)ProtocolEngine.this.messageDefCollection.get(auxCode);
                        if (messageDef == null) continue;
                        if (ProtocolEngine.this.in != null) {
                            NioDataInput nioDataInput = ProtocolEngine.this.in;
                            synchronized (nioDataInput) {
                                IMessageHandler handler = messageDef.getHandler();
                                ProtocolMessage message = MessageReader.readReceivedMessage(ProtocolEngine.this.in, auxCode, messageDef, ProtocolEngine.this);
                                ProtocolMessage returnedMessage = handler.handleMessage(ProtocolEngine.this.handle, message);
                                if (returnedMessage != null) {
                                    ProtocolEngine.this.requestSendMessage(returnedMessage);
                                }
                            }
                        }
                        code = 0L;
                    }
                    catch (IOException e) {
                        if (!this.isRunning) continue;
                        BasePlugin.logError((String)"Socket disconnection was detected. Stopping consumer.");
                        this.isRunning = false;
                        if (ProtocolEngine.this.exceptionHandler == null) continue;
                        BasePlugin.logInfo((String)"An user exception handler is available. Delegating exception to the handler.");
                        ProtocolEngine.this.exceptionHandler.handleIOException(ProtocolEngine.this.handle, e);
                    }
                    catch (Exception e) {
                        BasePlugin.logError((String)("A protocol related error happened. Stopping consumer. Cause: " + e.getMessage()));
                        this.isRunning = false;
                        if (ProtocolEngine.this.exceptionHandler == null) continue;
                        BasePlugin.logInfo((String)"An user exception handler is available. Delegating exception to the handler.");
                        if (e instanceof ProtocolHandshakeException) {
                            ProtocolEngine.this.exceptionHandler.handleProtocolHandshakeException(ProtocolEngine.this.handle, (ProtocolHandshakeException)e);
                            continue;
                        }
                        if (e instanceof MessageHandleException) {
                            ProtocolEngine.this.exceptionHandler.handleMessageHandleException(ProtocolEngine.this.handle, (MessageHandleException)e);
                            continue;
                        }
                        if (e instanceof InvalidMessageException) {
                            ProtocolEngine.this.exceptionHandler.handleInvalidMessageException(ProtocolEngine.this.handle, (InvalidMessageException)e);
                            continue;
                        }
                        if (e instanceof InvalidInputStreamDataException) {
                            ProtocolEngine.this.exceptionHandler.handleInvalidInputStreamDataException(ProtocolEngine.this.handle, (InvalidInputStreamDataException)e);
                            continue;
                        }
                        if (e instanceof InvalidDefinitionException) {
                            ProtocolEngine.this.exceptionHandler.handleInvalidDefinitionException(ProtocolEngine.this.handle, (InvalidDefinitionException)e);
                            continue;
                        }
                        if (!(e instanceof ProtocolRawHandlingException)) continue;
                        ProtocolEngine.this.exceptionHandler.handleProtocolRawHandlingException(ProtocolEngine.this.handle, (ProtocolRawHandlingException)e);
                    }
                }
                catch (Throwable throwable) {
                    BasePlugin.logError((String)"One unhandled error occurred in consumer thread. Restarting the protocol...");
                    ProtocolEngine.this.requestRestart();
                    this.isRunning = false;
                }
            }
            BasePlugin.logInfo((String)"Consumer stopped.");
        }

        public void stopConsumer() {
            BasePlugin.logDebugMessage((String)"Consumer", (String)"Stopping consumer");
            this.isRunning = false;
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EngineEventHandler
    implements Runnable {
        private boolean isRunning = true;
        private boolean restartRequested = false;
        private boolean startRequested = false;
        private boolean stopRequested = false;
        private Queue<ProtocolMessage> messagesToSend = new ConcurrentLinkedQueue<ProtocolMessage>();
        private SocketChannel nextChannel = null;
        private String nextHost = null;
        private int nextPort = -1;
        private int nextTimeout = -1;
        private Map<?, ?> nextParameters = null;

        private EngineEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BasePlugin.logInfo((String)"Starting engine event handler.");
            ProtocolMessage messageToSend = null;
            while (this.isRunning) {
                try {
                    block33: {
                        Object object = this.messagesToSend;
                        synchronized (object) {
                            if (!this.startRequested && !this.stopRequested && !this.restartRequested && this.messagesToSend.isEmpty()) {
                                try {
                                    this.messagesToSend.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            if (!this.messagesToSend.isEmpty()) {
                                messageToSend = this.messagesToSend.poll();
                            }
                        }
                        try {
                            if (this.startRequested) {
                                this.startRequested = false;
                                this.messagesToSend.clear();
                                ProtocolEngine.this.sockChannel = this.nextChannel;
                                ProtocolEngine.this.host = this.nextHost;
                                ProtocolEngine.this.port = this.nextPort;
                                ProtocolEngine.this.timeout = this.nextTimeout;
                                ProtocolEngine.this.parameters = this.nextParameters;
                                ProtocolEngine.this.doStartProtocol();
                                break block33;
                            }
                            if (this.stopRequested) {
                                this.stopRequested = false;
                                this.messagesToSend.clear();
                                ProtocolEngine.this.doStopProtocol();
                                this.stopEventHandler();
                                break block33;
                            }
                            if (!this.restartRequested) break block33;
                            this.restartRequested = false;
                            this.messagesToSend.clear();
                            object = this;
                            synchronized (object) {
                                int initialSerialNumber = ProtocolEngine.this.connectionSerialNumber;
                                while (ProtocolEngine.this.connectionSerialNumber == initialSerialNumber && ProtocolEngine.this.retries >= 0) {
                                    try {
                                        if (ProtocolEngine.this.isConnected() || ProtocolEngine.this.isRunning()) {
                                            ProtocolEngine.this.doStopProtocol();
                                        }
                                        if (ProtocolEngine.this.isConnected()) continue;
                                        ProtocolEngine.this.doStartProtocol();
                                    }
                                    catch (Exception e) {
                                        ProtocolEngine protocolEngine = ProtocolEngine.this;
                                        protocolEngine.retries = protocolEngine.retries - 1;
                                        if (ProtocolEngine.this.retries >= 0) continue;
                                        BasePlugin.logError((String)"Number of connection retries exceeded the limit.");
                                        ProtocolEngine.this.retries = ProtocolEngine.this.retriesMax;
                                        throw e;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            try {
                                ProtocolEngine.this.doStopProtocol();
                            }
                            catch (IOException iOException) {}
                            if (ProtocolEngine.this.exceptionHandler != null) {
                                if (e instanceof ProtocolHandshakeException) {
                                    ProtocolEngine.this.exceptionHandler.handleProtocolHandshakeException(ProtocolEngine.this.handle, (ProtocolHandshakeException)e);
                                }
                                if (e instanceof IOException) {
                                    ProtocolEngine.this.exceptionHandler.handleIOException(ProtocolEngine.this.handle, (IOException)e);
                                }
                                throw e;
                            }
                            throw e;
                        }
                    }
                    if (!ProtocolEngine.this.isConnected() || messageToSend == null) continue;
                    try {
                        MessageWriter.doSendMessage(ProtocolEngine.this.out, messageToSend, ProtocolEngine.this);
                        messageToSend = null;
                    }
                    catch (Exception e) {
                        if (ProtocolEngine.this.exceptionHandler != null) {
                            if (e instanceof ProtocolRawHandlingException) {
                                ProtocolEngine.this.exceptionHandler.handleProtocolRawHandlingException(ProtocolEngine.this.handle, (ProtocolRawHandlingException)e);
                                continue;
                            }
                            if (e instanceof InvalidMessageException) {
                                ProtocolEngine.this.exceptionHandler.handleInvalidMessageException(ProtocolEngine.this.handle, (InvalidMessageException)e);
                                continue;
                            }
                            if (e instanceof InvalidDefinitionException) {
                                ProtocolEngine.this.exceptionHandler.handleInvalidDefinitionException(ProtocolEngine.this.handle, (InvalidDefinitionException)e);
                                continue;
                            }
                            if (e instanceof IOException) {
                                ProtocolEngine.this.exceptionHandler.handleIOException(ProtocolEngine.this.handle, (IOException)e);
                                continue;
                            }
                            throw e;
                        }
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    BasePlugin.logWarning((String)"One unhandled error occurred in event handler thread.");
                }
            }
            BasePlugin.logInfo((String)"Engine event handler stopped.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueMessage(ProtocolMessage message) {
            Queue<ProtocolMessage> queue = this.messagesToSend;
            synchronized (queue) {
                this.messagesToSend.offer(message);
                this.messagesToSend.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRestart() {
            Queue<ProtocolMessage> queue = this.messagesToSend;
            synchronized (queue) {
                BasePlugin.logDebugMessage((String)"EngineEventHandler", (String)"A restart was requested.");
                this.restartRequested = true;
                this.messagesToSend.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStart(SocketChannel channel, String host, int port, int timeout, Map<?, ?> parameters) {
            Queue<ProtocolMessage> queue = this.messagesToSend;
            synchronized (queue) {
                BasePlugin.logDebugMessage((String)"EngineEventHandler", (String)("A start was requested. host=" + host + "; port=" + port + "; channel=" + (channel != null ? "available" : "none")));
                this.nextChannel = channel;
                this.nextHost = host;
                this.nextPort = port;
                this.nextTimeout = timeout;
                this.nextParameters = parameters;
                this.startRequested = true;
                this.messagesToSend.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStop() {
            Queue<ProtocolMessage> queue = this.messagesToSend;
            synchronized (queue) {
                BasePlugin.logDebugMessage((String)"EngineEventHandler", (String)"A stop was requested.");
                this.stopRequested = true;
                this.messagesToSend.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopEventHandler() {
            BasePlugin.logDebugMessage((String)"EngineEventHandler", (String)"Stopping engine event handler.");
            this.isRunning = false;
            Queue<ProtocolMessage> queue = this.messagesToSend;
            synchronized (queue) {
                this.messagesToSend.notify();
            }
        }
    }
}

