/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.tools.datamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.tml.localization.tools.datamodel.LocaleInfo;
import org.eclipse.tml.localization.tools.datamodel.LocalizationProject;
import org.eclipse.tml.localization.tools.datamodel.StringNode;
import org.eclipse.tml.localization.tools.persistence.IFilePersistentData;
import org.eclipse.tml.localization.tools.persistence.IPersistentData;
import org.eclipse.tml.localization.tools.persistence.PersistableAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationFile
implements IFilePersistentData {
    private LocalizationProject localizationProject;
    private IFile file;
    private LocaleInfo localeInfo;
    private List<StringNode> stringNodes;
    Map<String, StringNode> stringNodesMap = new HashMap<String, StringNode>();
    private boolean dirty = false;
    private boolean dirtyMetaExtraData = false;
    private boolean toBeDeleted = false;

    public LocalizationFile(IFile file, LocaleInfo localeInfo, List<StringNode> stringNodes) {
        this.file = file;
        this.localeInfo = localeInfo;
        this.setStringNodes(stringNodes);
    }

    public LocalizationProject getLocalizationProject() {
        return this.localizationProject;
    }

    public void setLocalizationProject(LocalizationProject localizationProject) {
        this.localizationProject = localizationProject;
    }

    public LocaleInfo getLocaleInfo() {
        return this.localeInfo;
    }

    public void setLocaleInfo(LocaleInfo localeInfo) {
        this.localeInfo = localeInfo;
    }

    public List<StringNode> getStringNodes() {
        return this.stringNodes;
    }

    public StringNode getStringNodeByKey(String key) {
        StringNode result = this.stringNodesMap.get(key);
        if (result == null) {
            StringNode newNode = new StringNode(key, "");
            newNode.setLocalizationFile(this);
            this.addStringNode(newNode);
            this.stringNodesMap.put(key, newNode);
            result = newNode;
        }
        return result;
    }

    public void setStringNodes(List<StringNode> stringNodes) {
        for (StringNode stringNode : stringNodes) {
            this.stringNodesMap.put(stringNode.getKey(), stringNode);
            stringNode.setLocalizationFile(this);
        }
        this.stringNodes = stringNodes;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (dirty) {
            this.getLocalizationProject().setDirty(dirty);
        }
        this.dirty = dirty;
    }

    public boolean isDirtyMetaExtraData() {
        return this.dirtyMetaExtraData;
    }

    public void setDirtyMetaExtraData(boolean dirtyMetaExtraData) {
        this.dirtyMetaExtraData = dirtyMetaExtraData;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public List<StringNode> getModifiedStringNodes() {
        ArrayList<StringNode> modifiedStringNodes = new ArrayList<StringNode>();
        for (StringNode stringNode : this.stringNodes) {
            if (!stringNode.isDirty()) continue;
            modifiedStringNodes.add(stringNode);
        }
        return modifiedStringNodes;
    }

    public void addStringNode(StringNode stringNode) {
        this.stringNodes.add(stringNode);
        this.stringNodesMap.put(stringNode.getKey(), stringNode);
        stringNode.setLocalizationFile(this);
        this.setDirty(true);
    }

    public void removeStringNode(StringNode stringNode) {
        if (this.stringNodes.contains(stringNode)) {
            this.stringNodes.remove(stringNode);
            this.stringNodesMap.remove(stringNode.getKey());
            this.setDirty(true);
        }
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public List<IPersistentData> getPersistentData() {
        ArrayList<IPersistentData> persistentData = new ArrayList<IPersistentData>();
        return persistentData;
    }

    @Override
    public PersistableAttributes getPersistableAttributes() {
        return null;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public void setToBeDeleted(boolean toBeDeleted) {
        this.toBeDeleted = toBeDeleted;
    }

    public boolean equals(Object obj) {
        boolean result = true;
        LocalizationFile locFile = (LocalizationFile)obj;
        List<StringNode> locFileStringNodes = locFile.getStringNodes();
        if (this.stringNodes.size() != locFileStringNodes.size()) {
            result = false;
        } else {
            int i = 0;
            while (i < this.stringNodes.size()) {
                boolean keyEqual = this.stringNodes.get(i).getKey().equals(locFileStringNodes.get(i).getKey());
                boolean valueEqual = this.stringNodes.get(i).getValue().equals(locFileStringNodes.get(i).getValue());
                if (!keyEqual || !valueEqual) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

