/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.localization.tools.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tml.common.utilities.exception.AbstractExceptionStatus;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.common.utilities.exception.TmLExceptionStatus;
import org.eclipse.tml.localization.stringeditor.datatype.CellInfo;
import org.eclipse.tml.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.tml.localization.stringeditor.datatype.RowInfo;
import org.eclipse.tml.localization.stringeditor.editor.input.IStringEditorInput;
import org.eclipse.tml.localization.tools.LocalizationToolsPlugin;
import org.eclipse.tml.localization.tools.datamodel.LocaleInfo;
import org.eclipse.tml.localization.tools.datamodel.LocalizationFile;
import org.eclipse.tml.localization.tools.datamodel.StringNode;
import org.eclipse.tml.localization.tools.datamodel.StringNodeComment;
import org.eclipse.tml.localization.tools.extensions.classes.ILocalizationSchema;
import org.eclipse.tml.localization.tools.i18n.Messages;
import org.eclipse.tml.localization.tools.managers.LocalizationManager;
import org.eclipse.tml.localization.tools.managers.ProjectLocalizationManager;
import org.eclipse.ui.IPersistableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditorInput
extends IStringEditorInput {
    private ProjectLocalizationManager projectLocalizationManager = null;
    private final LocalizationManager.IFileChangeListener fileChangeListener = new LocalizationManager.IFileChangeListener(){

        public IProject getProject() {
            return StringEditorInput.this.projectLocalizationManager.getLocalizationProject().getProject();
        }

        public void fileChanged(IFile file) {
            StringEditorInput.this.notifyInputChange(StringEditorInput.this.getColumnID(file));
        }

        public void projectRemoved() {
            StringEditorInput.this.notifyProjectRemoved();
        }
    };
    private final String LOCALIZATION_ICON = "icons/loc_icon.png";

    public String getTitle() {
        return this.projectLocalizationManager.getLocalizationProject().getProject().getName();
    }

    public void addRow(RowInfo row) {
        LocaleInfo locale;
        String key = row.getKey();
        Map cells = row.getCells();
        Set columns = cells.keySet();
        ILocalizationSchema schema = this.projectLocalizationManager.getProjectLocalizationSchema();
        if (columns.size() == 0 && (locale = schema.getLocaleInfoFromID(schema.getDefaultID())) != null) {
            LocalizationFile mainFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(locale);
            mainFile.getStringNodeByKey(row.getKey());
        }
        for (String column : columns) {
            LocaleInfo info = schema.getLocaleInfoFromID(column);
            LocalizationFile file = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(info);
            String value = ((CellInfo)cells.get(column)).getValue();
            String comment = ((CellInfo)cells.get(column)).getComment();
            StringNode newNode = new StringNode(key, value);
            StringNodeComment commentNode = new StringNodeComment();
            commentNode.setComment(comment);
            newNode.setStringNodeComment(commentNode);
            file.addStringNode(newNode);
        }
    }

    public ProjectLocalizationManager getProjectLocalizationManager() {
        return this.projectLocalizationManager;
    }

    public void removeRow(String key) {
        List<LocalizationFile> files = this.projectLocalizationManager.getLocalizationProject().getLocalizationFiles();
        for (LocalizationFile localizationFile : files) {
            localizationFile.removeStringNode(localizationFile.getStringNodeByKey(key));
        }
    }

    public void init(IProject project) throws TmLException {
        this.projectLocalizationManager = LocalizationManager.getInstance().getProjectLocalizationManager(project, true);
        LocalizationManager.getInstance().addFileChangeListener(this.fileChangeListener);
        if (this.projectLocalizationManager == null) {
            Status status = new Status(4, "org.eclipse.tml.localization.tools", Messages.StringEditorInput_ErrorInitializingEditor);
            throw new TmLException((AbstractExceptionStatus)new TmLExceptionStatus((IStatus)status));
        }
    }

    private String getColumnID(IFile file) {
        return file.getFullPath().removeLastSegments(1).lastSegment();
    }

    public List<ColumnInfo> getColumns() {
        List<LocalizationFile> files = this.projectLocalizationManager.getLocalizationProject().getLocalizationFiles();
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        ILocalizationSchema schema = this.projectLocalizationManager.getProjectLocalizationSchema();
        String defaultID = this.projectLocalizationManager.getProjectLocalizationSchema().getDefaultID();
        for (LocalizationFile localizationFile : files) {
            String columnID = this.getColumnID(localizationFile.getFile());
            String toolTip = schema.getLocaleToolTip(localizationFile.getFile().getFullPath());
            List<StringNode> localizationNodes = localizationFile.getStringNodes();
            HashMap<String, CellInfo> cells = new HashMap<String, CellInfo>();
            for (StringNode stringNode : localizationNodes) {
                String comment = stringNode.getStringNodeComment() != null ? stringNode.getStringNodeComment().getComment() : "";
                CellInfo info = new CellInfo(stringNode.getValue(), comment);
                cells.put(stringNode.getKey(), info);
            }
            columns.add(new ColumnInfo(columnID, toolTip, cells, !columnID.equals(defaultID)));
        }
        return columns;
    }

    public boolean translate(String srcColumnID, String destColumnID) {
        destColumnID = srcColumnID;
        return false;
    }

    public void addColumn(String ID) {
        ILocalizationSchema schema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo info = schema.getLocaleInfoFromID(ID);
        LocalizationFile existingFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(info);
        if (existingFile == null) {
            String path = schema.getPathFromLocaleInfo(info);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            LocalizationFile newFile = new LocalizationFile(file, info, new ArrayList<StringNode>());
            newFile.setLocalizationProject(this.projectLocalizationManager.getLocalizationProject());
            newFile.setDirty(true);
            this.projectLocalizationManager.getLocalizationProject().addLocalizationFile(newFile);
        } else {
            existingFile.setToBeDeleted(false);
        }
    }

    public void removeColumn(String columnID) {
        LocaleInfo locale = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(columnID);
        LocalizationFile file = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(locale);
        this.projectLocalizationManager.markFileForDeletion(file);
        this.projectLocalizationManager.getLocalizationProject().setDirty(true);
    }

    public void setValue(String columnID, String key, String value) throws TmLException {
        if (this.projectLocalizationManager == null) {
            Status status = new Status(4, "org.eclipse.tml.localization.tools", Messages.StringEditorInput_ErrorManagerNotInitialized);
            throw new TmLException((AbstractExceptionStatus)new TmLExceptionStatus((IStatus)status));
        }
        LocaleInfo locale = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(columnID);
        LocalizationFile file = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(locale);
        file.getStringNodeByKey(key).setValue(value);
    }

    public CellInfo getValue(String columnID, String key) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(columnID);
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        StringNode stringNode = localizationFile.getStringNodeByKey(key);
        return new CellInfo(stringNode.getValue(), stringNode.getStringNodeComment().getComment());
    }

    public Map<String, CellInfo> getValues(String columnID) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(columnID);
        HashMap<String, CellInfo> keyValueMap = new HashMap<String, CellInfo>();
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        List<StringNode> stringNodes = localizationFile.getStringNodes();
        for (StringNode stringNode : stringNodes) {
            String comment = "";
            if (stringNode.getStringNodeComment() != null) {
                comment = stringNode.getStringNodeComment().getComment();
            }
            keyValueMap.put(stringNode.getKey(), new CellInfo(stringNode.getValue(), comment));
        }
        return keyValueMap;
    }

    public List<CellInfo> getAvailableKeysForColumn(String columnID) {
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(columnID);
        ArrayList<CellInfo> keysForColumn = new ArrayList<CellInfo>();
        LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
        List<StringNode> stringNodes = localizationFile.getStringNodes();
        for (StringNode stringNode : stringNodes) {
            keysForColumn.add(new CellInfo(stringNode.getKey(), stringNode.getStringNodeComment().getComment()));
        }
        return keysForColumn;
    }

    public boolean canSave() {
        return true;
    }

    public boolean save() {
        return this.projectLocalizationManager.saveProject();
    }

    public boolean isDirty() {
        boolean returnValue = false;
        if (this.projectLocalizationManager != null) {
            returnValue = this.projectLocalizationManager.getLocalizationProject().isDirty();
        }
        return returnValue;
    }

    public boolean exists() {
        return this.projectLocalizationManager.getAvailableLocales().size() > 0;
    }

    public ImageDescriptor getImageDescriptor() {
        return LocalizationToolsPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tml.localization.tools", (String)"icons/loc_icon.png");
    }

    public String getName() {
        String name = "";
        if (this.projectLocalizationManager != null) {
            name = this.projectLocalizationManager.getProjectLocalizationSchema().getEditorName();
        }
        return name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean canRevertByColumn() {
        return true;
    }

    public boolean revert() {
        LocalizationManager.getInstance().unloadProjectLocalizationManager(this.projectLocalizationManager.getLocalizationProject().getProject());
        LocalizationManager.getInstance().getProjectLocalizationManager(this.projectLocalizationManager.getLocalizationProject().getProject(), false);
        return true;
    }

    public boolean revert(String columnID) throws IOException {
        boolean found = false;
        ILocalizationSchema schema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo localeInfo = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(columnID);
        if (localeInfo != null) {
            LocalizationFile file = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(localeInfo);
            LocalizationFile newFile = schema.loadFile(file.getFile());
            this.projectLocalizationManager.getLocalizationProject().removeLocalizationFile(file);
            this.projectLocalizationManager.getLocalizationProject().addLocalizationFile(newFile);
            found = true;
        }
        return found;
    }

    public String getToolTipText() {
        return this.projectLocalizationManager.getProjectLocalizationSchema().getEditorName();
    }

    public void dispose() {
        if (this.projectLocalizationManager != null) {
            LocalizationManager.getInstance().removeFileChangeListener(this.fileChangeListener);
            LocalizationManager.getInstance().unloadProjectLocalizationManager(this.projectLocalizationManager.getLocalizationProject().getProject());
            this.projectLocalizationManager = null;
        }
    }

    public void removeCell(String key, String columnID) {
        ILocalizationSchema schema = this.projectLocalizationManager.getProjectLocalizationSchema();
        LocaleInfo locale = schema.getLocaleInfoFromID(columnID);
        LocalizationFile file = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(locale);
        if (schema.getDefaultID() != null && schema.getDefaultID().equals(columnID)) {
            try {
                this.setValue(columnID, key, "");
            }
            catch (TmLException tmLException) {}
        } else {
            file.removeStringNode(file.getStringNodeByKey(key));
        }
    }

    public void setCellTooltip(String columnID, String key, String tooltip) throws TmLException {
        if (this.projectLocalizationManager == null) {
            Status status = new Status(4, "org.eclipse.tml.localization.tools", Messages.StringEditorInput_ErrorManagerNotInitialized);
            throw new TmLException((AbstractExceptionStatus)new TmLExceptionStatus((IStatus)status));
        }
        LocaleInfo locale = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(columnID);
        LocalizationFile file = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(locale);
        StringNodeComment comment = file.getStringNodeByKey(key).getStringNodeComment();
        if (comment == null) {
            comment = new StringNodeComment();
        }
        file.getStringNodeByKey(key).setStringNodeComment(comment);
        comment.setComment(tooltip);
    }

    public IStatus validate() {
        Status result = new Status(0, "org.eclipse.tml.localization.tools", "");
        String defaultID = this.projectLocalizationManager.getProjectLocalizationSchema().getDefaultID();
        if (defaultID != null) {
            LocaleInfo info = this.projectLocalizationManager.getProjectLocalizationSchema().getLocaleInfoFromID(defaultID);
            LocalizationFile localizationFile = this.projectLocalizationManager.getLocalizationProject().getLocalizationFile(info);
            if (localizationFile == null) {
                result = new Status(2, "org.eclipse.tml.localization.tools", Messages.Warning_NoDefaultFile);
            } else if (localizationFile.isToBeDeleted()) {
                result = new Status(2, "org.eclipse.tml.localization.tools", Messages.Warning_NoDefaultFile);
            }
        }
        return result;
    }

    public boolean canHandle(IFile file) {
        boolean canHandle = false;
        ILocalizationSchema localizationSchema = LocalizationManager.getInstance().getLocalizationSchema(file.getProject());
        if (localizationSchema != null) {
            canHandle = localizationSchema.isLocalizationFile(file);
        }
        return canHandle;
    }
}

