/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.stringeditor.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.localization.stringeditor.editor.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorSession {
    private final Map<QualifiedName, String> session;
    private final IProject project;
    private static final String PROPERTY_GROUP = Messages.EditorSession_0;

    private EditorSession(Map<QualifiedName, String> map, IProject iProject) {
        this.session = map;
        this.project = iProject;
    }

    public static EditorSession loadFromProject(IProject iProject) {
        EditorSession editorSession = null;
        try {
            Map map = iProject.getPersistentProperties();
            HashMap<QualifiedName, String> hashMap = new HashMap<QualifiedName, String>();
            for (QualifiedName qualifiedName : map.keySet()) {
                if (qualifiedName.getQualifier() == null || !qualifiedName.getQualifier().contains(PROPERTY_GROUP)) continue;
                hashMap.put(qualifiedName, (String)map.get(qualifiedName));
            }
            editorSession = new EditorSession(hashMap, iProject);
        }
        catch (CoreException coreException) {
            BasePlugin.logError((String)(String.valueOf(Messages.EditorSession_1) + iProject.getName()), (Throwable)coreException);
        }
        return editorSession;
    }

    public String getProperty(String string, PROPERTY pROPERTY) {
        String string2 = String.valueOf(PROPERTY_GROUP) + "." + string;
        QualifiedName qualifiedName = new QualifiedName(string2, pROPERTY.name());
        return this.session.get(qualifiedName);
    }

    public void setProperty(String string, PROPERTY pROPERTY, String string2) {
        String string3 = String.valueOf(PROPERTY_GROUP) + "." + string;
        QualifiedName qualifiedName = new QualifiedName(string3, pROPERTY.name());
        this.session.put(qualifiedName, string2);
    }

    public void save() {
        for (QualifiedName qualifiedName : this.session.keySet()) {
            try {
                this.project.setPersistentProperty(qualifiedName, this.session.get(qualifiedName));
            }
            catch (CoreException coreException) {
                BasePlugin.logError((String)(String.valueOf(Messages.EditorSession_4) + this.project.getName()), (Throwable)coreException);
            }
        }
    }

    public void clean() {
        for (QualifiedName qualifiedName : this.session.keySet()) {
            try {
                this.project.setPersistentProperty(qualifiedName, null);
            }
            catch (CoreException coreException) {
                BasePlugin.logError((String)(String.valueOf(Messages.EditorSession_5) + this.project.getName()), (Throwable)coreException);
            }
        }
        this.session.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PROPERTY {
        WIDTH,
        VISIBLE,
        ORDER,
        SORT_BY_COLUMN,
        HIGHLIGHT_CHANGES,
        SEARCH_TEXT,
        SHOW_COMMENTS,
        FILTER_BY_KEY,
        EXPAND_ROW;

    }
}

